;
; ந뢠⥫ Wave 䠩: ᭮                           
; ᪮ ࠢ (C) 1994 ਩ .⥪  .䠭             
;

       include Support.inc
       include Control.inc
       include Global.inc
       include Constant.inc
       include Wave.inc
       include Bios.inc

.data
;ͻ
; 饭 
;ͼ

msgTitle  DB  "Wave file player Version 1.10c "
          DB  "Copyright (C) 1995-1996 Dmitry A.Steklenev", CR,LF,0

msgPrompt DB  "Usage: WAVPLAY file.wav [/Vxx]"             ,CR,LF,CR,LF
          DB  "       /Vxx - set volume 1-255 (default 15)",CR,LF,0

;ͻ
;   
;ͼ

;---------------------------;
okVolume    DB  FALSE       ; ਧ ࠡ⠭ ४⥫ ஬
okFile      DB  FALSE       ; ਧ ࠡ⠭  䠩
;---------------------------;
wavIdStr    DB  "RIFF"      ; 䨪樮 ப Wave 䠩
;---------------------------;
wavHeader   WAV <>          ;  䠩
;---------------------------;
wavFile     DB  255 dup (0) ; 
wavHandle   DW  0           ;  䠩
wavBuffer   DD  0           ;  /뢮
wavBufLen   DW  65000       ;   /뢮
wavBufFil   DW  65000       ;      뢮
;---------------------------;

.code
.startup
;ͻ
;  ࠬ஢  樠                                    
;ͼ
wavInit proc near

  mov   _errEntry,offset wavFatal     ;⠭ ࠡ稪 訡.

  @version 3,0                        ;஢  DOS.

  call  _prgArg?                      ;᫨ ணࠬ 饭 
  @if ax == 0 then                    ;㬥⮢,
      @out  msgTitle                  ;뢥 ᪠ 
      @out  msgPrompt                 ; ࠡ.
      @quit 0
  @endif

  @if ax ++ 3 then                    ;᫨ ணࠬ । 
      mov   _errCode,EC_NUMARG        ; 㬥⮢, ஢
      call  _errEntry                 ;訡 ୮ ᫠ 㬥⮢.
  @endif

  xor bx,bx
  @for ax
      inc  bx                         ;३  ᫥饬 㬥.
      mov  ax,bx                      ;  㬥  AX.
      call _prgArg                    ; ଠ  㬥.
      @if al == PA_SWITCH then        ;᫨  ४⥫ 
        @if @byte(si) == '?' then     ;  - (?),
          @out  msgTitle              ;뢥 ᪠ 
          @out  msgPrompt             ; ࠡ.
          @quit 0
        @elseif @byte(si) == 'V'      ;᫨   (V),
          call argVolume              ;맢 ⮢ ஬.
        @else                         ;᫨ ४⥫  ,
          mov  _errCode, EC_INVARG    ;뤠 ᮮ饭 
          call _errEntry              ;訡   ࠡ
        @endif                        ;ᮮ  訡 㬥.
      @else                           ;᫨ 㬥  ४⥫,
        call argFile                  ;맢 ࠡ   
      @endif                          ;䠩.
  @next

  @if okFile == FALSE                 ;᫨ 饭  䠩,
      mov  _errCode, EC_NUMARG        ;뤠 ᮮ饭 
      call _errEntry                  ;訡   ࠡ
  @endif

  mov  ax,wavBufLen                   ;뤥   
  call _memGrab                       ;/뢮.
  mov  @high(wavBuffer),ax

  @if  okVolume == FALSE              ;᫨ 㬥 /V 饭,
       mov  ax,15                     ;⠭ ஢ ஬
       call _wavVolume                ; 㬮砭.
  @endif

;ͻ
;   䠩                                                      
;ͼ

  mov  _errEntry,offset wavFileErr    ;⠭ ࠡ稪 訡.

  lea  dx,wavFile                     ; 䠩  ⥭
  @int 3D20h,21h                      ;( ⮬ ).
  @if  CF == 1                        ; 㦥 訡,
       mov  _errCode,EC_OPEN          ; ࠡ.
       call _errEntry
  @endif
  mov  wavHandle,ax                   ;࠭ .

  mov  bx,wavHandle                   ;  䠩.
  mov  cx,2Ch
  lea  dx,wavHeader
  @int 3Fh,21h
  @if  CF == 1                        ; 㦥 訡,
       mov  _errCode,EC_OPEN          ; ࠡ.
       call _errEntry
  @endif

  @if  ax #= 2Ch                      ;᫨ 䠩  
       mov  _errCode,EC_FORMAT        ;ଠ,  ࠡ.
       call _errEntry
  @endif

  lea  si,wavIdStr                    ;ࠢ 䨪樮
  lea  di,wavHeader.riffstr           ;ப.
  mov  cx,4
  rep  cmpsb
  @if  ZF == 0                        ;᫨ 䠩  
       mov  _errCode,EC_FORMAT        ;ଠ,  ࠡ.
       call _errEntry
  @endif

  mov  ax,@low(wavHeader.frequence)
  call _wavFrequence                  ;⠭ ᪮ ந뢠.

  @if  wavHeader.channels #= 1        ;᫨ ᫮   1,
       mov  _errCode,EC_FORMAT        ; ࠡ.
       call _errEntry
  @endif

  @if  wavHeader.wavebits #=  8
       mov  _errCode,EC_FORMAT        ;᫨ ᫮   롮 
       call _errEntry                 ;ন,  ࠡ.
  @endif


  @repeat

      mov   dx,@high(wavHeader.dataLen)
      mov   ax,@low(wavHeader.dataLen)
      or    ax,dx
      @exit ZF == 1

      mov  cx,wavBufLen
      @if  <dx == 0> and <cx ++ @low(wavHeader.dataLen)>
           mov cx,@low(wavHeader.dataLen)
      @endif
      sub  @low(wavHeader.dataLen),cx
      sbb  @high(wavHeader.dataLen),0

      push ds                       ; । 
      mov  bx,wavHandle             ;.
      lds  dx,wavBuffer
      @int 3Fh,21h
      pop  ds
      @if  CF == 1                  ; 㦥 訡,
           mov  _errCode,EC_OPEN    ; ࠡ.
           call _errEntry
      @endif

      mov  wavBufFil,ax             ;࠭  ⠭
                                    ;.
      mov  cx,wavBufFil
      push ds
      lds  si,wavBuffer
      call _wavPlay08mono           ;ࠥ...
      pop  ds
  @always

  mov   bx,wavHandle                ; 䠩.
  @int  3Eh,21h
  @quit 0
endp

;ͻ
;  㬥⮢        
;ͼ
argVolume proc near

  @if okVolume == TRUE          ;᫨ ४⥫ ஬ 㦥 ࠡ⠭,
      mov  _errCode,EC_NUMARG   ;஢ 訡 ୮
      call _errEntry            ;᫠ 㬥⮢.
  @endif

  inc si                        ;ய ᨬ "V".
  dec cx                        ;  ⠢襩  ப.

  @if <cx == 0> or <cx ++ 3>    ;᫨ ᫮ ⪮  ,
      mov  _errCode,EC_INVARG   ;஢ 訡 ୮
      call _errEntry            ;⨯ 㬥.
  @endif

  call  _intCDF                 ;८ࠧ ⠭ ஬.

  @if <CF == 1> or <<dx #= 0> or <ax ++ 255>>
      mov  _errCode,EC_INVARG   ;஢ 訡 ୮
      call _errEntry            ;⨯ 㬥.
  @endif

  mov  okVolume,TRUE            ;⠭ ਧ ࠡ⪨ ஬
  call _wavVolume               ; ⠭ ॡ㥬 ஢ ஬.
  ret
endp

argFile proc near

  @if okFile == TRUE            ;᫨  䠩 㦥 ࠡ⠭,
      mov  _errCode,EC_NUMARG   ;஢ 訡 ୮
      call _errEntry            ;᫠ 㬥⮢.
  @endif

  lea di,wavFile                ;஢  䠩  
  rep movsb                     ;࠭    㫥.
  mov es:@byte(di),0
  mov okFile,TRUE               ;⠭ ਧ ࠡ⪨ .
  ret
endp

;ͻ
; 㭪樨 ࠡ⪨ 訡 
;ͼ
wavFatal proc near

  @out  msgTitle
  mov   _errAsk, EA_NOASK
  call  _errGen
  @quit 1
endp

wavFileErr proc near

  @out  msgTitle
  mov   _errAsk, EA_NOASK
  mov   _errObject, offset wavFile
  call  _errGen
  @quit 1
endp

end @Startup
