(****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                         System TRAY sample source                        *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************)

{
To compile this sources you need rc.exe from OS/2 Toolkit.
First, make .RES file with

RC trayex.rc

syntax and than compile this source.


Specially thanks to J. Francisco Garca Mtz., who
slightly improved TrayEx and translated it to spanish.
(Mxico, 2/Ene/2001)

K. Okounkov, D. Zakharov
}

  program TrayEx;

  {&PMTYPE PM}
  {&Use32+}

  Uses Os2Def, Os2Base, Os2PmApi, TrayApi, SysUtils;

  {$R trayex.res}

  Const
        ID_RESOURCE = 100;

  Var
    hwndFrame  : HWND;
    hwndClient : HWND;
    _hmq       : HMQ;
    _qmsg      : QMSG;
    _hab       : HAB;
    i          : byte; //counter for names of icons
    hIcon      : Array [0..5] of HPOINTER;
    Ptl        : PointL; //Pointer coordinates
    a          :integer; // Icons counter.
    hwndMenu : HWND;  //Menu handler.
    AutoChanging:Boolean; // Auto Change Icon menu option status flag

  Function ClientWndProc( wnd : HWND  ; msg : ULONG ;
                          mp1 : MPARAM; mp2 : MPARAM): MRESULT; cdecl;
  Var
    rcl          : RECTL; //rectangle (coordinates)
    PS           : HPS;
    Mensaje          : String;
  Const lColorB  : LONG  = CLR_CYAN;
        lColorF  : LONG  = CLR_DARKBLUE;
        szMsg    : PChar = 'Click left or right mouse button on my Icon in System Tray!';

    Procedure ChangeIcon;
     Begin
        Inc (a) ;
        a :=a mod 5 ;
        WinSendMsg(hwndFrame,WM_SETICON,MPARAM(hIcon[a]),0) ; // Change icono of frame
        ChangeTrayIcon(wnd,0) ; // Notifies to Systray that icon has changed
     End;


  Begin
    Case msg Of
      WM_BUTTON1CLICK or $2000: // 0x2000 means message from Systray.
         WinSetWindowPos(hwndFrame,HWND_TOP,0,0,0,0,SWP_ACTIVATE or SWP_SHOW or SWP_ZORDER or SWP_RESTORE);

      WM_BUTTON2click or $2000: // 0x2000 means message from Systray.
         Begin
            WinQueryPointerPos (HWND_DESKTOP, ptl); // gets mouse pointer coordinates
            WinMapWindowPoints (HWND_DESKTOP,wnd , ptl, 1) ; //Maps coordinates from desktop to client window
            WinPopupMenu(WND, wnd, hwndMenu, ptl.x, ptl.y+16, 0, // Shows Pop-up menu.
                PU_HCONSTRAIN   or // Constrain menu horizontally.
                PU_VCONSTRAIN or // Constrain menu verticaly.
                PU_MOUSEBUTTON1  or //Use menu with mouse button 1
                PU_MOUSEBUTTON2 or  //Use menu with mouse button 2
                PU_KEYBOARD //Use menu with keyboard
                );
         End;
      WM_COMMAND:
         Case Integer(Mp1) Of
            201:WinSetWindowPos(hwndFrame,HWND_TOP,0,0,0,0,SWP_ACTIVATE or SWP_SHOW or SWP_ZORDER or SWP_RESTORE) ; //Restores the window.
            207:WinSetWindowPos(hwndFrame,HWND_TOP,0,0,0,0,SWP_HIDE) ; //Hides the window.
            205:ChangeIcon;
            202:WinPostMsg(wnd, WM_CLOSE, MPARAM(0), MPARAM(0)); //Sends message to close the window.
            204:
            Begin
               Mensaje := 'Application example that uses Systray'+#0;
               WinMessageBox(
                  HWND_DESKTOP,
                  hwndFrame,                // Client window handler
                  @mensaje[1],                  // Message body
                  'About Systray example',   // Message title
                  0,                         // MessageBox ID
                  MB_Information OR MB_OK OR
                  MB_moveable OR
                  MB_ApplModal);       // icon & buttons flags
            End;
            206:
            Begin
               If AutoChanging Then
                  Begin
                     WinStopTimer (_hab,wnd,1);
                     WinSendMsg (hwndMenu, MM_SETITEMATTR,
                        MPFROM2SHORT (206, 1),
                        MPFROM2SHORT (MIA_CHECKED, 0));
                     AutoChanging:=False
                  End
               Else
                  If WinStartTimer(_hab,wnd,1,500) <> 0 THEN
                     Begin
                        WinSendMsg (hwndMenu, MM_SETITEMATTR,
                           MPFROM2SHORT (206, 1),
                           MPFROM2SHORT (MIA_CHECKED, MIA_CHECKED)) ;
                        AutoChanging:=True
                     End
                  Else
                     WinMessageBox (HWND_DESKTOP, wnd,
                        'Too many timers in system',
                        'Error Auto change icon', 0,
                        MB_OK OR MB_WARNING)
            End
         End;
      WM_TIMER:ChangeIcon;
      WM_CREATE:
        Begin
        InitializeTrayApi(wnd); //Initialize Sys Tray
        End;
      WM_DDE_INITIATEACK:
        Begin
        AnswerTrayApiDdeAck(mp1); // Answer to Systray when ask if we are ready.
        AddTrayIcon(wnd,0); // Adds icon to Sys Tray.
        End;
      WM_DESTROY:
        Begin
        DeleteTrayIcon(wnd); // Delete icon from Systray (VERY Important).
        End;
      WM_PAINT:
        Begin

        WinQueryWindowRect(wnd, rcl);
        PS := WinBeginPaint(Wnd, 0, @Rcl);
        WinFillRect(PS, Rcl, lColorB);
        WinDrawText(PS, -1, szMsg, rcl, lColorF, lColorB,
                    DT_CENTER or DT_VCENTER);
        WinEndPaint(PS);

        ClientWndProc := 0; exit;
        End;
    End;
    ClientWndProc := WinDefWindowProc (wnd, msg, mp1, mp2);
  End;



  Const flFrameFlags : ULONG =
                        FCF_TITLEBAR      Or  (*  Title bar                  *)
                        FCF_SIZEBORDER    Or  (*  Sizeable border            *)
                        FCF_MINMAX        Or  (*  Min & Max buttons          *)
                        FCF_SYSMENU       Or  (*  System menu                *)
                        FCF_SHELLPOSITION Or  (*  System Pos & Size          *)
                        FCF_TASKLIST      Or  (*  Show the name in task list *)
                        FCF_ICON           ;  (*  Iconize                    *)

  Begin
    _hab := WinInitialize(0);
    _hmq := WinCreateMsgQueue(_hab, 0);
    a:=0;
    WinRegisterClass(
       _hab,                   (* Anchor block handler        *)
       'TrayExClient',         (* Class name being registered *)
       ClientWndProc,          (* Procedure window class      *)
       CS_SIZEREDRAW Or        (* Class style                 *)
       CS_HITTEST,             (* Class style                 *)
       0);                     (* Extra bytes to reserve      *)

    hwndFrame := WinCreateStdWindow(
                 HWND_DESKTOP,       (* Window parent is Desktop *)
                 WS_VISIBLE,         (* Make frame window visible         *)
                 flFrameFlags,       (* Frame controls *)
                 'TrayExClient',     (* Window class for client *)
                 'Systray example program',     (* Window title *)
                 WS_VISIBLE,         (* Make client window visible *)
                 0,                  (* Module for resources           *)
                 ID_RESOURCE,        (* Resources ID *)
                 nil);               (* Pointer to client window handler *)

    for i:=100 to 104 do  // loads every icon to this array.
       hIcon[i-100] := WinLoadPointer(HWND_DESKTOP,NULLHANDLE,i) ;

    hwndMenu := WinLoadMenu(HWndFrame, 0, 100); // loads the pop-up menu.
    AutoChanging:=False; //Initial state of Auto Change Icon option.


    While WinGetMsg(_hab, _qmsg, 0, 0, 0) Do // process the messages.
          WinDispatchMsg(_hab, _qmsg);
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(_hmq);
    WinTerminate(_hab);
    Halt(0);
  End.



