(****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *               Systemp TRAY Application Interface Library                 *
 *                                                                          *
 * (C) 2000, Russian Team OS/2.                        All Rights Reserved  *
 * Written by Dmitry Zaharov                http://os2.ru/projects/systray  *
 ****************************************************************************)

unit TrayApi;

interface

uses Os2Def, Os2Base, Os2PmApi;

function InitializeTrayApi(win:HWND):boolean;
function AnswerTrayApiDdeAck(mp1:MPARAM):boolean;
function AddTrayIcon(win:HWND; res:ULONG):boolean;
function ChangeTrayIcon(win:HWND; res:ULONG):boolean;
function DeleteTrayIcon(win:HWND):boolean;

const

// do not alter these values

 wm_TrayAddMe = wm_user+1;
 wm_TrayDelMe = wm_user+2;
 wm_TrayIcon  = wm_user+3;
 szAppSS   :PChar = 'SystrayServer';
 szTopicSS :PChar = 'TRAY';

implementation

var

TrayServer : HWND;


function InitializeTrayApi(win:HWND):boolean;
var
pCC:pConvContext;
begin

pCC:=Nil;

WinDdeInitiate(win,SZAPPSS,SZTOPICSS,pCC^);

InitializeTrayApi := true;
end;

function AnswerTrayApiDdeAck(mp1:MPARAM):boolean;
begin

TrayServer := HWND(mp1);

AnswerTrayApiDdeAck := true;
end;

function AddTrayIcon(win:HWND; res:ULONG):boolean;
begin
AddTrayIcon := false;

if TrayServer=0 then exit;

WinPostMsg(TrayServer, wm_TRAYADDME, win, res);

AddTrayIcon := true;
end;

function ChangeTrayIcon(win:HWND; res:ULONG):boolean;
begin
ChangeTrayIcon := false;

if TrayServer=0 then exit;

WinPostMsg(TrayServer, wm_TRAYICON, win, res);

ChangeTrayIcon := true;
end;

function DeleteTrayIcon(win:HWND):boolean;
begin
DeleteTrayIcon := false;

if TrayServer=0 then exit;

WinPostMsg(TrayServer, wm_TRAYDELME, win, 0);

DeleteTrayIcon := true;
end;


end.
