/* @(#) generic/sproc/ins_syn_sql 84.3 7/21/93 */

use master
go

/*
** Create a procedure to print out error messages
*/
if exists (select name from sysobjects where name = "sybsyntax_printmsg")
begin
	drop procedure sybsyntax_printmsg
end
go

create procedure sybsyntax_printmsg
	@message_num	int
as
	declare @msg varchar(255)
	exec sp_getmessage @message_num, @msg output
	print @msg

go

/* create the database, if it does not exist */
if not exists (select name from sysdatabases where name = "sybsyntax")
begin
	/* is the space left on the default database devices > size of model? */
	if  (select sum (high-low +1)  from sysdevices where status & 1 = 1)
	-  (select (isnull (sum(size), 0)) from sysusages, sysdevices
		where vstart >= sysdevices.low
		and vstart <= sysdevices.high
		and sysdevices.status &1 = 1)
		> (select sum(sysusages.size) from sysusages where dbid = 3)
	begin
		create database sybsyntax
	end
	else
		/*
		** 18047, "There is not enough room on the default devices to create the sybsyntax database."
		*/
		exec sybsyntax_printmsg 18047

end
go

if exists (select name from sysdatabases where name = "sybsyntax")
	use sybsyntax
else
	/*
	** 18048, "The sybsyntax database couldn't be created."
	*/
	exec sybsyntax_printmsg 18048
go

/* create the sybsyntax table if it doesn't exist, and sybsyntax does */
if exists (select name from master..sysdatabases where name = "sybsyntax")
begin
	if not exists (select name
			from sybsyntax..sysobjects
			where name = "sybsyntax"
				and type = "U" and uid = 1)
	begin
	/* The table does not exist. Create it. */
		create table sybsyntax
		(commandname	varchar(50)	not null,
		module		varchar(20)	not null,
		linenum		smallint	not null,
		syntax		varchar(78)	not null,
		langid		smallint	null)
	end
end
go

/*
** If the table existed from before. It could be an older version.
** Check to make sure that it has a langid column.
*/
if not exists (select name from sybsyntax..syscolumns 
			 where id = object_id("sybsyntax..sybsyntax")
			 and name = "langid")
begin
	alter table sybsyntax..sybsyntax
	add langid smallint null
end
go

/* create the index on the sybsyntax table */
if not exists (select name from sysindexes where name = "sybsyntax_cuix")
begin
	create unique clustered index sybsyntax_cuix
		on sybsyntax(module, commandname, linenum)
end
go

/* delete existing rows for this module, if there are any
** For DB-Library/C, delete only DB-Library/C. For Transact-SQL,
** delete SQL, sprocs and utilities
*/

if exists (select module from sybsyntax
		where module = "DB-Library/C")

begin
	delete from sybsyntax where module = "DB-Library/C"
	dump transaction sybsyntax with truncate_only
end
go

use master
go

/* drop the insert_syntax procedure, and re-create it */
if exists (select name from sysobjects where name = "insert_syntax")
begin
	drop procedure insert_syntax
end
go

create procedure insert_syntax
	@command varchar(50),
	@module varchar(20),
	@linenum smallint,
	@syntax varchar(78),
	@lang_id smallint = null
as
if exists (select name
		from master..sysdatabases
		where name = "sybsyntax")
begin
	insert sybsyntax..sybsyntax values
		(@command, @module, @linenum, @syntax, @lang_id)
end
go
use master
go


exec insert_syntax 'db12hour',
'DB-Library/C',          1 ,
'db12hour - Determine whether the specified language uses 12-hour'
go
exec insert_syntax 'db12hour',
'DB-Library/C',          2 ,
'        or 24-hour time.'
go
exec insert_syntax 'db12hour',
'DB-Library/C',          3 ,
'    DBBOOL db12hour(dbproc, language)'
go
exec insert_syntax 'db12hour',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'db12hour',
'DB-Library/C',          5 ,
'    char          *language;'
go
exec insert_syntax 'dbadata',
'DB-Library/C',          1 ,
'dbadata - Return a pointer to the data for a compute column.'
go
exec insert_syntax 'dbadata',
'DB-Library/C',          2 ,
'    BYTE *dbadata(dbproc, computeid, column)'
go
exec insert_syntax 'dbadata',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbadata',
'DB-Library/C',          4 ,
'    int           computeid;'
go
exec insert_syntax 'dbadata',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbadlen',
'DB-Library/C',          1 ,
'dbadlen - Return the actual length of the data for a compute'
go
exec insert_syntax 'dbadlen',
'DB-Library/C',          2 ,
'        column.'
go
exec insert_syntax 'dbadlen',
'DB-Library/C',          3 ,
'    DBINT dbadlen(dbproc, computeid, column)'
go
exec insert_syntax 'dbadlen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbadlen',
'DB-Library/C',          5 ,
'    int           computeid;'
go
exec insert_syntax 'dbadlen',
'DB-Library/C',          6 ,
'    int           column;'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          1 ,
'dbaltbind - Bind a compute column to a program variable.'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          2 ,
'    RETCODE dbaltbind(dbproc, computeid, column, vartype,'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          3 ,
'                      varlen, varaddr)'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          5 ,
'    int           computeid;'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          6 ,
'    int           column;'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          7 ,
'    int           vartype;'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          8 ,
'    DBINT         varlen;'
go
exec insert_syntax 'dbaltbind',
'DB-Library/C',          9 ,
'    BYTE          *varaddr;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          1 ,
'dbaltbind_ps - Bind a compute column to a program variable, with'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          2 ,
'        precision and scale support for numeric and decimal'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          3 ,
'        variables.'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          4 ,
'    RETCODE dbaltbind_ps(dbproc, computeid, column,'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          5 ,
'                  vartype, varlen, varaddr,'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          6 ,
'                  typeinfo)'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          7 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          8 ,
'    int           computeid;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          9 ,
'    int           column;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          10,
'    int           vartype;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          11,
'    DBINT         varlen;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          12,
'    BYTE          *varaddr;'
go
exec insert_syntax 'dbaltbind_ps',
'DB-Library/C',          13,
'    DBTYPEINFO    *typeinfo;'
go
exec insert_syntax 'dbaltcolid',
'DB-Library/C',          1 ,
'dbaltcolid - Return the column id for a compute column.'
go
exec insert_syntax 'dbaltcolid',
'DB-Library/C',          2 ,
'    int dbaltcolid(dbproc, computeid, column)'
go
exec insert_syntax 'dbaltcolid',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbaltcolid',
'DB-Library/C',          4 ,
'    int           computeid;'
go
exec insert_syntax 'dbaltcolid',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbaltlen',
'DB-Library/C',          1 ,
'dbaltlen - Return the maximum length of the data for a particular'
go
exec insert_syntax 'dbaltlen',
'DB-Library/C',          2 ,
'        compute column.'
go
exec insert_syntax 'dbaltlen',
'DB-Library/C',          3 ,
'    DBINT dbaltlen(dbproc, computeid, column)'
go
exec insert_syntax 'dbaltlen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbaltlen',
'DB-Library/C',          5 ,
'    int           computeid;'
go
exec insert_syntax 'dbaltlen',
'DB-Library/C',          6 ,
'    int           column;'
go
exec insert_syntax 'dbaltop',
'DB-Library/C',          1 ,
'dbaltop - Return the type of aggregate operator for a particular'
go
exec insert_syntax 'dbaltop',
'DB-Library/C',          2 ,
'        compute column.'
go
exec insert_syntax 'dbaltop',
'DB-Library/C',          3 ,
'    int dbaltop(dbproc, computeid, column)'
go
exec insert_syntax 'dbaltop',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbaltop',
'DB-Library/C',          5 ,
'    int           computeid;'
go
exec insert_syntax 'dbaltop',
'DB-Library/C',          6 ,
'    int           column;'
go
exec insert_syntax 'dbalttype',
'DB-Library/C',          1 ,
'dbalttype - Return the datatype for a compute column.'
go
exec insert_syntax 'dbalttype',
'DB-Library/C',          2 ,
'    int dbalttype(dbproc, computeid, column)'
go
exec insert_syntax 'dbalttype',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbalttype',
'DB-Library/C',          4 ,
'    int           computeid;'
go
exec insert_syntax 'dbalttype',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbaltutype',
'DB-Library/C',          1 ,
'dbaltutype - Return the user-defined datatype for a compute'
go
exec insert_syntax 'dbaltutype',
'DB-Library/C',          2 ,
'        column.'
go
exec insert_syntax 'dbaltutype',
'DB-Library/C',          3 ,
'    DBINT dbaltutype(dbproc, computeid, column)'
go
exec insert_syntax 'dbaltutype',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbaltutype',
'DB-Library/C',          5 ,
'    int           computeid;'
go
exec insert_syntax 'dbaltutype',
'DB-Library/C',          6 ,
'    int           column;'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          1 ,
'dbanullbind - Associate an indicator variable with a compute-row'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          2 ,
'        column.'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          3 ,
'    RETCODE dbanullbind(dbproc, computeid, column,'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          4 ,
'                        indicator)'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          6 ,
'    int           computeid;'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          7 ,
'    int           column;'
go
exec insert_syntax 'dbanullbind',
'DB-Library/C',          8 ,
'    DBINT         *indicator;'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          1 ,
'dbbind - Bind a regular result column to a program variable.'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          2 ,
'    RETCODE dbbind(dbproc, column, vartype, varlen, varaddr)'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          4 ,
'    int           column;'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          5 ,
'    int           vartype;'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          6 ,
'    DBINT         varlen;'
go
exec insert_syntax 'dbbind',
'DB-Library/C',          7 ,
'    BYTE          *varaddr;'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          1 ,
'dbbind_ps - Bind a regular result column to a program variable,'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          2 ,
'        with precision and scale support for numeric and'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          3 ,
'        decimal variables.'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          4 ,
'    RETCODE dbbind_ps(dbproc, column, vartype, varlen,'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          5 ,
'                  varaddr, typeinfo)'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          6 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          7 ,
'    int           column;'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          8 ,
'    int           vartype;'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          9 ,
'    DBINT         varlen;'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          10,
'    BYTE          *varaddr;'
go
exec insert_syntax 'dbbind_ps',
'DB-Library/C',          11,
'    DBTYPEINFO    *typeinfo;'
go
exec insert_syntax 'dbbufsize',
'DB-Library/C',          1 ,
'dbbufsize - Return the size of a DBPROCESS row buffer.'
go
exec insert_syntax 'dbbufsize',
'DB-Library/C',          2 ,
'    int dbbufsize(dbproc)'
go
exec insert_syntax 'dbbufsize',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbbylist',
'DB-Library/C',          1 ,
'dbbylist - Return the bylist for a compute row.'
go
exec insert_syntax 'dbbylist',
'DB-Library/C',          2 ,
'    BYTE *dbbylist(dbproc, computeid, size)'
go
exec insert_syntax 'dbbylist',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbbylist',
'DB-Library/C',          4 ,
'    int           computeid;'
go
exec insert_syntax 'dbbylist',
'DB-Library/C',          5 ,
'    int           *size;'
go
exec insert_syntax 'dbcancel',
'DB-Library/C',          1 ,
'dbcancel - Cancel the current command batch.'
go
exec insert_syntax 'dbcancel',
'DB-Library/C',          2 ,
'    RETCODE dbcancel(dbproc)'
go
exec insert_syntax 'dbcancel',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          1 ,
'dbcancel_a - Cancel the current command batch (VMS only).'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          2 ,
'    RETCODE dbcancel_a(dbproc, final_result, ast_proc,'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          3 ,
'                       ast_param)'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          5 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          6 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbcancel_a',
'DB-Library/C',          7 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbcanquery',
'DB-Library/C',          1 ,
'dbcanquery - Cancel any rows pending from the most recently'
go
exec insert_syntax 'dbcanquery',
'DB-Library/C',          2 ,
'        executed query.'
go
exec insert_syntax 'dbcanquery',
'DB-Library/C',          3 ,
'    RETCODE dbcanquery(dbproc)'
go
exec insert_syntax 'dbcanquery',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          1 ,
'dbcanquery_a - Cancel any rows pending from the most recently'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          2 ,
'        executed query (VMS only).'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          3 ,
'    RETCODE dbcanquery_a(dbproc, final_result, ast_proc,'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          4 ,
'                   ast_param)'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          6 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          7 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbcanquery_a',
'DB-Library/C',          8 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbchange',
'DB-Library/C',          1 ,
'dbchange - Determine whether a command batch has changed the'
go
exec insert_syntax 'dbchange',
'DB-Library/C',          2 ,
'        current database.'
go
exec insert_syntax 'dbchange',
'DB-Library/C',          3 ,
'    char *dbchange(dbproc)'
go
exec insert_syntax 'dbchange',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcharsetconv',
'DB-Library/C',          1 ,
'dbcharsetconv - Indicate whether the server is performing character'
go
exec insert_syntax 'dbcharsetconv',
'DB-Library/C',          2 ,
'        set translation.'
go
exec insert_syntax 'dbcharsetconv',
'DB-Library/C',          3 ,
'    DBBOOL dbcharsetconv(dbproc)'
go
exec insert_syntax 'dbcharsetconv',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbclose',
'DB-Library/C',          1 ,
'dbclose - Close and de-allocate a single DBPROCESS structure.'
go
exec insert_syntax 'dbclose',
'DB-Library/C',          2 ,
'    void dbclose(dbproc)'
go
exec insert_syntax 'dbclose',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbclrbuf',
'DB-Library/C',          1 ,
'dbclrbuf - Drop rows from the row buffer.'
go
exec insert_syntax 'dbclrbuf',
'DB-Library/C',          2 ,
'    void dbclrbuf(dbproc, n)'
go
exec insert_syntax 'dbclrbuf',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbclrbuf',
'DB-Library/C',          4 ,
'    DBINT         n;'
go
exec insert_syntax 'dbclropt',
'DB-Library/C',          1 ,
'dbclropt - Clear an option set by dbsetopt.'
go
exec insert_syntax 'dbclropt',
'DB-Library/C',          2 ,
'    RETCODE dbclropt(dbproc, option, param)'
go
exec insert_syntax 'dbclropt',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbclropt',
'DB-Library/C',          4 ,
'    int           option;'
go
exec insert_syntax 'dbclropt',
'DB-Library/C',          5 ,
'    char          *param;'
go
exec insert_syntax 'dbcmd',
'DB-Library/C',          1 ,
'dbcmd - Add text to the DBPROCESS command buffer.'
go
exec insert_syntax 'dbcmd',
'DB-Library/C',          2 ,
'    RETCODE dbcmd(dbproc, cmdstring)'
go
exec insert_syntax 'dbcmd',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcmd',
'DB-Library/C',          4 ,
'    char          *cmdstring;'
go
exec insert_syntax 'dbcmdrow',
'DB-Library/C',          1 ,
'DBCMDROW - Determine whether the current command can return'
go
exec insert_syntax 'dbcmdrow',
'DB-Library/C',          2 ,
'        rows.'
go
exec insert_syntax 'dbcmdrow',
'DB-Library/C',          3 ,
'    RETCODE DBCMDROW(dbproc)'
go
exec insert_syntax 'dbcmdrow',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcolbrowse',
'DB-Library/C',          1 ,
'dbcolbrowse - Determine whether the source of a regular result'
go
exec insert_syntax 'dbcolbrowse',
'DB-Library/C',          2 ,
'        column is updatable via the DB-Library browse-mode'
go
exec insert_syntax 'dbcolbrowse',
'DB-Library/C',          3 ,
'        facilities.'
go
exec insert_syntax 'dbcolbrowse',
'DB-Library/C',          4 ,
'    DBBOOL dbcolbrowse(dbproc, colnum)'
go
exec insert_syntax 'dbcolbrowse',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcolbrowse',
'DB-Library/C',          6 ,
'    int           colnum;'
go
exec insert_syntax 'dbcollen',
'DB-Library/C',          1 ,
'dbcollen - Return the maximum length of the data in a regular'
go
exec insert_syntax 'dbcollen',
'DB-Library/C',          2 ,
'        result column.'
go
exec insert_syntax 'dbcollen',
'DB-Library/C',          3 ,
'    DBINT dbcollen(dbproc, column)'
go
exec insert_syntax 'dbcollen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcollen',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbcolname',
'DB-Library/C',          1 ,
'dbcolname - Return the name of a regular result column.'
go
exec insert_syntax 'dbcolname',
'DB-Library/C',          2 ,
'    char *dbcolname(dbproc, column)'
go
exec insert_syntax 'dbcolname',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcolname',
'DB-Library/C',          4 ,
'    int           column;'
go
exec insert_syntax 'dbcolsource',
'DB-Library/C',          1 ,
'dbcolsource - Return a pointer to the name of the database column'
go
exec insert_syntax 'dbcolsource',
'DB-Library/C',          2 ,
'        from which the specified regular result column was'
go
exec insert_syntax 'dbcolsource',
'DB-Library/C',          3 ,
'        derived.'
go
exec insert_syntax 'dbcolsource',
'DB-Library/C',          4 ,
'    char *dbcolsource(dbproc, colnum)'
go
exec insert_syntax 'dbcolsource',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcolsource',
'DB-Library/C',          6 ,
'    int           colnum;'
go
exec insert_syntax 'dbcoltype',
'DB-Library/C',          1 ,
'dbcoltype - Return the datatype for a regular result column.'
go
exec insert_syntax 'dbcoltype',
'DB-Library/C',          2 ,
'    int dbcoltype(dbproc, column)'
go
exec insert_syntax 'dbcoltype',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcoltype',
'DB-Library/C',          4 ,
'    int           column;'
go
exec insert_syntax 'dbcolutype',
'DB-Library/C',          1 ,
'dbcolutype - Return the user-defined datatype for a regular result'
go
exec insert_syntax 'dbcolutype',
'DB-Library/C',          2 ,
'        column.'
go
exec insert_syntax 'dbcolutype',
'DB-Library/C',          3 ,
'    DBINT dbcolutype(dbproc, column)'
go
exec insert_syntax 'dbcolutype',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcolutype',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          1 ,
'dbconvert - Convert data from one datatype to another.'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          2 ,
'    DBINT dbconvert(dbproc, srctype, src, srclen,'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          3 ,
'                    desttype, dest, destlen)'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          5 ,
'    int           srctype;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          6 ,
'    BYTE          *src;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          7 ,
'    DBINT         srclen;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          8 ,
'    int           desttype;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          9 ,
'    BYTE          *dest;'
go
exec insert_syntax 'dbconvert',
'DB-Library/C',          10,
'    DBINT         destlen;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          1 ,
'dbconvert_ps - Convert data from one datatype to another, with'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          2 ,
'        precision and scale support for numeric and decimal'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          3 ,
'        types.'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          4 ,
'    DBINT dbconvert_ps(dbproc, srctype, src, srclen,'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          5 ,
'                    desttype, dest, destlen, typeinfo)'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          6 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          7 ,
'    int           srctype;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          8 ,
'    BYTE          *src;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          9 ,
'    DBINT         srclen;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          10,
'    int           desttype;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          11,
'    BYTE          *dest;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          12,
'    DBINT         destlen;'
go
exec insert_syntax 'dbconvert_ps',
'DB-Library/C',          13,
'    DBTYPEINFO    *typeinfo;'
go
exec insert_syntax 'dbcount',
'DB-Library/C',          1 ,
'DBCOUNT - Return the number of rows affected by a Transact-SQL command.'
go
exec insert_syntax 'dbcount',
'DB-Library/C',          2 ,
'    DBINT DBCOUNT(dbproc)'
go
exec insert_syntax 'dbcount',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcurcmd',
'DB-Library/C',          1 ,
'DBCURCMD - Return the number of the current command.'
go
exec insert_syntax 'dbcurcmd',
'DB-Library/C',          2 ,
'    int DBCURCMD(dbproc)'
go
exec insert_syntax 'dbcurcmd',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcurrow',
'DB-Library/C',          1 ,
'DBCURROW - Return the number of the row currently being read.'
go
exec insert_syntax 'dbcurrow',
'DB-Library/C',          2 ,
'    DBINT DBCURROW(dbproc)'
go
exec insert_syntax 'dbcurrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          1 ,
'dbcursor - Inserts, updates, deletes, locks, or refreshes a'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          2 ,
'        particular row in the fetch buffer.'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          3 ,
'    RETCODE dbcursor(hc, optype, bufno, table, values)'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          4 ,
'    DBCURSOR      *hc;'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          5 ,
'    SHORT         optype;'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          6 ,
'    SHORT         bufno;'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          7 ,
'    BYTE          *table;'
go
exec insert_syntax 'dbcursor',
'DB-Library/C',          8 ,
'    BYTE          *values'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          1 ,
'dbcursorbind - Registers the binding information on the cursor'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          2 ,
'        columns.'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          3 ,
'    RETCODE dbcursorbind(hc, col, vartype, varlen,'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          4 ,
'                  poutlen, pvaraddr)'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          5 ,
'    DBCURSOR      hc;'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          6 ,
'    int           col;'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          7 ,
'    int           vartype;'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          8 ,
'    DBINT         varlen;'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          9 ,
'    DBINT         *poutlen;'
go
exec insert_syntax 'dbcursorbind',
'DB-Library/C',          10,
'    BYTE          *pvaraddr;'
go
exec insert_syntax 'dbcursorclose',
'DB-Library/C',          1 ,
'dbcursorclose - Closes the cursor associated with the given handle,'
go
exec insert_syntax 'dbcursorclose',
'DB-Library/C',          2 ,
'        releasing all the data belonging to it.'
go
exec insert_syntax 'dbcursorclose',
'DB-Library/C',          3 ,
'    void dbcursorclose(hc)'
go
exec insert_syntax 'dbcursorclose',
'DB-Library/C',          4 ,
'    DBCURSOR      *hc;'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          1 ,
'dbcursorcolinfo - Returns column information for the specified column'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          2 ,
'        number in the open cursor.'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          3 ,
'    RETCODE dbcursorcolinfo(hcursor, column, colname,'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          4 ,
'                  coltype, collen, usertype)'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          5 ,
'    DBCURSOR       *hcursor'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          6 ,
'    int           column;'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          7 ,
'    char          *colname;'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          8 ,
'    int           *coltype;'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          9 ,
'    DBINT         *collen;'
go
exec insert_syntax 'dbcursorcolinfo',
'DB-Library/C',          10,
'    int           *usertype;'
go
exec insert_syntax 'dbcursorfetch',
'DB-Library/C',          1 ,
'dbcursorfetch - Fetches a block of rows into the program variables'
go
exec insert_syntax 'dbcursorfetch',
'DB-Library/C',          2 ,
'        declared by the user in dbcursorbind.'
go
exec insert_syntax 'dbcursorfetch',
'DB-Library/C',          3 ,
'    RETCODE dbcursorfetch(hc, fetchtype, rownum)'
go
exec insert_syntax 'dbcursorfetch',
'DB-Library/C',          4 ,
'    DBCURSOR      *hc;'
go
exec insert_syntax 'dbcursorfetch',
'DB-Library/C',          5 ,
'    SHORT         fetchtype;'
go
exec insert_syntax 'dbcursorfetch',
'DB-Library/C',          6 ,
'    SHORT         rownum;'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          1 ,
'dbcursorinfo - Returns the number of columns and the number of rows'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          2 ,
'        in the keyset if the keyset hit the end of the result'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          3 ,
'        set.'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          4 ,
'    RETCODE dbcursorinfo(hcursor, ncols, nrows);'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          5 ,
'    DBCURSOR      *hcursor;'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          6 ,
'    int           *ncols'
go
exec insert_syntax 'dbcursorinfo',
'DB-Library/C',          7 ,
'    DBINT         *nrows;'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          1 ,
'dbcursoropen - Opens a cursor, specifying the scroll option,'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          2 ,
'        concurrency option, and the size of the fetch buffer'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          3 ,
'        (the number of rows retrieved with a single fetch).'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          4 ,
'    hc=dbcursoropen(dbproc, stmt, concuropt, nrows,'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          5 ,
'                  pstatus)'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          6 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          7 ,
'    BYTE          *stmt;'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          8 ,
'    SHORT         scrollopt;'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          9 ,
'    SHORT         concuropt;'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          10,
'    USHORT        nrows;'
go
exec insert_syntax 'dbcursoropen',
'DB-Library/C',          11,
'    DBINT         *pstatus'
go
exec insert_syntax 'dbdata',
'DB-Library/C',          1 ,
'dbdata - Return a pointer to the data in a regular result'
go
exec insert_syntax 'dbdata',
'DB-Library/C',          2 ,
'        column.'
go
exec insert_syntax 'dbdata',
'DB-Library/C',          3 ,
'    BYTE *dbdata(dbproc, column)'
go
exec insert_syntax 'dbdata',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdata',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbdate4cmp',
'DB-Library/C',          1 ,
'dbdate4cmp - Compare two DBDATETIME4 values.'
go
exec insert_syntax 'dbdate4cmp',
'DB-Library/C',          2 ,
'    int dbdate4cmp(dbproc, d1, d2)'
go
exec insert_syntax 'dbdate4cmp',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdate4cmp',
'DB-Library/C',          4 ,
'    DBDATETIME4   *d1;'
go
exec insert_syntax 'dbdate4cmp',
'DB-Library/C',          5 ,
'    DBDATETIME4   *d2;'
go
exec insert_syntax 'dbdate4zero',
'DB-Library/C',          1 ,
'dbdate4zero - Initialize a DBDATETIME4 variable to Jan 1, 1900'
go
exec insert_syntax 'dbdate4zero',
'DB-Library/C',          2 ,
'        12:00AM.'
go
exec insert_syntax 'dbdate4zero',
'DB-Library/C',          3 ,
'    RETCODE dbdate4zero(dbproc, dateptr)'
go
exec insert_syntax 'dbdate4zero',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdate4zero',
'DB-Library/C',          5 ,
'    DBDATETIME4   *dateptr;'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          1 ,
'dbdatechar - Convert an integer component of a DBDATETIME value'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          2 ,
'        into character format.'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          3 ,
'    RETCODE dbdatechar(dbproc, charbuf, datepart, value)'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          5 ,
'    char          *charbuf;'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          6 ,
'    int           datepart;'
go
exec insert_syntax 'dbdatechar',
'DB-Library/C',          7 ,
'    int           value;'
go
exec insert_syntax 'dbdatecmp',
'DB-Library/C',          1 ,
'dbdatecmp - Compare two DBDATETIME values.'
go
exec insert_syntax 'dbdatecmp',
'DB-Library/C',          2 ,
'    int dbdatecmp(dbproc, d1, d2)'
go
exec insert_syntax 'dbdatecmp',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatecmp',
'DB-Library/C',          4 ,
'    DBDATETIME    *d1;'
go
exec insert_syntax 'dbdatecmp',
'DB-Library/C',          5 ,
'    DBDATETIME    *d2;'
go
exec insert_syntax 'dbdatecrack',
'DB-Library/C',          1 ,
'dbdatecrack - Convert a machine-readable DBDATETIME value into'
go
exec insert_syntax 'dbdatecrack',
'DB-Library/C',          2 ,
'        user-accessible format.'
go
exec insert_syntax 'dbdatecrack',
'DB-Library/C',          3 ,
'    RETCODE dbdatecrack(dbproc, dateinfo, datetime)'
go
exec insert_syntax 'dbdatecrack',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatecrack',
'DB-Library/C',          5 ,
'    DBDATEREC     *dateinfo;'
go
exec insert_syntax 'dbdatecrack',
'DB-Library/C',          6 ,
'    DBDATETIME    *datetime;'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          1 ,
'dbdatename - Convert the specified component of a DBDATETIME'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          2 ,
'        structure into its corresponding character string.'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          3 ,
'    int dbdatename(dbproc, charbuf, datepart, datetime)'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          5 ,
'    char          *charbuf;'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          6 ,
'    int           datepart;'
go
exec insert_syntax 'dbdatename',
'DB-Library/C',          7 ,
'    DBDATETIME    *datetime;'
go
exec insert_syntax 'dbdateorder',
'DB-Library/C',          1 ,
'dbdateorder - Return the date component order for a given language.'
go
exec insert_syntax 'dbdateorder',
'DB-Library/C',          2 ,
'    char *dbdateorder(dbproc, language)'
go
exec insert_syntax 'dbdateorder',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdateorder',
'DB-Library/C',          4 ,
'    char          *language;'
go
exec insert_syntax 'dbdatepart',
'DB-Library/C',          1 ,
'dbdatepart - Return the specified part of a DBDATETIME value as a'
go
exec insert_syntax 'dbdatepart',
'DB-Library/C',          2 ,
'        numeric value.'
go
exec insert_syntax 'dbdatepart',
'DB-Library/C',          3 ,
'    DBINT dbdatepart(dbproc, datepart, datetime)'
go
exec insert_syntax 'dbdatepart',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatepart',
'DB-Library/C',          5 ,
'    int           datepart;'
go
exec insert_syntax 'dbdatepart',
'DB-Library/C',          6 ,
'    DBDATETIME    *datetime;'
go
exec insert_syntax 'dbdatezero',
'DB-Library/C',          1 ,
'dbdatezero - Initialize a DBDATETIME value to Jan 1, 1900'
go
exec insert_syntax 'dbdatezero',
'DB-Library/C',          2 ,
'        12:00:00:000AM.'
go
exec insert_syntax 'dbdatezero',
'DB-Library/C',          3 ,
'    RETCODE dbdatezero(dbproc, dateptr)'
go
exec insert_syntax 'dbdatezero',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatezero',
'DB-Library/C',          5 ,
'    DBDATETIME    *dateptr;'
go
exec insert_syntax 'dbdatlen',
'DB-Library/C',          1 ,
'dbdatlen - Return the length of the data in a regular result'
go
exec insert_syntax 'dbdatlen',
'DB-Library/C',          2 ,
'        column.'
go
exec insert_syntax 'dbdatlen',
'DB-Library/C',          3 ,
'    DBINT dbdatlen(dbproc, column)'
go
exec insert_syntax 'dbdatlen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdatlen',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbdayname',
'DB-Library/C',          1 ,
'dbdayname - Determine the name of a specified weekday in a'
go
exec insert_syntax 'dbdayname',
'DB-Library/C',          2 ,
'        specified language.'
go
exec insert_syntax 'dbdayname',
'DB-Library/C',          3 ,
'    char *dbdayname(dbproc, language, daynum)'
go
exec insert_syntax 'dbdayname',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbdayname',
'DB-Library/C',          5 ,
'    char          *language;'
go
exec insert_syntax 'dbdayname',
'DB-Library/C',          6 ,
'    int           daynum;'
go
exec insert_syntax 'dbdead',
'DB-Library/C',          1 ,
'DBDEAD - Determine whether a particular DBPROCESS is dead.'
go
exec insert_syntax 'dbdead',
'DB-Library/C',          2 ,
'    DBBOOL DBDEAD(dbproc)'
go
exec insert_syntax 'dbdead',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dberrhandle',
'DB-Library/C',          1 ,
'dberrhandle - Install a user function to handle DB-Library errors.'
go
exec insert_syntax 'dberrhandle',
'DB-Library/C',          2 ,
'    int (*dberrhandle(handler))()'
go
exec insert_syntax 'dberrhandle',
'DB-Library/C',          3 ,
'    int           (*handler)();'
go
exec insert_syntax 'dbexit',
'DB-Library/C',          1 ,
'dbexit - Close and de-allocate all DBPROCESS structures, and'
go
exec insert_syntax 'dbexit',
'DB-Library/C',          2 ,
'        clean up any structures initialized by dbinit.'
go
exec insert_syntax 'dbexit',
'DB-Library/C',          3 ,
'    void dbexit()'
go
exec insert_syntax 'dbfcmd',
'DB-Library/C',          1 ,
'dbfcmd - Add text to the DBPROCESS command buffer using C'
go
exec insert_syntax 'dbfcmd',
'DB-Library/C',          2 ,
'        run-time library sprintf-type formatting.'
go
exec insert_syntax 'dbfcmd',
'DB-Library/C',          3 ,
'    RETCODE dbfcmd(dbproc, cmdstring, args...)'
go
exec insert_syntax 'dbfcmd',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbfcmd',
'DB-Library/C',          5 ,
'    char          *cmdstring;'
go
exec insert_syntax 'dbfcmd',
'DB-Library/C',          6 ,
'    long          args...;'
go
exec insert_syntax 'dbfirstrow',
'DB-Library/C',          1 ,
'DBFIRSTROW - Return the number of the first row in the row buffer.'
go
exec insert_syntax 'dbfirstrow',
'DB-Library/C',          2 ,
'    DBINT DBFIRSTROW(dbproc)'
go
exec insert_syntax 'dbfirstrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbfree_xlate',
'DB-Library/C',          1 ,
'dbfree_xlate - Free a pair of character set translation tables.'
go
exec insert_syntax 'dbfree_xlate',
'DB-Library/C',          2 ,
'    RETCODE *dbfree_xlate(dbproc, xlt_tosrv, xlt_todisp)'
go
exec insert_syntax 'dbfree_xlate',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbfree_xlate',
'DB-Library/C',          4 ,
'    DBXLATE       *xlt_tosrv;'
go
exec insert_syntax 'dbfree_xlate',
'DB-Library/C',          5 ,
'    DBXLATE       *xlt_todisp;'
go
exec insert_syntax 'dbfreebuf',
'DB-Library/C',          1 ,
'dbfreebuf - Clear the command buffer.'
go
exec insert_syntax 'dbfreebuf',
'DB-Library/C',          2 ,
'    void dbfreebuf(dbproc)'
go
exec insert_syntax 'dbfreebuf',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbfreequal',
'DB-Library/C',          1 ,
'dbfreequal - Free the memory allocated by dbqual.'
go
exec insert_syntax 'dbfreequal',
'DB-Library/C',          2 ,
'    void dbfreequal(qualptr)'
go
exec insert_syntax 'dbfreequal',
'DB-Library/C',          3 ,
'    char          *qualptr;'
go
exec insert_syntax 'dbfreesort',
'DB-Library/C',          1 ,
'dbfreesort - Free a sort order structure allocated by dbloadsort.'
go
exec insert_syntax 'dbfreesort',
'DB-Library/C',          2 ,
'    RETCODE dbfreesort(dbproc, sortorder)'
go
exec insert_syntax 'dbfreesort',
'DB-Library/C',          3 ,
'    DBPROCESS      *dbproc;'
go
exec insert_syntax 'dbfreesort',
'DB-Library/C',          4 ,
'    DBSORTORDER    *sortorder;'
go
exec insert_syntax 'dbgetchar',
'DB-Library/C',          1 ,
'dbgetchar - Return a pointer to a character in the command'
go
exec insert_syntax 'dbgetchar',
'DB-Library/C',          2 ,
'        buffer.'
go
exec insert_syntax 'dbgetchar',
'DB-Library/C',          3 ,
'    char *dbgetchar(dbproc, n)'
go
exec insert_syntax 'dbgetchar',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetchar',
'DB-Library/C',          5 ,
'    int           n;'
go
exec insert_syntax 'dbgetcharset',
'DB-Library/C',          1 ,
'dbgetcharset - Get the name of the client character set from the'
go
exec insert_syntax 'dbgetcharset',
'DB-Library/C',          2 ,
'        DBPROCESS structure.'
go
exec insert_syntax 'dbgetcharset',
'DB-Library/C',          3 ,
'    char *dbgetcharset(dbproc)'
go
exec insert_syntax 'dbgetcharset',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetloginfo',
'DB-Library/C',          1 ,
'dbgetloginfo - Transfer TDS login response information from a'
go
exec insert_syntax 'dbgetloginfo',
'DB-Library/C',          2 ,
'        DBPROCESS structure to a newly-allocated DBLOGINFO'
go
exec insert_syntax 'dbgetloginfo',
'DB-Library/C',          3 ,
'        structure.'
go
exec insert_syntax 'dbgetloginfo',
'DB-Library/C',          4 ,
'    RETCODE dbgetloginfo(dbproc, loginfo)'
go
exec insert_syntax 'dbgetloginfo',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetloginfo',
'DB-Library/C',          6 ,
'    DBLOGINFO     **loginfo;'
go
exec insert_syntax 'dbgetlusername',
'DB-Library/C',          1 ,
'dbgetlusername - Return the user name from a LOGINREC structure.'
go
exec insert_syntax 'dbgetlusername',
'DB-Library/C',          2 ,
'    int dbgetlusername(login, name_buffer, buffer_len)'
go
exec insert_syntax 'dbgetlusername',
'DB-Library/C',          3 ,
'    LOGINREC      *login;'
go
exec insert_syntax 'dbgetlusername',
'DB-Library/C',          4 ,
'    BYTE          *name_buffer;'
go
exec insert_syntax 'dbgetlusername',
'DB-Library/C',          5 ,
'    int           buffer_len;'
go
exec insert_syntax 'dbgetmaxprocs',
'DB-Library/C',          1 ,
'dbgetmaxprocs - Determine the current maximum number of simultaneously'
go
exec insert_syntax 'dbgetmaxprocs',
'DB-Library/C',          2 ,
'        open DBPROCESSes.'
go
exec insert_syntax 'dbgetmaxprocs',
'DB-Library/C',          3 ,
'    int dbgetmaxprocs()'
go
exec insert_syntax 'dbgetnatlang',
'DB-Library/C',          1 ,
'dbgetnatlang - Get the national language from the DBPROCESS'
go
exec insert_syntax 'dbgetnatlang',
'DB-Library/C',          2 ,
'        structure.'
go
exec insert_syntax 'dbgetnatlang',
'DB-Library/C',          3 ,
'    char* dbgetnatlang(dbproc)'
go
exec insert_syntax 'dbgetnatlang',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetoff',
'DB-Library/C',          1 ,
'dbgetoff - Check for the existence of Transact-SQL constructs in'
go
exec insert_syntax 'dbgetoff',
'DB-Library/C',          2 ,
'        the command buffer.'
go
exec insert_syntax 'dbgetoff',
'DB-Library/C',          3 ,
'    int dbgetoff(dbproc, offtype, startfrom)'
go
exec insert_syntax 'dbgetoff',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetoff',
'DB-Library/C',          5 ,
'    DBUSMALLINT   offtype;'
go
exec insert_syntax 'dbgetoff',
'DB-Library/C',          6 ,
'    int           startfrom;'
go
exec insert_syntax 'dbgetpacket',
'DB-Library/C',          1 ,
'dbgetpacket - Return the TDS packet size currently in use.'
go
exec insert_syntax 'dbgetpacket',
'DB-Library/C',          2 ,
'    int dbgetpacket(dbproc)'
go
exec insert_syntax 'dbgetpacket',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetrow',
'DB-Library/C',          1 ,
'dbgetrow - Read the specified row in the row buffer.'
go
exec insert_syntax 'dbgetrow',
'DB-Library/C',          2 ,
'    STATUS dbgetrow(dbproc, row)'
go
exec insert_syntax 'dbgetrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbgetrow',
'DB-Library/C',          4 ,
'    DBINT         row;'
go
exec insert_syntax 'dbgettime',
'DB-Library/C',          1 ,
'DBGETTIME - Return the number of seconds that DB-Library will wait'
go
exec insert_syntax 'dbgettime',
'DB-Library/C',          2 ,
'        for a server response to a SQL command.'
go
exec insert_syntax 'dbgettime',
'DB-Library/C',          3 ,
'    int DBGETTIME()'
go
exec insert_syntax 'dbgetuserdata',
'DB-Library/C',          1 ,
'dbgetuserdata - Return a pointer to user-allocated data from a'
go
exec insert_syntax 'dbgetuserdata',
'DB-Library/C',          2 ,
'        DBPROCESS structure.'
go
exec insert_syntax 'dbgetuserdata',
'DB-Library/C',          3 ,
'    BYTE *dbgetuserdata(dbproc)'
go
exec insert_syntax 'dbgetuserdata',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbhasretstat',
'DB-Library/C',          1 ,
'dbhasretstat - Determine whether the current command or remote'
go
exec insert_syntax 'dbhasretstat',
'DB-Library/C',          2 ,
'        procedure call generated a return status number.'
go
exec insert_syntax 'dbhasretstat',
'DB-Library/C',          3 ,
'    DBBOOL dbhasretstat(dbprWoc)'
go
exec insert_syntax 'dbhasretstat',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbinit',
'DB-Library/C',          1 ,
'dbinit - Initialize DB-Library.'
go
exec insert_syntax 'dbinit',
'DB-Library/C',          2 ,
'    RETCODE dbinit()'
go
exec insert_syntax 'dbiordesc',
'DB-Library/C',          1 ,
'DBIORDESC - Provide program access to the UNIX or AOS/VS file'
go
exec insert_syntax 'dbiordesc',
'DB-Library/C',          2 ,
'        descriptor used by a DBPROCESS to read data coming'
go
exec insert_syntax 'dbiordesc',
'DB-Library/C',          3 ,
'        from the server (UNIX and AOS/VS only).'
go
exec insert_syntax 'dbiordesc (unix and aos/vs',
'DB-Library/C',          1 ,
'    int DBIORDESC(dbproc)'
go
exec insert_syntax 'dbiordesc (unix and aos/vs',
'DB-Library/C',          2 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbiowdesc',
'DB-Library/C',          1 ,
'DBIOWDESC - Provide program access to the UNIX or AOS/VS file'
go
exec insert_syntax 'dbiowdesc',
'DB-Library/C',          2 ,
'        descriptor used by a DBPROCESS to write data to the'
go
exec insert_syntax 'dbiowdesc',
'DB-Library/C',          3 ,
'        server (UNIX and AOS/VS only).'
go
exec insert_syntax 'dbiowdesc (unix and aos/vs',
'DB-Library/C',          1 ,
'    int DBIOWDESC(dbproc)'
go
exec insert_syntax 'dbiowdesc (unix and aos/vs',
'DB-Library/C',          2 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbisavail',
'DB-Library/C',          1 ,
'DBISAVAIL - Determine whether a DBPROCESS is available for general'
go
exec insert_syntax 'dbisavail',
'DB-Library/C',          2 ,
'        use.'
go
exec insert_syntax 'dbisavail',
'DB-Library/C',          3 ,
'    DBBOOL DBISAVAIL(dbproc)'
go
exec insert_syntax 'dbisavail',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbisopt',
'DB-Library/C',          1 ,
'dbisopt - Check the status of a server or DB-Library option.'
go
exec insert_syntax 'dbisopt',
'DB-Library/C',          2 ,
'    DBBOOL dbisopt(dbproc, option, param)'
go
exec insert_syntax 'dbisopt',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbisopt',
'DB-Library/C',          4 ,
'    int           option;'
go
exec insert_syntax 'dbisopt',
'DB-Library/C',          5 ,
'    char          *param;'
go
exec insert_syntax 'dblastrow',
'DB-Library/C',          1 ,
'DBLASTROW - Return the number of the last row in the row buffer.'
go
exec insert_syntax 'dblastrow',
'DB-Library/C',          2 ,
'    DBINT DBLASTROW(dbproc)'
go
exec insert_syntax 'dblastrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          1 ,
'dbload_xlate - Load a pair of character set translation tables.'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          2 ,
'    RETCODE dbload_xlate(dbproc, srv_charset, xlate_name,'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          3 ,
'                         xlt_tosrv, xlt_todisp)'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          5 ,
'    char          *srv_charset;'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          6 ,
'    char          *xlt_name;'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          7 ,
'    DBXLATE       **xlt_tosrv;'
go
exec insert_syntax 'dbload_xlate',
'DB-Library/C',          8 ,
'    DBXLATE       **xlt_todisp;'
go
exec insert_syntax 'dbloadsort',
'DB-Library/C',          1 ,
'dbloadsort - Load a server sort order.'
go
exec insert_syntax 'dbloadsort',
'DB-Library/C',          2 ,
'    DBSORTORDER *dbloadsort(dbproc)'
go
exec insert_syntax 'dbloadsort',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dblogin',
'DB-Library/C',          1 ,
'dblogin - Allocate a login record for use in dbopen.'
go
exec insert_syntax 'dblogin',
'DB-Library/C',          2 ,
'    LOGINREC *dblogin()'
go
exec insert_syntax 'dbloginfree',
'DB-Library/C',          1 ,
'dbloginfree - Free a login record.'
go
exec insert_syntax 'dbloginfree',
'DB-Library/C',          2 ,
'    void dbloginfree(loginptr)'
go
exec insert_syntax 'dbloginfree',
'DB-Library/C',          3 ,
'    LOGINREC      *loginptr;'
go
exec insert_syntax 'dbmny4add',
'DB-Library/C',          1 ,
'dbmny4add - Add two DBMONEY4 values.'
go
exec insert_syntax 'dbmny4add',
'DB-Library/C',          2 ,
'    RETCODE dbmny4add(dbproc, m1, m2, sum)'
go
exec insert_syntax 'dbmny4add',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4add',
'DB-Library/C',          4 ,
'    DBMONEY4      *m1;'
go
exec insert_syntax 'dbmny4add',
'DB-Library/C',          5 ,
'    DBMONEY4      *m2;'
go
exec insert_syntax 'dbmny4add',
'DB-Library/C',          6 ,
'    DBMONEY4      *sum;'
go
exec insert_syntax 'dbmny4cmp',
'DB-Library/C',          1 ,
'dbmny4cmp - Compare two DBMONEY4 values.'
go
exec insert_syntax 'dbmny4cmp',
'DB-Library/C',          2 ,
'    int dbmny4cmp(dbproc, m1, m2)'
go
exec insert_syntax 'dbmny4cmp',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4cmp',
'DB-Library/C',          4 ,
'    DBMONEY4      *m1;'
go
exec insert_syntax 'dbmny4cmp',
'DB-Library/C',          5 ,
'    DBMONEY4      *m2;'
go
exec insert_syntax 'dbmny4copy',
'DB-Library/C',          1 ,
'dbmny4copy - Copy a DBMONEY4 value.'
go
exec insert_syntax 'dbmny4copy',
'DB-Library/C',          2 ,
'    RETCODE dbmny4copy(dbproc, src, dest)'
go
exec insert_syntax 'dbmny4copy',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4copy',
'DB-Library/C',          4 ,
'    DBMONEY4      *src;'
go
exec insert_syntax 'dbmny4copy',
'DB-Library/C',          5 ,
'    DBMONEY4      *dest;'
go
exec insert_syntax 'dbmny4divide',
'DB-Library/C',          1 ,
'dbmny4divide - Divide one DBMONEY4 value by another.'
go
exec insert_syntax 'dbmny4divide',
'DB-Library/C',          2 ,
'    RETCODE dbmny4divide(dbproc, m1, m2, quotient)'
go
exec insert_syntax 'dbmny4divide',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4divide',
'DB-Library/C',          4 ,
'    DBMONEY4      *m1;'
go
exec insert_syntax 'dbmny4divide',
'DB-Library/C',          5 ,
'    DBMONEY4      *m2;'
go
exec insert_syntax 'dbmny4divide',
'DB-Library/C',          6 ,
'    DBMONEY4      *quotient;'
go
exec insert_syntax 'dbmny4minus',
'DB-Library/C',          1 ,
'dbmny4minus - Negate a DBMONEY4 value.'
go
exec insert_syntax 'dbmny4minus',
'DB-Library/C',          2 ,
'    RETCODE dbmny4minus(dbproc, src, dest)'
go
exec insert_syntax 'dbmny4minus',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4minus',
'DB-Library/C',          4 ,
'    DBMONEY4      *src;'
go
exec insert_syntax 'dbmny4minus',
'DB-Library/C',          5 ,
'    DBMONEY4      *dest;'
go
exec insert_syntax 'dbmny4mul',
'DB-Library/C',          1 ,
'dbmny4mul - Multiply two DBMONEY4 values.'
go
exec insert_syntax 'dbmny4mul',
'DB-Library/C',          2 ,
'    RETCODE dbmny4mul(dbproc, m1, m2, product)'
go
exec insert_syntax 'dbmny4mul',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4mul',
'DB-Library/C',          4 ,
'    DBMONEY4      *m1;'
go
exec insert_syntax 'dbmny4mul',
'DB-Library/C',          5 ,
'    DBMONEY4      *m2;'
go
exec insert_syntax 'dbmny4mul',
'DB-Library/C',          6 ,
'    DBMONEY4      *product;'
go
exec insert_syntax 'dbmny4sub',
'DB-Library/C',          1 ,
'dbmny4sub - Subtract one DBMONEY4 value from another.'
go
exec insert_syntax 'dbmny4sub',
'DB-Library/C',          2 ,
'    RETCODE dbmny4sub(dbproc, m1, m2, difference)'
go
exec insert_syntax 'dbmny4sub',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4sub',
'DB-Library/C',          4 ,
'    DBMONEY4      *m1;'
go
exec insert_syntax 'dbmny4sub',
'DB-Library/C',          5 ,
'    DBMONEY4      *m2;'
go
exec insert_syntax 'dbmny4sub',
'DB-Library/C',          6 ,
'    DBMONEY4      *difference;'
go
exec insert_syntax 'dbmny4zero',
'DB-Library/C',          1 ,
'dbmny4zero - Initialize a DBMONEY4 variable to $0.0000.'
go
exec insert_syntax 'dbmny4zero',
'DB-Library/C',          2 ,
'    RETCODE dbmny4zero(dbproc, mny4ptr)'
go
exec insert_syntax 'dbmny4zero',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmny4zero',
'DB-Library/C',          4 ,
'    DBMONEY4      *mny4ptr;'
go
exec insert_syntax 'dbmnyadd',
'DB-Library/C',          1 ,
'dbmnyadd - Add two DBMONEY values.'
go
exec insert_syntax 'dbmnyadd',
'DB-Library/C',          2 ,
'    RETCODE dbmnyadd(dbproc, m1, m2, sum)'
go
exec insert_syntax 'dbmnyadd',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyadd',
'DB-Library/C',          4 ,
'    DBMONEY       *m1;'
go
exec insert_syntax 'dbmnyadd',
'DB-Library/C',          5 ,
'    DBMONEY       *m2;'
go
exec insert_syntax 'dbmnyadd',
'DB-Library/C',          6 ,
'    DBMONEY       *sum;'
go
exec insert_syntax 'dbmnycmp',
'DB-Library/C',          1 ,
'dbmnycmp - Compare two DBMONEY values.'
go
exec insert_syntax 'dbmnycmp',
'DB-Library/C',          2 ,
'    int dbmnycmp(dbproc, m1, m2)'
go
exec insert_syntax 'dbmnycmp',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnycmp',
'DB-Library/C',          4 ,
'    DBMONEY       *m1;'
go
exec insert_syntax 'dbmnycmp',
'DB-Library/C',          5 ,
'    DBMONEY       *m2;'
go
exec insert_syntax 'dbmnycopy',
'DB-Library/C',          1 ,
'dbmnycopy - Copy a DBMONEY value.'
go
exec insert_syntax 'dbmnycopy',
'DB-Library/C',          2 ,
'    RETCODE dbmnycopy(dbproc, src, dest)'
go
exec insert_syntax 'dbmnycopy',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnycopy',
'DB-Library/C',          4 ,
'    DBMONEY       *src;'
go
exec insert_syntax 'dbmnycopy',
'DB-Library/C',          5 ,
'    DBMONEY       *dest;'
go
exec insert_syntax 'dbmnydec',
'DB-Library/C',          1 ,
'dbmnydec - Decrement a DBMONEY value by one ten-thousandth of a'
go
exec insert_syntax 'dbmnydec',
'DB-Library/C',          2 ,
'        dollar.'
go
exec insert_syntax 'dbmnydec',
'DB-Library/C',          3 ,
'    RETCODE dbmnydec(dbproc, mnyptr)'
go
exec insert_syntax 'dbmnydec',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnydec',
'DB-Library/C',          5 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmnydivide',
'DB-Library/C',          1 ,
'dbmnydivide - Divide one DBMONEY value by another.'
go
exec insert_syntax 'dbmnydivide',
'DB-Library/C',          2 ,
'    RETCODE dbmnydivide(dbproc, m1, m2, quotient)'
go
exec insert_syntax 'dbmnydivide',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnydivide',
'DB-Library/C',          4 ,
'    DBMONEY       *m1;'
go
exec insert_syntax 'dbmnydivide',
'DB-Library/C',          5 ,
'    DBMONEY       *m2;'
go
exec insert_syntax 'dbmnydivide',
'DB-Library/C',          6 ,
'    DBMONEY       *quotient;'
go
exec insert_syntax 'dbmnydown',
'DB-Library/C',          1 ,
'dbmnydown - Divide a DBMONEY value by a positive integer.'
go
exec insert_syntax 'dbmnydown',
'DB-Library/C',          2 ,
'    RETCODE dbmnydown(dbproc, mnyptr, divisor, remainder)'
go
exec insert_syntax 'dbmnydown',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnydown',
'DB-Library/C',          4 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmnydown',
'DB-Library/C',          5 ,
'    int           divisor;'
go
exec insert_syntax 'dbmnydown',
'DB-Library/C',          6 ,
'    int           *remainder;'
go
exec insert_syntax 'dbmnyinc',
'DB-Library/C',          1 ,
'dbmnyinc - Increment a DBMONEY value by one ten-thousandth of a'
go
exec insert_syntax 'dbmnyinc',
'DB-Library/C',          2 ,
'        dollar.'
go
exec insert_syntax 'dbmnyinc',
'DB-Library/C',          3 ,
'    RETCODE dbmnyinc(dbproc, mnyptr)'
go
exec insert_syntax 'dbmnyinc',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyinc',
'DB-Library/C',          5 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmnyinit',
'DB-Library/C',          1 ,
'dbmnyinit - Prepare a DBMONEY value for calls to dbmnyndigit.'
go
exec insert_syntax 'dbmnyinit',
'DB-Library/C',          2 ,
'    RETCODE dbmnyinit(dbproc, mnyptr, trim, negative)'
go
exec insert_syntax 'dbmnyinit',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyinit',
'DB-Library/C',          4 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmnyinit',
'DB-Library/C',          5 ,
'    int           trim;'
go
exec insert_syntax 'dbmnyinit',
'DB-Library/C',          6 ,
'    DBBOOL        *negative;'
go
exec insert_syntax 'dbmnymaxneg',
'DB-Library/C',          1 ,
'dbmnymaxneg - Return the maximum negative DBMONEY value supported.'
go
exec insert_syntax 'dbmnymaxneg',
'DB-Library/C',          2 ,
'    RETCODE dbmnymaxneg(dbproc,dest)'
go
exec insert_syntax 'dbmnymaxneg',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnymaxneg',
'DB-Library/C',          4 ,
'    DBMONEY       *dest;'
go
exec insert_syntax 'dbmnymaxpos',
'DB-Library/C',          1 ,
'dbmnymaxpos - Returns the maximum positive DBMONEY value supported.'
go
exec insert_syntax 'dbmnymaxpos',
'DB-Library/C',          2 ,
'    RETCODE dbmnymaxpos(dbproc, dest)'
go
exec insert_syntax 'dbmnymaxpos',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnymaxpos',
'DB-Library/C',          4 ,
'    DBMONEY       *dest;'
go
exec insert_syntax 'dbmnyminus',
'DB-Library/C',          1 ,
'dbmnyminus - Negate a DBMONEY value.'
go
exec insert_syntax 'dbmnyminus',
'DB-Library/C',          2 ,
'    RETCODE dbmnyminus(dbproc, src, dest)'
go
exec insert_syntax 'dbmnyminus',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyminus',
'DB-Library/C',          4 ,
'    DBMONEY       *src;'
go
exec insert_syntax 'dbmnyminus',
'DB-Library/C',          5 ,
'    DBMONEY       *dest;'
go
exec insert_syntax 'dbmnymul',
'DB-Library/C',          1 ,
'dbmnymul - Multiply two DBMONEY values.'
go
exec insert_syntax 'dbmnymul',
'DB-Library/C',          2 ,
'    RETCODE dbmnymul(dbproc, m1, m2, product)'
go
exec insert_syntax 'dbmnymul',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnymul',
'DB-Library/C',          4 ,
'    DBMONEY       *m1;'
go
exec insert_syntax 'dbmnymul',
'DB-Library/C',          5 ,
'    DBMONEY       *m2;'
go
exec insert_syntax 'dbmnymul',
'DB-Library/C',          6 ,
'    DBMONEY       *product;'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          1 ,
'dbmnyndigit - Return the rightmost digit of a DBMONEY value as a'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          2 ,
'        DBCHAR.'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          3 ,
'    RETCODE dbmnyndigit(dbproc, mnyptr, value, zero)'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          5 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          6 ,
'    DBCHAR        *value;'
go
exec insert_syntax 'dbmnyndigit',
'DB-Library/C',          7 ,
'    DBBOOL        *zero;'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          1 ,
'dbmnyscale - Multiply a DBMONEY value by a positive integer and add'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          2 ,
'        a specified amount.'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          3 ,
'    RETCODE dbmnyscale(dbproc, mnyptr, multiplier, addend)'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          5 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          6 ,
'    int           multiplier;'
go
exec insert_syntax 'dbmnyscale',
'DB-Library/C',          7 ,
'    int           addend;'
go
exec insert_syntax 'dbmnysub',
'DB-Library/C',          1 ,
'dbmnysub - Subtract one DBMONEY value from another.'
go
exec insert_syntax 'dbmnysub',
'DB-Library/C',          2 ,
'    RETCODE dbmnysub(dbproc, m1, m2, difference)'
go
exec insert_syntax 'dbmnysub',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnysub',
'DB-Library/C',          4 ,
'    DBMONEY       *m1;'
go
exec insert_syntax 'dbmnysub',
'DB-Library/C',          5 ,
'    DBMONEY       *m2;'
go
exec insert_syntax 'dbmnysub',
'DB-Library/C',          6 ,
'    DBMONEY       *difference;'
go
exec insert_syntax 'dbmnyzero',
'DB-Library/C',          1 ,
'dbmnyzero - Initialize a DBMONEY value to $0.0000.'
go
exec insert_syntax 'dbmnyzero',
'DB-Library/C',          2 ,
'    RETCODE dbmnyzero(dbproc, mnyptr)'
go
exec insert_syntax 'dbmnyzero',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmnyzero',
'DB-Library/C',          4 ,
'    DBMONEY       *mnyptr;'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          1 ,
'dbmonthname - Determine the name of a specified month in a specified'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          2 ,
'        language.'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          3 ,
'    char *dbmonthname(dbproc, language, monthnum,'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          4 ,
'                      shortform)'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          6 ,
'    char          *language;'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          7 ,
'    int           monthnum;'
go
exec insert_syntax 'dbmonthname',
'DB-Library/C',          8 ,
'    DBBOOL        shortform;'
go
exec insert_syntax 'dbmorecmds',
'DB-Library/C',          1 ,
'DBMORECMDS - Indicate whether there are more commands to be'
go
exec insert_syntax 'dbmorecmds',
'DB-Library/C',          2 ,
'        processed.'
go
exec insert_syntax 'dbmorecmds',
'DB-Library/C',          3 ,
'    RETCODE DBMORECMDS(dbproc)'
go
exec insert_syntax 'dbmorecmds',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmoretext',
'DB-Library/C',          1 ,
'dbmoretext - Send part of a text or image value to the server.'
go
exec insert_syntax 'dbmoretext',
'DB-Library/C',          2 ,
'    RETCODE dbmoretext(dbproc, size, text)'
go
exec insert_syntax 'dbmoretext',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbmoretext',
'DB-Library/C',          4 ,
'    DBINT         size;'
go
exec insert_syntax 'dbmoretext',
'DB-Library/C',          5 ,
'    BYTE          *text;'
go
exec insert_syntax 'dbmsghandle',
'DB-Library/C',          1 ,
'dbmsghandle - Install a user function to handle server messages.'
go
exec insert_syntax 'dbmsghandle',
'DB-Library/C',          2 ,
'    int (*dbmsghandle(handler))()'
go
exec insert_syntax 'dbmsghandle',
'DB-Library/C',          3 ,
'    int           (*handler)();'
go
exec insert_syntax 'dbname',
'DB-Library/C',          1 ,
'dbname - Return the name of the current database.'
go
exec insert_syntax 'dbname',
'DB-Library/C',          2 ,
'    char *dbname(dbproc)'
go
exec insert_syntax 'dbname',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnextrow',
'DB-Library/C',          1 ,
'dbnextrow - Read the next result row.'
go
exec insert_syntax 'dbnextrow',
'DB-Library/C',          2 ,
'    STATUS dbnextrow(dbproc)'
go
exec insert_syntax 'dbnextrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          1 ,
'dbnextrow_a - Read the next result row (VMS only).'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          2 ,
'    STATUS dbnextrow_a(dbproc, final_result, ast_proc,'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          3 ,
'                       ast_param)'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          5 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          6 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbnextrow_a',
'DB-Library/C',          7 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbnpcreate',
'DB-Library/C',          1 ,
'dbnpcreate - Create a notification procedure.'
go
exec insert_syntax 'dbnpcreate',
'DB-Library/C',          2 ,
'    RETCODE dbnpcreate(dbproc)'
go
exec insert_syntax 'dbnpcreate',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnpdefine',
'DB-Library/C',          1 ,
'dbnpdefine - Define a notification procedure.'
go
exec insert_syntax 'dbnpdefine',
'DB-Library/C',          2 ,
'    RETCODE dbnpdefine(dbproc, procedure_name, namelen)'
go
exec insert_syntax 'dbnpdefine',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnpdefine',
'DB-Library/C',          4 ,
'    DBCHAR        *procedure_name;'
go
exec insert_syntax 'dbnpdefine',
'DB-Library/C',          5 ,
'    DBSMALLINT    namelen;'
go
exec insert_syntax 'dbnullbind',
'DB-Library/C',          1 ,
'dbnullbind - Associate an indicator variable with a regular result'
go
exec insert_syntax 'dbnullbind',
'DB-Library/C',          2 ,
'        row column.'
go
exec insert_syntax 'dbnullbind',
'DB-Library/C',          3 ,
'    RETCODE dbnullbind(dbproc, column, indicator)'
go
exec insert_syntax 'dbnullbind',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnullbind',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbnullbind',
'DB-Library/C',          6 ,
'    DBINT         *indicator;'
go
exec insert_syntax 'dbnumalts',
'DB-Library/C',          1 ,
'dbnumalts - Return the number of columns in a compute row.'
go
exec insert_syntax 'dbnumalts',
'DB-Library/C',          2 ,
'    int dbnumalts(dbproc, computeid)'
go
exec insert_syntax 'dbnumalts',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnumalts',
'DB-Library/C',          4 ,
'    int           computeid;'
go
exec insert_syntax 'dbnumcols',
'DB-Library/C',          1 ,
'dbnumcols - Determine the number of regular columns for the'
go
exec insert_syntax 'dbnumcols',
'DB-Library/C',          2 ,
'        current set of results.'
go
exec insert_syntax 'dbnumcols',
'DB-Library/C',          3 ,
'    int dbnumcols(dbproc)'
go
exec insert_syntax 'dbnumcols',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnumcompute',
'DB-Library/C',          1 ,
'dbnumcompute - Return the number of compute clauses in the current'
go
exec insert_syntax 'dbnumcompute',
'DB-Library/C',          2 ,
'        set of results.'
go
exec insert_syntax 'dbnumcompute',
'DB-Library/C',          3 ,
'    int dbnumcompute(dbproc)'
go
exec insert_syntax 'dbnumcompute',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnumorders',
'DB-Library/C',          1 ,
'DBNUMORDERS - Return the number of columns specified in a'
go
exec insert_syntax 'dbnumorders',
'DB-Library/C',          2 ,
'        Transact-SQL select statement''s order by clause.'
go
exec insert_syntax 'dbnumorders',
'DB-Library/C',          3 ,
'    int DBNUMORDERS(dbproc)'
go
exec insert_syntax 'dbnumorders',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbnumrets',
'DB-Library/C',          1 ,
'dbnumrets - Determine the number of return parameter values'
go
exec insert_syntax 'dbnumrets',
'DB-Library/C',          2 ,
'        generated by a stored procedure.'
go
exec insert_syntax 'dbnumrets',
'DB-Library/C',          3 ,
'    int dbnumrets(dbproc)'
go
exec insert_syntax 'dbnumrets',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbopen',
'DB-Library/C',          1 ,
'dbopen - Create and initialize a DBPROCESS structure.'
go
exec insert_syntax 'dbopen',
'DB-Library/C',          2 ,
'    DBPROCESS *dbopen(login, server)'
go
exec insert_syntax 'dbopen',
'DB-Library/C',          3 ,
'    LOGINREC      *login;'
go
exec insert_syntax 'dbopen',
'DB-Library/C',          4 ,
'    char          *server;'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          1 ,
'dbopen_a - Create and initialize a DBPROCESS structure (VMS only).'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          2 ,
'    RETCODE dbopen_a(login, server, dbproc, final_result,'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          3 ,
'                     ast_proc, ast_param)'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          4 ,
'    LOGINREC      *login;'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          5 ,
'    char          *server;'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          6 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          7 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          8 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbopen_a',
'DB-Library/C',          9 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbordercol',
'DB-Library/C',          1 ,
'dbordercol - Return the id of a column appearing in the most'
go
exec insert_syntax 'dbordercol',
'DB-Library/C',          2 ,
'        recently executed query''s order by clause.'
go
exec insert_syntax 'dbordercol',
'DB-Library/C',          3 ,
'    int dbordercol(dbproc, order)'
go
exec insert_syntax 'dbordercol',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbordercol',
'DB-Library/C',          5 ,
'    int           order;'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          1 ,
'dbpoll - Check if a server response has arrived for a'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          2 ,
'        DBPROCESS.'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          3 ,
'    RETCODE dbpoll(dbproc, milliseconds, ready_dbproc,'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          4 ,
'                   return_reason)'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          6 ,
'    long          milliseconds;'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          7 ,
'    DBPROCESS     **ready_dbproc;'
go
exec insert_syntax 'dbpoll',
'DB-Library/C',          8 ,
'    int           *return_reason;'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          1 ,
'dbpoll_a - Check if a server response has arrived for a'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          2 ,
'        DBPROCESS (VMS only).'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          3 ,
'    RETCODE dbpoll(dbproc, milliseconds, ready_dbproc,'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          4 ,
'                   return_reason, final_result, ast_proc,'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          5 ,
'                   ast_param)'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          6 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          7 ,
'    long          milliseconds;'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          8 ,
'    DBPROCESS     **ready_dbproc;'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          9 ,
'    int           *return_reason;'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          10,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          11,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbpoll_a',
'DB-Library/C',          12,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbprhead',
'DB-Library/C',          1 ,
'dbprhead - Print the column headings for rows returned from the'
go
exec insert_syntax 'dbprhead',
'DB-Library/C',          2 ,
'        server.'
go
exec insert_syntax 'dbprhead',
'DB-Library/C',          3 ,
'    void dbprhead(dbproc)'
go
exec insert_syntax 'dbprhead',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbprrow',
'DB-Library/C',          1 ,
'dbprrow - Print all the rows returned from the server.'
go
exec insert_syntax 'dbprrow',
'DB-Library/C',          2 ,
'    RETCODE dbprrow(dbproc)'
go
exec insert_syntax 'dbprrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbprtype',
'DB-Library/C',          1 ,
'dbprtype - Convert a token value to a readable string.'
go
exec insert_syntax 'dbprtype',
'DB-Library/C',          2 ,
'    char *dbprtype(token)'
go
exec insert_syntax 'dbprtype',
'DB-Library/C',          3 ,
'    int           token;'
go
exec insert_syntax 'dbqual',
'DB-Library/C',          1 ,
'dbqual - Return a pointer to a where clause suitable for use in'
go
exec insert_syntax 'dbqual',
'DB-Library/C',          2 ,
'        updating the current row in a browsable table.'
go
exec insert_syntax 'dbqual',
'DB-Library/C',          3 ,
'    char *dbqual(dbproc, tabnum, tabname)'
go
exec insert_syntax 'dbqual',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbqual',
'DB-Library/C',          5 ,
'    int           tabnum;'
go
exec insert_syntax 'dbqual',
'DB-Library/C',          6 ,
'    char          *tabname;'
go
exec insert_syntax 'dbrbuf',
'DB-Library/C',          1 ,
'DBRBUF - Determine whether the DB-Library network buffer'
go
exec insert_syntax 'dbrbuf',
'DB-Library/C',          2 ,
'        contains any unread bytes (UNIX and AOS/VS only).'
go
exec insert_syntax 'dbrbuf',
'DB-Library/C',          3 ,
'    DBBOOL DBRBUF(dbproc)'
go
exec insert_syntax 'dbrbuf',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbreadpage',
'DB-Library/C',          1 ,
'dbreadpage - Read a page of binary data from the server.'
go
exec insert_syntax 'dbreadpage',
'DB-Library/C',          2 ,
'    DBINT dbreadpage(dbproc, dbname, pageno, buf)'
go
exec insert_syntax 'dbreadpage',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbreadpage',
'DB-Library/C',          4 ,
'    char          *dbname;'
go
exec insert_syntax 'dbreadpage',
'DB-Library/C',          5 ,
'    DBINT         pageno;'
go
exec insert_syntax 'dbreadpage',
'DB-Library/C',          6 ,
'    BYTE          buf[];'
go
exec insert_syntax 'dbreadtext',
'DB-Library/C',          1 ,
'dbreadtext - Read part of a text or image value from the server.'
go
exec insert_syntax 'dbreadtext',
'DB-Library/C',          2 ,
'    STATUS dbreadtext(dbproc, buf, bufsize)'
go
exec insert_syntax 'dbreadtext',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbreadtext',
'DB-Library/C',          4 ,
'    void          *buf;'
go
exec insert_syntax 'dbreadtext',
'DB-Library/C',          5 ,
'    DBINT         bufsize;'
go
exec insert_syntax 'dbrecftos',
'DB-Library/C',          1 ,
'dbrecftos - Record all SQL sent from the application to the'
go
exec insert_syntax 'dbrecftos',
'DB-Library/C',          2 ,
'        server.'
go
exec insert_syntax 'dbrecftos',
'DB-Library/C',          3 ,
'    void dbrecftos(filename)'
go
exec insert_syntax 'dbrecftos',
'DB-Library/C',          4 ,
'    char          *filename;'
go
exec insert_syntax 'dbrecvpassthru',
'DB-Library/C',          1 ,
'dbrecvpassthru - Receive a TDS packet from a server.'
go
exec insert_syntax 'dbrecvpassthru',
'DB-Library/C',          2 ,
'    RETCODE dbrecvpassthru(dbproc, recv_bufp)'
go
exec insert_syntax 'dbrecvpassthru',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrecvpassthru',
'DB-Library/C',          4 ,
'    DBVOIDPTR     *recv_bufp;'
go
exec insert_syntax 'dbregdrop',
'DB-Library/C',          1 ,
'dbregdrop - Drop a registered procedure.'
go
exec insert_syntax 'dbregdrop',
'DB-Library/C',          2 ,
'    RETCODE dbregdrop(dbproc, procedure_name, namelen)'
go
exec insert_syntax 'dbregdrop',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbregdrop',
'DB-Library/C',          4 ,
'    DBCHAR        *procedure_name;'
go
exec insert_syntax 'dbregdrop',
'DB-Library/C',          5 ,
'    DBSMALLINT    namelen;'
go
exec insert_syntax 'dbregexec',
'DB-Library/C',          1 ,
'dbregexec - Execute a registered procedure.'
go
exec insert_syntax 'dbregexec',
'DB-Library/C',          2 ,
'    RETCODE dbregexec(dbproc, options)'
go
exec insert_syntax 'dbregexec',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbregexec',
'DB-Library/C',          4 ,
'    DBUSMALLINT   options;'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          1 ,
'dbreghandle - Install a handler routine for a registered procedure'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          2 ,
'        notification.'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          3 ,
'    RETCODE dbreghandle(dbproc, procedure_name, namelen,'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          4 ,
'                        handler)'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          6 ,
'    DBCHAR        *procedure_name;'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          7 ,
'    DBSMALLINT    namelen;'
go
exec insert_syntax 'dbreghandle',
'DB-Library/C',          8 ,
'    INTFUNCPTR    handler;'
go
exec insert_syntax 'dbreginit',
'DB-Library/C',          1 ,
'dbreginit - Initiate execution of a registered procedure.'
go
exec insert_syntax 'dbreginit',
'DB-Library/C',          2 ,
'    RETCODE dbreginit(dbproc, procedure_name, namelen)'
go
exec insert_syntax 'dbreginit',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbreginit',
'DB-Library/C',          4 ,
'    DBCHAR        *procedure_name;'
go
exec insert_syntax 'dbreginit',
'DB-Library/C',          5 ,
'    DBSMALLINT    namelen;'
go
exec insert_syntax 'dbreglist',
'DB-Library/C',          1 ,
'dbreglist - Return a list of registered procedures currently'
go
exec insert_syntax 'dbreglist',
'DB-Library/C',          2 ,
'        defined in Open Server.'
go
exec insert_syntax 'dbreglist',
'DB-Library/C',          3 ,
'    RETCODE dbreglist(dbproc)'
go
exec insert_syntax 'dbreglist',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          1 ,
'dbregnowatch - Cancel a request to be notified when a registered'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          2 ,
'        procedure executes.'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          3 ,
'    RETCODE dbregnowatch(dbproc, procedure_name,'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          4 ,
'                         namelen)'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          6 ,
'    DBCHAR        *procedure_name;'
go
exec insert_syntax 'dbregnowatch',
'DB-Library/C',          7 ,
'    DBSMALLINT    namelen;'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          1 ,
'dbregparam - Define or describe a registered procedure parameter.'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          2 ,
'    RETCODE dbregparam(dbproc,param_name, type, datalen,'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          3 ,
'                       data)'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          5 ,
'    char          *param_name;'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          6 ,
'    int           type;'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          7 ,
'    DBINT         datalen;'
go
exec insert_syntax 'dbregparam',
'DB-Library/C',          8 ,
'    BYTE          *data;'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          1 ,
'dbregwatch - Request to be notified when a registered procedure'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          2 ,
'        executes.'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          3 ,
'    RETCODE dbregwatch(dbproc, procedure_name,namelen,'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          4 ,
'                       options)'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          6 ,
'    DBCHAR        *procedure_name;'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          7 ,
'    DBSMALLINT    namelen;'
go
exec insert_syntax 'dbregwatch',
'DB-Library/C',          8 ,
'    DBUSMALLINT   options;'
go
exec insert_syntax 'dbregwatchlist',
'DB-Library/C',          1 ,
'dbregwatchlist - Return a list of registered procedures that a'
go
exec insert_syntax 'dbregwatchlist',
'DB-Library/C',          2 ,
'        DBPROCESS is watching for.'
go
exec insert_syntax 'dbregwatchlist',
'DB-Library/C',          3 ,
'    RETCODE dbregwatchlist(dbproc)'
go
exec insert_syntax 'dbregwatchlist',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbresults',
'DB-Library/C',          1 ,
'dbresults - Set up the results of the next query.'
go
exec insert_syntax 'dbresults',
'DB-Library/C',          2 ,
'    RETCODE dbresults(dbproc)'
go
exec insert_syntax 'dbresults',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          1 ,
'dbresults_a - Set up the results of the next query (VMS only).'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          2 ,
'    RETCODE dbresults_a(dbproc, final_result, ast_proc,'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          3 ,
'                        ast_param)'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          5 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          6 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbresults_a',
'DB-Library/C',          7 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbretdata',
'DB-Library/C',          1 ,
'dbretdata - Return a pointer to a return parameter value generated'
go
exec insert_syntax 'dbretdata',
'DB-Library/C',          2 ,
'        by a stored procedure.'
go
exec insert_syntax 'dbretdata',
'DB-Library/C',          3 ,
'    BYTE *dbretdata(dbproc, retnum)'
go
exec insert_syntax 'dbretdata',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbretdata',
'DB-Library/C',          5 ,
'    int           retnum;'
go
exec insert_syntax 'dbretlen',
'DB-Library/C',          1 ,
'dbretlen - Determine the length of a return parameter value'
go
exec insert_syntax 'dbretlen',
'DB-Library/C',          2 ,
'        generated by a stored procedure.'
go
exec insert_syntax 'dbretlen',
'DB-Library/C',          3 ,
'    DBINT dbretlen(dbproc, retnum)'
go
exec insert_syntax 'dbretlen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbretlen',
'DB-Library/C',          5 ,
'    int           retnum;'
go
exec insert_syntax 'dbretname',
'DB-Library/C',          1 ,
'dbretname - Determine the name of the stored procedure parameter'
go
exec insert_syntax 'dbretname',
'DB-Library/C',          2 ,
'        associated with a particular return parameter value.'
go
exec insert_syntax 'dbretname',
'DB-Library/C',          3 ,
'    char *dbretname(dbproc, retnum)'
go
exec insert_syntax 'dbretname',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbretname',
'DB-Library/C',          5 ,
'    int           retnum;'
go
exec insert_syntax 'dbretstatus',
'DB-Library/C',          1 ,
'dbretstatus - Determine the stored procedure status number returned'
go
exec insert_syntax 'dbretstatus',
'DB-Library/C',          2 ,
'        by the current command or remote procedure call.'
go
exec insert_syntax 'dbretstatus',
'DB-Library/C',          3 ,
'    DBINT dbretstatus(dbproc)'
go
exec insert_syntax 'dbretstatus',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrettype',
'DB-Library/C',          1 ,
'dbrettype - Determine the datatype of a return parameter value'
go
exec insert_syntax 'dbrettype',
'DB-Library/C',          2 ,
'        generated by a stored procedure.'
go
exec insert_syntax 'dbrettype',
'DB-Library/C',          3 ,
'    int dbrettype(dbproc, retnum)'
go
exec insert_syntax 'dbrettype',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrettype',
'DB-Library/C',          5 ,
'    int           retnum;'
go
exec insert_syntax 'dbrows',
'DB-Library/C',          1 ,
'DBROWS - Indicate whether the current command actually returned'
go
exec insert_syntax 'dbrows',
'DB-Library/C',          2 ,
'        rows.'
go
exec insert_syntax 'dbrows',
'DB-Library/C',          3 ,
'    RETCODE DBROWS(dbproc)'
go
exec insert_syntax 'dbrows',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrowtype',
'DB-Library/C',          1 ,
'DBROWTYPE - Return the type of the current row.'
go
exec insert_syntax 'dbrowtype',
'DB-Library/C',          2 ,
'    STATUS DBROWTYPE(dbproc)'
go
exec insert_syntax 'dbrowtype',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrpcinit',
'DB-Library/C',          1 ,
'dbrpcinit - Initialize a remote procedure call.'
go
exec insert_syntax 'dbrpcinit',
'DB-Library/C',          2 ,
'    RETCODE dbrpcinit(dbproc, rpcname, options)'
go
exec insert_syntax 'dbrpcinit',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrpcinit',
'DB-Library/C',          4 ,
'    char          *rpcname;'
go
exec insert_syntax 'dbrpcinit',
'DB-Library/C',          5 ,
'    DBSMALLINT    options;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          1 ,
'dbrpcparam - Add a parameter to a remote procedure call.'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          2 ,
'    RETCODE dbrpcparam(dbproc, paramname, status, type,'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          3 ,
'                       maxlen, datalen, value)'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          5 ,
'    char          *paramname;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          6 ,
'    BYTE          status;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          7 ,
'    int           type;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          8 ,
'    DBINT         maxlen;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          9 ,
'    DBINT         datalen;'
go
exec insert_syntax 'dbrpcparam',
'DB-Library/C',          10,
'    BYTE          *value;'
go
exec insert_syntax 'dbrpcsend',
'DB-Library/C',          1 ,
'dbrpcsend - Signal the end of a remote procedure call.'
go
exec insert_syntax 'dbrpcsend',
'DB-Library/C',          2 ,
'    RETCODE dbrpcsend(dbproc)'
go
exec insert_syntax 'dbrpcsend',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbrpwclr',
'DB-Library/C',          1 ,
'dbrpwclr - Clear all remote passwords from the LOGINREC'
go
exec insert_syntax 'dbrpwclr',
'DB-Library/C',          2 ,
'        structure.'
go
exec insert_syntax 'dbrpwclr',
'DB-Library/C',          3 ,
'    void dbrpwclr(loginrec)'
go
exec insert_syntax 'dbrpwclr',
'DB-Library/C',          4 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbrpwset',
'DB-Library/C',          1 ,
'dbrpwset - Add a remote password to the LOGINREC structure.'
go
exec insert_syntax 'dbrpwset',
'DB-Library/C',          2 ,
'    RETCODE dbrpwset(loginrec, srvname, password, pwlen)'
go
exec insert_syntax 'dbrpwset',
'DB-Library/C',          3 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbrpwset',
'DB-Library/C',          4 ,
'    char          *srvname;'
go
exec insert_syntax 'dbrpwset',
'DB-Library/C',          5 ,
'    char          *password;'
go
exec insert_syntax 'dbrpwset',
'DB-Library/C',          6 ,
'    int           pwlen;'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          1 ,
'dbsafestr - Double the quotes in a character string.'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          2 ,
'    RETCODE dbsafestr(dbproc, src, srclen, dest,'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          3 ,
'                     destlen, quotetype)'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          5 ,
'    char          *src;'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          6 ,
'    DBINT         srclen;'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          7 ,
'    char          *dest;'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          8 ,
'    DBINT         destlen;'
go
exec insert_syntax 'dbsafestr',
'DB-Library/C',          9 ,
'    int           quotetype;'
go
exec insert_syntax 'dbsechandle',
'DB-Library/C',          1 ,
'dbsechandle - Install a user function to handle secure logins.'
go
exec insert_syntax 'dbsechandle',
'DB-Library/C',          2 ,
'    RETCODE *dbsechandle(type, handler)'
go
exec insert_syntax 'dbsechandle',
'DB-Library/C',          3 ,
'    DBINT         type;'
go
exec insert_syntax 'dbsechandle',
'DB-Library/C',          4 ,
'    INTFUNCPTR    (*handler)();'
go
exec insert_syntax 'dbsendpassthru',
'DB-Library/C',          1 ,
'dbsendpassthru - Send a TDS packet to a server.'
go
exec insert_syntax 'dbsendpassthru',
'DB-Library/C',          2 ,
'    RETCODE dbsendpassthru(dbproc, send_bufp)'
go
exec insert_syntax 'dbsendpassthru',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsendpassthru',
'DB-Library/C',          4 ,
'    DBVOIDPTR     send_bufp;'
go
exec insert_syntax 'dbservcharset',
'DB-Library/C',          1 ,
'dbservcharset - Get the name of the server character set.'
go
exec insert_syntax 'dbservcharset',
'DB-Library/C',          2 ,
'    char *dbservcharset(dbproc)'
go
exec insert_syntax 'dbservcharset',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetavail',
'DB-Library/C',          1 ,
'dbsetavail - Mark a DBPROCESS as being available for general use.'
go
exec insert_syntax 'dbsetavail',
'DB-Library/C',          2 ,
'    void dbsetavail(dbproc)'
go
exec insert_syntax 'dbsetavail',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetbusy',
'DB-Library/C',          1 ,
'dbsetbusy - Call a user-supplied function when DB-Library is'
go
exec insert_syntax 'dbsetbusy',
'DB-Library/C',          2 ,
'        reading from the server.'
go
exec insert_syntax 'dbsetbusy',
'DB-Library/C',          3 ,
'    void dbsetbusy(dbproc, busyfunc)'
go
exec insert_syntax 'dbsetbusy',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetbusy',
'DB-Library/C',          5 ,
'    int           (*(*busyfunc)())();'
go
exec insert_syntax 'dbsetdeflang',
'DB-Library/C',          1 ,
'dbsetdeflang - Set the default language name for an application.'
go
exec insert_syntax 'dbsetdeflang',
'DB-Library/C',          2 ,
'    RETCODE dbsetdeflang(language)'
go
exec insert_syntax 'dbsetdeflang',
'DB-Library/C',          3 ,
'    char          *language;'
go
exec insert_syntax 'dbsetidle',
'DB-Library/C',          1 ,
'dbsetidle - Call a user-supplied function when DB-Library is'
go
exec insert_syntax 'dbsetidle',
'DB-Library/C',          2 ,
'        finished reading from the server.'
go
exec insert_syntax 'dbsetidle',
'DB-Library/C',          3 ,
'    void dbsetidle(dbproc, idlefunc)'
go
exec insert_syntax 'dbsetidle',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetidle',
'DB-Library/C',          5 ,
'    void          (*idlefunc)();'
go
exec insert_syntax 'dbsetifile',
'DB-Library/C',          1 ,
'dbsetifile - Specify the name and location of the SYBASE interfaces'
go
exec insert_syntax 'dbsetifile',
'DB-Library/C',          2 ,
'        file.'
go
exec insert_syntax 'dbsetifile',
'DB-Library/C',          3 ,
'    void dbsetifile(filename)'
go
exec insert_syntax 'dbsetifile',
'DB-Library/C',          4 ,
'    char          *filename;'
go
exec insert_syntax 'dbsetinterrupt',
'DB-Library/C',          1 ,
'dbsetinterrupt - Call user-supplied functions to handle interrupts'
go
exec insert_syntax 'dbsetinterrupt',
'DB-Library/C',          2 ,
'        while waiting on a read from the server.'
go
exec insert_syntax 'dbsetinterrupt',
'DB-Library/C',          3 ,
'    void dbsetinterrupt(dbproc, chkintr, hndlintr)'
go
exec insert_syntax 'dbsetinterrupt',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetinterrupt',
'DB-Library/C',          5 ,
'    int           (*chkintr)();'
go
exec insert_syntax 'dbsetinterrupt',
'DB-Library/C',          6 ,
'    int           (*hndlintr)();'
go
exec insert_syntax 'dbsetlapp',
'DB-Library/C',          1 ,
'DBSETLAPP - Set the application name in the LOGINREC structure.'
go
exec insert_syntax 'dbsetlapp',
'DB-Library/C',          2 ,
'    RETCODE DBSETLAPP(loginrec, application)'
go
exec insert_syntax 'dbsetlapp',
'DB-Library/C',          3 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetlapp',
'DB-Library/C',          4 ,
'    char          *application;'
go
exec insert_syntax 'dbsetlcharset',
'DB-Library/C',          1 ,
'DBSETLCHARSET - Set the character set in the LOGINREC structure.'
go
exec insert_syntax 'dbsetlcharset',
'DB-Library/C',          2 ,
'    RETCODE DBSETLCHARSET(loginrec, char_set)'
go
exec insert_syntax 'dbsetlcharset',
'DB-Library/C',          3 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetlcharset',
'DB-Library/C',          4 ,
'    DBCHAR        *char_set;'
go
exec insert_syntax 'dbsetlencrypt',
'DB-Library/C',          1 ,
'DBSETLENCRYPT - Specify whether or not network password encryption is'
go
exec insert_syntax 'dbsetlencrypt',
'DB-Library/C',          2 ,
'        to be used when logging into a 10.0+ SQL Server.'
go
exec insert_syntax 'dbsetlencrypt',
'DB-Library/C',          3 ,
'    RETCODE DBSETLENCRYPT(loginrec, enable)'
go
exec insert_syntax 'dbsetlencrypt',
'DB-Library/C',          4 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetlencrypt',
'DB-Library/C',          5 ,
'    DBBOOL        enable;'
go
exec insert_syntax 'dbsetlhost',
'DB-Library/C',          1 ,
'DBSETLHOST - Set the host name in the LOGINREC structure.'
go
exec insert_syntax 'dbsetlhost',
'DB-Library/C',          2 ,
'    RETCODE DBSETLHOST(loginrec, hostname)'
go
exec insert_syntax 'dbsetlhost',
'DB-Library/C',          3 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetlhost',
'DB-Library/C',          4 ,
'    char          *hostname;'
go
exec insert_syntax 'dbsetllabeled',
'DB-Library/C',          1 ,
'DBSETLLABELED - Set a bit to inform Secure SQL Server that login'
go
exec insert_syntax 'dbsetllabeled',
'DB-Library/C',          2 ,
'        security labels will be sent at login time.'
go
exec insert_syntax 'dbsetllabeled',
'DB-Library/C',          3 ,
'    RETCODE DBSETLLABELED(loginrec, enable)'
go
exec insert_syntax 'dbsetllabeled',
'DB-Library/C',          4 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetllabeled',
'DB-Library/C',          5 ,
'    DBBOOL        enable;'
go
exec insert_syntax 'dbsetlnatlang',
'DB-Library/C',          1 ,
'DBSETLNATLANG - Set the national language name in the LOGINREC'
go
exec insert_syntax 'dbsetlnatlang',
'DB-Library/C',          2 ,
'        structure.'
go
exec insert_syntax 'dbsetlnatlang',
'DB-Library/C',          3 ,
'    RETCODE DBSETLNATLANG(loginrec, language)'
go
exec insert_syntax 'dbsetlnatlang',
'DB-Library/C',          4 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetlnatlang',
'DB-Library/C',          5 ,
'    char          *language;'
go
exec insert_syntax 'dbsetloginfo',
'DB-Library/C',          1 ,
'dbsetloginfo - Transfer TDS login information from a DBLOGINFO'
go
exec insert_syntax 'dbsetloginfo',
'DB-Library/C',          2 ,
'        structure to a LOGINREC structure.'
go
exec insert_syntax 'dbsetloginfo',
'DB-Library/C',          3 ,
'    RETCODE dbsetloginfo(loginrec, loginfo)'
go
exec insert_syntax 'dbsetloginfo',
'DB-Library/C',          4 ,
'    LOGINREC      *login;'
go
exec insert_syntax 'dbsetloginfo',
'DB-Library/C',          5 ,
'    DBLOGINFO     *loginfo;'
go
exec insert_syntax 'dbsetlogintime',
'DB-Library/C',          1 ,
'dbsetlogintime - Set the number of seconds that DB-Library waits for a'
go
exec insert_syntax 'dbsetlogintime',
'DB-Library/C',          2 ,
'        server response to a request for a DBPROCESS'
go
exec insert_syntax 'dbsetlogintime',
'DB-Library/C',          3 ,
'        connection.'
go
exec insert_syntax 'dbsetlogintime',
'DB-Library/C',          4 ,
'    RETCODE dbsetlogintime(seconds)'
go
exec insert_syntax 'dbsetlogintime',
'DB-Library/C',          5 ,
'    int           seconds;'
go
exec insert_syntax 'dbsetlpacket',
'DB-Library/C',          1 ,
'DBSETLPACKET - Set the TDS packet size in an application''s LOGINREC'
go
exec insert_syntax 'dbsetlpacket',
'DB-Library/C',          2 ,
'        structure.'
go
exec insert_syntax 'dbsetlpacket',
'DB-Library/C',          3 ,
'    RETCODE DBSETLPACKET(login, packet_size)'
go
exec insert_syntax 'dbsetlpacket',
'DB-Library/C',          4 ,
'    LOGINREC      *login;'
go
exec insert_syntax 'dbsetlpacket',
'DB-Library/C',          5 ,
'    short         packet_size;'
go
exec insert_syntax 'dbsetlpwd',
'DB-Library/C',          1 ,
'DBSETLPWD - Set the user server password in the LOGINREC'
go
exec insert_syntax 'dbsetlpwd',
'DB-Library/C',          2 ,
'        structure.'
go
exec insert_syntax 'dbsetlpwd',
'DB-Library/C',          3 ,
'    RETCODE DBSETLPWD(loginrec, password)'
go
exec insert_syntax 'dbsetlpwd',
'DB-Library/C',          4 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetlpwd',
'DB-Library/C',          5 ,
'    char          *password;'
go
exec insert_syntax 'dbsetluser',
'DB-Library/C',          1 ,
'DBSETLUSER - Set the username in the LOGINREC structure.'
go
exec insert_syntax 'dbsetluser',
'DB-Library/C',          2 ,
'    RETCODE DBSETLUSER(loginrec, username)'
go
exec insert_syntax 'dbsetluser',
'DB-Library/C',          3 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetluser',
'DB-Library/C',          4 ,
'    char          *username;'
go
exec insert_syntax 'dbsetmaxprocs',
'DB-Library/C',          1 ,
'dbsetmaxprocs - Set the maximum number of simultaneously open'
go
exec insert_syntax 'dbsetmaxprocs',
'DB-Library/C',          2 ,
'        DBPROCESSes.'
go
exec insert_syntax 'dbsetmaxprocs',
'DB-Library/C',          3 ,
'    RETCODE dbsetmaxprocs(maxprocs)'
go
exec insert_syntax 'dbsetmaxprocs',
'DB-Library/C',          4 ,
'    int           maxprocs;'
go
exec insert_syntax 'dbsetnotifs',
'DB-Library/C',          1 ,
'dbsetnotifs - Enable or disable registered'
go
exec insert_syntax 'dbsetnotifs',
'DB-Library/C',          2 ,
'                procedure notifications (VMS only).'
go
exec insert_syntax 'dbsetnotifs',
'DB-Library/C',          3 ,
'    RETCODE dbsetnotifs(notif_state)'
go
exec insert_syntax 'dbsetnotifs',
'DB-Library/C',          4 ,
'    DBBOOL        notif_state;'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          1 ,
'dbsetnull - Define substitution values to be used when binding'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          2 ,
'        null values.'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          3 ,
'    RETCODE dbsetnull(dbproc, bindtype, bindlen, bindval)'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          5 ,
'    int           bindtype;'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          6 ,
'    int           bindlen;'
go
exec insert_syntax 'dbsetnull',
'DB-Library/C',          7 ,
'    BYTE          *bindval;'
go
exec insert_syntax 'dbsetopt',
'DB-Library/C',          1 ,
'dbsetopt - Set a server or DB-Library option.'
go
exec insert_syntax 'dbsetopt',
'DB-Library/C',          2 ,
'    RETCODE dbsetopt(dbproc, option, char_param, int_param)'
go
exec insert_syntax 'dbsetopt',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetopt',
'DB-Library/C',          4 ,
'    int           option;'
go
exec insert_syntax 'dbsetopt',
'DB-Library/C',          5 ,
'    char          *char_param;'
go
exec insert_syntax 'dbsetopt',
'DB-Library/C',          6 ,
'    int           int_param;'
go
exec insert_syntax 'dbsetrow',
'DB-Library/C',          1 ,
'dbsetrow - Set a buffered row to "current."'
go
exec insert_syntax 'dbsetrow',
'DB-Library/C',          2 ,
'    STATUS dbsetrow(dbproc, row)'
go
exec insert_syntax 'dbsetrow',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetrow',
'DB-Library/C',          4 ,
'    DBINT         row;'
go
exec insert_syntax 'dbsetsecurity',
'DB-Library/C',          1 ,
'dbsetsecurity - Set login security labels for use when logging into a'
go
exec insert_syntax 'dbsetsecurity',
'DB-Library/C',          2 ,
'        Secure SQL Server.'
go
exec insert_syntax 'dbsetsecurity',
'DB-Library/C',          3 ,
'    RETCODE dbsetsecurity(loginrec, labelname, labelvalue)'
go
exec insert_syntax 'dbsetsecurity',
'DB-Library/C',          4 ,
'    LOGINREC      *loginrec;'
go
exec insert_syntax 'dbsetsecurity',
'DB-Library/C',          5 ,
'    CHAR          *labelname;'
go
exec insert_syntax 'dbsetsecurity',
'DB-Library/C',          6 ,
'    CHAR          *labelvalue;'
go
exec insert_syntax 'dbsettime',
'DB-Library/C',          1 ,
'dbsettime - Set the number of seconds that DB-Library will wait'
go
exec insert_syntax 'dbsettime',
'DB-Library/C',          2 ,
'        for a server response to a SQL command.'
go
exec insert_syntax 'dbsettime',
'DB-Library/C',          3 ,
'    RETCODE dbsettime(seconds)'
go
exec insert_syntax 'dbsettime',
'DB-Library/C',          4 ,
'    int           seconds;'
go
exec insert_syntax 'dbsetuserdata',
'DB-Library/C',          1 ,
'dbsetuserdata - Use a DBPROCESS structure to save a pointer to'
go
exec insert_syntax 'dbsetuserdata',
'DB-Library/C',          2 ,
'        user-allocated data.'
go
exec insert_syntax 'dbsetuserdata',
'DB-Library/C',          3 ,
'    void dbsetuserdata(dbproc, ptr)'
go
exec insert_syntax 'dbsetuserdata',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsetuserdata',
'DB-Library/C',          5 ,
'    BYTE          *ptr;'
go
exec insert_syntax 'dbsetversion',
'DB-Library/C',          1 ,
'dbsetversion - Specify a DB-Library version level.'
go
exec insert_syntax 'dbsetversion',
'DB-Library/C',          2 ,
'    RETCODE dbsetversion(version)'
go
exec insert_syntax 'dbsetversion',
'DB-Library/C',          3 ,
'    DBINT         version;'
go
exec insert_syntax 'dbspid',
'DB-Library/C',          1 ,
'dbspid - Get the server process id for the specified'
go
exec insert_syntax 'dbspid',
'DB-Library/C',          2 ,
'        DBPROCESS.'
go
exec insert_syntax 'dbspid',
'DB-Library/C',          3 ,
'    int dbspid(dbproc)'
go
exec insert_syntax 'dbspid',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbspr1row',
'DB-Library/C',          1 ,
'dbspr1row - Place one row of server query results into a buffer.'
go
exec insert_syntax 'dbspr1row',
'DB-Library/C',          2 ,
'    RETCODE dbspr1row(dbproc, buffer, buf_len)'
go
exec insert_syntax 'dbspr1row',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbspr1row',
'DB-Library/C',          4 ,
'    char          *buffer;'
go
exec insert_syntax 'dbspr1row',
'DB-Library/C',          5 ,
'    DBINT         buf_len;'
go
exec insert_syntax 'dbspr1rowlen',
'DB-Library/C',          1 ,
'dbspr1rowlen - Determine how large a buffer to allocate to hold the'
go
exec insert_syntax 'dbspr1rowlen',
'DB-Library/C',          2 ,
'        results returned by dbsprhead, dbsprline, and'
go
exec insert_syntax 'dbspr1rowlen',
'DB-Library/C',          3 ,
'        dbspr1row.'
go
exec insert_syntax 'dbspr1rowlen',
'DB-Library/C',          4 ,
'    DBINT dbspr1rowlen(dbproc)'
go
exec insert_syntax 'dbspr1rowlen',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsprhead',
'DB-Library/C',          1 ,
'dbsprhead - Place the server query results header into a buffer.'
go
exec insert_syntax 'dbsprhead',
'DB-Library/C',          2 ,
'    RETCODE dbsprhead(dbproc, buffer, buf_len)'
go
exec insert_syntax 'dbsprhead',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsprhead',
'DB-Library/C',          4 ,
'    char          *buffer;'
go
exec insert_syntax 'dbsprhead',
'DB-Library/C',          5 ,
'    DBINT         buf_len;'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          1 ,
'dbsprline - Choose the character with which to underline the'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          2 ,
'        column names produced by dbsprhead.'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          3 ,
'    RETCODE dbsprline(dbproc, buffer, buf_len, linechar)'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          5 ,
'    char          *buffer;'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          6 ,
'    DBINT         buf_len;'
go
exec insert_syntax 'dbsprline',
'DB-Library/C',          7 ,
'    DBCHAR        linechar;'
go
exec insert_syntax 'dbsqlexec',
'DB-Library/C',          1 ,
'dbsqlexec - Send a command batch to the server.'
go
exec insert_syntax 'dbsqlexec',
'DB-Library/C',          2 ,
'    RETCODE dbsqlexec(dbproc)'
go
exec insert_syntax 'dbsqlexec',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          1 ,
'dbsqlexec_a - Send a command batch to the server and verify its'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          2 ,
'        correctness asynchronously (VMS only).'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          3 ,
'    RETCODE dbsqlexec_a(dbproc, final_result, ast_proc,'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          4 ,
'                        ast_param)'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          6 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          7 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbsqlexec_a',
'DB-Library/C',          8 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbsqlok',
'DB-Library/C',          1 ,
'dbsqlok - Wait for results from the server and verify the'
go
exec insert_syntax 'dbsqlok',
'DB-Library/C',          2 ,
'        correctness of the instructions the server is'
go
exec insert_syntax 'dbsqlok',
'DB-Library/C',          3 ,
'        responding to.'
go
exec insert_syntax 'dbsqlok',
'DB-Library/C',          4 ,
'    RETCODE dbsqlok(dbproc)'
go
exec insert_syntax 'dbsqlok',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          1 ,
'dbsqlok_a - Wait for results from the server and verify the'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          2 ,
'        correctness of the instructions asynchronously (VMS only).'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          3 ,
'    RETCODE dbsqlok_a(dbproc, final_result, ast_proc,'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          4 ,
'                      ast_param)'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          6 ,
'    RETCODE       *final_result;'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          7 ,
'    void          (*ast_proc)();'
go
exec insert_syntax 'dbsqlok_a',
'DB-Library/C',          8 ,
'    BYTE          *ast_param;'
go
exec insert_syntax 'dbsqlsend',
'DB-Library/C',          1 ,
'dbsqlsend - Send a command batch to the server and do not wait for'
go
exec insert_syntax 'dbsqlsend',
'DB-Library/C',          2 ,
'        a response.'
go
exec insert_syntax 'dbsqlsend',
'DB-Library/C',          3 ,
'    RETCODE dbsqlsend(dbproc)'
go
exec insert_syntax 'dbsqlsend',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          1 ,
'dbstrbuild - Build a printable string from text containing'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          2 ,
'        placeholders for variables.'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          3 ,
'    int dbstrbuild(dbproc, charbuf, bufsize,'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          4 ,
'                   text [, formats [, arg] ... ])'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          6 ,
'    char          *charbuf;'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          7 ,
'    int           bufsize;'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          8 ,
'    char          *text;'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          9 ,
'    char          *formats;'
go
exec insert_syntax 'dbstrbuild',
'DB-Library/C',          10,
'    ???           args???;'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          1 ,
'dbstrcmp - Compare two character strings using a specified sort'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          2 ,
'        order.'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          3 ,
'    int dbstrcmp(dbproc, str1, len1, str2, len2,'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          4 ,
'    sortorder)'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          6 ,
'    char          *str1;'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          7 ,
'    int           len1;'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          8 ,
'    char          *str2;'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          9 ,
'    int           len2;'
go
exec insert_syntax 'dbstrcmp',
'DB-Library/C',          10,
'    DBSORTORDER   *sortorder;'
go
exec insert_syntax 'dbstrcpy',
'DB-Library/C',          1 ,
'dbstrcpy - Copy a portion of the command buffer.'
go
exec insert_syntax 'dbstrcpy',
'DB-Library/C',          2 ,
'    RETCODE dbstrcpy(dbproc, start, numbytes, dest)'
go
exec insert_syntax 'dbstrcpy',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbstrcpy',
'DB-Library/C',          4 ,
'    int           start;'
go
exec insert_syntax 'dbstrcpy',
'DB-Library/C',          5 ,
'    int           numbytes;'
go
exec insert_syntax 'dbstrcpy',
'DB-Library/C',          6 ,
'    char          *dest;'
go
exec insert_syntax 'dbstrlen',
'DB-Library/C',          1 ,
'dbstrlen - Return the length, in characters, of the command'
go
exec insert_syntax 'dbstrlen',
'DB-Library/C',          2 ,
'        buffer.'
go
exec insert_syntax 'dbstrlen',
'DB-Library/C',          3 ,
'    int dbstrlen(dbproc)'
go
exec insert_syntax 'dbstrlen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          1 ,
'dbstrsort - Determine which of two character strings should appear'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          2 ,
'        first in a sorted list.'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          3 ,
'    int dbstrsort(dbproc, str1, len1, str2, len2, sortorder)'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          5 ,
'    char          *str1;'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          6 ,
'    int           len1;'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          7 ,
'    char          *str2;'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          8 ,
'    int           len2;'
go
exec insert_syntax 'dbstrsort',
'DB-Library/C',          9 ,
'    DBSORTORDER   *sortorder;'
go
exec insert_syntax 'dbtabbrowse',
'DB-Library/C',          1 ,
'dbtabbrowse - Determine whether the specified table is updatable via'
go
exec insert_syntax 'dbtabbrowse',
'DB-Library/C',          2 ,
'        the DB-Library browse-mode facilities.'
go
exec insert_syntax 'dbtabbrowse',
'DB-Library/C',          3 ,
'    DBBOOL dbtabbrowse(dbproc, tabnum)'
go
exec insert_syntax 'dbtabbrowse',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtabbrowse',
'DB-Library/C',          5 ,
'    int           tabnum;'
go
exec insert_syntax 'dbtabcount',
'DB-Library/C',          1 ,
'dbtabcount - Return the number of tables involved in the current'
go
exec insert_syntax 'dbtabcount',
'DB-Library/C',          2 ,
'        select query.'
go
exec insert_syntax 'dbtabcount',
'DB-Library/C',          3 ,
'    int dbtabcount(dbproc)'
go
exec insert_syntax 'dbtabcount',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtabname',
'DB-Library/C',          1 ,
'dbtabname - Return the name of a table based on its number.'
go
exec insert_syntax 'dbtabname',
'DB-Library/C',          2 ,
'    char *dbtabname(dbproc, tabnum)'
go
exec insert_syntax 'dbtabname',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtabname',
'DB-Library/C',          4 ,
'    int           tabnum;'
go
exec insert_syntax 'dbtabsource',
'DB-Library/C',          1 ,
'dbtabsource - Return the name and number of the table from which a'
go
exec insert_syntax 'dbtabsource',
'DB-Library/C',          2 ,
'        particular result column was derived.'
go
exec insert_syntax 'dbtabsource',
'DB-Library/C',          3 ,
'    char *dbtabsource(dbproc, colnum, tabnum)'
go
exec insert_syntax 'dbtabsource',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtabsource',
'DB-Library/C',          5 ,
'    int           colnum;'
go
exec insert_syntax 'dbtabsource',
'DB-Library/C',          6 ,
'    int           *tabnum;'
go
exec insert_syntax 'dbtds',
'DB-Library/C',          1 ,
'DBTDS - Determine which version of TDS (the Tabular Data'
go
exec insert_syntax 'dbtds',
'DB-Library/C',          2 ,
'        Stream protocol) is being used.'
go
exec insert_syntax 'dbtds',
'DB-Library/C',          3 ,
'    int DBTDS(dbproc)'
go
exec insert_syntax 'dbtds',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtextsize',
'DB-Library/C',          1 ,
'dbtextsize - Return the number of text/image bytes that remain to'
go
exec insert_syntax 'dbtextsize',
'DB-Library/C',          2 ,
'        be read for the current row.'
go
exec insert_syntax 'dbtextsize',
'DB-Library/C',          3 ,
'    DBINT dbtextsize(dbproc)'
go
exec insert_syntax 'dbtextsize',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtsnewlen',
'DB-Library/C',          1 ,
'dbtsnewlen - Return the length of the new value of the timestamp'
go
exec insert_syntax 'dbtsnewlen',
'DB-Library/C',          2 ,
'        column after a browse-mode update.'
go
exec insert_syntax 'dbtsnewlen',
'DB-Library/C',          3 ,
'    int dbtsnewlen(dbproc)'
go
exec insert_syntax 'dbtsnewlen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtsnewval',
'DB-Library/C',          1 ,
'dbtsnewval - Return the new value of the timestamp column after a'
go
exec insert_syntax 'dbtsnewval',
'DB-Library/C',          2 ,
'        browse-mode update.'
go
exec insert_syntax 'dbtsnewval',
'DB-Library/C',          3 ,
'    DBBINARY *dbtsnewval(dbproc)'
go
exec insert_syntax 'dbtsnewval',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          1 ,
'dbtsput - Put the new value of the timestamp column into the'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          2 ,
'        given table''s current row in the DBPROCESS.'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          3 ,
'    RETCODE dbtsput(dbproc, newts, newtslen, tabnum,'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          4 ,
'                    tabname)'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          6 ,
'    DBBINARY      *newts;'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          7 ,
'    int           newtslen;'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          8 ,
'    int           tabnum;'
go
exec insert_syntax 'dbtsput',
'DB-Library/C',          9 ,
'    char          *tabname;'
go
exec insert_syntax 'dbtxptr',
'DB-Library/C',          1 ,
'dbtxptr - Return the value of the text pointer for a column in'
go
exec insert_syntax 'dbtxptr',
'DB-Library/C',          2 ,
'        the current row.'
go
exec insert_syntax 'dbtxptr',
'DB-Library/C',          3 ,
'    DBBINARY *dbtxptr(dbproc, column)'
go
exec insert_syntax 'dbtxptr',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtxptr',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbtxtimestamp',
'DB-Library/C',          1 ,
'dbtxtimestamp - Return the value of the text timestamp for a column in'
go
exec insert_syntax 'dbtxtimestamp',
'DB-Library/C',          2 ,
'        the current row.'
go
exec insert_syntax 'dbtxtimestamp',
'DB-Library/C',          3 ,
'    DBBINARY *dbtxtimestamp(dbproc, column)'
go
exec insert_syntax 'dbtxtimestamp',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtxtimestamp',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbtxtsnewval',
'DB-Library/C',          1 ,
'dbtxtsnewval - Return the new value of a text timestamp after a call'
go
exec insert_syntax 'dbtxtsnewval',
'DB-Library/C',          2 ,
'        to dbwritetext.'
go
exec insert_syntax 'dbtxtsnewval',
'DB-Library/C',          3 ,
'    DBBINARY *dbtxtsnewval(dbproc)'
go
exec insert_syntax 'dbtxtsnewval',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtxtsput',
'DB-Library/C',          1 ,
'dbtxtsput - Put the new value of a text timestamp into the'
go
exec insert_syntax 'dbtxtsput',
'DB-Library/C',          2 ,
'        specified column of the current row in the DBPROCESS.'
go
exec insert_syntax 'dbtxtsput',
'DB-Library/C',          3 ,
'    RETCODE dbtxtsput(dbproc, newtxts, colnum)'
go
exec insert_syntax 'dbtxtsput',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbtxtsput',
'DB-Library/C',          5 ,
'    DBBINARY      *newtxts;'
go
exec insert_syntax 'dbtxtsput',
'DB-Library/C',          6 ,
'    int           colnum;'
go
exec insert_syntax 'dbuse',
'DB-Library/C',          1 ,
'dbuse - Use a particular database.'
go
exec insert_syntax 'dbuse',
'DB-Library/C',          2 ,
'    RETCODE dbuse(dbproc, dbname)'
go
exec insert_syntax 'dbuse',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbuse',
'DB-Library/C',          4 ,
'    char          *dbname;'
go
exec insert_syntax 'dbvarylen',
'DB-Library/C',          1 ,
'dbvarylen - Determine whether the specified regular result'
go
exec insert_syntax 'dbvarylen',
'DB-Library/C',          2 ,
'        column''s data can vary in length.'
go
exec insert_syntax 'dbvarylen',
'DB-Library/C',          3 ,
'    DBBOOL dbvarylen(dbproc, column)'
go
exec insert_syntax 'dbvarylen',
'DB-Library/C',          4 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbvarylen',
'DB-Library/C',          5 ,
'    int           column;'
go
exec insert_syntax 'dbversion',
'DB-Library/C',          1 ,
'dbversion - Determine which version of DB-Library is in use.'
go
exec insert_syntax 'dbversion',
'DB-Library/C',          2 ,
'    char *dbversion()'
go
exec insert_syntax 'dbwillconvert',
'DB-Library/C',          1 ,
'dbwillconvert - Determine whether a specific datatype conversion is'
go
exec insert_syntax 'dbwillconvert',
'DB-Library/C',          2 ,
'        available within DB-Library.'
go
exec insert_syntax 'dbwillconvert',
'DB-Library/C',          3 ,
'    DBBOOL dbwillconvert(srctype, desttype)'
go
exec insert_syntax 'dbwillconvert',
'DB-Library/C',          4 ,
'    int           srctype;'
go
exec insert_syntax 'dbwillconvert',
'DB-Library/C',          5 ,
'    int           desttype;'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          1 ,
'dbwritepage - Write a page of binary data to the server.'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          2 ,
'    RETCODE dbwritepage(dbproc, dbname, pageno, size, buf)'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          3 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          4 ,
'    char          *dbname;'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          5 ,
'    DBINT         pageno;'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          6 ,
'    DBINT         size;'
go
exec insert_syntax 'dbwritepage',
'DB-Library/C',          7 ,
'    BYTE          buf[];'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          1 ,
'dbwritetext - Send a text or image value to the server.'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          2 ,
'    RETCODE dbwritetext(dbproc, objname, textptr,'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          3 ,
'                        textptrlen, timestamp, log,'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          4 ,
'                        size, text)'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          5 ,
'    DBPROCESS     *dbproc;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          6 ,
'    char          *objname;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          7 ,
'    DBBINARY      *textptr;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          8 ,
'    DBTINYINT     textptrlen;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          9 ,
'    DBBINARY      *timestamp;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          10,
'    DBBOOL        log;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          11,
'    DBINT         size;'
go
exec insert_syntax 'dbwritetext',
'DB-Library/C',          12,
'    BYTE          *text;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          1 ,
'dbxlate - Translate a character string from one character set to'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          2 ,
'        another.'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          3 ,
'    int dbxlate(dbproc, src, srclen, dest, destlen, xlt,'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          4 ,
'                srcbytes_used, srcend, status)'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          5 ,
'    DBPROCESS     dbproc;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          6 ,
'    char          *src;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          7 ,
'    int           srclen;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          8 ,
'    char          *dest;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          9 ,
'    int           destlen;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          10,
'    DBXLATE       *xlt;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          11,
'    int           *srcbytes_used;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          12,
'    DBBOOL        srcend;'
go
exec insert_syntax 'dbxlate',
'DB-Library/C',          13,
'    int           *status;'
go


/* drop the insert_syntax procedure */
if exists (select name from sysobjects where name = "insert_syntax")
begin
	drop procedure insert_syntax
end
go

/* drop the sybsyntax_printmsg procedure */
if exists (select name from sysobjects where name = "sybsyntax_printmsg")
begin
	drop procedure sybsyntax_printmsg
end
go

/* If sp_syntax already exists, drop it so that we might replace it */
if exists (select *
	from sysobjects
		where sysstat & 7 = 4
			and name = 'sp_syntax')
begin
	drop procedure sp_syntax
end
go

create procedure sp_syntax
	@word varchar(50) = null,	/* command */
	@mod varchar(20) = null,	/* module */
	@language varchar(30) = null	/* language */
as

set nocount on
declare	@pattern	varchar(52),
	@counter	tinyint,
	@mincommand	varchar(50),
	@modpattern	varchar(22),
	@modcount	tinyint,
	@minmod		varchar(20),
	@msg		varchar(255),
	@msgparam	varchar(30),
	@lang_id	smallint,
	@returncode smallint
/*
**  If we're in a transaction, disallow this since it might make recovery
**  impossible.
*/
if @@trancount > 0
begin
	/*
	** 17260, "Can't run %1! from within a transaction."
	*/
	exec sp_getmessage 17260, @msg output
	print @msg, "sp_syntax"
	return (1)
end

/*
** Check that language is valid.
*/
if @language is not NULL
begin
    execute @returncode = sp_validlang @language
    if @returncode != 0
    begin
	    /* Us_english is always valid */
	    if @language != "us_english"
	    begin
		    /* 
		    ** 17201, "'%1!' is not an official language
		    **	name from Syslanguages."
		    */
		    exec sp_getmessage 17201, @msg output
		    print @msg, @language
		    return @returncode
	    end

	    /* set to us_english */
	    select @lang_id = NULL
    end

    else
    select @lang_id = langid from syslanguages
		where @language = name

end

/* set search string to %word% */

select @pattern = "%" + lower(@word) + "%",
	@modpattern = "%" + lower(@mod) + "%"


/* if no command/routine name is given, print the syntax and return*/

if @word is null
begin
	/*
	** 17970, "sp_syntax provides syntax help for Sybase products."
	*/
	exec sp_getmessage 17970, @msg output, @language
	print @msg
	/*
	** 17971, "These modules are installed on this Server:"
	*/
	exec sp_getmessage 17971, @msg output, @language
	print @msg
	print ""
	select distinct module Module from sybsyntax..sybsyntax
	print""
	/*
	** 17972, "Usage:  sp_syntax command [, module, language]"
	*/
	exec sp_getmessage 17972, @msg output, @language
	print @msg
	return
end

/* if no commands match, print a message and return */

if (select count(*) from sybsyntax..sybsyntax
	where commandname like @pattern) = 0
begin
	/*
	** 17973, "No command or routine has a name like '%1!'"
	*/
	exec sp_getmessage 17973, @msg output, @language
	print @msg, @word
	return
end

/* if no modules match, print a message and return */

if @mod is not null and (select count(*) from sybsyntax..sybsyntax
	where lower(module) like @modpattern) = 0
begin
	/*
	** 17974, "No module has a name like '%1!'"
	*/
	exec sp_getmessage 17974, @msg output, @language
	print @msg, @mod
	return
end

/* if command/module combo has no matches, print message and return */
if (select count(*) from sybsyntax..sybsyntax
		where lower (module) like @modpattern
		and lower (commandname) like @pattern
		and langid = @lang_id) = 0
begin
	/*
	** 17975, "No command or routine has a name like '%1!' and a module like '%2!'"
	*/
	exec sp_getmessage 17975, @msg output, @language
	print @msg, @word, @mod
	return
end

/* Put a list of all desired module names into #tempsyntax1.
** If a module was specified, find all %mod% matches.
** If @mod is null, select modules from the table with a
** matching %word%
*/

create table #tempsyntax1 (module varchar(20))
if @mod is not null
begin
	insert #tempsyntax1
		select distinct(module)
		from sybsyntax..sybsyntax
		where lower(module) like @modpattern
		and langid = @lang_id
end
else
begin
	insert #tempsyntax1
		select distinct(module)
		from sybsyntax..sybsyntax
		where commandname like @pattern
		and langid = @lang_id
end

select @modcount = (select count(*) from #tempsyntax1)

/* create a table to store the results */
create table #tempsyntax2 (c1 varchar(78))


/* find the first module in alpha order */
select @minmod = min(module)
	from #tempsyntax1

/* the loop that finds all the answers */
while @modcount > 0
begin

	/* Put module name into results */
	insert #tempsyntax2 values (@minmod)
		/* count matches for this module */
		select @counter = (select count(*)
			from sybsyntax..sybsyntax
			where commandname like @pattern
				and linenum = 1
				and module = @minmod
				and langid = @lang_id)
	/*find the first word in alpha order */
	select @mincommand = min(commandname)
		from sybsyntax..sybsyntax
		where commandname like @pattern
			and module = @minmod
			and langid = @lang_id
	while @counter > 0
	begin
		/* select the syntax info into the results */
		insert #tempsyntax2
		select syntax from sybsyntax..sybsyntax
			where commandname = @mincommand
				and module = @minmod
				and langid = @lang_id
				order by linenum
		/* add a blank line between commands */
		insert #tempsyntax2
			select ""
		select @counter = @counter - 1
		/*find the first word in alpha order */
		select @mincommand = min(commandname)
			from sybsyntax..sybsyntax
			where commandname like @pattern
				and commandname > @mincommand
				and module = @minmod
				and langid = @lang_id
	end
	/* find the next module in alpha order */
	select @minmod = min(module)
		from #tempsyntax1
		where module > @minmod
	select @modcount = @modcount - 1
end

/*
** 18049, "Syntax Help"
*/
exec sp_getmessage 18049, @msg output, @language
print @msg
select "" = c1 from #tempsyntax2
go

/* add guest user to sybsyntax db so everybody can access it */
use sybsyntax
go

if not exists (select * from sysusers where name="guest")
	exec sp_adduser guest
go

/* grant permission for sp_syntax to be executed by anybody */
use master
go

grant execute on sp_syntax to public
go
