/*
 * @(#)MacLookAndFeel.java	1.4 99/03/23
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.*;
import javax.swing.plaf.*;
import javax.swing.*;
import javax.swing.plaf.basic.*;
import javax.swing.border.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.DefaultEditorKit;

import java.awt.Font;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;

import java.net.URL;
import java.io.Serializable;


/**
 * Implements The Macintosh Platinum Look and Feel.
 * <p>
 * For the keyboard keys defined for each component in this Look and
 * Feel (L&F), see 
 * <a href="../../doc-files/Key-Metal.html">Component Keystroke Actions for the Metal L&F</a>.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 03/23/99
 * @author Steve Wilson
 */
public class MacLookAndFeel extends BasicLookAndFeel {


  public String getName() {
      return "Macintosh";
  }

  public String getID() {
      return "Platinum";
  }

  public String getDescription() {
      return "The Apple Macintosh(tm) Look and Feel";
  }


  public boolean isNativeLookAndFeel() {
      String osName = System.getProperty("os.name");
      return (osName != null) && (osName.indexOf("Mac") != -1);
  }


  public boolean isSupportedLookAndFeel() {
      return isNativeLookAndFeel();
  }

    /** 
     * Initialize the uiClassID to BasicComponentUI mapping.
     * The JComponent classes define their own uiClassID constants
     * (see AbstractComponent.getUIClassID).  This table must
     * map those constants to a BasicComponentUI class of the
     * appropriate type.
     * 
     * @see BasicLookAndFeel#getDefaults
     */
  protected void initClassDefaults(UIDefaults table) {
      super.initClassDefaults(table);
      String macPackageName = "com.sun.java.swing.plaf.mac.";
      
      Object[] uiDefaults = {
	  "ButtonUI",        macPackageName + "MacButtonUI",
	  "TextFieldUI",     macPackageName + "MacTextFieldUI",
	  "InternalFrameUI", macPackageName + "MacInternalFrameUI",
	  "SliderUI",        macPackageName + "MacSliderUI",
	  "ScrollBarUI",     macPackageName + "MacScrollBarUI",
	  "ComboBoxUI",      macPackageName + "MacComboBoxUI",
	  "SeparatorUI",     macPackageName + "MacSeparatorUI",
	  "TreeUI",          macPackageName + "MacTreeUI",
	  "DesktopPaneUI",   macPackageName + "MacDesktopPaneUI",
	  "ToggleButtonUI",  macPackageName + "MacToggleButtonUI",
	  "FileChooserUI",   macPackageName + "MacFileChooserUI",
	  "TabbedPaneUI",    macPackageName + "MacTabbedPaneUI",
	  "ProgressBarUI",   macPackageName + "MacProgressBarUI",
      };

      table.putDefaults(uiDefaults);
  }

	/**
	 * Load the SystemColors into the defaults table.  The keys
	 * for SystemColor defaults are the same as the names of
	 * the public fields in SystemColor.
	 */
	protected void initSystemColorDefaults(UIDefaults table) {
		Object[] systemColors = {
			"desktop", getAccent(),	/* Color of the desktop background */
			"activeCaption", getGray2(), /* Color for captions (title bars) when they are active. */
			"activeCaptionText", getBlack(),	/* Text color for text in captions (title bars). */
			"activeCaptionBorder", getBlack(), /* Border color for caption (title bar) window borders. */
			"inactiveCaption", getGray1(), /* Color for captions (title bars) when not active. */
			"inactiveCaptionText", getDisabledControlText(), /* Text color for text in inactive captions (title bars). */
			"inactiveCaptionBorder", getGray9(), /* Border color for inactive caption (title bar) window borders. */
			"window", getWhite(), /* Default color for the interior of windows */
			"windowBorder", getGray1(), /* ??? */
			"windowText", getBlack(), /* ??? */
			"menu", getGray1(), /* Background color for menus */
			"menuText", getBlack(),	/* Text color for menus  */
			"text", getWhite(), /* Text background color */
			"textText", getUserTextColor(), /* Text foreground color */
			"textHighlight", getUserTextHighlightColor(), /* Text background color when selected */
			"textHighlightText", getUserTextHighlightTextColor(),	/* Text color when selected */
			"textInactiveText", getDisabledControlText(), /* Text color when disabled */
			"control", getGray1(), /* Default color for controls (buttons, sliders, etc) */
			"controlText", getBlack(),	/* Default color for text in controls */
			"controlHighlight", getWhite(), /* Specular highlight (opposite of the shadow) */
			"controlLtHighlight", getWhite(), /* Highlight color for controls */
			"controlShadow", getGray4(), /* Shadow color for controls */
			"controlDkShadow", getGray7(), /* Dark shadow color for controls */
			"scrollbar", getGray4(), /* Scrollbar background (usually the "track") */
			"info", getAccentDarkShadow(), /* ToolTip Background */
			"infoText", getWhite()	/* ToolTip Text */
		};

		for (int i = 0; i < systemColors.length; i += 2) {
			table.put((String)systemColors[i], systemColors[i + 1]);
		}
	}

	protected void initComponentDefaults(UIDefaults table) {
		super.initComponentDefaults( table );

		Border marginBorder = new BasicBorders.MarginBorder();


		JTextComponent.KeyBinding[] fieldBindings = {
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_C, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.copyAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.pasteAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_X, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.cutAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionBackwardAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionForwardAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.previousWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.nextWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
																				  InputEvent.CTRL_MASK | 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionPreviousWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
																				  InputEvent.CTRL_MASK |
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionNextWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_A, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.selectAllAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
													DefaultEditorKit.beginLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
													DefaultEditorKit.endLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionBeginLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionEndLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
													JTextField.notifyAction)
		};

		JTextComponent.KeyBinding[] multilineBindings = {
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_C, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.copyAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.pasteAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_X, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.cutAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionBackwardAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionForwardAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.previousWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.nextWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
																				  InputEvent.CTRL_MASK | 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionPreviousWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
																				  InputEvent.CTRL_MASK |
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionNextWordAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_A, 
																				  InputEvent.CTRL_MASK),
													DefaultEditorKit.selectAllAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
													DefaultEditorKit.beginLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
													DefaultEditorKit.endLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionBeginLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionEndLineAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0),
													DefaultEditorKit.upAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0),
													DefaultEditorKit.downAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
													DefaultEditorKit.pageUpAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
													DefaultEditorKit.pageDownAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP,
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionUpAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
																				  InputEvent.SHIFT_MASK),
													DefaultEditorKit.selectionDownAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
													DefaultEditorKit.insertBreakAction),
			new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0),
													DefaultEditorKit.insertTabAction)
		};


		Border buttonBorder =  new BorderUIResource.CompoundBorderUIResource(
																								  new MacBorders.ButtonBorder(),
																								  marginBorder);

      Object defaultButtonBorder   = new BorderUIResource.CompoundBorderUIResource(
                                                                                   new MacBorders.DefaultButtonBorder(),
                                                                                   buttonBorder);

      Object toggleButtonBorder =  new BorderUIResource.CompoundBorderUIResource(
                                                                    new MacBorders.ToggleButtonBorder(),
                                                                    marginBorder);
      
		Object toolTipBorder = new BorderUIResource.LineBorderUIResource(
																							 getBlack());

		Object focusCellHighlightBorder = new BorderUIResource.LineBorderUIResource(
																											getFocusColor());

		Object tabbedPaneTabAreaInsets = new InsetsUIResource(4, 2, 0, 6);

	Object menuItemAcceleratorDelimiter = new String("-");


		//
		// DEFAULTS TABLE
		//



		Object[] defaults = {

			"TextField.font", getUserFont(),
			"TextField.caretForeground", getUserTextColor(),
			"TextField.border", new MacBorders.TextFieldBorder(),

			"PasswordField.font", getUserFont(),
			"PasswordField.caretForeground", getUserTextColor(),
         "PasswordField.border", new MacBorders.TextFieldBorder(),


			"TextArea.font", getUserFont(),
			"TextArea.caretForeground", getUserTextColor(),

			"TextPane.selectionBackground", table.get("textHighlight"),
			"TextPane.selectionForeground", table.get("textHighlightText"),
			"TextPane.background", table.get("window"),
			"TextPane.foreground", table.get("textText"),
			"TextPane.font", getUserFont(),
			"TextPane.caretForeground", getUserTextColor(),

			"EditorPane.selectionBackground", table.get("textHighlight"),
			"EditorPane.selectionForeground", table.get("textHighlightText"),
			"EditorPane.background", table.get("window"),
			"EditorPane.foreground", table.get("textText"),
			"EditorPane.font", getUserFont(),
			"EditorPane.caretForeground", getUserTextColor(),

			"TextField.keyBindings", fieldBindings,
			"PasswordField.keyBindings", fieldBindings,
			"TextArea.keyBindings", multilineBindings,
			"TextPane.keyBindings", multilineBindings,
			"EditorPane.keyBindings", multilineBindings,


			// Buttons
			"Button.background", table.get("control"),
			"Button.foreground", table.get("controlText"),
			"Button.disabledText", getDisabledControlText(),
			"Button.select", getGray8(),
			"Button.selectText", getWhite(),
			"Button.border", defaultButtonBorder,
			"Button.font", getControlFont(),
         "Button.margin", new InsetsUIResource(0, 10, 0, 10),



			"CheckBox.background", table.get("control"),
			"CheckBox.foreground", table.get("controlText"),
			"CheckBox.disabledText", getDisabledControlText(),
			"CheckBox.font", getControlFont(),
			"CheckBox.icon", new MacBorders.CheckBoxIcon(),

			"RadioButton.background", table.get("control"),
			"RadioButton.foreground", table.get("controlText"),
			"RadioButton.disabledText", getDisabledControlText(),
			"RadioButton.icon", new MacBorders.RadioButtonIcon(),
			"RadioButton.font", getControlFont(),
			"RadioButton.on", LookAndFeel.makeIcon(getClass(), "icons/RadioButtonEnabledOn.gif"),
			"RadioButton.off", LookAndFeel.makeIcon(getClass(), "icons/RadioButtonEnabledOff.gif"),
			"RadioButton.pressedOn", LookAndFeel.makeIcon(getClass(), "icons/RadioButtonPressedOn.gif"),
			"RadioButton.pressedOff", LookAndFeel.makeIcon(getClass(), "icons/RadioButtonPressedOff.gif"),
			"RadioButton.disabledOn", LookAndFeel.makeIcon(getClass(), "icons/RadioButtonDisabledOn.gif"),
			"RadioButton.disabledOff", LookAndFeel.makeIcon(getClass(), "icons/RadioButtonDisabledOff.gif"),


			"ToggleButton.background", getGray2(),
			"ToggleButton.foreground", table.get("controlText"),
			"ToggleButton.select",  getGray8(),
			"ToggleButton.text", table.get("controlText"),
			"ToggleButton.disabledText", getDisabledControlText(),
			"ToggleButton.disabledSelectedText", getDisabledControlText(),
			"ToggleButton.disabledBackground", getGray1(),
			"ToggleButton.disabledSelectedBackground", getGray3(),
			"ToggleButton.border", toggleButtonBorder,
			"ToggleButton.font", getControlFont(),


			// InternalFrame
			"InternalFrame.closeIcon", LookAndFeel.makeIcon(getClass(), "icons/WindowCloseEnabled.gif"),
			"InternalFrame.maximizeIcon", LookAndFeel.makeIcon(getClass(), "icons/WindowZoomEnabled.gif"),
			"InternalFrame.iconifyIcon", LookAndFeel.makeIcon(getClass(), "icons/WindowMinimizeEnabled.gif"),
			"InternalFrame.closePressed", LookAndFeel.makeIcon(getClass(), "icons/WindowClosePressed.gif"),
			"InternalFrame.maximizePressed", LookAndFeel.makeIcon(getClass(), "icons/WindowZoomPressed.gif"),
			"InternalFrame.iconifyPressed", LookAndFeel.makeIcon(getClass(), "icons/WindowMinimizePressed.gif"),

			"InternalFrame.minimizeIcon", LookAndFeel.makeIcon(getClass(), "icons/WindowZoomEnabled.gif"),
			"InternalFrame.font",  getControlFont(),

			"InternalFrame.icon", null,
			"InternalFrame.border", new MacBorders.InternalFrameBorder(),
			"InternalFrame.windowShadeBorder", new MacBorders.WindowShadeBorder(),

			// ToolTip
			"ToolTip.font", getUserFont(),
			"ToolTip.border", toolTipBorder,
			"ToolTip.background", table.get("info"),
			"ToolTip.foreground", table.get("infoText"),

			// Slider Defaults
			"Slider.border", null,
			"Slider.foreground", getGray4(),
			"Slider.background", getGray1(),
			"Slider.trackWidth", new Integer( 7 ),
			"Slider.majorTickLength", new Integer( 8 ),
			"Slider.minorTickLength", new Integer( 5 ),
			"Slider.horizontalThumbIcon", MacIconFactory.getSliderHorizontalThumbIcon(),
			"Slider.verticalThumbIcon", MacIconFactory.getSliderVerticalThumbIcon(),

			// Progress Bar
			"ProgressBar.font", getUserFont(),
	      "ProgressBar.foreground",  getAccent(),
	      "ProgressBar.background", table.get("control"),
	      "ProgressBar.selectionForeground", table.get("control"),
	      "ProgressBar.selectionBackground", getAccent(),
		   "ProgressBar.border", new LineBorder( getBlack() ),
			"ProgressBar.cellSpacing", new Integer(0),
			"ProgressBar.cellLength", new Integer(1),

			// Combo Box
			"ComboBox.background", table.get("control"),
			"ComboBox.foreground", table.get("controlText"),
			"ComboBox.selectionBackground", getAccentShadow(),
			"ComboBox.selectionForeground", getWhite(),
			"ComboBox.listBackground", table.get("menu"),
			"ComboBox.listForeground", table.get("menuText"),
			"ComboBox.font", getControlFont(),
 			
         // Titled Border
			"TitledBorder.font", getControlFont(),
			"TitledBorder.titleColor", table.get("controlText"),
			//"TitledBorder.border", titledBorderBorder,

			// Label
			"Label.font", getControlFont(),
			"Label.background", table.get("control"),
			"Label.foreground", table.get("controlText"),
			"Label.disabledForeground", getDisabledControlText(),

			// List
			"List.focusCellHighlightBorder", new EmptyBorder(0,0,0,0),

			// ScrollBar
			"ScrollBar.border", new MacBorders.ScrollBarBorder(),
			"ScrollBar.track", getGray4(),
			"ScrollBar.trackHighlight", getGray3(),
			"ScrollBar.trackLightHighlight", getGray2(),
			"ScrollBar.trackShadow", getGray6(),
			"ScrollBar.trackDarkShadow", getGray7(),
			"ScrollBar.thumb", getAccentHighlight(),
			"ScrollBar.thumbShadow", getAccent(),            
			"ScrollBar.thumbDarkShadow", getAccentShadow(),
			"ScrollBar.thumbHighlight", getAccentLightHighlight(),
			"ScrollBar.thumbLightHighlight", getGray0(),
			"ScrollBar.pressedThumb", getAccent(),
			"ScrollBar.pressedThumbShadow", getAccentShadow(),            
			"ScrollBar.pressedThumbDarkShadow", getAccentDarkShadow(),
			"ScrollBar.pressedThumbHighlight", getAccentHighlight(),
			"ScrollBar.pressedThumbLightHighlight", getAccentLightHighlight(),
			"ScrollBar.arrowBackground", getGray1(),
			"ScrollBar.arrowHighlight", getWhite(),
			"ScrollBar.arrowShadow", getGray3(),
			"ScrollBar.pressedArrowBackground", getGray7(),
			"ScrollBar.pressedArrowHighlight", getGray5(),
			"ScrollBar.pressedArrowShadow", getGray9(),
			"ScrollBar.arrowColor", getBlack(),
			"ScrollBar.width", new Integer( 14 ),	// doesn't include border

			// ScrollPane
			//"ScrollPane.border", scrollPaneBorder,
			"ScrollPane.background", table.get("window"),

			// Tabbed Pane
	 /*  	"TabbedPane.font", getControlFont(),
			"TabbedPane.background", getGray0(),
			"TabbedPane.foreground", table.get("controlText"),
			"TabbedPane.highlight", getWhite(),
			"TabbedPane.darkShadow", getGray3(),
			"TabbedPane.nonSelected", getGray2(),
			"TabbedPane.tabAreaInsets", tabbedPaneTabAreaInsets,     */


         "TabbedPane.font", getControlFont(),
			"TabbedPane.background", getGray1(),
			"TabbedPane.foreground", table.get("controlText"),
			"TabbedPane.highlight", getWhite(),
			"TabbedPane.darkShadow", getGray4(),
			"TabbedPane.nonSelected", getGray3(),
			"TabbedPane.tabAreaInsets", tabbedPaneTabAreaInsets,


			// Table
			"Table.font", getUserFont(),
			"Table.focusCellHighlightBorder", focusCellHighlightBorder,
			"Table.focusCellBackground", table.get("window"),
			//"Table.scrollPaneBorder", scrollPaneBorder,
			"Table.gridColor", getGray5(),  // grid line color
			"Table.font", getUserFont(),
			//"TableHeader.cellBorder", new MetalUtils.TableHeaderBorder(),



			// MenuBar
			"MenuBar.border", new MacBorders.MenuBarBorder(),
			"MenuBar.font", getControlFont(),
			"MenuBar.foreground", table.get("menuText"),
			"MenuBar.background", table.get("menu"),

			// Menu
			"Menu.border", new MacBorders.MenuItemBorder(),
			"Menu.borderPainted", Boolean.TRUE,
			"Menu.font", getControlFont(),
			"Menu.acceleratorFont", getControlFont(),
			"Menu.acceleratorForeground", table.get("menuText"),
			"Menu.acceleratorPressedForeground", getWhite(),
			"Menu.acceleratorSelectionForeground", getWhite(),
			"Menu.foreground", table.get("menuText"),
			"Menu.background", table.get("menu"),
			"Menu.selectionForeground", getWhite(),
			"Menu.selectionBackground", getAccentShadow(),
			"Menu.disabledForeground", getDisabledControlText(),
			//"Menu.checkIcon", MetalIconFactory.getMenuItemCheckIcon(),
			//"Menu.arrowIcon", MetalIconFactory.getMenuArrowIcon(),

			// Menu Item
			"MenuItem.border", new MacBorders.MenuItemBorder(),
			"MenuItem.borderPainted", Boolean.TRUE,
			"MenuItem.font", getControlFont(),
			"MenuItem.acceleratorFont", getControlFont(),
			"MenuItem.acceleratorForeground", table.get("menuText"),
			"MenuItem.acceleratorSelectionForeground", getWhite(),
			"MenuItem.acceleratorDelimiter", menuItemAcceleratorDelimiter,
			"MenuItem.foreground", table.get("menuText"),
			"MenuItem.background", table.get("menu"),
			"MenuItem.selectionForeground", getWhite(),
			"MenuItem.selectionBackground", getAccentShadow(),
			"MenuItem.disabledForeground", getDisabledControlText(),
			"MenuItem.margin", new InsetsUIResource(2, 0, 2, 0),

			//"MenuItem.checkIcon", MetalIconFactory.getMenuItemCheckIcon(),
			//"MenuItem.arrowIcon", MetalIconFactory.getMenuItemArrowIcon(),

			// Separator
			"Separator.background", getWhite(),
			"Separator.foreground", getGray6(),

			// Popup Menu
			"PopupMenu.background", table.get("menu"),
			"PopupMenu.border", new MacBorders.PopupMenuBorder(),          

			// CB & RB Menu Item
			//"CheckBoxMenuItem.border", menuItemBorder,
			"CheckBoxMenuItem.borderPainted", Boolean.TRUE,	  // - ??? PENDING - (STEVE)
			"CheckBoxMenuItem.font", getControlFont(),
			"CheckBoxMenuItem.acceleratorFont", getControlFont(),
			"CheckBoxMenuItem.acceleratorForeground", table.get("menuText"),
			"CheckBoxMenuItem.acceleratorSelectionForeground", getWhite(),
			"CheckBoxMenuItem.foreground", table.get("menuText"),
			"CheckBoxMenuItem.background", table.get("menu"),
			"CheckBoxMenuItem.selectionForeground", getWhite(),
			"CheckBoxMenuItem.selectionBackground", getAccentShadow(),
			"CheckBoxMenuItem.disabledForeground", getDisabledControlText(),
			//"MenuItem.checkIcon", MetalIconFactory.getMenuItemCheckIcon(),
			//"MenuItem.arrowIcon", MetalIconFactory.getMenuItemArrowIcon(),

			//"RadioButtonMenuItem.border", menuItemBorder,
			"RadioButtonMenuItem.borderPainted", Boolean.TRUE,	  // - ??? PENDING - (STEVE)
			"RadioButtonMenuItem.font", getControlFont(),
			"RadioButtonMenuItem.acceleratorFont", getControlFont(),
			"RadioButtonMenuItem.acceleratorForeground", table.get("menuText"),
			"RadioButtonMenuItem.acceleratorSelectionForeground", getWhite(),
			"RadioButtonMenuItem.foreground", table.get("menuText"),
			"RadioButtonMenuItem.background", table.get("menu"),
			"RadioButtonMenuItem.selectionForeground", getWhite(),
			"RadioButtonMenuItem.selectionBackground", getAccentShadow(),
			"RadioButtonMenuItem.disabledForeground", getDisabledControlText(),
			//   "RadioButtonMenuItem.checkIcon", MetalIconFactory.getRadioButtonMenuItemIcon(),
			//  "RadioButtonMenuItem.arrowIcon", MetalIconFactory.getMenuItemArrowIcon(),

			// SplitPane

			"SplitPane.dividerSize", new Integer(8),

			// Tree
			"Tree.background", table.get("window"),
			"Tree.font", getUserFont(),
			"Tree.textForeground", table.get("textText"),
			"Tree.textBackground", table.get("window"),
			"Tree.selectionForeground", table.get("textHighlightText"),
			"Tree.selectionBackground", table.get("textHighlight"),
			"Tree.selectionBorderColor", table.get("window"),
			"InternalFrame.closeIcon", LookAndFeel.makeIcon(getClass(), "icons/WindowCloseEnabled.gif"),
			/*   "Tree.openIcon", MetalIconFactory.getTreeFolderIcon(),
				 "Tree.closedIcon", MetalIconFactory.getTreeFolderIcon(),
				 "Tree.leafIcon", MetalIconFactory.getTreeLeafIcon(),
			*/
			"Tree.expandedIcon", LookAndFeel.makeIcon( getClass(), "icons/TreeExpanded.gif" ),
			"Tree.collapsedIcon", LookAndFeel.makeIcon( getClass(), "icons/TreeCollapsed.gif" ),
			"Tree.darkExpandedIcon", LookAndFeel.makeIcon( getClass(), "icons/TreeExpandedPressed.gif" ),
			"Tree.darkCollapsedIcon", LookAndFeel.makeIcon( getClass(), "icons/TreeCollapsedPressed.gif" ),
			/*
	  "Tree.hash", getPrimaryControl(),  // legs
  */
			"Tree.rowHeight", new Integer(18),

			// ToolBar
			//"ToolBar.border", toolBarBorder,
			"ToolBar.background", getGray1(),
			"ToolBar.foreground", getBlack(),
			"ToolBar.font", getControlFont(),
			"ToolBar.dockingBackground", getGray1(),
			"ToolBar.floatingBackground", getGray1(),
			"ToolBar.dockingForeground", getAccentDarkShadow(), 
			"ToolBar.floatingForeground", getAccent(),
		};

		table.putDefaults(defaults);
	}

	static final ColorUIResource getWhite() {return white;}  
	static final ColorUIResource getBlack() {return black;}  

	// note - 0 is lightest, 10 is darkest

	/** #EEEEEE - very light accents */
	static final ColorUIResource getGray0() {return gray0;}

	/** #DDDDDD - main control color, background */
	static final ColorUIResource getGray1() {return gray1;}

	/** #CCCCCC - scrollbar track highlight */
	static final ColorUIResource getGray2() {return gray2;}

	/** #BBBBBB - scrollbar track highlight */
	static final ColorUIResource getGray3() {return gray3;}

	/** #AAAAAA - control shadow, button shadow */
	static final ColorUIResource getGray4() {return gray4;}

	/** #999999 - window frame shadow */
	static final ColorUIResource getGray5() {return gray5;}

	/** #888888 - scrollbar track shadow */
	static final ColorUIResource getGray6() {return gray6;}

	/** #777777 - control dark shadow, button dark shadow */
	static final ColorUIResource getGray7() {return gray7;}

	/** #666666 - inactive text color */
	static final ColorUIResource getGray8() {return gray8;}

	/** #555555 - pressed button shadow */
	static final ColorUIResource getGray9() {return gray9;}

	/** #444444 - pressed button dark shadow */
	static final ColorUIResource getGray10() {return gray10;}

/** #333333 - pressed button dark shadow */
	static final ColorUIResource getGray11() {return gray11;}

/** #222222 - pressed button dark shadow */
	static final ColorUIResource getGray12() {return gray12;}



	/** #6666CC - for Lavender accents*/
	static final ColorUIResource getAccent() {return accent;}

	/** #9999FF - for Lavender accents*/
	static final ColorUIResource getAccentHighlight() {return accentHighlight;}

	/** #CCCCFF - for Lavender accents*/
	static final ColorUIResource getAccentLightHighlight() {return accentLightHighlight;}

	/** #333399 - for Lavender accents*/
	static final ColorUIResource getAccentShadow() {return accentShadow;}

	/** #000055 - for Lavender accents*/
	static final ColorUIResource getAccentDarkShadow() {return accentDarkShadow;}


	static final ColorUIResource getUserTextColor() {return getBlack();}
	static final ColorUIResource getUserTextHighlightColor() {return getBlack();}
	static final ColorUIResource getUserTextHighlightTextColor() {return getWhite();}


	static final ColorUIResource getDisabledControlText() {return getGray6();}
	static final ColorUIResource getFocusColor() {return getAccent();}


	private static final ColorUIResource white = new ColorUIResource(255,255,255); //#FFFFFF

	private static final ColorUIResource gray0 = new ColorUIResource(238,238,238); //#EEEEEE
	private static final ColorUIResource gray1 = new ColorUIResource(221,221,221); //#DDDDDD
	private static final ColorUIResource gray2 = new ColorUIResource(204,204,204); //#CCCCCC
	private static final ColorUIResource gray3 = new ColorUIResource(187,187,187); //#BBBBBB
	private static final ColorUIResource gray4 = new ColorUIResource(170,170,170); //#AAAAAA
	private static final ColorUIResource gray5 = new ColorUIResource(153,153,153); //#999999
	private static final ColorUIResource gray6 = new ColorUIResource(136,136,136); //#888888
	private static final ColorUIResource gray7 = new ColorUIResource(119,119,119); //#777777
	private static final ColorUIResource gray8 = new ColorUIResource(119,119,119); //#666666
	private static final ColorUIResource gray9 = new ColorUIResource( 85, 85, 85); //#555555
	private static final ColorUIResource gray10 = new ColorUIResource( 68, 68, 68); //#444444
	private static final ColorUIResource gray11 = new ColorUIResource( 34, 34, 34); //#333333
	private static final ColorUIResource gray12 = new ColorUIResource( 17, 17, 17); //#222222


	private static final ColorUIResource black = new ColorUIResource(  0,  0,  0); //#000000

	// colors listed below are for the "Lavender" accent colors
	private static ColorUIResource accent = new ColorUIResource(102,102,204); //#6666CC
	private static ColorUIResource accentHighlight = new ColorUIResource(153,153,255); //#9999FF
	private static ColorUIResource accentLightHighlight = new ColorUIResource(204,204,255); //#CCCCFF
	private static ColorUIResource accentShadow = new ColorUIResource( 51, 51,153); //#333399
	private static ColorUIResource accentDarkShadow = new ColorUIResource(  0,  0,85); //#000055


	private static FontUIResource userFont = new FontUIResource("SansSerif", Font.PLAIN, 12);	//  Geneva?
	private static FontUIResource controlFont = new FontUIResource("Dialog", Font.PLAIN, 12);	//  Charcoal, Chicago?

	static final FontUIResource getUserFont() {return userFont;}  
	static final FontUIResource getControlFont() {return controlFont;}
}
