/*
 * @(#)MetalInternalFrameTitlePane.java	1.18 98/05/12
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.basic.*;
import javax.swing.border.*;
import javax.swing.event.InternalFrameEvent;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.PropertyVetoException;


/**
 * Package private class that manages a Mac title bar
 * @version 1.18 05/12/98
 * @author Steve Wilson
 */
class MacInternalFrameTitlePane extends BasicInternalFrameTitlePane {

  static int titleBarHeight = 20;

  public MacInternalFrameTitlePane(JInternalFrame frame) {
      super(frame);
  }

  public void paintComponent(Graphics g) {
      int h = getHeight();
      int w = getWidth();
      
      String title = frame.getTitle();
      
      g.setFont(MacLookAndFeel.getControlFont());
      FontMetrics fm = g.getFontMetrics();
      int fmHeight = fm.getHeight() - fm.getLeading();
      int baseline = (titleBarHeight - fmHeight) / 2 +
	              fm.getAscent() + fm.getLeading();
      baseline -= 2; // just get it to look right

      int titleLength = fm.stringWidth(title);
      int titleX = (w/2) - titleLength/2;
      
      g.drawString(title, titleX, baseline);

      if (frame.isSelected()) {
	  g.setColor(MacLookAndFeel.getGray2());
	  g.fillRect(0,0,w-1,h-1);
	  g.setColor(MacLookAndFeel.getBlack());
	  g.drawLine(0,h-1, w-1,  h-1);
	  g.drawString(title, titleX, baseline);
	  g.setColor(MacLookAndFeel.getGray4());
	  g.drawLine(0,h-2,w,h-2);
	  
	  int gripStart = 0;
	  if (frame.isClosable()) {
	      gripStart+=16;
	  }
	  
	  int gripEndOffset = 34;
	  
	  if (!frame.isIconifiable()) {
	      gripEndOffset -=16;
	  }
	  
	  if (!frame.isMaximizable()) {
	      gripEndOffset -=16;
	  }

	  drawGrips(g, gripStart, titleX-4);
	  drawGrips(g, titleX+titleLength+4, w-gripEndOffset);

      } else {
	  g.setColor(MacLookAndFeel.getGray1());
	  g.fillRect(0,0,w-1,h-1);
	  g.setColor(MacLookAndFeel.getGray8());
	  g.drawLine(0,h-1, w-1,  h-1);
	  g.drawString(title, titleX, baseline);
      }
      
      iconButton.setVisible(frame.isSelected());
      closeButton.setVisible(frame.isSelected());
      maxButton.setVisible(frame.isSelected());
      
  }

  void drawGrips(Graphics g, int xStart, int xEnd) {

      g.setColor(MacLookAndFeel.getWhite());
      for (int y = 2; y <=12; y+=2) {
	  g.drawLine( xStart, y, xEnd-1, y);
      }
      
      g.setColor(MacLookAndFeel.getGray6());
      for (int y = 2; y <=12; y+=2) {
	  g.drawLine( xStart+1, y+1, xEnd, y+1);
      }
  }

  protected LayoutManager createLayout() {
      return new MacTitlePaneLayout();
  }

  protected void createButtons() {
      super.createButtons();
      Border empty = new EmptyBorder(0,0,0,0);
      iconButton.setBorder(empty);
      maxButton.setBorder(empty);
      closeButton.setBorder(empty);
      
      iconButton.setPressedIcon(UIManager.getIcon("InternalFrame.iconifyPressed"));
      maxButton.setPressedIcon(UIManager.getIcon("InternalFrame.maximizePressed"));
      closeButton.setPressedIcon(UIManager.getIcon("InternalFrame.closePressed"));

      iconButton.setContentAreaFilled(false);
      maxButton.setContentAreaFilled(false);
      closeButton.setContentAreaFilled(false); 
  }

  protected void setButtonIcons() {
      iconButton.setIcon(iconIcon);
      closeButton.setIcon(closeIcon);
      maxButton.setIcon(maxIcon);
  }

    /**
     * This method is overrides the parent's method to do nothing.
     * Macintosh frames do not have system menus.
     *
     */
  protected void assembleSystemMenu() { 
  }

    /**
     * This method is overrides the parent's method to do nothing.
     * Macintosh frames do not have system menus.
     *
     */
  protected void addSystemMenuItems(JMenu systemMenu) {
  }

  protected void addSubComponents() {
      add(iconButton);
      add(maxButton);
      add(closeButton);
  }

    // these are all hacks for the inner class protected variable bug.
  JButton getMaxB() {
      return maxButton;
  }

  JButton getIconB() {
      return iconButton;
  }

  JButton getCloseB() {
      return closeButton;
  }

  JInternalFrame getFrame() {
      return frame;
  }


  public class MacTitlePaneLayout extends TitlePaneLayout {
    public void addLayoutComponent(String name, Component c) {}
    public void removeLayoutComponent(Component c) {}    
    public Dimension preferredLayoutSize(Container c) {
	return new Dimension(100, titleBarHeight);
    }

    public Dimension minimumLayoutSize(Container c) {
	return preferredLayoutSize(c);
    }

    public void layoutContainer(Container c) {
      
	JButton closeButton = getCloseB();
	JButton iconButton = getIconB();
	JButton maxButton = getMaxB();
	JInternalFrame frame = getFrame();
	
	int iconSize = 13;
	
	int w = getWidth();
	int x = w - (iconSize-1);
	
	if (frame.isClosable()) {
	    closeButton.setBounds(0, 2, iconSize, iconSize);
	} else if (closeButton.getParent() != null) {
	    closeButton.getParent().remove(closeButton);
	}
	
	if (frame.isIconifiable()) {
	    iconButton.setBounds(x , 2, iconSize, iconSize);
	    x -= iconSize+3;            
	} else if (iconButton.getParent() != null) {
	    iconButton.getParent().remove(iconButton);
	}
	
	
	if (frame.isMaximizable()) {
	    maxButton.setBounds(x , 2, iconSize, iconSize);
	} else if (maxButton.getParent() != null) {
	    maxButton.getParent().remove(maxButton);
	}
	
    }
  } // end TitlePaneLayout
    
}; // End Title Pane Class
