/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SampleTree {
    protected JFrame frame;
    protected JTree tree;
    protected DefaultTreeModel treeModel;

    public SampleTree() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        JMenuBar jMenuBar = this.constructMenuBar();
        JPanel jPanel = new JPanel(true);
        this.frame = new JFrame("SampleTree");
        this.frame.getContentPane().add("Center", jPanel);
        this.frame.setJMenuBar(jMenuBar);
        ((Component)this.frame).setBackground(Color.lightGray);
        DefaultMutableTreeNode defaultMutableTreeNode = this.createNewNode("Root");
        this.treeModel = new SampleTreeModel(defaultMutableTreeNode);
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new SampleTreeCellRenderer());
        this.tree.setRowHeight(-1);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.getViewport().add(this.tree);
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", jScrollPane);
        jPanel.add("South", this.constructOptionsPanel());
        this.frame.addWindowListener(new 1());
        this.frame.pack();
        this.frame.show();
    }

    private JPanel constructOptionsPanel() {
        JPanel jPanel = new JPanel(false);
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel.setLayout(new FlowLayout());
        JCheckBox jCheckBox = new JCheckBox("show handles");
        jCheckBox.setSelected(this.tree.getShowsRootHandles());
        jCheckBox.addChangeListener(new ShowHandlesChangeListener());
        jPanel.add(jCheckBox);
        jCheckBox = new JCheckBox("show root");
        jCheckBox.setSelected(this.tree.isRootVisible());
        jCheckBox.addChangeListener(new ShowRootChangeListener());
        jPanel.add(jCheckBox);
        jCheckBox = new JCheckBox("editable");
        jCheckBox.setSelected(this.tree.isEditable());
        jCheckBox.addChangeListener(new TreeEditableChangeListener());
        jCheckBox.setToolTipText("Triple click to edit");
        jPanel.add(jCheckBox);
        jPanel2.add((Component)jPanel, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel3 = new JPanel(false);
        jPanel3.setLayout(new FlowLayout());
        JRadioButton jRadioButton = new JRadioButton("Single");
        jRadioButton.addActionListener(new 2());
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jRadioButton = new JRadioButton("Contiguous");
        jRadioButton.addActionListener(new 3());
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jRadioButton = new JRadioButton("Discontiguous");
        jRadioButton.addActionListener(new 4());
        jRadioButton.setSelected(true);
        buttonGroup.add(jRadioButton);
        jPanel3.add(jRadioButton);
        jPanel2.add((Component)jPanel3, "South");
        return jPanel2;
    }

    private JMenuBar constructMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.addActionListener(new 5());
        jMenu = new JMenu("Tree");
        jMenuBar.add(jMenu);
        jMenuItem = jMenu.add(new JMenuItem("Add"));
        jMenuItem.addActionListener(new AddAction());
        jMenuItem = jMenu.add(new JMenuItem("Insert"));
        jMenuItem.addActionListener(new InsertAction());
        jMenuItem = jMenu.add(new JMenuItem("Reload"));
        jMenuItem.addActionListener(new ReloadAction());
        jMenuItem = jMenu.add(new JMenuItem("Remove"));
        jMenuItem.addActionListener(new RemoveAction());
        return jMenuBar;
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    protected DefaultMutableTreeNode createNewNode(String string) {
        return new DynamicTreeNode(new SampleData(null, Color.black, string));
    }

    public static void main(String[] stringArray) {
        new SampleTree();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends AbstractAction {
        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SampleTree.this.tree.getSelectionModel().setSelectionMode(1);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends AbstractAction {
        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SampleTree.this.tree.getSelectionModel().setSelectionMode(2);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends AbstractAction {
        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SampleTree.this.tree.getSelectionModel().setSelectionMode(4);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }

        /* synthetic */ 5() {
        }
    }

    class AddAction
    implements ActionListener {
        public int addCount;

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
                    defaultMutableTreeNode2 = null;
                }
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
            }
            int n = defaultMutableTreeNode2 == null ? SampleTree.this.treeModel.getChildCount(defaultMutableTreeNode) : defaultMutableTreeNode.getIndex(defaultMutableTreeNode2) + 1;
            SampleTree.this.treeModel.insertNodeInto(SampleTree.this.createNewNode("Added " + Integer.toString(this.addCount++)), defaultMutableTreeNode, n);
        }

        AddAction() {
            SampleTree.this = SampleTree.this;
        }
    }

    class InsertAction
    implements ActionListener {
        public int insertCount;

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            DefaultMutableTreeNode defaultMutableTreeNode2 = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
                    defaultMutableTreeNode2 = null;
                }
            } else {
                defaultMutableTreeNode = (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot();
            }
            int n = defaultMutableTreeNode2 == null ? SampleTree.this.treeModel.getChildCount(defaultMutableTreeNode) : defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
            SampleTree.this.treeModel.insertNodeInto(SampleTree.this.createNewNode("Inserted " + Integer.toString(this.insertCount++)), defaultMutableTreeNode, n);
        }

        InsertAction() {
            SampleTree.this = SampleTree.this;
        }
    }

    class ReloadAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode != null) {
                SampleTree.this.treeModel.reload(defaultMutableTreeNode);
            }
        }

        ReloadAction() {
            SampleTree.this = SampleTree.this;
        }
    }

    class RemoveAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = SampleTree.this.getSelectedNode();
            if (defaultMutableTreeNode != null && defaultMutableTreeNode != (DefaultMutableTreeNode)SampleTree.this.treeModel.getRoot()) {
                SampleTree.this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            }
        }

        RemoveAction() {
            SampleTree.this = SampleTree.this;
        }
    }

    class ShowHandlesChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            SampleTree.this.tree.setShowsRootHandles(((JCheckBox)changeEvent.getSource()).isSelected());
        }

        ShowHandlesChangeListener() {
            SampleTree.this = SampleTree.this;
        }
    }

    class ShowRootChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            SampleTree.this.tree.setRootVisible(((JCheckBox)changeEvent.getSource()).isSelected());
        }

        ShowRootChangeListener() {
            SampleTree.this = SampleTree.this;
        }
    }

    class TreeEditableChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            SampleTree.this.tree.setEditable(((JCheckBox)changeEvent.getSource()).isSelected());
        }

        TreeEditableChangeListener() {
            SampleTree.this = SampleTree.this;
        }
    }
}

