/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MotifComboBoxUI
extends BasicComboBoxUI
implements Serializable {
    Icon arrowIcon;
    static final int HORIZ_MARGIN = 3;

    public void configureEditor() {
        super.configureEditor();
        this.editor.setBackground(UIManager.getColor("text"));
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ComboPopup createPopup() {
        return new MotifComboPopup(this.comboBox);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifComboBoxUI();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Insets insets = this.getInsets();
        Dimension dimension = this.getDisplaySize();
        dimension.height += insets.top + insets.bottom;
        int n = this.iconAreaWidth();
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return dimension;
    }

    public int iconAreaWidth() {
        if (this.comboBox.isEditable()) {
            return this.arrowIcon.getIconWidth() + 6;
        }
        return this.arrowIcon.getIconWidth() + 9 + 2;
    }

    protected void installComponents() {
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MotifComboBoxUI.this.motifGetComboBox().isEnabled() && MotifComboBoxUI.this.isPopupVisible(MotifComboBoxUI.this.motifGetComboBox())) {
                    MotifComboBoxUI.this.motifGetUI().selectNextPossibleValue();
                }
            }
        };
        this.motifGetComboBox().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 0), 1);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MotifComboBoxUI.this.motifGetComboBox().isEnabled() && MotifComboBoxUI.this.isPopupVisible(MotifComboBoxUI.this.motifGetComboBox())) {
                    MotifComboBoxUI.this.motifGetUI().selectPreviousPossibleValue();
                }
            }
        };
        this.motifGetComboBox().registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(38, 0), 1);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.arrowIcon = new MotifComboBoxArrowIcon(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"));
        Runnable runnable = new Runnable(){

            public void run() {
                if (MotifComboBoxUI.this.motifGetEditor() != null) {
                    MotifComboBoxUI.this.motifGetEditor().setBackground(UIManager.getColor("text"));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    JComboBox motifGetComboBox() {
        return this.comboBox;
    }

    Component motifGetEditor() {
        return this.editor;
    }

    MotifComboBoxUI motifGetUI() {
        return this;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        boolean bl = this.comboBox.hasFocus();
        graphics.setColor(this.comboBox.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (!this.comboBox.isEditable()) {
            rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, bl);
        }
        rectangle = this.rectangleForArrowIcon();
        this.arrowIcon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        if (!this.comboBox.isEditable()) {
            Border border = this.comboBox.getBorder();
            Insets insets = border != null ? border.getBorderInsets(this.comboBox) : new Insets(0, 0, 0, 0);
            rectangle.x -= 5;
            rectangle.y = insets.top;
            rectangle.width = 1;
            rectangle.height = this.comboBox.getBounds().height - insets.bottom - insets.top;
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++rectangle.x;
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, dimension.height);
    }

    protected Rectangle rectangleForArrowIcon() {
        Rectangle rectangle = this.comboBox.getBounds();
        Border border = this.comboBox.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this.comboBox) : new Insets(0, 0, 0, 0);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.x = rectangle.x + rectangle.width - 3 - this.arrowIcon.getIconWidth();
        rectangle.y += (rectangle.height - this.arrowIcon.getIconHeight()) / 2;
        rectangle.width = this.arrowIcon.getIconWidth();
        rectangle.height = this.arrowIcon.getIconHeight();
        return rectangle;
    }

    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right) - this.iconAreaWidth(), n2 - (insets.top + insets.bottom));
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void uninstallComponents() {
        this.removeEditor();
        this.comboBox.removeAll();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
    }

    public class MotifComboPopup
    extends BasicComboPopup {
        JComboBox cBox;

        public MotifComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            this.cBox = jComboBox;
        }

        public KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        public MouseMotionListener createListMouseMotionListener() {
            return new MouseMotionAdapter(){};
        }

        public class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            public InvocationKeyHandler() {
                super(MotifComboPopup.this);
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (!MotifComboPopup.this.cBox.isEditable()) {
                    if (keyEvent.getKeyCode() == 40) {
                        if (!MotifComboPopup.this.isVisible()) {
                            MotifComboPopup.this.show();
                        }
                    } else {
                        super.keyReleased(keyEvent);
                    }
                } else if (!(keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40 || MotifComboPopup.this.isVisible())) {
                    MotifComboPopup.this.show();
                }
            }
        }
    }

    public class ComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public ComboBoxLayoutManager() {
            super(MotifComboBoxUI.this);
        }

        public void layoutContainer(Container container) {
            if (MotifComboBoxUI.this.motifGetEditor() != null) {
                Rectangle rectangle = MotifComboBoxUI.this.rectangleForCurrentValue();
                ++rectangle.x;
                ++rectangle.y;
                --rectangle.width;
                rectangle.height -= 2;
                MotifComboBoxUI.this.motifGetEditor().setBounds(rectangle);
            }
        }
    }

    static class MotifComboBoxArrowIcon
    implements Icon,
    Serializable {
        private Color lightShadow;
        private Color darkShadow;
        private Color fill;

        public MotifComboBoxArrowIcon(Color color, Color color2, Color color3) {
            this.lightShadow = color;
            this.darkShadow = color2;
            this.fill = color3;
        }

        public int getIconHeight() {
            return 11;
        }

        public int getIconWidth() {
            return 11;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.lightShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 1, n2 + 1);
            int n5 = n + 1;
            int n6 = n2 + 2;
            int n7 = n3 - 6;
            while (n6 + 1 < n2 + n4) {
                graphics.setColor(this.lightShadow);
                graphics.drawLine(n5, n6, n5 + 1, n6);
                graphics.drawLine(n5, n6 + 1, n5 + 1, n6 + 1);
                if (n7 > 0) {
                    graphics.setColor(this.fill);
                    graphics.drawLine(n5 + 2, n6, n5 + 1 + n7, n6);
                    graphics.drawLine(n5 + 2, n6 + 1, n5 + 1 + n7, n6 + 1);
                }
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n5 + n7 + 2, n6, n5 + n7 + 3, n6);
                graphics.drawLine(n5 + n7 + 2, n6 + 1, n5 + n7 + 3, n6 + 1);
                ++n5;
                n7 -= 2;
                n6 += 2;
            }
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 / 2, n2 + n4 - 1, n + n3 / 2, n2 + n4 - 1);
        }
    }
}

