/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.OptionListModel;

public class FormView
extends ComponentView
implements ActionListener {
    public static final String SUBMIT = new String("Submit Query");
    public static final String RESET = new String("Reset");

    public FormView(Element element) {
        super(element);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Element element = this.getElement();
        StringBuffer stringBuffer = new StringBuffer();
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        AttributeSet attributeSet = element.getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        if (string.equals("submit")) {
            hTMLDocument.getFormData(stringBuffer, element);
            this.submitData(stringBuffer.toString());
        } else if (string.equals("reset")) {
            hTMLDocument.resetForm(element);
        } else if (string.equals("text") || string.equals("password")) {
            if (hTMLDocument.isLastTextOrPasswordField(element)) {
                hTMLDocument.getFormData(stringBuffer, element);
                this.submitData(stringBuffer.toString());
            } else {
                this.getComponent().transferFocus();
            }
        }
    }

    protected Component createComponent() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
        JComponent jComponent = null;
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (tag == HTML.Tag.INPUT) {
            jComponent = this.createInputComponent(attributeSet, object);
        } else if (tag == HTML.Tag.SELECT) {
            if (object instanceof OptionListModel) {
                JList jList = new JList((ListModel)object);
                int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, 1);
                jList.setVisibleRowCount(n);
                jList.setOpaque(false);
                jList.setSelectionModel((ListSelectionModel)object);
                jComponent = new JScrollPane(jList);
            } else {
                jComponent = new JComboBox((ComboBoxModel)object);
            }
        } else if (tag == HTML.Tag.TEXTAREA) {
            JTextArea jTextArea = new JTextArea((Document)object);
            int n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.ROWS, 0);
            jTextArea.setRows(n);
            int n2 = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.COLS, 0);
            jTextArea.setColumns(n2);
            jComponent = new JScrollPane(jTextArea, 22, 32);
        }
        if (jComponent != null) {
            jComponent.setAlignmentY(1.0f);
            jComponent.setOpaque(false);
        }
        return jComponent;
    }

    private JComponent createInputComponent(AttributeSet attributeSet, Object object) {
        JComponent jComponent = null;
        String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
        if (string.equals("submit") || string.equals("reset")) {
            String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string2 == null) {
                string2 = string.equals("submit") ? SUBMIT : RESET;
            }
            JButton jButton = new JButton(string2);
            if (object != null) {
                jButton.setModel((ButtonModel)object);
                jButton.addActionListener(this);
            }
            jComponent = jButton;
        } else if (string.equals("image")) {
            JButton jButton;
            String string3 = (String)attributeSet.getAttribute(HTML.Attribute.SRC);
            try {
                URL uRL = ((HTMLDocument)this.getElement().getDocument()).getBase();
                URL uRL2 = new URL(uRL, string3);
                ImageIcon imageIcon = new ImageIcon(uRL2);
                jButton = new JButton(imageIcon);
            }
            catch (MalformedURLException malformedURLException) {
                jButton = new JButton(string3);
            }
            if (object != null) {
                jButton.setModel((ButtonModel)object);
                jButton.addMouseListener(new MouseEventListener());
            }
            jComponent = jButton;
        } else if (string.equals("checkbox")) {
            jComponent = new JCheckBox();
            if (object != null) {
                boolean bl = attributeSet.getAttribute(HTML.Attribute.CHECKED) != null;
                ((JToggleButton.ToggleButtonModel)object).setSelected(bl);
                jComponent.setModel((JToggleButton.ToggleButtonModel)object);
            }
        } else if (string.equals("radio")) {
            jComponent = new JRadioButton();
            if (object != null) {
                boolean bl = attributeSet.getAttribute(HTML.Attribute.CHECKED) != null;
                ((JToggleButton.ToggleButtonModel)object).setSelected(bl);
                ((JRadioButton)jComponent).setModel((JToggleButton.ToggleButtonModel)object);
            }
        } else if (string.equals("text")) {
            String string4;
            int n;
            JTextField jTextField = new JTextField();
            jComponent = jTextField;
            if (object != null) {
                jTextField.setDocument((Document)object);
            }
            if ((n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1)) > 0) {
                jTextField.setColumns(n);
            }
            if ((string4 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) != null) {
                jTextField.setText(string4);
            }
            jTextField.addActionListener(this);
        } else if (string.equals("password")) {
            String string5;
            int n;
            JPasswordField jPasswordField = new JPasswordField();
            jComponent = jPasswordField;
            if (object != null) {
                jPasswordField.setDocument((Document)object);
            }
            if ((n = HTML.getIntegerAttributeValue(attributeSet, HTML.Attribute.SIZE, -1)) > 0) {
                jPasswordField.setColumns(n);
            }
            if ((string5 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE)) != null) {
                jPasswordField.setText(string5);
            }
            jPasswordField.addActionListener(this);
        }
        return jComponent;
    }

    private String getImageData(Point point) {
        String string;
        String string2 = String.valueOf(point.x) + ":" + point.y;
        int n = string2.indexOf(58);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(++n);
        String string5 = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
        if (string5 == null || string5.equals("")) {
            string = "x=" + string3 + "&y=" + string4;
        } else {
            string5 = URLEncoder.encode(string5);
            string = String.valueOf(string5) + ".x" + "=" + string3 + "&" + string5 + ".y" + "=" + string4;
        }
        return string;
    }

    protected void imageSubmit(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = this.getElement();
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        hTMLDocument.getFormData(stringBuffer, this.getElement());
        if (stringBuffer.length() > 0) {
            stringBuffer.append('&');
        }
        stringBuffer.append(string);
        this.submitData(stringBuffer.toString());
    }

    protected void submitData(String string) {
        SubmitThread submitThread = new SubmitThread(this.getElement(), string);
        submitThread.start();
    }

    class SubmitThread
    extends Thread {
        String data;
        HTMLDocument hdoc;
        HTMLDocument newDoc;
        AttributeSet formAttr;
        InputStream in;

        public SubmitThread(Element element, String string) {
            this.data = string;
            this.hdoc = (HTMLDocument)element.getDocument();
            this.formAttr = this.hdoc.getFormAttributes(element.getAttributes());
        }

        public String getAction() {
            if (this.formAttr == null) {
                return null;
            }
            String string = (String)this.formAttr.getAttribute(HTML.Attribute.ACTION);
            int n = string.indexOf(63);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return string;
        }

        String getMethod() {
            String string;
            if (this.formAttr != null && (string = (String)this.formAttr.getAttribute(HTML.Attribute.METHOD)) != null) {
                return string.toLowerCase();
            }
            return null;
        }

        public void loadDocument() {
            JEditorPane jEditorPane = (JEditorPane)FormView.this.getContainer();
            try {
                jEditorPane.read(this.in, (Object)this.newDoc);
            }
            catch (IOException iOException) {}
        }

        public void postData(URLConnection uRLConnection, String string) {
            uRLConnection.setDoOutput(true);
            PrintWriter printWriter = null;
            try {
                try {
                    printWriter = new PrintWriter(new OutputStreamWriter(uRLConnection.getOutputStream()));
                    printWriter.print(string);
                    printWriter.flush();
                }
                catch (IOException iOException) {
                }
                Object var5_4 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }

        public void run() {
            block8: {
                if (this.data.length() <= 0) break block8;
                String string = this.getMethod();
                String string2 = this.getAction();
                try {
                    URL uRL;
                    URL uRL2;
                    Object object;
                    URL uRL3 = this.hdoc.getBase();
                    if (string2 == null) {
                        object = uRL3.getFile();
                        int n = ((String)object).indexOf(63);
                        if (n >= 0) {
                            object = ((String)object).substring(0, n);
                        }
                        uRL2 = new URL(uRL3.getProtocol(), uRL3.getHost(), uRL3.getPort(), (String)object);
                    } else {
                        uRL2 = new URL(uRL3, string2);
                    }
                    if ("post".equals(string)) {
                        uRL = uRL2;
                        object = uRL.openConnection();
                        this.postData((URLConnection)object, this.data);
                    } else {
                        uRL = new URL(String.valueOf(String.valueOf(uRL2)) + "?" + this.data);
                        object = uRL.openConnection();
                    }
                    this.in = ((URLConnection)object).getInputStream();
                    JEditorPane jEditorPane = (JEditorPane)FormView.this.getContainer();
                    HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
                    this.newDoc = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
                    this.newDoc.putProperty("stream", uRL);
                    Runnable runnable = new Runnable(this){
                        private final /* synthetic */ SubmitThread this$1;
                        {
                            this.this$1 = submitThread;
                        }

                        public void run() {
                            this.this$1.loadDocument();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected class MouseEventListener
    extends MouseAdapter {
        protected MouseEventListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            String string = FormView.this.getImageData(mouseEvent.getPoint());
            FormView.this.imageSubmit(string);
        }
    }
}

