/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

class Notepad
extends JPanel {
    private static ResourceBundle resources;
    private JTextComponent editor;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private JComponent status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String exitAction = "exit";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new OpenAction(), new ExitAction(), new ShowElementTreeAction(), this.undoAction, this.redoAction};

    Notepad() {
        super(true);
        Object object;
        Object object2;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.setFont(new Font("monospaced", 0, 12));
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.commands = new Hashtable();
        Action[] actionArray = this.getActions();
        int n = 0;
        while (n < actionArray.length) {
            object2 = actionArray[n];
            this.commands.put(object2.getValue("Name"), object2);
            ++n;
        }
        object2 = new JScrollPane();
        JViewport jViewport = ((JScrollPane)object2).getViewport();
        jViewport.add(this.editor);
        try {
            object = resources.getString("ViewportBackingStore");
            Boolean bl = new Boolean((String)object);
            jViewport.setBackingStoreEnabled(bl);
        }
        catch (MissingResourceException missingResourceException) {}
        this.menuItems = new Hashtable();
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add("North", this.createToolbar());
        ((Container)object).add("Center", (Component)object2);
        this.add("Center", (Component)object);
        this.add("South", this.createStatusbar());
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("java.version");
            if (string.compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
            }
            JFrame jFrame = new JFrame();
            jFrame.setTitle(resources.getString("Title"));
            ((Component)jFrame).setBackground(Color.lightGray);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add("Center", new Notepad());
            jFrame.addWindowListener(new AppCloser());
            jFrame.pack();
            ((Component)jFrame).setSize(500, 600);
            jFrame.show();
            return;
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
            return;
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected JTextComponent createEditor() {
        return new JTextArea();
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    protected Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected JMenuItem createMenuItem(String string) {
        String string2;
        JMenuItem jMenuItem = new JMenuItem(this.getResourceString(String.valueOf(string) + labelSuffix));
        URL uRL = this.getResource(String.valueOf(string) + imageSuffix);
        if (uRL != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(new ImageIcon(uRL));
        }
        if ((string2 = this.getResourceString(String.valueOf(string) + actionSuffix)) == null) {
            string2 = string;
        }
        jMenuItem.setActionCommand(string2);
        Action action = this.getAction(string2);
        if (action != null) {
            jMenuItem.addActionListener(action);
            action.addPropertyChangeListener(this.createActionChangeListener(jMenuItem));
            jMenuItem.setEnabled(action.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return (Action)this.commands.get(string);
    }

    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
        }
        return string2;
    }

    protected URL getResource(String string) {
        String string2 = this.getResourceString(string);
        if (string2 != null) {
            URL uRL = this.getClass().getResource(string2);
            return uRL;
        }
        return null;
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(this.getResourceString("toolbar"));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
            } else {
                this.toolbar.add(this.createTool(stringArray[n]));
            }
            ++n;
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected JButton createToolbarButton(String string) {
        Action action;
        URL uRL = this.getResource(String.valueOf(string) + imageSuffix);
        1 var3_3 = new 1(new ImageIcon(uRL));
        var3_3.setRequestFocusEnabled(false);
        var3_3.setMargin(new Insets(1, 1, 1, 1));
        String string2 = this.getResourceString(String.valueOf(string) + actionSuffix);
        if (string2 == null) {
            string2 = string;
        }
        if ((action = this.getAction(string2)) != null) {
            var3_3.setActionCommand(string2);
            var3_3.addActionListener(action);
        } else {
            var3_3.setEnabled(false);
        }
        String string3 = this.getResourceString(String.valueOf(string) + tipSuffix);
        if (string3 != null) {
            var3_3.setToolTipText(string3);
        }
        return var3_3;
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = this.tokenize(this.getResourceString("menubar"));
        int n = 0;
        while (n < stringArray.length) {
            JMenu jMenu = this.createMenu(stringArray[n]);
            if (jMenu != null) {
                jMenuBar.add(jMenu);
            }
            ++n;
        }
        return jMenuBar;
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(this.getResourceString(string));
        JMenu jMenu = new JMenu(this.getResourceString(String.valueOf(string) + labelSuffix));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = this.createMenuItem(stringArray[n]);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Notepad", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("resources/Notepad.properties not found");
            System.exit(1);
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }

        protected AppCloser() {
        }
    }

    private final class 1
    extends JButton {
        public float getAlignmentY() {
            return 0.5f;
        }

        /* synthetic */ 1(ImageIcon imageIcon) {
            super(imageIcon);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            Notepad.this = Notepad.this;
            this.menuItem = jMenuItem;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
                return;
            }
            if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            Notepad.this.undo.addEdit(undoableEditEvent.getEdit());
            Notepad.this.undoAction.update();
            Notepad.this.redoAction.update();
        }

        UndoHandler() {
            Notepad.this = Notepad.this;
        }
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            Notepad.this = Notepad.this;
            this.setLayout(new BoxLayout(this, 0));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            Notepad.this = Notepad.this;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Notepad.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.update();
            Notepad.this.redoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getUndoPresentationName());
                return;
            }
            this.setEnabled(false);
            this.putValue("Name", "Undo");
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            Notepad.this = Notepad.this;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Notepad.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.update();
            Notepad.this.undoAction.update();
        }

        protected void update() {
            if (Notepad.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getRedoPresentationName());
                return;
            }
            this.setEnabled(false);
            this.putValue("Name", "Redo");
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Notepad.openAction);
            Notepad.this = Notepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = Notepad.this.getFrame();
            if (Notepad.this.fileDialog == null) {
                Notepad.this.fileDialog = new FileDialog(frame);
            }
            Notepad.this.fileDialog.setMode(0);
            Notepad.this.fileDialog.show();
            String string = Notepad.this.fileDialog.getFile();
            if (string == null) {
                return;
            }
            String string2 = Notepad.this.fileDialog.getDirectory();
            File file = new File(string2, string);
            if (file.exists()) {
                Document document = Notepad.this.getEditor().getDocument();
                if (document != null) {
                    document.removeUndoableEditListener(Notepad.this.undoHandler);
                }
                if (Notepad.this.elementTreePanel != null) {
                    Notepad.this.elementTreePanel.setEditor(null);
                }
                Notepad.this.getEditor().setDocument(new PlainDocument());
                frame.setTitle(string);
                FileLoader fileLoader = new FileLoader(file, Notepad.this.editor.getDocument());
                fileLoader.start();
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Notepad.newAction);
            Notepad.this = Notepad.this;
        }

        NewAction(String string) {
            super(string);
            Notepad.this = Notepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document = Notepad.this.getEditor().getDocument();
            if (document != null) {
                document.removeUndoableEditListener(Notepad.this.undoHandler);
            }
            Notepad.this.getEditor().setDocument(new PlainDocument());
            Notepad.this.getEditor().getDocument().addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.revalidate();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Notepad.exitAction);
            Notepad.this = Notepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(Notepad.showElementTreeAction);
            Notepad.this = Notepad.this;
        }

        ShowElementTreeAction(String string) {
            super(string);
            Notepad.this = Notepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Notepad.this.elementTreeFrame == null) {
                Object object;
                try {
                    object = resources.getString("ElementTreeFrameTitle");
                    Notepad.this.elementTreeFrame = new JFrame((String)object);
                }
                catch (MissingResourceException missingResourceException) {
                    Notepad.this.elementTreeFrame = new JFrame();
                }
                Notepad.this.elementTreeFrame.addWindowListener(new 2(this));
                object = Notepad.this.elementTreeFrame.getContentPane();
                ((Container)object).setLayout(new BorderLayout());
                Notepad.this.elementTreePanel = new ElementTreePanel(Notepad.this.getEditor());
                ((Container)object).add(Notepad.this.elementTreePanel);
                Notepad.this.elementTreeFrame.pack();
            }
            Notepad.this.elementTreeFrame.show();
        }

        static /* synthetic */ Notepad access$0(ShowElementTreeAction showElementTreeAction) {
            return showElementTreeAction.Notepad.this;
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;

        FileLoader(File file, Document document) {
            Notepad.this = Notepad.this;
            this.setPriority(4);
            this.f = file;
            this.doc = document;
        }

        public void run() {
            try {
                int n;
                Notepad.this.status.removeAll();
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setMinimum(0);
                jProgressBar.setMaximum((int)this.f.length());
                Notepad.this.status.add(jProgressBar);
                Notepad.this.status.revalidate();
                FileReader fileReader = new FileReader(this.f);
                char[] cArray = new char[4096];
                while ((n = ((Reader)fileReader).read(cArray, 0, cArray.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(cArray, 0, n), null);
                    jProgressBar.setValue(jProgressBar.getValue() + n);
                }
                this.doc.addUndoableEditListener(Notepad.this.undoHandler);
                Notepad.this.status.removeAll();
                Notepad.this.status.revalidate();
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException.getMessage());
            }
            if (Notepad.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new 3(this));
            }
        }

        static /* synthetic */ Notepad access$0(FileLoader fileLoader) {
            return fileLoader.Notepad.this;
        }
    }
}

