/*
 * Copyright 1992 by Jutta Degener and Carsten Bormann, Technische
 * Universitaet Berlin.  See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.


   Copyright 1992 by Jutta Degener and Carsten Bormann,
   Technische Universitaet Berlin

   Any use of this software is permitted provided that this notice is not
   removed and that neither the authors nor the Technische Universitaet Berlin
   are deemed to have made any representations as to the suitability of this
   software for any purpose nor are held responsible for any defects of
   this software.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.

   As a matter of courtesy, the authors request to be informed about uses
   this software has found, about bugs in this software, and about any
   improvements that may be of general interest.

   Berlin, 15.09.1992
   Jutta Degener
   Carsten Bormann

*/
 
/* This definition puts the following large arrays of constants
   in the code segment, conserving precious DGROUP space in 16
   bit Windows medium memory model.  The definition should be void
   in a 32 bit port.  Note that modules which reference this data
   should declare it FAR, *not* the same as it is declared here
   (as that would cause them to address into their own code
   segment instead of this module's.  */

#define CONSTANT_DATA __based(__segname("_CODE"))

const unsigned short CONSTANT_DATA u2s[] = {
        33280, 34308, 35336, 36364, 37393, 38421, 39449, 40477,
        41505, 42534, 43562, 44590, 45618, 46647, 47675, 48703,
        49474, 49988, 50503, 51017, 51531, 52045, 52559, 53073,
        53587, 54101, 54616, 55130, 55644, 56158, 56672, 57186,
        57572, 57829, 58086, 58343, 58600, 58857, 59114, 59371,
        59628, 59885, 60142, 60399, 60656, 60913, 61171, 61428,
        61620, 61749, 61877, 62006, 62134, 62263, 62392, 62520,
        62649, 62777, 62906, 63034, 63163, 63291, 63420, 63548,
        63645, 63709, 63773, 63838, 63902, 63966, 64030, 64095,
        64159, 64223, 64287, 64352, 64416, 64480, 64544, 64609,
        64657, 64689, 64721, 64753, 64785, 64818, 64850, 64882,
        64914, 64946, 64978, 65010, 65042, 65075, 65107, 65139,
        65163, 65179, 65195, 65211, 65227, 65243, 65259, 65275,
        65291, 65308, 65324, 65340, 65356, 65372, 65388, 65404,
        65416, 65424, 65432, 65440, 65448, 65456, 65464, 65472,
        65480, 65488, 65496, 65504, 65512, 65520, 65528,     0,
        32256, 31228, 30200, 29172, 28143, 27115, 26087, 25059,
        24031, 23002, 21974, 20946, 19918, 18889, 17861, 16833,
        16062, 15548, 15033, 14519, 14005, 13491, 12977, 12463,
        11949, 11435, 10920, 10406,  9892,  9378,  8864,  8350,
         7964,  7707,  7450,  7193,  6936,  6679,  6422,  6165, 
         5908,  5651,  5394,  5137,  4880,  4623,  4365,  4108, 
         3916,  3787,  3659,  3530,  3402,  3273,  3144,  3016, 
         2887,  2759,  2630,  2502,  2373,  2245,  2116,  1988, 
         1891,  1827,  1763,  1698,  1634,  1570,  1506,  1441, 
         1377,  1313,  1249,  1184,  1120,  1056,   992,   927, 
          879,   847,   815,   783,   751,   718,   686,   654,
          622,   590,   558,   526,   494,   461,   429,   397,
          373,   357,   341,   325,   309,   293,   277,   261,
          245,   228,   212,   196,   180,   164,   148,   132,
          120,   112,   104,    96,    88,    80,    72,    64,
           56,    48,    40,    32,    24,    16,    8,      0
};

const unsigned char CONSTANT_DATA s2u[] = {
0377,0376,0375,0374,0373,0372,0371,0370,0367,0366,0365,0364,0363,0362,0361,
0360,0357,0357,0356,0356,0355,0355,0354,0354,0353,0353,0352,0352,0351,0351,
0350,0350,0347,0347,0346,0346,0345,0345,0344,0344,0343,0343,0342,0342,0341,
0341,0340,0340,0337,0337,0337,0337,0336,0336,0336,0336,0335,0335,0335,0335,
0334,0334,0334,0334,0333,0333,0333,0333,0332,0332,0332,0332,0331,0331,0331,
0331,0330,0330,0330,0330,0327,0327,0327,0327,0326,0326,0326,0326,0325,0325,
0325,0325,0324,0324,0324,0324,0323,0323,0323,0323,0322,0322,0322,0322,0321,
0321,0321,0321,0320,0320,0320,0320,0317,0317,0317,0317,0317,0317,0317,0317,
0316,0316,0316,0316,0316,0316,0316,0316,0315,0315,0315,0315,0315,0315,0315,
0315,0314,0314,0314,0314,0314,0314,0314,0314,0313,0313,0313,0313,0313,0313,
0313,0313,0312,0312,0312,0312,0312,0312,0312,0312,0311,0311,0311,0311,0311,
0311,0311,0311,0310,0310,0310,0310,0310,0310,0310,0310,0307,0307,0307,0307,
0307,0307,0307,0307,0306,0306,0306,0306,0306,0306,0306,0306,0305,0305,0305,
0305,0305,0305,0305,0305,0304,0304,0304,0304,0304,0304,0304,0304,0303,0303,
0303,0303,0303,0303,0303,0303,0303,0302,0302,0302,0302,0302,0302,0302,0302,
0301,0301,0301,0301,0301,0301,0301,0301,0300,0300,0300,0300,0300,0300,0300,
0300,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,
0277,0277,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,
0276,0276,0276,0275,0275,0275,0275,0275,0275,0275,0275,0275,0275,0275,0275,
0275,0275,0275,0275,0274,0274,0274,0274,0274,0274,0274,0274,0274,0274,0274,
0274,0274,0274,0274,0274,0273,0273,0273,0273,0273,0273,0273,0273,0273,0273,
0273,0273,0273,0273,0273,0273,0272,0272,0272,0272,0272,0272,0272,0272,0272,
0272,0272,0272,0272,0272,0272,0272,0271,0271,0271,0271,0271,0271,0271,0271,
0271,0271,0271,0271,0271,0271,0271,0271,0270,0270,0270,0270,0270,0270,0270,
0270,0270,0270,0270,0270,0270,0270,0270,0270,0267,0267,0267,0267,0267,0267,
0267,0267,0267,0267,0267,0267,0267,0267,0267,0267,0266,0266,0266,0266,0266,
0266,0266,0266,0266,0266,0266,0266,0266,0266,0266,0266,0265,0265,0265,0265,
0265,0265,0265,0265,0265,0265,0265,0265,0265,0265,0265,0265,0264,0264,0264,
0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0263,0263,
0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0262,
0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,
0262,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,
0261,0261,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,
0260,0260,0260,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,
0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,
0257,0257,0257,0257,0257,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,
0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,
0256,0256,0256,0256,0256,0256,0256,0255,0255,0255,0255,0255,0255,0255,0255,
0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,
0255,0255,0255,0255,0255,0255,0255,0255,0255,0254,0254,0254,0254,0254,0254,
0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,
0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0253,0253,0253,0253,
0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,
0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0252,0252,
0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,
0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,
0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,
0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,
0251,0251,0251,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,
0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,
0250,0250,0250,0250,0250,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,
0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,
0247,0247,0247,0247,0247,0247,0247,0246,0246,0246,0246,0246,0246,0246,0246,
0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,
0246,0246,0246,0246,0246,0246,0246,0246,0246,0245,0245,0245,0245,0245,0245,
0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,
0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0244,0244,0244,0244,
0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,
0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0243,0243,
0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,
0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,
0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,
0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,
0242,0242,0242,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,
0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,
0241,0241,0241,0241,0241,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,
0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,
0240,0240,0240,0240,0240,0240,0240,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0040,0040,0040,0040,0040,
0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,
0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0041,0041,
0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,
0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,
0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,
0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,
0042,0042,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,
0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,
0043,0043,0043,0043,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,
0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,
0044,0044,0044,0044,0044,0044,0045,0045,0045,0045,0045,0045,0045,0045,0045,
0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,
0045,0045,0045,0045,0045,0045,0045,0045,0046,0046,0046,0046,0046,0046,0046,
0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,
0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0047,0047,0047,0047,0047,
0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,
0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0050,0050,
0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,
0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,
0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,
0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,
0051,0051,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,
0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,
0052,0052,0052,0052,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,
0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,
0053,0053,0053,0053,0053,0053,0054,0054,0054,0054,0054,0054,0054,0054,0054,
0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,
0054,0054,0054,0054,0054,0054,0054,0054,0055,0055,0055,0055,0055,0055,0055,
0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,
0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0056,0056,0056,0056,0056,
0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,
0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0057,0057,0057,
0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,
0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,
0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,
0060,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,
0061,0061,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,
0062,0062,0062,0063,0063,0063,0063,0063,0063,0063,0063,0063,0063,0063,0063,
0063,0063,0063,0063,0064,0064,0064,0064,0064,0064,0064,0064,0064,0064,0064,
0064,0064,0064,0064,0064,0065,0065,0065,0065,0065,0065,0065,0065,0065,0065,
0065,0065,0065,0065,0065,0065,0066,0066,0066,0066,0066,0066,0066,0066,0066,
0066,0066,0066,0066,0066,0066,0066,0067,0067,0067,0067,0067,0067,0067,0067,
0067,0067,0067,0067,0067,0067,0067,0067,0070,0070,0070,0070,0070,0070,0070,
0070,0070,0070,0070,0070,0070,0070,0070,0070,0071,0071,0071,0071,0071,0071,
0071,0071,0071,0071,0071,0071,0071,0071,0071,0071,0072,0072,0072,0072,0072,
0072,0072,0072,0072,0072,0072,0072,0072,0072,0072,0072,0073,0073,0073,0073,
0073,0073,0073,0073,0073,0073,0073,0073,0073,0073,0073,0073,0074,0074,0074,
0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0075,0075,
0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,
0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,
0076,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,
0077,0077,0100,0100,0100,0100,0100,0100,0100,0100,0101,0101,0101,0101,0101,
0101,0101,0101,0102,0102,0102,0102,0102,0102,0102,0102,0103,0103,0103,0103,
0103,0103,0103,0103,0104,0104,0104,0104,0104,0104,0104,0104,0105,0105,0105,
0105,0105,0105,0105,0105,0106,0106,0106,0106,0106,0106,0106,0106,0107,0107,
0107,0107,0107,0107,0107,0107,0110,0110,0110,0110,0110,0110,0110,0110,0111,
0111,0111,0111,0111,0111,0111,0111,0112,0112,0112,0112,0112,0112,0112,0112,
0113,0113,0113,0113,0113,0113,0113,0113,0114,0114,0114,0114,0114,0114,0114,
0114,0115,0115,0115,0115,0115,0115,0115,0115,0116,0116,0116,0116,0116,0116,
0116,0116,0117,0117,0117,0117,0117,0117,0117,0117,0120,0120,0120,0120,0121,
0121,0121,0121,0122,0122,0122,0122,0123,0123,0123,0123,0124,0124,0124,0124,
0125,0125,0125,0125,0126,0126,0126,0126,0127,0127,0127,0127,0130,0130,0130,
0130,0131,0131,0131,0131,0132,0132,0132,0132,0133,0133,0133,0133,0134,0134,
0134,0134,0135,0135,0135,0135,0136,0136,0136,0136,0137,0137,0137,0137,0140,
0140,0141,0141,0142,0142,0143,0143,0144,0144,0145,0145,0146,0146,0147,0147,
0150,0150,0150,0151,0151,0152,0152,0153,0153,0154,0154,0155,0155,0156,0156,
0157,0157,0160,0161,0162,0163,0164,0165,0166,0167,0170,0171,0172,0173,0174,
0175,0176
};

#ifdef WIN32
void BillGatesAndHisKompilerKiddiesAreBrainDeadAndDestroyingOurIndustry(void)
{
	s2u[0]++;
}
#endif
