/* $Id: idedata.h,v 1.2 2003/12/19 21:57:27 root Exp $
 *
 * IDE extended IOCTL commands. Derived from:
 *
 *      1. IDEINFO.C, DANIS506 v 1.20 by Daniela Engert.
 *      2. IDE.PAS, HDDSPEED v 2.00 by Mikhail Radchenko.
 */

#ifndef IDEDATA_INCLUDED
#define IDEDATA_INCLUDED

#define INCL_BASE
#include <os2.h>

#pragma pack(1)

#define DSKSP_CAT_SMART             0x80  /* SMART IOCTL category */

#define DSKSP_SMART_ONOFF	    0x20  /* turn SMART on or off */
#define DSKSP_SMART_AUTOSAVE_ONOFF  0x21  /* turn SMART autosave on or off */
#define DSKSP_SMART_SAVE	    0x22  /* force save of SMART data */
#define DSKSP_SMART_GETSTATUS	    0x23  /* get SMART status (pass/fail) */
#define DSKSP_SMART_GET_ATTRIBUTES  0x24  /* get SMART attributes table */
#define DSKSP_SMART_GET_THRESHOLDS  0x25  /* get SMART thresholds table */

#define SMART_CMD_ON	  1		  /* on value for related SMART functions */
#define SMART_CMD_OFF	  0		  /* off value for related SMART functions */

#define DSKSP_CAT_GENERIC	    0x90  /* generic IOCTL category */
#define DSKSP_GEN_GET_COUNTERS	    0x40  /* get general counter values table */
#define DSKSP_GET_UNIT_INFORMATION  0x41  /* get unit configuration and BM DMA c*/
#define DSKSP_GET_INQUIRY_DATA	    0x42  /* get ATA/ATAPI inquiry data */

typedef struct _DSKSP_CommandParameters {
 BYTE byPhysicalUnit;		   /* physical unit number 0-n */
				   /* 0 = Pri/Mas, 1=Pri/Sla, 2=Sec/Mas,*/
} DSKSP_CommandParameters, *PDSKSP_CommandParameters;

/*
 * Parameters for SMART and generic commands
 */

/*
 * SMART Attribute table item
 */

typedef struct _S_Attribute
{
  BYTE	      byAttribID;		  /* attribute ID number */
  USHORT      wFlags;			  /* flags */
  BYTE        byValue;                    /* attribute value */
  BYTE        byWorst;                    /* worst value -- HDDSPEED */
  BYTE        byRaw[6];                   /* raw value -- HDDSPEED */
  BYTE        byReserved;                 /* vendor specific data */
} S_Attribute;

/*
 * SMART Attribute table structure
 */

typedef struct _DeviceAttributesData
{
  USHORT      wRevisionNumber;		  /* revision number of attribute table */
  S_Attribute Attribute[30];		  /* attribute table */
  BYTE	      byReserved[6];		  /* reserved bytes */
  USHORT      wSMART_Capability;	  /* capabilities word */
  BYTE	      byReserved2[16];		  /* reserved bytes */
  BYTE	      byVendorSpecific[125];	  /* vendor specific data */
  BYTE	      byCheckSum;		  /* checksum of data in this structure */
} DeviceAttributesData, NEAR *NPDeviceAttributesData, FAR *PDeviceAttributesData;

/*
 * SMART Device Threshold table item
 */

typedef struct _S_Threshold
{
  BYTE	      byAttributeID;		  /* attribute ID number */
  BYTE	      byValue;			  /* threshold value */
  BYTE	      byReserved[10];		  /* reserved bytes */
} S_Threshold;

/*
 * SMART Device Threshold table
 */

typedef struct _DeviceThresholdsData
{
  USHORT      wRevisionNumber;		  /* table revision number */
  S_Threshold Threshold[30];		  /* threshold table */
  BYTE	      byReserved[18];		  /* reserved bytes */
  BYTE	      VendorSpecific[131];	  /* vendor specific data */
  BYTE	      byCheckSum;		  /* checksum of data in this structure */
} DeviceThresholdsData, NEAR *NPDeviceThresholdsData, FAR *PDeviceThresholdsData;

/*
 * Unit Configuration and Counters
 */

typedef struct _UnitInformationData
{
  USHORT	wRevisionNumber;	    /* structure revision number */
  USHORT	wTaskFileBase;		    /* task file register base addr */
  USHORT	wAlternateStatusAddress;    /* alternate status register addr */
  USHORT	wIRQ;			    /* interrupt request level */
  USHORT	wFlags; 		    /* flags */
  BYTE	      byPIO_Mode;		  /* PIO transfer mode programmed */
  BYTE	      byDMA_Mode;		  /* DMA transfer mode programmed */

} UnitInformationData, *PUnitInformationData;

/*
 * Unit Information Flags Definitions
 */

#define UIF_VALID	    0x8000	  /* unit information valid */
#define UIF_TIMINGS_VALID   0x4000	  /* timing information valid */
#define UIF_RUNNING_BMDMA   0x2000	  /* running Bus Master DMA on unit */
#define UIF_RUNNING_DMA     0x1000	  /* running slave DMA on unit */
#define UIF_SLAVE	    0x0002	  /* slave on channel */
#define UIF_ATAPI	    0x0001	  /* ATAPI device if 1, ATA otherwise */

typedef struct _DeviceCountersData
{
  USHORT      wRevisionNumber;		  /* counter structure revision */
  ULONG       TotalReadOperations;	  /* total read operations performed */
  ULONG       TotalWriteOperations;	  /* total write operations performed */
  ULONG       TotalWriteErrors; 	  /* total write errors encountered */
  ULONG       TotalReadErrors;		  /* total read errors encountered */
  ULONG       TotalSeekErrors;		  /* total seek errors encountered */
  ULONG       TotalSectorsRead; 	  /* total number of sectors read */
  ULONG       TotalSectorsWritten;	  /* total number of sectors written */

  ULONG       TotalBMReadOperations;	  /* [003] total bus master DMA read operations */
  ULONG       TotalBMWriteOperations;	  /* [003] total bus master DMA write operations */
  ULONG       ByteMisalignedBuffers;	  /* [003] total buffers on odd byte boundary */
  ULONG       TransfersAcross64K;	  /* [003] total buffers crossing a 64K page boundary */
  ULONG       Reserved[4];		  /* [003] */
} DeviceCountersData, *PDeviceCountersData;

/* Identify Data */

typedef struct _IDENTIFYDATA  *PIDENTIFYDATA;

typedef struct _IDENTIFYDATA
{
  USHORT	GeneralConfig;		/*  0 General configuration bits      */
  USHORT	TotalCylinders; 	/*  1 Default Translation - Num cyl   */
  USHORT	Reserved;		/*  2 Reserved			      */
  USHORT	NumHeads;		/*  3			  - Num heads */
  USHORT	NumUnformattedbpt;	/*  4 Unformatted Bytes   - Per track */
  USHORT	NumUnformattedbps;	/*  5			  - Per sector*/
  USHORT	SectorsPerTrack;	/*  6 Default Translation - Sec/Trk   */
  USHORT	NumBytesISG;		/*  7 Byte Len - inter-sector gap     */
  USHORT	NumBytesSync;		/*  8	       - sync field	      */
  USHORT	NumWordsVUS;		/*  9 Len - Vendor Unique Info	      */
  CHAR		SerialNum[20];		/* 10 Serial number		      */
  USHORT	CtrlType;		/* 20 Controller Type		      */
  USHORT	CtrlBufferSize; 	/* 21 Ctrl buffer size - Sectors      */
  USHORT	NumECCBytes;		/* 21 ECC bytes -  read/write long    */
  CHAR		FirmwareRN[8];		/* 23 Firmware Revision 	      */
  CHAR		ModelNum[40];		/* 27 Model number		      */
  USHORT	NumSectorsPerInt;	/* 47 Multiple Mode - Sec/Blk	      */
  USHORT	DoubleWordIO;		/* 48 [001] Double Word IO Flag       */
  USHORT	IDECapabilities;	/* 49 [001] Capability Flags Word     */
  USHORT	Reserved2;		/* 50 [001]			      */
  USHORT	PIOCycleTime;		/* 51 Transfer Cycle Timing - PIO     */
  USHORT	DMACycleTime;		/* 52			    - DMA     */
  USHORT	AdditionalWordsValid;	/* 53 [002] Additional Words valid    */
  USHORT	LogNumCyl;		/* 54 Current Translation - Num Cyl   */
  USHORT	LogNumHeads;		/* 55			    Num Heads */
  USHORT	LogSectorsPerTrack;	/* 56			    Sec/Trk   */
  ULONG 	LogTotalSectors;	/* 57			    Total Sec */
  USHORT	LogNumSectorsPerInt;	/* 59				      */
  ULONG 	LBATotalSectors;	/* 60 LBA Mode - Sectors	      */
  USHORT	DMASWordFlags;		/* 62				      */
  USHORT	DMAMWordFlags;		/* 63				      */
  USHORT	AdvancedPIOModes;	/* 64 [002] Advanced PIO modes supported */
  USHORT	MinMWDMACycleTime;	/* 65 [002] Minimum multiWord DMA cycle time */
  USHORT	RecMWDMACycleTime;	/* 66 [002] Recommended MW DMA cycle time */
  USHORT	MinPIOCycleTimeWOFC;	/* 67 [002] Minimum PIO cycle time without IORDY */
  USHORT	MinPIOCycleTime;	/* 68 [002] Minimum PIO cycle time    */
  USHORT	Reserved3[82-69];	/* 69			 @V179942 @DANI1    */
  USHORT	CommandSetSupported[3]; /* 82			 @DANI1*/
  USHORT	CommandSetEnabled[3];	/* 85			 @DANI1*/
  USHORT	UltraDMAModes;		/* 88 Ultra DMA Modes	 @V179942     */
  USHORT	Reserved4[93-89];	/* 89			 @V179942     *//*@DANI12*/
  USHORT	HardwareTestResult;	/* 93 hardware test result    @DANI12 */
  USHORT	Reserved5[127-94];	/* 94			 @DANI12      */
  USHORT	MediaStatusWord;	/* 127 media status Word @V151345 SRD */
  USHORT	Reserved6[256-128];	/*			 @V151345     *//*@DANI12*/
}IDENTIFYDATA;

#endif
