/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

class MergeBaseGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int IN_PENDING = 2;
    private static final int POPPED = 16;
    private static final int MERGE_BASE = 8;
    private final RevWalk walker;
    private final DateRevQueue pending;
    private int branchMask;
    private int recarryTest;
    private int recarryMask;

    MergeBaseGenerator(RevWalk w) {
        this.walker = w;
        this.pending = new DateRevQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(AbstractRevQueue p) {
        try {
            RevCommit c;
            while ((c = p.next()) != null) {
                this.add(c);
            }
        }
        finally {
            this.walker.freeFlag(this.branchMask);
            this.recarryTest = this.branchMask | 0x10;
            this.recarryMask = this.branchMask | 0x10 | 8;
        }
    }

    private void add(RevCommit c) {
        int flag = this.walker.allocFlag();
        this.branchMask |= flag;
        if ((c.flags & this.branchMask) != 0) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().staleRevFlagsOn, c.name()));
        }
        c.flags |= flag;
        this.pending.add(c);
    }

    int outputType() {
        return 0;
    }

    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (true) {
            boolean mb;
            if ((c = this.pending.next()) == null) {
                this.walker.reader.walkAdviceEnd();
                return null;
            }
            for (RevCommit p : c.parents) {
                if ((p.flags & 2) != 0) continue;
                if ((p.flags & 1) == 0) {
                    p.parseHeaders(this.walker);
                }
                p.flags |= 2;
                this.pending.add(p);
            }
            int carry = c.flags & this.branchMask;
            boolean bl = mb = carry == this.branchMask;
            if (mb) {
                carry |= 8;
            }
            this.carryOntoHistory(c, carry);
            if ((c.flags & 8) != 0) {
                if (!this.pending.everbodyHasFlag(8)) continue;
                return null;
            }
            c.flags |= 0x10;
            if (mb) break;
        }
        c.flags |= 8;
        return c;
    }

    private void carryOntoHistory(RevCommit c, int carry) {
        RevCommit[] pList;
        do {
            if ((pList = c.parents) == null) {
                return;
            }
            int n = pList.length;
            if (n == 0) {
                return;
            }
            for (int i = 1; i < n; ++i) {
                RevCommit p = pList[i];
                if (this.carryOntoOne(p, carry)) continue;
                this.carryOntoHistory(p, carry);
            }
        } while (!this.carryOntoOne(c = pList[0], carry));
    }

    private boolean carryOntoOne(RevCommit p, int carry) {
        boolean haveAll = (p.flags & carry) == carry;
        p.flags |= carry;
        if ((p.flags & this.recarryMask) == this.recarryTest) {
            p.flags &= 0xFFFFFFEF;
            this.pending.add(p);
            this.carryOntoHistory(p, this.branchMask | 8);
            return true;
        }
        return haveAll;
    }
}

