/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.diff.ContentSource;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.QuotedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffFormatter {
    private static final int DEFAULT_BINARY_FILE_THRESHOLD = 0x3200000;
    private static final byte[] noNewLine = Constants.encodeASCII("\\ No newline at end of file\n");
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] BINARY = new byte[0];
    private final OutputStream out;
    private Repository db;
    private ObjectReader reader;
    private int context = 3;
    private int abbreviationLength = 7;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator comparator = RawTextComparator.DEFAULT;
    private int binaryFileThreshold = 0x3200000;
    private String oldPrefix = "a/";
    private String newPrefix = "b/";
    private TreeFilter pathFilter = TreeFilter.ALL;
    private RenameDetector renameDetector;
    private ProgressMonitor progressMonitor;
    private ContentSource.Pair source;

    public DiffFormatter(OutputStream out) {
        this.out = out;
    }

    protected OutputStream getOutputStream() {
        return this.out;
    }

    public void setRepository(Repository repository) {
        if (this.reader != null) {
            this.reader.release();
        }
        this.db = repository;
        this.reader = this.db.newObjectReader();
        ContentSource cs = ContentSource.create(this.reader);
        this.source = new ContentSource.Pair(cs, cs);
        DiffConfig dc = this.db.getConfig().get(DiffConfig.KEY);
        if (dc.isNoPrefix()) {
            this.setOldPrefix("");
            this.setNewPrefix("");
        }
        this.setDetectRenames(dc.isRenameDetectionEnabled());
        this.diffAlgorithm = DiffAlgorithm.getAlgorithm(this.db.getConfig().getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM));
    }

    public void setContext(int lineCount) {
        if (lineCount < 0) {
            throw new IllegalArgumentException(JGitText.get().contextMustBeNonNegative);
        }
        this.context = lineCount;
    }

    public void setAbbreviationLength(int count) {
        if (count < 0) {
            throw new IllegalArgumentException(JGitText.get().abbreviationLengthMustBeNonNegative);
        }
        this.abbreviationLength = count;
    }

    public void setDiffAlgorithm(DiffAlgorithm alg) {
        this.diffAlgorithm = alg;
    }

    public void setDiffComparator(RawTextComparator cmp) {
        this.comparator = cmp;
    }

    public void setBinaryFileThreshold(int threshold) {
        this.binaryFileThreshold = threshold;
    }

    public void setOldPrefix(String prefix) {
        this.oldPrefix = prefix;
    }

    public void setNewPrefix(String prefix) {
        this.newPrefix = prefix;
    }

    public boolean isDetectRenames() {
        return this.renameDetector != null;
    }

    public void setDetectRenames(boolean on) {
        if (on && this.renameDetector == null) {
            this.assertHaveRepository();
            this.renameDetector = new RenameDetector(this.db);
        } else if (!on) {
            this.renameDetector = null;
        }
    }

    public RenameDetector getRenameDetector() {
        return this.renameDetector;
    }

    public void setProgressMonitor(ProgressMonitor pm) {
        this.progressMonitor = pm;
    }

    public void setPathFilter(TreeFilter filter) {
        this.pathFilter = filter != null ? filter : TreeFilter.ALL;
    }

    public TreeFilter getPathFilter() {
        return this.pathFilter;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void release() {
        if (this.reader != null) {
            this.reader.release();
        }
    }

    public List<DiffEntry> scan(AnyObjectId a, AnyObjectId b) throws IOException {
        this.assertHaveRepository();
        RevWalk rw = new RevWalk(this.reader);
        return this.scan(rw.parseTree(a), rw.parseTree(b));
    }

    public List<DiffEntry> scan(RevTree a, RevTree b) throws IOException {
        this.assertHaveRepository();
        CanonicalTreeParser aParser = new CanonicalTreeParser();
        CanonicalTreeParser bParser = new CanonicalTreeParser();
        aParser.reset(this.reader, a);
        bParser.reset(this.reader, b);
        return this.scan(aParser, bParser);
    }

    public List<DiffEntry> scan(AbstractTreeIterator a, AbstractTreeIterator b) throws IOException {
        this.assertHaveRepository();
        TreeWalk walk = new TreeWalk(this.reader);
        walk.addTree(a);
        walk.addTree(b);
        walk.setRecursive(true);
        TreeFilter filter = DiffFormatter.getDiffTreeFilterFor(a, b);
        if (this.pathFilter instanceof FollowFilter) {
            walk.setFilter(AndTreeFilter.create(PathFilter.create(((FollowFilter)this.pathFilter).getPath()), filter));
        } else {
            walk.setFilter(AndTreeFilter.create(this.pathFilter, filter));
        }
        this.source = new ContentSource.Pair(this.source(a), this.source(b));
        List<DiffEntry> files = DiffEntry.scan(walk);
        if (this.pathFilter instanceof FollowFilter && this.isAdd(files)) {
            a.reset();
            b.reset();
            walk.reset();
            walk.addTree(a);
            walk.addTree(b);
            walk.setFilter(filter);
            if (this.renameDetector == null) {
                this.setDetectRenames(true);
            }
            files = this.updateFollowFilter(this.detectRenames(DiffEntry.scan(walk)));
        } else if (this.renameDetector != null) {
            files = this.detectRenames(files);
        }
        return files;
    }

    private static TreeFilter getDiffTreeFilterFor(AbstractTreeIterator a, AbstractTreeIterator b) {
        if (a instanceof DirCacheIterator && b instanceof WorkingTreeIterator) {
            return new IndexDiffFilter(0, 1);
        }
        if (a instanceof WorkingTreeIterator && b instanceof DirCacheIterator) {
            return new IndexDiffFilter(1, 0);
        }
        TreeFilter filter = TreeFilter.ANY_DIFF;
        if (a instanceof WorkingTreeIterator) {
            filter = AndTreeFilter.create(new NotIgnoredFilter(0), filter);
        }
        if (b instanceof WorkingTreeIterator) {
            filter = AndTreeFilter.create(new NotIgnoredFilter(1), filter);
        }
        return filter;
    }

    private ContentSource source(AbstractTreeIterator iterator) {
        if (iterator instanceof WorkingTreeIterator) {
            return ContentSource.create((WorkingTreeIterator)iterator);
        }
        return ContentSource.create(this.reader);
    }

    private List<DiffEntry> detectRenames(List<DiffEntry> files) throws IOException {
        this.renameDetector.reset();
        this.renameDetector.addAll(files);
        return this.renameDetector.compute(this.reader, this.progressMonitor);
    }

    private boolean isAdd(List<DiffEntry> files) {
        String oldPath = ((FollowFilter)this.pathFilter).getPath();
        for (DiffEntry ent : files) {
            if (ent.getChangeType() != DiffEntry.ChangeType.ADD || !ent.getNewPath().equals(oldPath)) continue;
            return true;
        }
        return false;
    }

    private List<DiffEntry> updateFollowFilter(List<DiffEntry> files) {
        String oldPath = ((FollowFilter)this.pathFilter).getPath();
        for (DiffEntry ent : files) {
            if (!DiffFormatter.isRename(ent) || !ent.getNewPath().equals(oldPath)) continue;
            this.pathFilter = FollowFilter.create(ent.getOldPath());
            return Collections.singletonList(ent);
        }
        return Collections.emptyList();
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }

    public void format(AnyObjectId a, AnyObjectId b) throws IOException {
        this.format(this.scan(a, b));
    }

    public void format(RevTree a, RevTree b) throws IOException {
        this.format(this.scan(a, b));
    }

    public void format(AbstractTreeIterator a, AbstractTreeIterator b) throws IOException {
        this.format(this.scan(a, b));
    }

    public void format(List<? extends DiffEntry> entries) throws IOException {
        for (DiffEntry diffEntry : entries) {
            this.format(diffEntry);
        }
    }

    public void format(DiffEntry ent) throws IOException {
        FormatResult res = this.createFormatResult(ent);
        this.format(res.header, res.a, res.b);
    }

    private void writeGitLinkDiffText(OutputStream o, DiffEntry ent) throws IOException {
        if (ent.getOldMode() == FileMode.GITLINK) {
            o.write(Constants.encodeASCII("-Subproject commit " + ent.getOldId().name() + "\n"));
        }
        if (ent.getNewMode() == FileMode.GITLINK) {
            o.write(Constants.encodeASCII("+Subproject commit " + ent.getNewId().name() + "\n"));
        }
    }

    private String format(AbbreviatedObjectId id) {
        if (id.isComplete() && this.db != null) {
            try {
                id = this.reader.abbreviate(id.toObjectId(), this.abbreviationLength);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return id.name();
    }

    private static String quotePath(String name) {
        return QuotedString.GIT_PATH.quote(name);
    }

    public void format(FileHeader head, RawText a, RawText b) throws IOException {
        int start = head.getStartOffset();
        int end = head.getEndOffset();
        if (!head.getHunks().isEmpty()) {
            end = head.getHunks().get(0).getStartOffset();
        }
        this.out.write(head.getBuffer(), start, end - start);
        if (head.getPatchType() == FileHeader.PatchType.UNIFIED) {
            this.format(head.toEditList(), a, b);
        }
    }

    public void format(EditList edits, RawText a, RawText b) throws IOException {
        int curIdx = 0;
        while (curIdx < edits.size()) {
            Edit curEdit = (Edit)edits.get(curIdx);
            int endIdx = this.findCombinedEnd(edits, curIdx);
            Edit endEdit = (Edit)edits.get(endIdx);
            int aCur = Math.max(0, curEdit.getBeginA() - this.context);
            int bCur = Math.max(0, curEdit.getBeginB() - this.context);
            int aEnd = Math.min(a.size(), endEdit.getEndA() + this.context);
            int bEnd = Math.min(b.size(), endEdit.getEndB() + this.context);
            this.writeHunkHeader(aCur, aEnd, bCur, bEnd);
            while (aCur < aEnd || bCur < bEnd) {
                if (aCur < curEdit.getBeginA() || endIdx + 1 < curIdx) {
                    this.writeContextLine(a, aCur);
                    if (this.isEndOfLineMissing(a, aCur)) {
                        this.out.write(noNewLine);
                    }
                    ++aCur;
                    ++bCur;
                } else if (aCur < curEdit.getEndA()) {
                    this.writeRemovedLine(a, aCur);
                    if (this.isEndOfLineMissing(a, aCur)) {
                        this.out.write(noNewLine);
                    }
                    ++aCur;
                } else if (bCur < curEdit.getEndB()) {
                    this.writeAddedLine(b, bCur);
                    if (this.isEndOfLineMissing(b, bCur)) {
                        this.out.write(noNewLine);
                    }
                    ++bCur;
                }
                if (!DiffFormatter.end(curEdit, aCur, bCur) || ++curIdx >= edits.size()) continue;
                curEdit = (Edit)edits.get(curIdx);
            }
        }
    }

    protected void writeContextLine(RawText text, int line) throws IOException {
        this.writeLine(' ', text, line);
    }

    private boolean isEndOfLineMissing(RawText text, int line) {
        return line + 1 == text.size() && text.isMissingNewlineAtEnd();
    }

    protected void writeAddedLine(RawText text, int line) throws IOException {
        this.writeLine('+', text, line);
    }

    protected void writeRemovedLine(RawText text, int line) throws IOException {
        this.writeLine('-', text, line);
    }

    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        this.out.write(64);
        this.out.write(64);
        this.writeRange('-', aStartLine + 1, aEndLine - aStartLine);
        this.writeRange('+', bStartLine + 1, bEndLine - bStartLine);
        this.out.write(32);
        this.out.write(64);
        this.out.write(64);
        this.out.write(10);
    }

    private void writeRange(char prefix, int begin, int cnt) throws IOException {
        this.out.write(32);
        this.out.write(prefix);
        switch (cnt) {
            case 0: {
                this.out.write(Constants.encodeASCII(begin - 1));
                this.out.write(44);
                this.out.write(48);
                break;
            }
            case 1: {
                this.out.write(Constants.encodeASCII(begin));
                break;
            }
            default: {
                this.out.write(Constants.encodeASCII(begin));
                this.out.write(44);
                this.out.write(Constants.encodeASCII(cnt));
            }
        }
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        this.out.write(prefix);
        text.writeLine(this.out, cur);
        this.out.write(10);
    }

    public FileHeader toFileHeader(DiffEntry ent) throws IOException, CorruptObjectException, MissingObjectException {
        return this.createFormatResult((DiffEntry)ent).header;
    }

    private FormatResult createFormatResult(DiffEntry ent) throws IOException, CorruptObjectException, MissingObjectException {
        FileHeader.PatchType type;
        EditList editList;
        FormatResult res = new FormatResult();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.formatHeader(buf, ent);
        if (ent.getOldMode() == FileMode.GITLINK || ent.getNewMode() == FileMode.GITLINK) {
            this.formatOldNewPaths(buf, ent);
            this.writeGitLinkDiffText(buf, ent);
            editList = new EditList();
            type = FileHeader.PatchType.UNIFIED;
        } else {
            this.assertHaveRepository();
            byte[] aRaw = this.open(DiffEntry.Side.OLD, ent);
            byte[] bRaw = this.open(DiffEntry.Side.NEW, ent);
            if (aRaw == BINARY || bRaw == BINARY || RawText.isBinary(aRaw) || RawText.isBinary(bRaw)) {
                this.formatOldNewPaths(buf, ent);
                buf.write(Constants.encodeASCII("Binary files differ\n"));
                editList = new EditList();
                type = FileHeader.PatchType.BINARY;
            } else {
                res.a = new RawText(aRaw);
                res.b = new RawText(bRaw);
                editList = this.diff(res.a, res.b);
                type = FileHeader.PatchType.UNIFIED;
                switch (ent.getChangeType()) {
                    case RENAME: 
                    case COPY: {
                        if (editList.isEmpty()) break;
                        this.formatOldNewPaths(buf, ent);
                        break;
                    }
                    default: {
                        this.formatOldNewPaths(buf, ent);
                    }
                }
            }
        }
        res.header = new FileHeader(buf.toByteArray(), editList, type);
        return res;
    }

    private EditList diff(RawText a, RawText b) {
        return this.diffAlgorithm.diff(this.comparator, a, b);
    }

    private void assertHaveRepository() {
        if (this.db == null) {
            throw new IllegalStateException(JGitText.get().repositoryIsRequired);
        }
    }

    private byte[] open(DiffEntry.Side side, DiffEntry entry) throws IOException {
        if (entry.getMode(side) == FileMode.MISSING) {
            return EMPTY;
        }
        if (entry.getMode(side).getObjectType() != 3) {
            return EMPTY;
        }
        if (this.isBinary(entry.getPath(side))) {
            return BINARY;
        }
        AbbreviatedObjectId id = entry.getId(side);
        if (!id.isComplete()) {
            Collection<ObjectId> ids = this.reader.resolve(id);
            if (ids.size() == 1) {
                id = AbbreviatedObjectId.fromObjectId(ids.iterator().next());
                switch (side) {
                    case OLD: {
                        entry.oldId = id;
                        break;
                    }
                    case NEW: {
                        entry.newId = id;
                    }
                }
            } else {
                if (ids.size() == 0) {
                    throw new MissingObjectException(id, 3);
                }
                throw new AmbiguousObjectException(id, ids);
            }
        }
        try {
            ObjectLoader ldr = this.source.open(side, entry);
            return ldr.getBytes(this.binaryFileThreshold);
        }
        catch (LargeObjectException.ExceedsLimit overLimit) {
            return BINARY;
        }
        catch (LargeObjectException.ExceedsByteArrayLimit overLimit) {
            return BINARY;
        }
        catch (LargeObjectException.OutOfMemory tooBig) {
            return BINARY;
        }
        catch (LargeObjectException tooBig) {
            tooBig.setObjectId(id.toObjectId());
            throw tooBig;
        }
    }

    private boolean isBinary(String path) {
        return false;
    }

    private void formatHeader(ByteArrayOutputStream o, DiffEntry ent) throws IOException {
        DiffEntry.ChangeType type = ent.getChangeType();
        String oldp = ent.getOldPath();
        String newp = ent.getNewPath();
        FileMode oldMode = ent.getOldMode();
        FileMode newMode = ent.getNewMode();
        o.write(Constants.encodeASCII("diff --git "));
        o.write(Constants.encode(DiffFormatter.quotePath(this.oldPrefix + (type == DiffEntry.ChangeType.ADD ? newp : oldp))));
        o.write(32);
        o.write(Constants.encode(DiffFormatter.quotePath(this.newPrefix + (type == DiffEntry.ChangeType.DELETE ? oldp : newp))));
        o.write(10);
        switch (type) {
            case ADD: {
                o.write(Constants.encodeASCII("new file mode "));
                newMode.copyTo(o);
                o.write(10);
                break;
            }
            case DELETE: {
                o.write(Constants.encodeASCII("deleted file mode "));
                oldMode.copyTo(o);
                o.write(10);
                break;
            }
            case RENAME: {
                o.write(Constants.encodeASCII("similarity index " + ent.getScore() + "%"));
                o.write(10);
                o.write(Constants.encode("rename from " + DiffFormatter.quotePath(oldp)));
                o.write(10);
                o.write(Constants.encode("rename to " + DiffFormatter.quotePath(newp)));
                o.write(10);
                break;
            }
            case COPY: {
                o.write(Constants.encodeASCII("similarity index " + ent.getScore() + "%"));
                o.write(10);
                o.write(Constants.encode("copy from " + DiffFormatter.quotePath(oldp)));
                o.write(10);
                o.write(Constants.encode("copy to " + DiffFormatter.quotePath(newp)));
                o.write(10);
                if (oldMode.equals(newMode)) break;
                o.write(Constants.encodeASCII("new file mode "));
                newMode.copyTo(o);
                o.write(10);
                break;
            }
            case MODIFY: {
                if (0 >= ent.getScore()) break;
                o.write(Constants.encodeASCII("dissimilarity index " + (100 - ent.getScore()) + "%"));
                o.write(10);
            }
        }
        if (!(type != DiffEntry.ChangeType.MODIFY && type != DiffEntry.ChangeType.RENAME || oldMode.equals(newMode))) {
            o.write(Constants.encodeASCII("old mode "));
            oldMode.copyTo(o);
            o.write(10);
            o.write(Constants.encodeASCII("new mode "));
            newMode.copyTo(o);
            o.write(10);
        }
        if (!ent.getOldId().equals(ent.getNewId())) {
            this.formatIndexLine(o, ent);
        }
    }

    protected void formatIndexLine(OutputStream o, DiffEntry ent) throws IOException {
        o.write(Constants.encodeASCII("index " + this.format(ent.getOldId()) + ".." + this.format(ent.getNewId())));
        if (ent.getOldMode().equals(ent.getNewMode())) {
            o.write(32);
            ent.getNewMode().copyTo(o);
        }
        o.write(10);
    }

    private void formatOldNewPaths(ByteArrayOutputStream o, DiffEntry ent) throws IOException {
        String newp;
        String oldp;
        switch (ent.getChangeType()) {
            case ADD: {
                oldp = "/dev/null";
                newp = DiffFormatter.quotePath(this.newPrefix + ent.getNewPath());
                break;
            }
            case DELETE: {
                oldp = DiffFormatter.quotePath(this.oldPrefix + ent.getOldPath());
                newp = "/dev/null";
                break;
            }
            default: {
                oldp = DiffFormatter.quotePath(this.oldPrefix + ent.getOldPath());
                newp = DiffFormatter.quotePath(this.newPrefix + ent.getNewPath());
            }
        }
        o.write(Constants.encode("--- " + oldp + "\n"));
        o.write(Constants.encode("+++ " + newp + "\n"));
    }

    private int findCombinedEnd(List<Edit> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.combineA(edits, end) || this.combineB(edits, end)); ++end) {
        }
        return end - 1;
    }

    private boolean combineA(List<Edit> e, int i) {
        return e.get(i).getBeginA() - e.get(i - 1).getEndA() <= 2 * this.context;
    }

    private boolean combineB(List<Edit> e, int i) {
        return e.get(i).getBeginB() - e.get(i - 1).getEndB() <= 2 * this.context;
    }

    private static boolean end(Edit edit, int a, int b) {
        return edit.getEndA() <= a && edit.getEndB() <= b;
    }

    private static class FormatResult {
        FileHeader header;
        RawText a;
        RawText b;

        private FormatResult() {
        }
    }
}

