/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNChecksumInputStream
extends DigestInputStream {
    public static final String MD5_ALGORITHM = "MD5";
    private static byte[] ourDirtyBuffer = new byte[16384];

    public SVNChecksumInputStream(InputStream source, String algorithm) {
        super(source, null);
        algorithm = algorithm == null ? MD5_ALGORITHM : algorithm;
        try {
            this.setMessageDigest(MessageDigest.getInstance(algorithm));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        this.on(this.getMessageDigest() != null);
    }

    public void close() throws IOException {
        int r = 0;
        while ((r = this.read(ourDirtyBuffer)) >= 0) {
        }
        super.close();
    }

    public String getDigest() {
        return this.getMessageDigest() != null ? SVNFileUtil.toHexDigest(this.getMessageDigest().digest()) : null;
    }
}

