/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.svnversion.SVNVersionCommandEnvironment;
import org.tmatesoft.svn.cli.svnversion.SVNVersionOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public class SVNVersionCommand
extends AbstractSVNCommand {
    public SVNVersionCommand() {
        super("", null);
    }

    protected Collection createSupportedOptions() {
        ArrayList<SVNVersionOption> options = new ArrayList<SVNVersionOption>();
        options.add(SVNVersionOption.NO_NEWLINE);
        options.add(SVNVersionOption.COMMITTED);
        options.add(SVNVersionOption.HELP);
        options.add(SVNVersionOption.VERSION);
        return options;
    }

    protected SVNVersionCommandEnvironment getSVNVersionEnvironment() {
        return (SVNVersionCommandEnvironment)this.getEnvironment();
    }

    protected String getResourceBundleName() {
        return "org.tmatesoft.svn.cli.svnversion.commands";
    }

    public void run() throws SVNException {
        String id;
        SVNPath target;
        List targets = this.getEnvironment().combineTargets(null, false);
        if (targets.isEmpty()) {
            targets.add("");
        }
        if ((target = new SVNPath((String)targets.get(0))).isURL()) {
            target = new SVNPath("");
            targets.add(0, "");
        }
        String trailURL = targets.size() > 1 ? targets.get(1) : null;
        if (target.isFile() && (id = SVNClientManager.newInstance().getWCClient().doGetWorkingCopyID(target.getFile(), trailURL, this.getSVNVersionEnvironment().isCommitted())) != null) {
            this.getEnvironment().getOut().print(id);
            if (!this.getSVNVersionEnvironment().isNoNewLine()) {
                this.getEnvironment().getOut().println();
            }
        }
    }

    public Collection getGlobalOptions() {
        return Collections.EMPTY_LIST;
    }
}

