/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedList<E>
implements List<E> {
    private Comparator<E> comparator;
    private List<E> delegate;

    public SortedList(List<E> delegate, Comparator comparator) {
        this.delegate = delegate;
        this.comparator = comparator;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public boolean add(E o) {
        int size = this.delegate.size();
        for (int i = 0; i < size; ++i) {
            if (this.comparator.compare(this.delegate.get(i), o) <= 0) continue;
            this.delegate.add(i, o);
            return true;
        }
        this.delegate.add(o);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this.delegate.set(index, element);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public Object[] toArray(Object[] a2) {
        return this.delegate.toArray(a2);
    }

    public static void main(String[] args) {
        SortedList<String> sortedList = new SortedList<String>(new ArrayList(), new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        sortedList.add("test");
        sortedList.add("aaa");
        sortedList.add("ddd");
        sortedList.add("ccc");
        for (String s : sortedList) {
            System.out.println(s);
        }
    }
}

