/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedNumericRange
extends AbstractNumericRange<Double> {
    private final Object monitor = new Object();
    private List<Range<Double>> _ranges = new ArrayList<Range<Double>>();
    private Double _max = null;
    private Double _min = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedNumericRange add(Range<Double> range) {
        if (range == null) {
            return this;
        }
        Object object = this.monitor;
        synchronized (object) {
            this._ranges.add(range);
            this._min = null;
            this._max = null;
        }
        return this;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    @Override
    public void adjust(Double lower, Double upper) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double maximum() {
        Object object = this.monitor;
        synchronized (object) {
            if (this._max != null) {
                return this._max;
            }
            if (this._ranges == null || this._ranges.size() == 0) {
                return Double.MAX_VALUE;
            }
            this._max = Double.MIN_VALUE;
            for (Range<Double> range : this._ranges) {
                if (range == null || !(range.maximum() > this._max)) continue;
                this._max = range.maximum();
            }
            return this._max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double minimum() {
        Object object = this.monitor;
        synchronized (object) {
            if (this._min != null) {
                return this._min;
            }
            if (this._ranges == null || this._ranges.size() == 0) {
                return Double.MIN_VALUE;
            }
            this._min = Double.MAX_VALUE;
            for (Range<Double> range : this._ranges) {
                if (range == null || !(range.minimum() < this._min)) continue;
                this._min = range.minimum();
            }
            return this._min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Double x) {
        Object object = this.monitor;
        synchronized (object) {
            if (x == null || this._ranges.size() == 0) {
                return false;
            }
            for (Range<Double> range : this._ranges) {
                if (!range.contains(x)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double size() {
        Object object = this.monitor;
        synchronized (object) {
            return this.maximum() - this.minimum();
        }
    }
}

