/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class XertoUtils {
    private static Color BASE_COLOR;
    private static Color CONTROL_COLOR;
    private static Color LIGHT_CONTROL_COLOR;
    private static Color MID_CONTROL_COLOR;
    private static Color CONTROL_VERY_LIGHT_SHADOW_COLOR;
    private static Color CONTROL_LIGHT_SHADOW_COLOR;
    private static Color CONTROL_MID_SHADOW_COLOR;
    private static Color CONTROL_DARK_SHADOW_COLOR;
    private static Color SELECTION_COLOR;
    private static Color INACTIVE_CAPTION_COLOR;
    private static Color SELECTED_TAB_BACKGROUND_COLOR;
    private static Color TAB_FORGROUND_COLOR;
    private static Color FRAME_ACTIVE_TITLE_TOP_COLOR;
    private static Color FRAME_ACTIVE_TITLE_BOTTOM_COLOR;
    private static Color FRAME_INACTIVE_TITLE_TOP_COLOR;
    private static Color FRAME_INACTIVE_TITLE_BOTTOM_COLOR;
    public static final double RATIO1 = 0.67;
    public static final double RATIO2 = 0.78;
    public static final double RATIO3 = 0.86;
    static final Color DARK_GREEN;
    static final Color DARK_MAGENTA;

    public static void updateColors() {
        UIDefaults uiDefaults = UIManager.getDefaults();
        BASE_COLOR = uiDefaults.getColor("activeCaption");
        CONTROL_COLOR = uiDefaults.getColor("control");
        INACTIVE_CAPTION_COLOR = uiDefaults.getColor("inactiveCaption");
        LIGHT_CONTROL_COLOR = uiDefaults.getColor("MenuItem.background");
        float[] oControlHSB = Color.RGBtoHSB(CONTROL_COLOR.getRed(), CONTROL_COLOR.getGreen(), CONTROL_COLOR.getBlue(), null);
        float[] oBaseHSB = Color.RGBtoHSB(BASE_COLOR.getRed(), BASE_COLOR.getGreen(), BASE_COLOR.getBlue(), null);
        MID_CONTROL_COLOR = Color.getHSBColor(oControlHSB[0], Math.max(oControlHSB[1] - 0.05f, 0.0f), oControlHSB[2] < 0.95f ? oControlHSB[2] + 0.05f : 0.98f);
        SELECTED_TAB_BACKGROUND_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], oControlHSB[1] == 0.0f ? 0.75f : 0.85f);
        TAB_FORGROUND_COLOR = Color.getHSBColor(oControlHSB[0], (double)oControlHSB[1] > 0.01 ? 0.45f : oControlHSB[0], 0.2f);
        CONTROL_VERY_LIGHT_SHADOW_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], oControlHSB[2] - 0.02f);
        CONTROL_LIGHT_SHADOW_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], oControlHSB[2] - 0.06f);
        CONTROL_MID_SHADOW_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], oControlHSB[2] - 0.16f);
        CONTROL_DARK_SHADOW_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], oControlHSB[2] - 0.32f);
        SELECTION_COLOR = Color.getHSBColor(oBaseHSB[0], (double)oBaseHSB[1] > 0.01 ? 0.45f : oBaseHSB[0], 0.8f);
        FRAME_ACTIVE_TITLE_TOP_COLOR = Color.getHSBColor(oBaseHSB[0], (double)oBaseHSB[1] > 0.01 ? 0.3f : oBaseHSB[0], 0.9f);
        FRAME_ACTIVE_TITLE_BOTTOM_COLOR = Color.getHSBColor(oBaseHSB[0], (double)oBaseHSB[1] > 0.01 ? 0.45f : oBaseHSB[0], 0.7f);
        FRAME_INACTIVE_TITLE_TOP_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], 0.75f);
        FRAME_INACTIVE_TITLE_BOTTOM_COLOR = Color.getHSBColor(oControlHSB[0], oControlHSB[1], 0.5f);
    }

    public static Color getBaseColor() {
        return BASE_COLOR;
    }

    public static Color getInActiveCaptionColor() {
        return INACTIVE_CAPTION_COLOR;
    }

    public static Color getControlColor() {
        return CONTROL_COLOR;
    }

    public static Color getMidControlColor() {
        return MID_CONTROL_COLOR;
    }

    public static Color getLightControlColor() {
        return LIGHT_CONTROL_COLOR;
    }

    public static Color getSelectedTabBackgroundColor() {
        return SELECTED_TAB_BACKGROUND_COLOR;
    }

    public static Color getTabForgroundColor() {
        return TAB_FORGROUND_COLOR;
    }

    public static Color getControlVeryLightShadowColor() {
        return CONTROL_VERY_LIGHT_SHADOW_COLOR;
    }

    public static Color getControlLightShadowColor() {
        return CONTROL_LIGHT_SHADOW_COLOR;
    }

    public static Color getControlMidShadowColor() {
        return CONTROL_MID_SHADOW_COLOR;
    }

    public static Color getControlDarkShadowColor() {
        return CONTROL_DARK_SHADOW_COLOR;
    }

    public static Color getSelectionColor() {
        return SELECTION_COLOR;
    }

    public static Color getApplicationFrameBackgroundColor() {
        return XertoUtils.getControlColor();
    }

    public static Color getFrameBorderColor() {
        return UIDefaultsLookup.getColor("controlShadow");
    }

    public static Color getFrameActiveTitleTopColor() {
        return FRAME_ACTIVE_TITLE_TOP_COLOR;
    }

    public static Color getFrameActiveTitleBottomColor() {
        return FRAME_ACTIVE_TITLE_BOTTOM_COLOR;
    }

    public static Color getFrameInactiveTitleTopColor() {
        return FRAME_INACTIVE_TITLE_TOP_COLOR;
    }

    public static Color getFrameInactiveTitleBottomColor() {
        return FRAME_INACTIVE_TITLE_BOTTOM_COLOR;
    }

    public static Color getLighterColor(Color backColor) {
        int r = XertoUtils.getLighterColor(backColor.getRed());
        int g = XertoUtils.getLighterColor(backColor.getGreen());
        int b2 = XertoUtils.getLighterColor(backColor.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    public static int getLighterColor(int x) {
        return (int)((double)x * 36.0 / 255.0 + 219.5);
    }

    public static Color getMenuSelectionColor(Color backColor) {
        int r = XertoUtils.getMenuSelectionValue(backColor.getRed());
        int g = XertoUtils.getMenuSelectionValue(backColor.getGreen());
        int b2 = XertoUtils.getMenuSelectionValue(backColor.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    public static int getMenuSelectionValue(int x) {
        return (int)((double)x * 76.0 / 255.0 + 179.5);
    }

    public static Color getMenuBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        int r = XertoUtils.getMenuValue(color.getRed());
        int g = XertoUtils.getMenuValue(color.getGreen());
        int b2 = XertoUtils.getMenuValue(color.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    public static int getMenuValue(int x) {
        return (int)((double)x * 36.0 / 255.0 + 219.5);
    }

    public static Color getToolBarBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        int r = XertoUtils.getToolBarValue(color.getRed());
        int g = XertoUtils.getToolBarValue(color.getGreen());
        int b2 = XertoUtils.getToolBarValue(color.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    public static int getToolBarValue(int x) {
        return x * 215 / 255 + 40;
    }

    public static Color getGripperForegroundColor(Color backColor) {
        int r = XertoUtils.getGripperValue(backColor.getRed());
        int g = XertoUtils.getGripperValue(backColor.getGreen());
        int b2 = XertoUtils.getGripperValue(backColor.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    public static int getGripperValue(int x) {
        if (x == 255) {
            return 0;
        }
        if (x >= 0 && x <= 64) {
            return x * 33 / 64 + 123;
        }
        return (x - 65) * 157 / 189 + 33;
    }

    public static Color getDefaultBackgroundColor(Color backColor) {
        Color backIDE;
        if (backColor.getRed() == 212 && backColor.getGreen() == 208 && backColor.getBlue() == 200) {
            backIDE = new Color(247, 243, 233);
        } else if (backColor.getRed() == 236 && backColor.getGreen() == 233 && backColor.getBlue() == 216) {
            backIDE = new Color(255, 251, 233);
        } else {
            int r = backColor.getRed() + 35;
            int g = backColor.getGreen() + 35;
            int b2 = backColor.getBlue() + 35;
            if (r >= 255) {
                r = 255;
            }
            if (g >= 255) {
                g = 255;
            }
            if (b2 >= 255) {
                b2 = 255;
            }
            backIDE = new Color(r, g, b2);
        }
        return backIDE;
    }

    public static int getLightColor(int x, double ratio) {
        return (int)((double)(255 - x) * ratio + (double)x);
    }

    public static Color getLighterColor(Color color, double ratio) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        int r = XertoUtils.getLightColor(color.getRed(), ratio);
        int g = XertoUtils.getLightColor(color.getGreen(), ratio) + 1;
        int b2 = XertoUtils.getLightColor(color.getBlue(), ratio);
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b2 >= 255) {
            b2 = 255;
        }
        return new Color(r, g, b2);
    }

    public static Color getHighlightColor(Color bottomColor) {
        float[] oHSB = new float[3];
        Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), oHSB);
        oHSB[1] = oHSB[1] - 0.07f;
        if (oHSB[1] < 0.0f) {
            oHSB[1] = 0.0f;
        }
        oHSB[2] = oHSB[2] + 0.04f;
        if (oHSB[2] > 1.0f) {
            oHSB[2] = 1.0f;
        }
        return Color.getHSBColor(oHSB[0], oHSB[1], oHSB[2]);
    }

    public static Color getEmBaseColor(Color bottomColor) {
        float[] oHSB = new float[3];
        Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), oHSB);
        oHSB[1] = oHSB[1] + 0.1f;
        if (oHSB[1] > 1.0f) {
            oHSB[1] = 1.0f;
        }
        oHSB[2] = oHSB[2] - 0.1f;
        if (oHSB[2] < 0.0f) {
            oHSB[2] = 0.0f;
        }
        return Color.getHSBColor(oHSB[0], oHSB[1], oHSB[2]);
    }

    public static Color getTextColor(Color backgroundColor) {
        float[] oHSB = new float[3];
        Color.RGBtoHSB(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), oHSB);
        return (double)oHSB[2] > 0.53 ? UIDefaultsLookup.getColor("controlText") : Color.WHITE;
    }

    public static Color getSelectedAndFocusedButtonColor(Color backColor) {
        return XertoUtils.getLighterColor(backColor, 0.67);
    }

    public static Color getFocusedButtonColor(Color backColor) {
        return XertoUtils.getLighterColor(backColor, 0.78);
    }

    public static Color getSelectedButtonColor(Color backColor) {
        return XertoUtils.getLighterColor(backColor, 0.86);
    }

    static {
        XertoUtils.updateColors();
        DARK_GREEN = new Color(0, 128, 0);
        DARK_MAGENTA = new Color(128, 0, 128);
    }
}

