/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.vsnet.ConvertListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class ExtWindowsDesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WeakPCL pcl;
    private String[] keys;
    private Object[] value;
    private Object[] fallback;
    private ConvertListener listener;
    private Toolkit toolkit;

    private static synchronized void setUpdatePending(boolean update) {
        updatePending = update;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateAllUIs() {
        Frame[] appFrames;
        for (Frame frame : appFrames = Frame.getFrames()) {
            ExtWindowsDesktopProperty.updateWindowUI(frame);
        }
    }

    private static void updateWindowUI(Window window) {
        Window[] ownedWins;
        SwingUtilities.updateComponentTreeUI(window);
        for (Window win : ownedWins = window.getOwnedWindows()) {
            ExtWindowsDesktopProperty.updateWindowUI(win);
        }
    }

    public ExtWindowsDesktopProperty(String[] keys, Object[] fallback, Toolkit toolkit, ConvertListener listener) {
        this.keys = keys;
        this.fallback = fallback;
        this.toolkit = toolkit;
        this.listener = listener;
    }

    public Object createValue(UIDefaults table) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value[0] == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.listener.convert(this.value);
    }

    protected Object[] getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        this.pcl = new WeakPCL(this, this.toolkit);
        Object[] values = new Object[this.getKeys().length];
        for (int i = 0; i < this.getKeys().length; ++i) {
            values[i] = this.toolkit.getDesktopProperty(this.getKeys()[i]);
            this.toolkit.addPropertyChangeListener(this.getKeys()[i], this.pcl);
        }
        return values;
    }

    protected Object[] getDefaultValue() {
        return this.fallback;
    }

    public void invalidate() {
        if (this.pcl != null) {
            for (int i = 0; i < this.getKeys().length; ++i) {
                this.toolkit.removePropertyChangeListener(this.getKeys()[i], this.pcl);
            }
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected void updateUI() {
        if (!ExtWindowsDesktopProperty.isUpdatePending()) {
            ExtWindowsDesktopProperty.setUpdatePending(true);
            Runnable uiUpdater = new Runnable(){

                public void run() {
                    ExtWindowsDesktopProperty.updateAllUIs();
                    ExtWindowsDesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(uiUpdater);
        }
    }

    protected Object[] configureValue(Object[] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                value[i] = this.configureValue(value[i]);
            }
        }
        return value;
    }

    protected Object configureValue(Object value) {
        if (value != null) {
            if (value instanceof Color) {
                return new ColorUIResource((Color)value);
            }
            if (value instanceof Font) {
                return new FontUIResource((Font)value);
            }
            if (value instanceof UIDefaults.ProxyLazyValue) {
                value = ((UIDefaults.ProxyLazyValue)value).createValue(null);
            } else if (value instanceof UIDefaults.ActiveValue) {
                value = ((UIDefaults.ActiveValue)value).createValue(null);
            }
        }
        return value;
    }

    protected String[] getKeys() {
        return this.keys;
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;

        WeakPCL(Object target, Toolkit kit) {
            super(target);
            this.kit = kit;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            ExtWindowsDesktopProperty property = (ExtWindowsDesktopProperty)this.get();
            if (property == null) {
                this.kit.removePropertyChangeListener(pce.getPropertyName(), this);
            } else {
                property.invalidate();
                property.updateUI();
            }
        }
    }
}

