/*
 *  Smart Cache , http proxy caching server
 *  Copyright (C) 1998 Radim Kolar <hsn@cybermail.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;

public final class minicachedir extends localdir{

public static final String DIRINFO=".cacheinfo";

minicachedir(String locdir)
{
 super(locdir);
}

protected final void localinit()
{
 File f=new File(name);
 if(!f.exists() || !f.isDirectory())
  {
   return;
  }
 /* nacteme cachovane objekty */

 DataInputStream is=null;
 try{
 is=new DataInputStream(
                 new BufferedInputStream(
                 new FileInputStream( name+DIRINFO ),4096));

 byte version=0;
 int howmany=is.readInt();
 switch(howmany) {
 case 0x53433033:
	 version=3;
	 break;
 case 0x53433034:
	 version=4;
	 break;
 default:
	 System.err.println("Unsupported cacheinfo version.");
	 return;
 }
 howmany=is.readInt();

 for(int i=0;i<howmany;i++)
 {
   localurl lu;
   String uname,ctype,localname,location,enc;
   long date;

   uname=is.readUTF();
   ctype=is.readUTF();
   localname=is.readUTF();
   location=is.readUTF();
   if(location.length()==0) location=null;
   is.readInt(); // size
   is.readInt();  // httprc
   is.readLong(); // expires
   date=is.readLong(); //date
   is.readLong();  // lastmod
   is.readLong();  // lru
   enc=null;
   switch(version)
   {
      case 4:
      is.readUTF();
      case 3:
      enc=is.readUTF();
      if(enc.length()==0) enc=null;
      is.readBoolean();
   }

   if(localname.equals("<>")) continue;
   if(localname.length()==0) continue;

   lu=new localurl(this.name,uname,localname,ctype,enc,location,date);
   objects.put(uname,lu);
 }
 is.close();
 }
 catch(IOException e) {
                       try{
                         if(is!=null) { System.out.println("I/O error reading "+name+DIRINFO+" ,file corrupted?");
                                        is.close();
                                      }
                          }
                        catch (IOException z) {}
                       };
} /* konstruktor */

} /* class */
