UNIT BseErr;

{****************************** Module Header ******************************
*                                                                          *
* Module Name: BSEERR.H                                                    *
*                                                                          *
* This file includes the error codes for Base OS/2;applications.           *
*                                                                          *
 ***************************************************************************}

INTERFACE

CONST
      NO_ERROR                =0;      { MSG%RESPONSE_DATA }
      ERROR_INVALID_FUNCTION  =1;      { MSG%INVALID_FUNCTION }
      ERROR_FILE_NOT_FOUND    =2;      { MSG%FILE_NOT_FOUND }
      ERROR_PATH_NOT_FOUND    =3;      { MSG%PATH_NOT_FOUND }
      ERROR_TOO_MANY_OPEN_FILES=4;     { MSG%OUT_OF_HANDLES }
      ERROR_ACCESS_DENIED     =5;      { MSG%ACCESS_DENIED }
      ERROR_INVALID_HANDLE    =6;      { MSG%INVALID_HANDLE }
      ERROR_ARENA_TRASHED     =7;      { MSG%MEMORY_BLOCKS_BAD }
      ERROR_NOT_ENOUGH_MEMORY =8;      { MSG%NO_MEMORY }
      ERROR_INVALID_BLOCK     =9;      { MSG%INVALID_MEM_ADDR }
      ERROR_BAD_ENVIRONMENT   =10;     { MSG%INVALID_ENVIRON }
      ERROR_BAD_FORMAT        =11;     { MSG%INVALID_FORMAT }
      ERROR_INVALID_ACCESS    =12;     { MSG%INVALID_ACC_CODE }
      ERROR_INVALID_DATA      =13;     { MSG%INVALID_DATA }
      ERROR_INVALID_DRIVE     =15;     { MSG%INVALID_DRIVE }
      ERROR_CURRENT_DIRECTORY =16;     { MSG%ATT_RD_CURDIR }
      ERROR_NOT_SAME_DEVICE   =17;     { MSG%NOT_SAME_DEVICE }
      ERROR_NO_MORE_FILES     =18;     { MSG%NO_MORE_FILES }
      ERROR_WRITE_PROTECT     =19;     { MSG%ATT_WRITE_PROT }
      ERROR_BAD_UNIT          =20;     { MSG%UNKNOWN_UNIT }
      ERROR_NOT_READY         =21;     { MSG%DRIVE_NOT_READY }
      ERROR_BAD_COMMAND       =22;     { MSG%UNKNOWN_COMMAND }
      ERROR_CRC               =23;     { MSG%DATA_ERROR }
      ERROR_BAD_LENGTH        =24;     { MSG%BAD_REQ_STRUCTURE }
      ERROR_SEEK              =25;     { MSG%SEEK_ERROR }
      ERROR_NOT_DOS_DISK      =26;     { MSG%UNKNOWN_MEDIA }
      ERROR_SECTOR_NOT_FOUND  =27;     { MSG%SECTOR_NOT_FOUND }
      ERROR_OUT_OF_PAPER      =28;     { MSG%OUT_OF_PAPER }
      ERROR_WRITE_FAULT       =29;     { MSG%WRITE_FAULT }
      ERROR_READ_FAULT        =30;     { MSG%READ_FAULT }
      ERROR_GEN_FAILURE       =31;     { MSG%GENERAL_FAILURE }
      ERROR_SHARING_VIOLATION =32;     { MSG%SHARING_VIOLATION }
{                                      =32%msg%SHAR_VIOLAT_FIND }
      ERROR_LOCK_VIOLATION    =33;     { MSG%LOCK_VIOLATION }
      ERROR_WRONG_DISK        =34;     { MSG%INVALID_DISK_CHANGE }
      ERROR_FCB_UNAVAILABLE   =35;     { MSG%35;}
      ERROR_SHARING_BUFFER_EXCEEDED=36;{ MSG%SHARING_BUFF_OFLOW }
      ERROR_CODE_PAGE_MISMATCHED=37;   { MSG%ERROR_WRITE_PROTECT }
      ERROR_HANDLE_EOF        =38;     { MSG%ERROR_BAD_UNIT }
      ERROR_HANDLE_DISK_FULL  =39;     { MSG%ERROR_NOT_READY }
{                                      =40%msg%ERROR_BAD_COMMAND }
{                                      =41%msg%ERROR_CRC }
{                                      =42%msg%ERROR_BAD_LENGTH }
{                                      =43%msg%ERROR_SEEK }
{                                      =44%msg%ERROR_NOT_DOS_DISK }
{                                      =45%msg%ERROR_SECTOR_NOT_FOUND }
{                                      =46%msg%ERROR_OUT_OF_PAPER }
{                                      =47%msg%ERROR_WRITE_FAULT }
{                                      =48%msg%ERROR_READ_FAULT }
{                                      =49%msg%ERROR_GEN_FAILURE }
      ERROR_NOT_SUPPORTED     =50;     { MSG%NET_REQ_NOT_SUPPORT }
      ERROR_REM_NOT_LIST      =51;     { MSG%NET_REMOTE_NOT_ONLINE }
      ERROR_DUP_NAME          =52;     { MSG%NET_DUP_FILENAME }
      ERROR_BAD_NETPATH       =53;     { MSG%NET_PATH_NOT_FOUND }
      ERROR_NETWORK_BUSY      =54;     { MSG%NET_BUSY }
      ERROR_DEV_NOT_EXIST     =55;     { MSG%NET_DEV_NOT_INSTALLED }
      ERROR_TOO_MANY_CMDS     =56;     { MSG%NET_BIOS_LIMIT_REACHED }
      ERROR_ADAP_HDW_ERR      =57;     { MSG%NET_ADAPT_HRDW_ERROR }
      ERROR_BAD_NET_RESP      =58;     { MSG%NET_INCORRECT_RESPONSE }
      ERROR_UNEXP_NET_ERR     =59;     { MSG%NET_UNEXPECT_ERROR }
      ERROR_BAD_REM_ADAP      =60;     { MSG%NET_REMOT_ADPT_INCOMP }
      ERROR_PRINTQ_FULL       =61;     { MSG%NET_PRINT_Q_FULL }
      ERROR_NO_SPOOL_SPACE    =62;     { MSG%NET_NO_SPACE_TO_PRINT_FL }
      ERROR_PRINT_CANCELLED   =63;     { MSG%NET_PRINT_FILE_DELETED }
      ERROR_NETNAME_DELETED   =64;     { MSG%NET_NAME_DELETED }
      ERROR_NETWORK_ACCESS_DENIED=65;  { MSG%NET_ACCESS_DENIED }
      ERROR_BAD_DEV_TYPE      =66;     { MSG%NET_DEV_TYPE_INVALID }
      ERROR_BAD_NET_NAME      =67;     { MSG%NET_NAME_NOT_FOUND }
      ERROR_TOO_MANY_NAMES    =68;     { MSG%NET_NAME_LIMIT_EXCEED }
      ERROR_TOO_MANY_SESS     =69;     { MSG%NET_BIOS_LIMIT_EXCEED }
      ERROR_SHARING_PAUSED    =70;     { MSG%NET_TEMP_PAUSED }
      ERROR_REQ_NOT_ACCEP     =71;     { MSG%NET_REQUEST_DENIED }
      ERROR_REDIR_PAUSED      =72;     { MSG%NET_PRT_DSK_REDIR_PAUSE }
      ERROR_SBCS_ATT_WRITE_PROT=73;    { Attempted write on protected disk }
      ERROR_SBCS_GENERAL_FAILURE=74;   { General failure }
      ERROR_XGA_OUT_MEMORY    =75;     { MSG%XGA_OUT_MEMORY }
      ERROR_FILE_EXISTS       =80;     { MSG%FILE_EXISTS }
      ERROR_DUP_FCB           =81;     { MSG%none }
      ERROR_CANNOT_MAKE       =82;     { MSG%CANNOT_MAKE }
      ERROR_FAIL_I24          =83;     { MSG%NET_FAIL_INT_TWO_FOUR }
      ERROR_OUT_OF_STRUCTURES =84;     { MSG%NET_TOO_MANY_REDIRECT }
      ERROR_ALREADY_ASSIGNED  =85;     { MSG%NET_DUP_REDIRECTION }
      ERROR_INVALID_PASSWORD  =86;     { MSG%NET_INVALID_PASSWORD }
      ERROR_INVALID_PARAMETER =87;     { MSG%NET_INCORR_PARAMETER }
      ERROR_NET_WRITE_FAULT   =88;     { MSG%NET_DATA_FAULT }
      ERROR_NO_PROC_SLOTS     =89;     { MSG%NO_PROC_SLOTS }
      ERROR_NOT_FROZEN        =90;     { MSG%none }
      ERROR_SYS_COMP_NOT_LOADED=ERROR_NOT_FROZEN;
      ERR_TSTOVFL             =91;     { MSG%none }
      ERR_TSTDUP              =92;     { MSG%none }
      ERROR_NO_ITEMS          =93;     { MSG%none }
      ERROR_INTERRUPT         =95;     { MSG%none }
      ERROR_DEVICE_IN_USE     =99;     { MSG%DEVICE_IN_USE }
      ERROR_TOO_MANY_SEMAPHORES=100;   { MSG%TOO_MANY_SEMAPHORES }
      ERROR_EXCL_SEM_ALREADY_OWNED=101;{ MSG%EXCL_SEM_ALREADY_OWNED }
      ERROR_SEM_IS_SET        =102;    { MSG%SEM_IS_SET }
      ERROR_TOO_MANY_SEM_REQUESTS=103; { MSG%TOO_MANY_SEM_REQUESTS }
      ERROR_INVALID_AT_INTERRUPT_TIME=104; { MSG%INVALID_AT_INTERRUPT_TIME }
      ERROR_SEM_OWNER_DIED    =105;    { MSG%SEM_OWNER_DIED }
      ERROR_SEM_USER_LIMIT    =106;    { MSG%ERROR_DISK_CHANGE }
      ERROR_DISK_CHANGE       =107;    { MSG%DISK_CHANGE }
      ERROR_DRIVE_LOCKED      =108;    { MSG%DRIVE_LOCKED }
      ERROR_BROKEN_PIPE       =109;    { MSG%BROKEN_PIPE }
      ERROR_OPEN_FAILED       =110;    { MSG%ERROR_OPEN_FAILED }
      ERROR_BUFFER_OVERFLOW   =111;    { MSG%ERROR_FILENAME_LONG }
      ERROR_DISK_FULL         =112;    { MSG%DISK_FULL }
      ERROR_NO_MORE_SEARCH_HANDLES=113;{ MSG%NO_SEARCH_HANDLES }
      ERROR_INVALID_TARGET_HANDLE=114; { MSG%ERR_INV_TAR_HANDLE }
      ERROR_PROTECTION_VIOLATION=115;  { MSG%none }
      ERROR_VIOKBD_REQUEST    =116;    { MSG%none }
      ERROR_INVALID_CATEGORY  =117;    { MSG%INVALID_CATEGORY }
      ERROR_INVALID_VERIFY_SWITCH=118; { MSG%INVALID_VERIFY_SWITCH }
      ERROR_BAD_DRIVER_LEVEL  =119;    { MSG%BAD_DRIVER_LEVEL }
      ERROR_CALL_NOT_IMPLEMENTED=120;  { MSG%BAD_DYNALINK }
      ERROR_SEM_TIMEOUT       =121;    { MSG%SEM_TIMEOUT }
      ERROR_INSUFFICIENT_BUFFER=122;   { MSG%INSUFFICIENT_BUFFER }
      ERROR_INVALID_NAME      =123;    { MSG%INVALID_NAME }
{                                      =123%msg%HPFS_INVALID_VOLUME_CHAR }
      ERROR_INVALID_LEVEL     =124;    { MSG%INVALID_LEVEL }
      ERROR_NO_VOLUME_LABEL   =125;    { MSG%NO_VOLUME_LABEL }
      ERROR_MOD_NOT_FOUND     =126;    { MSG%MOD_NOT_FOUND }
      ERROR_PROC_NOT_FOUND    =127;    { MSG%PROC_NOT_FOUND }
      ERROR_WAIT_NO_CHILDREN  =128;    { MSG%none }
      ERROR_CHILD_NOT_COMPLETE=129;    { MSG%PROT_MODE_ONLY }
      ERROR_DIRECT_ACCESS_HANDLE=130;  { MSG%APPL_SINGLEFRAMECHAR }
      ERROR_NEGATIVE_SEEK     =131;    { MSG%APPL_DOUBLEFRAMECHAR }
      ERROR_SEEK_ON_DEVICE    =132;    { MSG%APPL_ARROWCHAR }
      ERROR_IS_JOIN_TARGET    =133;    { MSG%JOIN_ON_DRIV_IS_TAR }
      ERROR_IS_JOINED         =134;    { MSG%JOIN_DRIVE_IS }
      ERROR_IS_SUBSTED        =135;    { MSG%SUB_DRIVE_IS }
      ERROR_NOT_JOINED        =136;    { MSG%DRIVE_IS_NOT_JOINED }
      ERROR_NOT_SUBSTED       =137;    { MSG%DRIVE_NOT_SUBSTED }
      ERROR_JOIN_TO_JOIN      =138;    { MSG%JOIN_CANNOT_JOIN_DRIVE }
      ERROR_SUBST_TO_SUBST    =139;    { MSG%SUB_CANNOT_SUBST_DRIVE }
      ERROR_JOIN_TO_SUBST     =140;    { MSG%JOIN_CANNOT_SUB_DRIVE }
      ERROR_SUBST_TO_JOIN     =141;    { MSG%SUB_CANNOT_JOIN_DRIVE }
      ERROR_BUSY_DRIVE        =142;    { MSG%DRIVE_IS_BUSY }
      ERROR_SAME_DRIVE        =143;    { MSG%JOIN_SUB_SAME_DRIVE }
      ERROR_DIR_NOT_ROOT      =144;    { MSG%DIRECT_IS_NOT_SUBDIR }
      ERROR_DIR_NOT_EMPTY     =145;    { MSG%DIRECT_IS_NOT_EMPTY }
      ERROR_IS_SUBST_PATH     =146;    { MSG%PATH_USED_SUBST_JOIN }
      ERROR_IS_JOIN_PATH      =147;    { MSG%NO_NEEDED_RESOURCES }
      ERROR_PATH_BUSY         =148;    { MSG%PATH_BUSY }
      ERROR_IS_SUBST_TARGET   =149;    { MSG%SUB_ON_DRIVE_IS_JOIN }
      ERROR_SYSTEM_TRACE      =150;    { MSG%SYSTEM_TRACE }
      ERROR_INVALID_EVENT_COUNT=151;   { MSG%INVALID_EVENT_COUNT }
      ERROR_TOO_MANY_MUXWAITERS=152;   { MSG%TOO_MANY_MUXWAITERS }
      ERROR_INVALID_LIST_FORMAT=153;   { MSG%INVALID_LIST_FORMAT }
      ERROR_LABEL_TOO_LONG    =154;    { MSG%VOLUME_TOO_LONG }
{                                      =154%msg%HPFS_VOL_LABEL_LONG }
      ERROR_TOO_MANY_TCBS     =155;    { MSG%TOO_MANY_TCBS }
      ERROR_SIGNAL_REFUSED    =156;    { MSG%SIGNAL_REFUSED }
      ERROR_DISCARDED         =157;    { MSG%DISCARDED }
      ERROR_NOT_LOCKED        =158;    { MSG%NOT_LOCKED }
      ERROR_BAD_THREADID_ADDR =159;    { MSG%BAD_THREADID_ADDR }
      ERROR_BAD_ARGUMENTS     =160;    { MSG%BAD_ARGUMENTS }
      ERROR_BAD_PATHNAME      =161;    { MSG%none }
      ERROR_SIGNAL_PENDING    =162;    { MSG%SIGNAL_PENDING }
      ERROR_UNCERTAIN_MEDIA   =163;    { MSG%none }
      ERROR_MAX_THRDS_REACHED =164;    { MSG%MAX_THRDS_REACHED }
      ERROR_MONITORS_NOT_SUPPORTED=165;{ MSG%none }
      ERROR_UNC_DRIVER_NOT_INSTALLED=166;{ MSG%UNC_DRIVER_NOT_INSTALLED }
      ERROR_LOCK_FAILED       =167;    { MSG%LOCK_FAILED }
      ERROR_SWAPIO_FAILED     =168;    { MSG%SWAPIO_FAILED }
      ERROR_SWAPIN_FAILED     =169;    { MSG%SWAPIN_ATTEMPT_FAILED }
      ERROR_BUSY              =170;    { MSG%SEGMENT_BUSY }
{                                      =171%msg%INT_TOO_LONG }
      ERROR_CANCEL_VIOLATION  =173;    { MSG%UNLOCK_VIOLATION }
      ERROR_ATOMIC_LOCK_NOT_SUPPORTED=174;{ MSG%none }
      ERROR_READ_LOCKS_NOT_SUPPORTED=175;{ MSG%none }
      ERROR_INVALID_SEGMENT_NUMBER=180;{ MSG%INVALID_SEGMENT_NUM }
      ERROR_INVALID_CALLGATE  =181;    { MSG%none }
      ERROR_INVALID_ORDINAL   =182;    { MSG%INVALID_ORDINAL }
      ERROR_ALREADY_EXISTS    =183;    { MSG%none }
      ERROR_NO_CHILD_PROCESS  =184;    { MSG%none }
      ERROR_CHILD_ALIVE_NOWAIT=185;    { MSG%none }
      ERROR_INVALID_FLAG_NUMBER=186;   { MSG%INVALID_FLAG_NUMBER }
      ERROR_SEM_NOT_FOUND     =187;    { MSG%SEM_NOT_FOUND }
      ERROR_INVALID_STARTING_CODESEG=188;{ MSG%INVALID_STARTING_CODESEG }
      ERROR_INVALID_STACKSEG  =189;    { MSG%INVALID_STACKSEG }
      ERROR_INVALID_MODULETYPE=190;    { MSG%INVALID_MODULETYPE }
      ERROR_INVALID_EXE_SIGNATURE=191; { MSG%INVALID_EXE_SIGNATURE }
      ERROR_EXE_MARKED_INVALID=192;    { MSG%EXE_MARKED_INVALID }
      ERROR_BAD_EXE_FORMAT    =193;    { MSG%BAD_EXE_FORMAT }
      ERROR_ITERATED_DATA_EXCEEDS_64k=194;{ MSG%ITERATED_DATA_EXCEEDS_64K }
      ERROR_INVALID_MINALLOCSIZE=195;  { MSG%INVALID_MINALLOCSIZE }
      ERROR_DYNLINK_FROM_INVALID_RING=196;{ MSG%DYNLINK_FROM_INVALID_RING }
      ERROR_IOPL_NOT_ENABLED  =197;    { MSG%IOPL_NOT_ENABLED }
      ERROR_INVALID_SEGDPL    =198;    { MSG%INVALID_SEGDPL }
      ERROR_AUTODATASEG_EXCEEDS_64k=199;{ MSG%AUTODATASEG_EXCEEDS_64K }
      ERROR_RING2SEG_MUST_BE_MOVABLE=200;{ MSG%CODESEG_CANNOT_BE_64K }
      ERROR_RELOC_CHAIN_XEEDS_SEGLIM=201;{ MSG%RELOC_CHAIN_XEEDS_SEGMENT }
      ERROR_INFLOOP_IN_RELOC_CHAIN=202;    { MSG%INFLOOP_IN_RELOC_CHAIN }
      ERROR_ENVVAR_NOT_FOUND  =203;    { MSG%ENVVAR_NOT_FOUND }
      ERROR_NOT_CURRENT_CTRY  =204;    { MSG%none }
      ERROR_NO_SIGNAL_SENT    =205;    { MSG%SIGNAL_NOT_SENT }
      ERROR_FILENAME_EXCED_RANGE=206;  { MSG%NAME_TOO_LONG }
      ERROR_RING2_STACK_IN_USE=207;    { MSG%RING2_STACK_IN_USE }
      ERROR_META_EXPANSION_TOO_LONG=208;    { MSG%WILD_CARD_NAME }
      ERROR_INVALID_SIGNAL_NUMBER=209;    { MSG%INVALID_SIGNAL_NUMBER }
      ERROR_THREAD_1_INACTIVE =210;    { MSG%THREAD_1_INACTIVE }
      ERROR_INFO_NOT_AVAIL    =211;    { MSG%none }
      ERROR_LOCKED            =212;    { MSG%LOCKED }
      ERROR_BAD_DYNALINK      =213;    { MSG%none }
      ERROR_TOO_MANY_MODULES  =214;    { MSG%TOO_MANY_MODULES }
      ERROR_NESTING_NOT_ALLOWED=215;   { MSG%none }
      ERROR_CANNOT_SHRINK     =216;    { MSG%CANNOT_SHRINK }
      ERROR_ZOMBIE_PROCESS    =217;    { MSG%none }
      ERROR_STACK_IN_HIGH_MEMORY=218;  { MSG%none }
      ERROR_INVALID_EXITROUTINE_RING=219;    { MSG%INVALID_EXITROUTINE_RING }
      ERROR_GETBUF_FAILED     =220;    { MSG%none }
      ERROR_FLUSHBUF_FAILED   =221;    { MSG%none }
      ERROR_TRANSFER_TOO_LONG =222;    { MSG%none }
      ERROR_FORCENOSWAP_FAILED=223;    { MSG%none }
      ERROR_SMG_NO_TARGET_WINDOW=224;  { PM ID can't be selected }
      ERROR_NO_CHILDREN       =228;    { MSG%NO_CHILDREN }
      ERROR_INVALID_SCREEN_GROUP=229;  { MSG%none }
      ERROR_BAD_PIPE          =230;    { MSG%ERROR_BAD_PIPE }
      ERROR_PIPE_BUSY         =231;    { MSG%ERROR_PIPE_BUSY }
      ERROR_NO_DATA           =232;    { MSG%ERROR_NO_DATA }
      ERROR_PIPE_NOT_CONNECTED=233;    { MSG%ERROR_PIPE_NOT_CONNECTED }
      ERROR_MORE_DATA         =234;    { MSG%ERROR_MORE_DATA }
      ERROR_VC_DISCONNECTED   =240;    { MSG%ERROR_VC_DISCONNECTED }
      ERROR_CIRCULARITY_REQUESTED=250; { MSG%CIRCULARITY_REQUESTED }
      ERROR_DIRECTORY_IN_CDS  =251;    { MSG%DIRECTORY_IN_CDS }
      ERROR_INVALID_FSD_NAME  =252;    { MSG%INVALID_FSD_NAME }
      ERROR_INVALID_PATH      =253;    { MSG%INVALID_PATH }
      ERROR_INVALID_EA_NAME   =254;    { MSG%INVALID_EA_NAME }
      ERROR_EA_LIST_INCONSISTENT=255;  { MSG%EA_LIST_INCONSISTENT }
      ERROR_EA_LIST_TOO_LONG  =256;    { MSG%EA_LIST_TOO_LONG }
      ERROR_NO_META_MATCH     =257;    { MSG%NO_META_MATCH }
      ERROR_FINDNOTIFY_TIMEOUT=258;    { MSG%FINDNOTIFY_TIMEOUT }
      ERROR_NO_MORE_ITEMS     =259;    { MSG%NO_MORE_ITEMS }
      ERROR_SEARCH_STRUC_REUSED=260;   { MSG%SEARCH_STRUC_REUSED }
      ERROR_CHAR_NOT_FOUND    =261;    { MSG%CHAR_NOT_FOUND }
      ERROR_TOO_MUCH_STACK    =262;    { MSG%TOO_MUCH_STACK }
      ERROR_INVALID_ATTR      =263;    { MSG%INVALID_ATTR }
      ERROR_INVALID_STARTING_RING=264; { MSG%INVALID_STARTING_RING }
      ERROR_INVALID_DLL_INIT_RING=265; { MSG%INVALID_DLL_INIT_RING }
      ERROR_CANNOT_COPY       =266;    { MSG%CANNOT_COPY }
      ERROR_DIRECTORY         =267;    { MSG%DIRECTORY }
      ERROR_OPLOCKED_FILE     =268;    { MSG%OPLOCKED_FILE }
      ERROR_OPLOCK_THREAD_EXISTS=269;  { MSG%OPLOCK_THREAD_EXISTS }
      ERROR_VOLUME_CHANGED    =270;    { MSG%none }
      ERROR_FINDNOTIFY_HANDLE_IN_USE=271;    { MSG%none }
      ERROR_FINDNOTIFY_HANDLE_CLOSED=272;    { MSG%none }
      ERROR_NOTIFY_OBJECT_REMOVED=273; { MSG%none }
      ERROR_ALREADY_SHUTDOWN  =274;    { MSG%none }
      ERROR_EAS_DIDNT_FIT     =275;    { MSG%none }
      ERROR_EA_FILE_CORRUPT   =276;    { MSG%ERROR_EAS_CORRUPT }
      ERROR_EA_TABLE_FULL     =277;    { MSG%EA_TABLE_FULL }
      ERROR_INVALID_EA_HANDLE =278;    { MSG%INVALID_EA_HANDLE }
      ERROR_NO_CLUSTER        =279;    { MSG%NO_CLUSTER }
      ERROR_CREATE_EA_FILE    =280;    { MSG%ERROR_CREATE_EA_FILE }
      ERROR_CANNOT_OPEN_EA_FILE=281;   { MSG%CANNOT_OPEN_FILE }
      ERROR_EAS_NOT_SUPPORTED =282;    { MSG%EAS_NOT_SUPPORTED }
      ERROR_NEED_EAS_FOUND    =283;    { MSG%NEED_EAS_FOUND }
      ERROR_DUPLICATE_HANDLE  =284;    { MSG%EAS_DISCARDED }
      ERROR_DUPLICATE_NAME    =285;    { MSG%DUPLICATE_SEM_NAME }
      ERROR_EMPTY_MUXWAIT     =286;    { MSG%EMPTY_MUXWAIT_SEM }
      ERROR_MUTEX_OWNED       =287;    { MSG%MUTEX_SEM_OWNED }
      ERROR_NOT_OWNER         =288;    { MSG%NOT_MUTEX_SEM_OWNER }
      ERROR_PARAM_TOO_SMALL   =289;    { MSG%QUERY_MUX_PARAM_TOO_SMALL }
      ERROR_TOO_MANY_HANDLES  =290;    { MSG%TOO_MANY_SEM_HANDLES }
      ERROR_TOO_MANY_OPENS    =291;    { MSG%TOO_MANY_SEM_OPENS }
      ERROR_WRONG_TYPE        =292;    { MSG%SEM_WRONG_TYPE }
      ERROR_UNUSED_CODE       =293;    { MSG%none }
      ERROR_THREAD_NOT_TERMINATED=294; { MSG%none }
      ERROR_INIT_ROUTINE_FAILED=295;   { MSG%none }
      ERROR_MODULE_IN_USE     =296;    { MSG%none }
      ERROR_NOT_ENOUGH_WATCHPOINTS=297;{ MSG%none }
      ERROR_TOO_MANY_POSTS    =298;    { MSG%TOO_MANY_EVENT_SEM_POSTS }
      ERROR_ALREADY_POSTED    =299;    { MSG%EVENT_SEM_ALREADY_POSTED }
      ERROR_ALREADY_RESET     =300;    { MSG%EVENT_SEM_ALREADY_RESET }
      ERROR_SEM_BUSY          =301;    { MSG%SEM_BUSY }

{ end of set 0;- 302;}

      ERROR_USER_DEFINED_BASE =$FF00;

      ERROR_I24_WRITE_PROTECT         =0;
      ERROR_I24_BAD_UNIT              =1;
      ERROR_I24_NOT_READY             =2;
      ERROR_I24_BAD_COMMAND           =3;
      ERROR_I24_CRC                   =4;
      ERROR_I24_BAD_LENGTH            =5;
      ERROR_I24_SEEK                  =6;
      ERROR_I24_NOT_DOS_DISK          =7;
      ERROR_I24_SECTOR_NOT_FOUND      =8;
      ERROR_I24_OUT_OF_PAPER          =9;
      ERROR_I24_WRITE_FAULT           =10;
      ERROR_I24_READ_FAULT            =11;
      ERROR_I24_GEN_FAILURE           =12;
      ERROR_I24_DISK_CHANGE           =13;
      ERROR_I24_WRONG_DISK            =15;
      ERROR_I24_UNCERTAIN_MEDIA       =16;
      ERROR_I24_CHAR_CALL_INTERRUPTED =17;
      ERROR_I24_NO_MONITOR_SUPPORT    =18;
      ERROR_I24_INVALID_PARAMETER     =19;
      ERROR_I24_DEVICE_IN_USE         =20;
      ERROR_I24_QUIET_INIT_FAIL       =21;

      ALLOWED_FAIL                    =$0001;
      ALLOWED_ABORT                   =$0002;
      ALLOWED_RETRY                   =$0004;
      ALLOWED_IGNORE                  =$0008;
      ALLOWED_ACKNOWLEDGE             =$0010;
      ALLOWED_DISPATCH                =$8000;
      ALLOWED_REGDUMP                 =$0020;
      ALLOWED_DETACHED                =ALLOWED_DISPATCH;
      ALLOWED_RESERVED                =NOT (ALLOWED_FAIL OR ALLOWED_ABORT OR
                                            ALLOWED_RETRY OR ALLOWED_IGNORE OR
                                            ALLOWED_ACKNOWLEDGE);

      I24_OPERATION                   =$01;
      I24_AREA                        =$06;
      I24_CLASS                       =$80;

{ Values for error CLASS }
      ERRCLASS_OUTRES                 =1;  { Out of Resource                }
      ERRCLASS_TEMPSIT                =2;  { Temporary Situation            }
      ERRCLASS_AUTH                   =3;  { Permission problem             }
      ERRCLASS_INTRN                  =4;  { Internal System Error          }
      ERRCLASS_HRDFAIL                =5;  { Hardware Failure               }
      ERRCLASS_SYSFAIL                =6;  { System Failure                 }
      ERRCLASS_APPERR                 =7;  { Application Error              }
      ERRCLASS_NOTFND                 =8;  { Not Found                      }
      ERRCLASS_BADFMT                 =9;  { Bad Format                     }
      ERRCLASS_LOCKED                 =10; { Locked                         }
      ERRCLASS_MEDIA                  =11; { Media Failure                  }
      ERRCLASS_ALREADY                =12; { Collision with Existing Item   }
      ERRCLASS_UNK                    =13; { Unknown/other                  }
      ERRCLASS_CANT                   =14;
      ERRCLASS_TIME                   =15;

{ Values for error ACTION }
      ERRACT_RETRY                    =1;  { Retry                          }
      ERRACT_DLYRET                   =2;  { Delay Retry, retry after pause }
      ERRACT_USER                     =3;  { Ask user to regive information }
      ERRACT_ABORT                    =4;  { abort with clean up            }
      ERRACT_PANIC                    =5;  { abort immediately              }
      ERRACT_IGNORE                   =6;  { ignore                         }
      ERRACT_INTRET                   =7;  { Retry after User Intervention  }

{ Values for error LOCUS }
      ERRLOC_UNK                      =1;  { No appropriate value           }
      ERRLOC_DISK                     =2;  { Random Access Mass Storage     }
      ERRLOC_NET                      =3;  { Network                        }
      ERRLOC_SERDEV                   =4;  { Serial Device                  }
      ERRLOC_MEM                      =5;  { Memory                         }

{ Abnormal termination codes }
      TC_NORMAL                       =0;
      TC_HARDERR                      =1;
      TC_GP_TRAP                      =2;
      TC_SIGNAL                       =3;
      TC_XCPT                         =4;


      ERROR_INVALID_PROCID    =303;    { MSG%none }
      ERROR_INVALID_PDELTA    =304;    { MSG%none }
      ERROR_NOT_DESCENDANT    =305;    { MSG%none }
      ERROR_NOT_SESSION_MANAGER=306;   { MSG%none }
      ERROR_INVALID_PCLASS    =307;    { MSG%none }
      ERROR_INVALID_SCOPE     =308;    { MSG%none }
      ERROR_INVALID_THREADID  =309;    { MSG%none }
      ERROR_DOSSUB_SHRINK     =310;    { MSG%none }
      ERROR_DOSSUB_NOMEM      =311;    { MSG%none }
      ERROR_DOSSUB_OVERLAP    =312;    { MSG%none }
      ERROR_DOSSUB_BADSIZE    =313;    { MSG%none }
      ERROR_DOSSUB_BADFLAG    =314;    { MSG%none }
      ERROR_DOSSUB_BADSELECTOR=315;    { MSG%none }
      ERROR_MR_MSG_TOO_LONG   =316;    { MSG%MR_MSG_TOO_LONG }
      MGS_MR_MSG_TOO_LONG     =316;
      ERROR_MR_MID_NOT_FOUND  =317;    { MSG%MR_CANT_FORMAT }
      ERROR_MR_UN_ACC_MSGF    =318;    { MSG%MR_NOT_FOUND }
      ERROR_MR_INV_MSGF_FORMAT=319;    { MSG%MR_READ_ERROR }
      ERROR_MR_INV_IVCOUNT    =320;    { MSG%MR_IVCOUNT_ERROR }
      ERROR_MR_UN_PERFORM     =321;    { MSG%MR_UN_PERFORM }
      ERROR_TS_WAKEUP         =322;    { MSG%none }
      ERROR_TS_SEMHANDLE      =323;    { MSG%none }
      ERROR_TS_NOTIMER        =324;    { MSG%none }
      ERROR_TS_HANDLE         =326;    { MSG%none }
      ERROR_TS_DATETIME       =327;    { MSG%none }
      ERROR_SYS_INTERNAL      =328;    { MSG%none }
      ERROR_QUE_CURRENT_NAME  =329;    { MSG%none }
      ERROR_QUE_PROC_NOT_OWNED=330;    { MSG%QUE_PROC_NOT_OWNED }
      ERROR_QUE_PROC_OWNED    =331;    { MSG%none }
      ERROR_QUE_DUPLICATE     =332;    { MSG%QUE_DUPLICATE }
      ERROR_QUE_ELEMENT_NOT_EXIST=333; { MSG%QUE_ELEMENT_NOT_EXIST }
      ERROR_QUE_NO_MEMORY     =334;    { MSG%QUE_NO_MEMORY }
      ERROR_QUE_INVALID_NAME  =335;    { MSG%none }
      ERROR_QUE_INVALID_PRIORITY=336;  { MSG%none }
      ERROR_QUE_INVALID_HANDLE=337;    { MSG%none }
      ERROR_QUE_LINK_NOT_FOUND=338;    { MSG%none }
      ERROR_QUE_MEMORY_ERROR  =339;    { MSG%none }
      ERROR_QUE_PREV_AT_END   =340;    { MSG%none }
      ERROR_QUE_PROC_NO_ACCESS=341;    { MSG%none }
      ERROR_QUE_EMPTY         =342;    { MSG%none }
      ERROR_QUE_NAME_NOT_EXIST=343;    { MSG%none }
      ERROR_QUE_NOT_INITIALIZED=344;   { MSG%none }
      ERROR_QUE_UNABLE_TO_ACCESS=345;  { MSG%none }
      ERROR_QUE_UNABLE_TO_ADD =346;    { MSG%none }
      ERROR_QUE_UNABLE_TO_INIT=347;    { MSG%none }
      ERROR_VIO_INVALID_MASK  =349;    { MSG%VIO_INVALID_MASK }
      ERROR_VIO_PTR           =350;    { MSG%VIO_PTR }
      ERROR_VIO_APTR          =351;    { MSG%none }
      ERROR_VIO_RPTR          =352;    { MSG%none }
      ERROR_VIO_CPTR          =353;    { MSG%none }
      ERROR_VIO_LPTR          =354;    { MSG%none }
      ERROR_VIO_MODE          =355;    { MSG%DIS_ERROR }
      ERROR_VIO_WIDTH         =356;    { MSG%VIO_WIDTH }
      ERROR_VIO_ATTR          =357;    { MSG%none }
      ERROR_VIO_ROW           =358;    { MSG%VIO_ROW }
      ERROR_VIO_COL           =359;    { MSG%VIO_COL }
      ERROR_VIO_TOPROW        =360;    { MSG%none }
      ERROR_VIO_BOTROW        =361;    { MSG%none }
      ERROR_VIO_RIGHTCOL      =362;    { MSG%none }
      ERROR_VIO_LEFTCOL       =363;    { MSG%none }
      ERROR_SCS_CALL          =364;    { MSG%none }
      ERROR_SCS_VALUE         =365;    { MSG%none }
      ERROR_VIO_WAIT_FLAG     =366;    { MSG%VIO_WAIT_FLAG }
      ERROR_VIO_UNLOCK        =367;    { MSG%VIO_UNLOCK }
      ERROR_SGS_NOT_SESSION_MGR=368;   { MSG%none }
      ERROR_SMG_INVALID_SGID  =369;    { MSG%SMG_INVALID_SESSION_ID }
      ERROR_SMG_INVALID_SESSION_ID=ERROR_SMG_INVALID_SGID;
      ERROR_SMG_NOSG          =370;    { MSG%none }
      ERROR_SMG_NO_SESSIONS   =370;    { MSG%none }
      ERROR_SMG_GRP_NOT_FOUND =371;    { MSG%SMG_GRP_NOT_FOUND }
      ERROR_SMG_SESSION_NOT_FOUND=ERROR_SMG_GRP_NOT_FOUND;
{                                      =371%msg%SMG_SESSION_NOT_FOUND }
      ERROR_SMG_SET_TITLE     =372;    { MSG%SMG_SET_TITLE }
      ERROR_KBD_PARAMETER     =373;    { MSG%KBD_PARAMETER }
      ERROR_KBD_NO_DEVICE     =374;    { MSG%none }
      ERROR_KBD_INVALID_IOWAIT=375;    { MSG%KBD_INVALID_IOWAIT }
      ERROR_KBD_INVALID_LENGTH=376;    { MSG%KBD_INVALID_LENGTH }
      ERROR_KBD_INVALID_ECHO_MASK=377; { MSG%KBD_INVALID_ECHO_MASK }
{                                      =377%msg%KBD_INVALID_INPUT_MASK }
      ERROR_KBD_INVALID_INPUT_MASK=378;{ MSG%none }
      ERROR_MON_INVALID_PARMS =379;    { MSG%MON_INVALID_PARMS }
      ERROR_MON_INVALID_DEVNAME=380;   { MSG%MON_INVALID_DEVNAME }
      ERROR_MON_INVALID_HANDLE=381;    { MSG%MON_INVALID_HANDLE }
      ERROR_MON_BUFFER_TOO_SMALL=382;  { MSG%MON_BUFFER_TOO_SMALL }
      ERROR_MON_BUFFER_EMPTY  =383;    { MSG%MON_BUFFER_EMPTY }
      ERROR_MON_DATA_TOO_LARGE=384;    { MSG%MON_DATA_TOO_LARGE }
      ERROR_MOUSE_NO_DEVICE   =385;    { MSG%MOUSE_NO_DEVICE }
      ERROR_MOUSE_INV_HANDLE  =386;    { MSG%MOUSE_INV_HANDLE }
      ERROR_MOUSE_INV_PARMS   =387;    { MSG%MOUSE_CALLER_NOT_SYBSYS }
      ERROR_MOUSE_CANT_RESET  =388;    { MSG%none }
      ERROR_MOUSE_DISPLAY_PARMS=389;   { MSG%none }
      ERROR_MOUSE_INV_MODULE  =390;    { MSG%none }
      ERROR_MOUSE_INV_ENTRY_PT=391;    { MSG%none }
      ERROR_MOUSE_INV_MASK    =392;    { MSG%none }
      NO_ERROR_MOUSE_NO_DATA  =393;    { MSG%none }
      NO_ERROR_MOUSE_PTR_DRAWN=394;    { MSG%none }
      ERROR_INVALID_FREQUENCY =395;    { MSG%none }
      ERROR_NLS_NO_COUNTRY_FILE=396;   { MSG%NLS_NO_COUNTRY_FILE }
{                                      =396%msg%NO_COUNTRY_SYS }
      ERROR_NLS_OPEN_FAILED   =397;    { MSG%NLS_OPEN_FAILED }
{                                      =397%msg%OPEN_COUNTRY_SYS }
      ERROR_NLS_NO_CTRY_CODE  =398;    { MSG%NLS_NO_CTRY_CODE }
      ERROR_NO_COUNTRY_OR_CODEPAGE=398;{ MSG%NO_COUNTRY_OR_CODEPAGE }
      ERROR_NLS_TABLE_TRUNCATED=399;   { MSG%NLS_TABLE_TRUNCATED }
      ERROR_NLS_BAD_TYPE      =400;    { MSG%NLS_BAD_TYPE }
      ERROR_NLS_TYPE_NOT_FOUND=401;    { MSG%NLS_TYPE_NOT_FOUND }
{                                      =401%msg%COUNTRY_NO_TYPE }
      ERROR_VIO_SMG_ONLY      =402;    { MSG%SWAPIN_FAILED }
      ERROR_VIO_INVALID_ASCIIZ=403;    { MSG%SEGVALIDATE_FAILURE }
      ERROR_VIO_DEREGISTER    =404;    { MSG%VIO_DEREGISTER }
      ERROR_VIO_NO_POPUP      =405;    { MSG%VIO_NO_POPUP }
      ERROR_VIO_EXISTING_POPUP=406;    { MSG%VIO_EXISTING_POPUP }
      ERROR_KBD_SMG_ONLY      =407;    { MSG%KBD_SMG_ONLY }
      ERROR_KBD_INVALID_ASCIIZ=408;    { MSG%KBD_INVALID_ASCIIZ }
      ERROR_KBD_INVALID_MASK  =409;    { MSG%KBD_INVALID_MASK }
      ERROR_KBD_REGISTER      =410;    { MSG%KBD_REGISTER }
      ERROR_KBD_DEREGISTER    =411;    { MSG%KBD_DEREGISTER }
      ERROR_MOUSE_SMG_ONLY    =412;    { MSG%MOUSE_SMG_ONLY }
      ERROR_MOUSE_INVALID_ASCIIZ=413;  { MSG%MOUSE_INVALID_ASCIIZ }
      ERROR_MOUSE_INVALID_MASK=414;    { MSG%MOUSE_INVALID_MASK }
      ERROR_MOUSE_REGISTER    =415;    { MSG%MOUSE_REGISTER }
      ERROR_MOUSE_DEREGISTER  =416;    { MSG%MOUSE_DEREGISTER }
      ERROR_SMG_BAD_ACTION    =417;    { MSG%SMG_BAD_ACTION }
      ERROR_SMG_INVALID_CALL  =418;    { MSG%SMG_INVALID_CALL }
      ERROR_SCS_SG_NOTFOUND   =419;    { MSG%none }
      ERROR_SCS_NOT_SHELL     =420;    { MSG%none }
      ERROR_VIO_INVALID_PARMS =421;    { MSG%VIO_INVALID_PARMS }
      ERROR_VIO_FUNCTION_OWNED=422;    { MSG%VIO_FUNCTION_OWNED }
      ERROR_VIO_RETURN        =423;    { MSG%none }
      ERROR_SCS_INVALID_FUNCTION=424;  { MSG%none }
      ERROR_SCS_NOT_SESSION_MGR=425;   { MSG%none }
      ERROR_VIO_REGISTER      =426;    { MSG%VIO_REGISTER }
      ERROR_VIO_NO_MODE_THREAD=427;    { MSG%none }
      ERROR_VIO_NO_SAVE_RESTORE_THD=428;{ MSG%VIO_NO_SAVE_RESTORE_THD }
      ERROR_VIO_IN_BG         =429;    { MSG%VIO_IN_BG }
      ERROR_VIO_ILLEGAL_DURING_POPUP=430;    { MSG%VIO_ILLEGAL_DURING_POPUP }
      ERROR_SMG_NOT_BASESHELL =431;    { MSG%SMG_NOT_BASESHELL }
      ERROR_SMG_BAD_STATUSREQ =432;    { MSG%SMG_BAD_STATUSREQ }
      ERROR_QUE_INVALID_WAIT  =433;    { MSG%none }
      ERROR_VIO_LOCK          =434;    { MSG%VIO_LOCK }
      ERROR_MOUSE_INVALID_IOWAIT=435;  { MSG%MOUSE_INVALID_IOWAIT }
      ERROR_VIO_INVALID_HANDLE=436;    { MSG%VIO_INVALID_HANDLE }
      ERROR_VIO_ILLEGAL_DURING_LOCK=437;    { MSG%none }
      ERROR_VIO_INVALID_LENGTH=438;    { MSG%VIO_INVALID_LENGTH }
      ERROR_KBD_INVALID_HANDLE=439;    { MSG%KBD_INVALID_HANDLE }
      ERROR_KBD_NO_MORE_HANDLE=440;    { MSG%KBD_NO_MORE_HANDLE }
      ERROR_KBD_CANNOT_CREATE_KCB=441; { MSG%KBD_CANNOT_CREATE_KCB }
      ERROR_KBD_CODEPAGE_LOAD_INCOMPL=442;    { MSG%KBD_CODEPAGE_LOAD_INCOMPL }
      ERROR_KBD_INVALID_CODEPAGE_ID=443;    { MSG%KBD_INVALID_CODEPAGE_ID }
      ERROR_KBD_NO_CODEPAGE_SUPPORT=444;    { MSG%KBD_NO_CODEPAGE_SUPPORT }
      ERROR_KBD_FOCUS_REQUIRED=445;    { MSG%KBD_FOCUS_REQUIRED }
      ERROR_KBD_FOCUS_ALREADY_ACTIVE=446;    { MSG%KBD_FOCUS_ALREADY_ACTIVE }
      ERROR_KBD_KEYBOARD_BUSY =447;    { MSG%KBD_KEYBOARD_BUSY }
      ERROR_KBD_INVALID_CODEPAGE=448;  { MSG%KBD_INVALID_CODEPAGE }
      ERROR_KBD_UNABLE_TO_FOCUS=449;   { MSG%KBD_UNABLE_TO_FOCUS }
      ERROR_SMG_SESSION_NON_SELECT=450;{ MSG%SMG_SESSION_NON_SELECT }
      ERROR_SMG_SESSION_NOT_FOREGRND=451;    { MSG%SMG_SESSION_NOT_FOREGRND }
      ERROR_SMG_SESSION_NOT_PARENT=452;    { MSG%SMG_SESSION_NOT_PARENT }
      ERROR_SMG_INVALID_START_MODE=453;    { MSG%SMG_INVALID_START_MODE }
      ERROR_SMG_INVALID_RELATED_OPT=454;{ MSG%SMG_INVALID_RELATED_OPT }
      ERROR_SMG_INVALID_BOND_OPTION=455;    { MSG%SMG_INVALID_BOND_OPTION }
      ERROR_SMG_INVALID_SELECT_OPT=456;{ MSG%SMG_INVALID_SELECT_OPT }
      ERROR_SMG_START_IN_BACKGROUND=457;{ MSG%SMG_START_IN_BACKGROUND }
      ERROR_SMG_INVALID_STOP_OPTION=458;{ MSG%SMG_INVALID_STOP_OPTION }
      ERROR_SMG_BAD_RESERVE   =459;    { MSG%SMG_BAD_RESERVE }
      ERROR_SMG_PROCESS_NOT_PARENT=460;{ MSG%SMG_PROCESS_NOT_PARENT }
      ERROR_SMG_INVALID_DATA_LENGTH=461;    { MSG%SMG_INVALID_DATA_LENGTH }
      ERROR_SMG_NOT_BOUND     =462;    { MSG%SMG_NOT_BOUND }
      ERROR_SMG_RETRY_SUB_ALLOC=463;   { MSG%SMG_RETRY_SUB_ALLOC }
      ERROR_KBD_DETACHED      =464;    { MSG%KBD_DETACHED }
      ERROR_VIO_DETACHED      =465;    { MSG%VIO_DETACHED }
      ERROR_MOU_DETACHED      =466;    { MSG%MOU_DETACHED }
      ERROR_VIO_FONT          =467;    { MSG%VIO_FONT }
      ERROR_VIO_USER_FONT     =468;    { MSG%VIO_USER_FONT }
      ERROR_VIO_BAD_CP        =469;    { MSG%VIO_BAD_CP }
      ERROR_VIO_NO_CP         =470;    { MSG%none }
      ERROR_VIO_NA_CP         =471;    { MSG%VIO_NA_CP }
      ERROR_INVALID_CODE_PAGE =472;    { MSG%none }
      ERROR_CPLIST_TOO_SMALL  =473;    { MSG%none }
      ERROR_CP_NOT_MOVED      =474;    { MSG%none }
      ERROR_MODE_SWITCH_INIT  =475;    { MSG%none }
      ERROR_CODE_PAGE_NOT_FOUND=476;   { MSG%none }
      ERROR_UNEXPECTED_SLOT_RETURNED=477;    { MSG%none }
      ERROR_SMG_INVALID_TRACE_OPTION=478;    { MSG%SMG_INVALID_TRACE_OPTION }
      ERROR_VIO_INTERNAL_RESOURCE=479; { MSG%none }
      ERROR_VIO_SHELL_INIT    =480;    { MSG%VIO_SHELL_INIT }
      ERROR_SMG_NO_HARD_ERRORS=481;    { MSG%SMG_NO_HARD_ERRORS }
      ERROR_CP_SWITCH_INCOMPLETE=482;  { MSG%none }
      ERROR_VIO_TRANSPARENT_POPUP=483; { MSG%VIO_TRANSPARENT_POPUP }
      ERROR_CRITSEC_OVERFLOW  =484;    { MSG%none }
      ERROR_CRITSEC_UNDERFLOW =485;    { MSG%none }
      ERROR_VIO_BAD_RESERVE   =486;    { MSG%VIO_BAD_RESERVE }
      ERROR_INVALID_ADDRESS   =487;    { MSG%INVALID_ADDRESS }
      ERROR_ZERO_SELECTORS_REQUESTED=488;    { MSG%ZERO_SELECTORS_REQUESTED }
      ERROR_NOT_ENOUGH_SELECTORS_AVA=489;    { MSG%NOT_ENOUGH_SELECTORS_AVA }
      ERROR_INVALID_SELECTOR  =490;    { MSG%INVALID_SELECTOR }
      ERROR_SMG_INVALID_PROGRAM_TYPE=491;    { MSG%SMG_INVALID_PROGRAM_TYPE }
      ERROR_SMG_INVALID_PGM_CONTROL=492;    { MSG%SMG_INVALID_PGM_CONTROL }
      ERROR_SMG_INVALID_INHERIT_OPT=493;    { MSG%SMG_INVALID_INHERIT_OPT }
      ERROR_VIO_EXTENDED_SG   =494;    { MSG%VIO_EXTENDED_SG }
      ERROR_VIO_NOT_PRES_MGR_SG=495;   { MSG%VIO_NOT_PRES_MGR_SG }
      ERROR_VIO_SHIELD_OWNED  =496;    { MSG%VIO_SHIELD_OWNED }
      ERROR_VIO_NO_MORE_HANDLES=497;   { MSG%VIO_NO_MORE_HANDLES }
      ERROR_VIO_SEE_ERROR_LOG =498;    { MSG%none }
      ERROR_VIO_ASSOCIATED_DC =499;    { MSG%none }
      ERROR_KBD_NO_CONSOLE    =500;    { MSG%KBD_NO_CONSOLE }
      ERROR_MOUSE_NO_CONSOLE  =501;    { MSG%DOS_STOPPED }
      ERROR_MOUSE_INVALID_HANDLE=502;  { MSG%MOUSE_INVALID_HANDLE }
      ERROR_SMG_INVALID_DEBUG_PARMS=503;{ MSG%SMG_INVALID_DEBUG_PARMS }
      ERROR_KBD_EXTENDED_SG   =504;    { MSG%KBD_EXTENDED_SG }
      ERROR_MOU_EXTENDED_SG   =505;    { MSG%MOU_EXTENDED_SG }
      ERROR_SMG_INVALID_ICON_FILE=506; { MSG%none }
      ERROR_TRC_PID_NON_EXISTENT=507;  { MSG%TRC_PID_NON_EXISTENT }
      ERROR_TRC_COUNT_ACTIVE  =508;    { MSG%TRC_COUNT_ACTIVE }
      ERROR_TRC_SUSPENDED_BY_COUNT=509;{ MSG%TRC_SUSPENDED_BY_COUNT }
      ERROR_TRC_COUNT_INACTIVE=510;    { MSG%TRC_COUNT_INACTIVE }
      ERROR_TRC_COUNT_REACHED =511;    { MSG%TRC_COUNT_REACHED }
      ERROR_NO_MC_TRACE       =512;    { MSG%NO_MC_TRACE }
      ERROR_MC_TRACE          =513;    { MSG%MC_TRACE }
      ERROR_TRC_COUNT_ZERO    =514;    { MSG%TRC_COUNT_ZERO }
      ERROR_SMG_TOO_MANY_DDS  =515;    { MSG%SMG_TOO_MANY_DDS }
      ERROR_SMG_INVALID_NOTIFICATION=516;    { MSG%SMG_INVALID_NOTIFICATION }
      ERROR_LF_INVALID_FUNCTION=517;   { MSG%LF_INVALID_FUNCTION }
      ERROR_LF_NOT_AVAIL      =518;    { MSG%LF_NOT_AVAIL }
      ERROR_LF_SUSPENDED      =519;    { MSG%LF_SUSPENDED }
      ERROR_LF_BUF_TOO_SMALL  =520;    { MSG%LF_BUF_TOO_SMALL }
      ERROR_LF_BUFFER_CORRUPTED=521;   { MSG%none }
      ERROR_LF_BUFFER_FULL    =521;    { MSG%LF_BUF_FULL }
      ERROR_LF_INVALID_DAEMON =522;    { MSG%none }
      ERROR_LF_INVALID_RECORD =522;    { MSG%LF_INVAL_RECORD }
      ERROR_LF_INVALID_TEMPL  =523;    { MSG%none }
      ERROR_LF_INVALID_SERVICE=523;    { MSG%LF_INVAL_SERVICE }
      ERROR_LF_GENERAL_FAILURE=524;    { MSG%LF_GENERAL_FAILURE }
      ERROR_LF_INVALID_ID     =525;    { MSG%HPFS_DISK_ALREADY_INUSE }
      ERROR_LF_INVALID_HANDLE =526;    { MSG%HPFS_CANNOT_FORMAT_DISK }
      ERROR_LF_NO_ID_AVAIL    =527;    { MSG%HPFS_CANNOT_COPY_SYS_DATA }
      ERROR_LF_TEMPLATE_AREA_FULL=528; { MSG%HPFS_FORMAT_NOT_DONE }
      ERROR_LF_ID_IN_USE      =529;    { MSG%HPFS_FMT_NOT_ENOUGH_MEM }
      ERROR_MOU_NOT_INITIALIZED=530;   { MSG%HPFS_SPECIFY_FIXDSK }
      ERROR_MOUINITREAL_DONE  =531;    { MSG%HPFS_SPECIFY_ONE_DRIVE }
      ERROR_DOSSUB_CORRUPTED  =532;    { MSG%HPFS_UNKNOWN_ERR_NO_FORMAT }
      ERROR_MOUSE_CALLER_NOT_SUBSYS=533;    { MSG%HPFS_SYNTAX_HELP }
      ERROR_ARITHMETIC_OVERFLOW=534;   { MSG%HPFS_DISK_FORMATING }
      ERROR_TMR_NO_DEVICE     =535;    { MSG%HPFS_AVAIL_DISK_SPACE }
      ERROR_TMR_INVALID_TIME  =536;    { MSG%HPFS_BAD_BLOCKS }
      ERROR_PVW_INVALID_ENTITY=537;    { MSG%HPFS_DISK_SPACE_AVAIL }
      ERROR_PVW_INVALID_ENTITY_TYPE=538;    { MSG%HPFS_SPACE_FORMATTED }
      ERROR_PVW_INVALID_SPEC  =539;    { MSG%HPFS_TYPE_CUR_VOLUME_LABEL }
      ERROR_PVW_INVALID_RANGE_TYPE=540;{ MSG%HPFS_DRIVER_NOT_LOADED }
      ERROR_PVW_INVALID_COUNTER_BLK=541;    { MSG%HPFS_DRIVER_LOADER }
      ERROR_PVW_INVALID_TEXT_BLK=542;  { MSG%HPFS_CACHE_BUF_SPECIFIED }
      ERROR_PRF_NOT_INITIALIZED=543;   { MSG%HPFS_CHKDSK_PARM_ERROR }
      ERROR_PRF_ALREADY_INITIALIZED=544;    { MSG%HPFS_CHKDSK_NOACCESS_DRIVE }
      ERROR_PRF_NOT_STARTED   =545;    { MSG%HPFS_UNKNOWN_ERR_NO_CHKDSK }
      ERROR_PRF_ALREADY_STARTED=546;   { MSG%HPFS_CHKDSK_NOT_ENOUGH_MEM }
      ERROR_PRF_TIMER_OUT_OF_RANGE=547;{ MSG%HPFS_CHKDSK_NOWRITEODATA }
      ERROR_PRF_TIMER_RESET   =548;    { MSG%HPFS_CHKDSK_NORECOVER_DATA }
{                                      =549%msg%HPFS_CHKDSK_NO_PARM_SPACE }
{                                      =550%msg%HPFS_CHKDSK_NORECOGNIZE }
{                                      =551%msg%HPFS_CHKDSK_NOROOT_FIND }
{                                      =552%msg%HPFS_CHKDSK_NOFIX_FS_ERROR }
{                                      =553%msg%HPFS_CHKDSK_CORRECT_FS_ERR }
{                                      =554%msg%HPFS_CHKDSK_ORGAN_FIX }
{                                      =555%msg%HPFS_CHKDSK_RELOC_BBPDATA }
{                                      =556%msg%HPFS_CHKDSK_REM_CORRU_BLOC }
{                                      =557%msg%HPFS_CHKDSK_REM_CORRUP_FIL }
{                                      =558%msg%HPFS_CHKDSK_FIX_SPACE_ALLO }
{                                      =559%msg%HPFS_NOT_FORMATTED_DISK }
{                                      =560%msg%HPFS_CHKDSK_COR_ALLOC }
{                                      =561%msg%HPFS_CHKDSK_SEARC_UNALLOC }
{                                      =562%msg%HPFS_CHKDSK_DET_LOST_DATA }
{                                      =563%msg%HPFS_CHKDSK_PERCENT_SEARC }
{                                      =564%msg%HPFS_CHKDSK_LOST_DATASEARC }
{                                      =565%msg%HPFS_CHKDSK_CRIT_NOREAD }
{                                      =566%msg%HPFS_CHKDSK_DISK_INUSE }
{                                      =567%msg%HPFS_CHKDSK_RECOVTEMP_RELOC }
{                                      =568%msg%HPFS_TOTAL_DISK_SPACE }
{                                      =569%msg%HPFS_DIR_KBYTES }
{                                      =570%msg%HPFS_FILE_KBYTES }
{                                      =571%msg%HPFS_KBYTES_AVAILABLE }
{                                      =572%msg%HPFS_CHKDSK_PLACE_REC_FILE }
{                                      =573%msg%HPFS_CHKDSK_RECO_DIR_AS }
{                                      =574%msg%HPFS_CHKDSK_PLACEED_DATA }
{                                      =575%msg%HPFS_CHKDSK_RECOV_EA }
{                                      =576%msg%HPFS_CHKDSK_FIND_EA_INTEM }
{                                      =577%msg%HPFS_CHKDSK_RELOC_TEMP_EA }
{                                      =578%msg%HPFS_CHKDSK_RELOC_AC_LIST }
{                                      =579%msg%HPFS_CHKDSK_LIST_NORELOC }
{                                      =580%msg%HPFS_CHKDSK_TRUN_EA_LIST }
{                                      =581%msg%HPFS_CHKDSK_TRUN_EA_NAME }
{                                      =582%msg%HPFS_CHKDSK_TRUN_EA_BBLOCK }
{                                      =583%msg%HPFS_CHKDSK_REM_INVALID_EA }
{                                      =584%msg%HPFS_CHKDSK_FIX_EA_ALLOC }
{                                      =585%msg%HPFS_CHKDSK_FIX_ALACCCTRL }
{                                      =586%msg%HPFS_CHKDSK_ACCTR_LIST_BBL }
{                                      =587%msg%HPFS_CHKDSK_REM_ACLIST }
{                                      =588%msg%HPFS_CHKDSK_FOUND_DATANORL }
{                                      =589%msg%HPFS_WRONG_VERSION }
{                                      =590%msg%HPFS_CHKDSK_FOUND_DATATEMP }
{                                      =591%msg%HPFS_CHKDSK_FIX_TEMPSTATUS }
{                                      =592%msg%HPFS_CHKDSK_FIX_NEEDEADATA }
{                                      =593%msg%HPFS_RECOVER_PARM_ERROR }
{                                      =594%msg%HPFS_RECOV_FILE_NOT_FOUND }
{                                      =595%msg%HPFS_RECOV_UNKNOWN_ERROR }
{                                      =596%msg%HPFS_RECOV_NOT_ENOUGH_MEM }
{                                      =597%msg%HPFS_RECOV_NOWRITE_DATA }
{                                      =598%msg%HPFS_RECOV_NOTEMP_CREATE }
{                                      =599%msg%HPFS_RECOV_EA_NOREAD }
{                                      =600%msg%HPFS_RECOV_FILE_BYTES }
{                                      =601%msg%HPFS_RECOV_BAD_BYTES_RECOV }
{                                      =602%msg%HPFS_RECOV_FILEBYTES_NOREC }
{                                      =603%msg%HPFS_RECOV_DISK_INUSE }
{                                      =604%msg%HPFS_RECOV_FILE_NODELETE }
{                                      =605%msg%HPFS_RECOV_NOCREATE_NEWFILE }
{                                      =606%msg%HPFS_RECOV_SYSTEM_ERROR }
{                                      =607%msg%HPFS_SYS_PARM_ERROR }
{                                      =608%msg%HPFS_SYS_CANNOT_INSTALL }
{                                      =609%msg%HPFS_SYS_DRIVE_NOTFORMATED }
{                                      =610%msg%HPFS_SYS_FILE_NOCREATE }
{                                      =611%msg%HPFS_SIZE_EXCEED }
{                                      =612%msg%HPFS_SYNTAX_ERR }
{                                      =613%msg%HPFS_NOTENOUGH_MEM }
{                                      =614%msg%HPFS_WANT_MEM }
{                                      =615%msg%HPFS_GET_RETURNED }
{                                      =616%msg%HPFS_SET_RETURNED }
{                                      =617%msg%HPFS_BOTH_RETURNED }
{                                      =618%msg%HPFS_STOP_RETURNED }
{                                      =619%msg%HPFS_SETPRTYRETURNED }
{                                      =620%msg%HPFS_ALCSG_RETURNED }
{                                      =621%msg%HPFS_MSEC_SET }
{                                      =622%msg%HPFS_OPTIONS }
{                                      =623%msg%HPFS_POS_NUM_VALUE }
{                                      =624%msg%HPFS_VALUE_TOO_LARGE }
{                                      =625%msg%HPFS_LAZY_NOT_VALID }
{                                      =626%msg%HPFS_VOLUME_ERROR }
{                                      =627%msg%HPFS_VOLUME_DIRTY }
{                                      =628%msg%HPFS_NEW_SECTOR }
{                                      =629%msg%HPFS_FORMAT_PARM_ERROR }
{                                      =630%msg%HPFS_CANNOT_ACCESS_CONFIG }
{                                      =631%msg%HPFS_RECOV_FILE }
{                                      =632%msg%HPFS_CHKDSK_KBYTES_RESERVE }
{                                      =633%msg%HPFS_CHKDSK_KBYTES_IN_EA }
{                                      =634%msg%HPFS_BYTEBUF_SET }
{                                      =635%msg%HPFS_FORMATTING_COMPLETE }
{                                      =636%msg%HPFS_WRONG_VOLUME_LABEL }
{                                      =637%msg%HPFS_FMAT_TOO_MANY_DRS }
{                                      =638%msg%VDD_UNSUPPORTED_ACCESS }
      ERROR_VDD_LOCK_USEAGE_DENIED=639;{ KP.COM not supported in DOS }
      ERROR_TIMEOUT           =640;    { MSG%none }
      ERROR_VDM_DOWN          =641;    { MSG%none }
      ERROR_VDM_LIMIT         =642;    { MSG%none }
      ERROR_VDD_NOT_FOUND     =643;    { MSG%none }
      ERROR_INVALID_CALLER    =644;    { MSG%none }
      ERROR_PID_MISMATCH      =645;    { MSG%none }
      ERROR_INVALID_VDD_HANDLE=646;    { MSG%none }
      ERROR_VLPT_NO_SPOOLER   =647;    { MSG%none }
      ERROR_VCOM_DEVICE_BUSY  =648;    { MSG%none }
      ERROR_VLPT_DEVICE_BUSY  =649;    { MSG%none }
      ERROR_NESTING_TOO_DEEP  =650;    { MSG%none }
      ERROR_VDD_MISSING       =651;    { MSG%VDD_MISSING }

{ INVALID BIDI API PARAMETERS 671;- 684;no msg's required }

      ERROR_BIDI_INVALID_LENGTH       =671;   { MSG%none }
      ERROR_BIDI_INVALID_INCREMENT    =672;   { MSG%none }
      ERROR_BIDI_INVALID_COMBINATION  =673;   { MSG%none }
      ERROR_BIDI_INVALID_RESERVED     =674;   { MSG%none }
      ERROR_BIDI_INVALID_EFFECT       =675;   { MSG%none }
      ERROR_BIDI_INVALID_CSDREC       =676;   { MSG%none }
      ERROR_BIDI_INVALID_CSDSTATE     =677;   { MSG%none }
      ERROR_BIDI_INVALID_LEVEL        =678;   { MSG%none }
      ERROR_BIDI_INVALID_TYPE_SUPPORT =679;   { MSG%none }
      ERROR_BIDI_INVALID_ORIENTATION  =680;   { MSG%none }
      ERROR_BIDI_INVALID_NUM_SHAPE    =681;   { MSG%none }
      ERROR_BIDI_INVALID_CSD          =682;   { MSG%none }
      ERROR_BIDI_NO_SUPPORT           =683;   { MSG%none }
      NO_ERROR_BIDI_RW_INCOMPLETE     =684;   { MSG%none }

{                                             =689%msg%HPFS_LAZY_ON }
{                                             =690%msg%HPFS_LAZY_OFF }
      ERROR_IMP_INVALID_PARM          =691;    { MSG%none }
      ERROR_IMP_INVALID_LENGTH        =692;    { MSG%none }
      MSG_HPFS_DISK_ERROR_WARN        =693;    { MSG%HPFS_DISK_ERROR_WARN }
      ERROR_MON_BAD_BUFFER            =730;    { MSG%BAD_MON_BUFFER }

      ERROR_MODULE_CORRUPTED           =731;    { MSG%MODULE_CORRUPTED }

      ERROR_SM_OUTOF_SWAPFILE          =1477;  { MSG%SM_OUT_OF_SWAFILE }

      ERROR_LF_TIMEOUT                 =2055;  { MSG%LF_TIMEOUT }
      ERROR_LF_SUSPEND_SUCCESS         =2057;  { MSG%LF_SUSP_SUCCESS }
      ERROR_LF_RESUME_SUCCESS          =2058;  { MSG%LF_RESUM_SUCCESS }
      ERROR_LF_REDIRECT_SUCCESS        =2059;  { MSG%LF_REDIR_SUCCESS }
      ERROR_LF_REDIRECT_FAILURE        =2060;  { MSG%LF_REDIR_FAILURE }


      ERROR_SWAPPER_NOT_ACTIVE        =32768;
      ERROR_INVALID_SWAPID            =32769;
      ERROR_IOERR_SWAP_FILE           =32770;
      ERROR_SWAP_TABLE_FULL           =32771;
      ERROR_SWAP_FILE_FULL            =32772;
      ERROR_CANT_INIT_SWAPPER         =32773;
      ERROR_SWAPPER_ALREADY_INIT      =32774;
      ERROR_PMM_INSUFFICIENT_MEMORY   =32775;
      ERROR_PMM_INVALID_FLAGS         =32776;
      ERROR_PMM_INVALID_ADDRESS       =32777;
      ERROR_PMM_LOCK_FAILED           =32778;
      ERROR_PMM_UNLOCK_FAILED         =32779;
      ERROR_PMM_MOVE_INCOMPLETE       =32780;
      ERROR_UCOM_DRIVE_RENAMED        =32781;
      ERROR_UCOM_FILENAME_TRUNCATED   =32782;
      ERROR_UCOM_BUFFER_LENGTH        =32783;
      ERROR_MON_CHAIN_HANDLE          =32784;
      ERROR_MON_NOT_REGISTERED        =32785;
      ERROR_SMG_ALREADY_TOP           =32786;
      ERROR_PMM_ARENA_MODIFIED        =32787;
      ERROR_SMG_PRINTER_OPEN          =32788;
      ERROR_PMM_SET_FLAGS_FAILED      =32789;
      ERROR_INVALID_DOS_DD            =32790;
      ERROR_BLOCKED                   =32791;
      ERROR_NOBLOCK                   =32792;
      ERROR_INSTANCE_SHARED           =32793;
      ERROR_NO_OBJECT                 =32794;
      ERROR_PARTIAL_ATTACH            =32795;
      ERROR_INCACHE                   =32796;
      ERROR_SWAP_IO_PROBLEMS          =32797;
      ERROR_CROSSES_OBJECT_BOUNDARY   =32798;
      ERROR_LONGLOCK                  =32799;
      ERROR_SHORTLOCK                 =32800;
      ERROR_UVIRTLOCK                 =32801;
      ERROR_ALIASLOCK                 =32802;
      ERROR_ALIAS                     =32803;
      ERROR_NO_MORE_HANDLES           =32804;
      ERROR_SCAN_TERMINATED           =32805;
      ERROR_TERMINATOR_NOT_FOUND      =32806;
      ERROR_NOT_DIRECT_CHILD          =32807;
      ERROR_DELAY_FREE                =32808;
      ERROR_GUARDPAGE                 =32809;
      ERROR_SWAPERROR                 =32900;
      ERROR_LDRERROR                  =32901;
      ERROR_NOMEMORY                  =32902;
      ERROR_NOACCESS                  =32903;
      ERROR_NO_DLL_TERM               =32904;
      ERROR_CPSIO_CODE_PAGE_INVALID   =65026;
      ERROR_CPSIO_NO_SPOOLER          =65027;
      ERROR_CPSIO_FONT_ID_INVALID     =65028;
      ERROR_CPSIO_INTERNAL_ERROR      =65033;
      ERROR_CPSIO_INVALID_PTR_NAME    =65034;
      ERROR_CPSIO_NOT_ACTIVE          =65037;
      ERROR_CPSIO_PID_FULL            =65039;
      ERROR_CPSIO_PID_NOT_FOUND       =65040;
      ERROR_CPSIO_READ_CTL_SEQ        =65043;
      ERROR_CPSIO_READ_FNT_DEF        =65045;
      ERROR_CPSIO_WRITE_ERROR         =65047;
      ERROR_CPSIO_WRITE_FULL_ERROR    =65048;
      ERROR_CPSIO_WRITE_HANDLE_BAD    =65049;
      ERROR_CPSIO_SWIT_LOAD           =65074;
      ERROR_CPSIO_INV_COMMAND         =65077;
      ERROR_CPSIO_NO_FONT_SWIT        =65078;
      ERROR_ENTRY_IS_CALLGATE         =65079;

IMPLEMENTATION

BEGIN
END.
