/*
 * Decompiled with CFR 0.152.
 */
public class History {
    private SharpTools sharp;
    public static final int UNCHANGED = 0;
    public static final int INSERTROW = 1;
    public static final int INSERTCOLUMN = 2;
    public static final int REMOVEROW = 3;
    public static final int REMOVECOLUMN = 4;
    private ListNode current;

    History(SharpTools sharpTools) {
        this.sharp = sharpTools;
        this.current = new ListNode(null);
    }

    public void add(SharpTableModel sharpTableModel, CellRange cellRange) {
        SharpClipboard sharpClipboard = new SharpClipboard(sharpTableModel, cellRange, false);
        this.add(sharpTableModel, sharpClipboard);
    }

    public void add(SharpTableModel sharpTableModel, SharpClipboard sharpClipboard) {
        ListNode listNode = new ListNode(sharpClipboard);
        if (Debug.isDebug()) {
            Debug.println("Add history for range " + sharpClipboard.getSource());
        }
        this.current.setNext(listNode);
        listNode.setPrev(this.current);
        this.current = listNode;
        sharpTableModel.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public void add(SharpTableModel sharpTableModel, CellRange cellRange, int n) {
        ListNode listNode;
        if (n == 0) {
            this.add(sharpTableModel, cellRange);
            return;
        }
        if (n == 3 || n == 4) {
            SharpClipboard sharpClipboard = new SharpClipboard(sharpTableModel, cellRange, false);
            listNode = new ListNode(sharpClipboard);
        } else {
            listNode = new ListNode(cellRange);
        }
        listNode.setType(n);
        this.current.setNext(listNode);
        listNode.setPrev(this.current);
        this.current = listNode;
        sharpTableModel.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public void undo(SharpTableModel sharpTableModel) {
        CellRange cellRange;
        if (!this.isUndoable()) {
            return;
        }
        int n = this.current.getType();
        if (n == 0) {
            SharpClipboard sharpClipboard = (SharpClipboard)this.current.getObject();
            cellRange = sharpClipboard.getSource();
            SharpClipboard sharpClipboard2 = new SharpClipboard(sharpTableModel, cellRange, false);
            this.current.setObject(sharpClipboard2);
            sharpClipboard.paste(sharpTableModel, cellRange.getminCorner());
        } else if (n == 3 || n == 4) {
            SharpClipboard sharpClipboard = (SharpClipboard)this.current.getObject();
            cellRange = sharpClipboard.getSource();
            if (n == 3) {
                sharpTableModel.insertRow(cellRange);
            } else {
                sharpTableModel.insertColumn(cellRange);
            }
            sharpClipboard.paste(sharpTableModel, cellRange.getminCorner());
        } else {
            cellRange = (CellRange)this.current.getObject();
            if (n == 1) {
                sharpTableModel.removeRow(cellRange);
            } else {
                sharpTableModel.removeColumn(cellRange);
            }
        }
        this.current = this.current.getPrev();
        sharpTableModel.setSelection(cellRange);
        sharpTableModel.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public void redo(SharpTableModel sharpTableModel) {
        if (!this.isRedoable()) {
            return;
        }
        this.current = this.current.getNext();
        int n = this.current.getType();
        if (n == 0) {
            SharpClipboard sharpClipboard = (SharpClipboard)this.current.getObject();
            CellRange cellRange = sharpClipboard.getSource();
            SharpClipboard sharpClipboard2 = new SharpClipboard(sharpTableModel, cellRange, false);
            this.current.setObject(sharpClipboard2);
            sharpClipboard.paste(sharpTableModel, cellRange.getminCorner());
            sharpTableModel.setSelection(cellRange);
        } else if (n == 3 || n == 4) {
            SharpClipboard sharpClipboard = (SharpClipboard)this.current.getObject();
            CellRange cellRange = sharpClipboard.getSource();
            if (n == 3) {
                sharpTableModel.removeRow(cellRange);
            } else {
                sharpTableModel.removeColumn(cellRange);
            }
        } else {
            CellRange cellRange = (CellRange)this.current.getObject();
            if (n == 1) {
                sharpTableModel.insertRow(cellRange);
            } else {
                sharpTableModel.insertColumn(cellRange);
            }
        }
        sharpTableModel.setModified(true);
        this.sharp.checkUndoRedoState();
    }

    public boolean isUndoable() {
        return this.current.getPrev() != null;
    }

    public boolean isRedoable() {
        return this.current.getNext() != null;
    }

    class ListNode {
        private ListNode prev;
        private ListNode next;
        private int type;
        private Object obj;

        ListNode(Object object) {
            this.setObject(object);
        }

        Object getObject() {
            return this.obj;
        }

        ListNode getPrev() {
            return this.prev;
        }

        ListNode getNext() {
            return this.next;
        }

        void setObject(Object object) {
            this.obj = object;
        }

        void setPrev(ListNode listNode) {
            this.prev = listNode;
        }

        void setNext(ListNode listNode) {
            this.next = listNode;
        }

        int getType() {
            return this.type;
        }

        void setType(int n) {
            this.type = n;
        }
    }
}

