// Test program for the shaded button class

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include "Buttons.H"

MRESULT EXPENTRY ClientWndProc(HWND, ULONG, MPARAM, MPARAM);

int main() {
        static CHAR  szClientClass[] = "ButtonTest";
        static ULONG flFrameFlags= FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MINMAX | FCF_SHELLPOSITION | FCF_TASKLIST;
        HAB                                      hab;
        HMQ                                      hmq;
        HWND                             hWndFrame, hWndClient;
        QMSG                             qmsg;

        hab = WinInitialize(0);
        hmq = WinCreateMsgQueue(hab, 0);

        RegisterShadedButtonClass();
        WinRegisterClass(hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0);
        hWndFrame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &flFrameFlags, szClientClass, NULL, 0L, 0, 0, &hWndClient);

        while (WinGetMsg(hab, &qmsg, NULLHANDLE, 0, 0))
                WinDispatchMsg(hab, &qmsg);

        WinDestroyWindow(hWndFrame);
        WinDestroyMsgQueue(hmq);
        WinTerminate(hab);
        return 0;
}

MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
        static HWND hwndFrame, hwndButton[3];
        static INT      cxClient, cyClient, cyChar;
        static LONG ButtonWidth, ButtonHeight;
        FONTMETRICS fm;
        HAB                                     hab;
        HPS                                     hps;
        INT                                     id;
        RECTL                           rcl;

        switch(msg) {
                case WM_CREATE:
                        hab = WinQueryAnchorBlock(hwnd);
                        hwndFrame = WinQueryWindow(hwnd, QW_PARENT);
                        hps = WinGetPS(hwnd);
                        GpiQueryFontMetrics(hps, sizeof(fm),&fm);
                        cyChar = fm.lMaxBaselineExt;
                        WinReleasePS(hps);
// Buttons should be big enough to hold the pointer, with a 4 pixel border
                        ButtonWidth = WinQuerySysValue(HWND_DESKTOP, SV_CXPOINTER) + 4;
                        ButtonHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYPOINTER) + 4;
                        hwndButton[0] = WinCreateWindow(hwnd, SHADEDBTNCLASS, "100", WS_VISIBLE | GBT_NORIGHTLINE | GBT_GRAPHIC, 0, 0, ButtonWidth, ButtonHeight, hwnd, HWND_BOTTOM, 0, NULL, NULL);
                        hwndButton[1] = WinCreateWindow(hwnd, SHADEDBTNCLASS, "101", WS_VISIBLE | GBT_NOLEFTLINE | GBT_GRAPHIC, 0, 0, ButtonWidth, ButtonHeight, hwnd, HWND_BOTTOM, 1, NULL, NULL);
// This is the status bar
                        hwndButton[2] = WinCreateWindow(hwnd, SHADEDBTNCLASS, "Status Bar", WS_VISIBLE | GBT_NOPUSH, 0, 0, 0, cyChar * 5 / 4, hwnd, HWND_BOTTOM, 2, NULL, NULL);
                        return 0;
                case WM_SIZE:
                        cxClient = SHORT1FROMMP(mp2);
                        cyClient = SHORT2FROMMP(mp2);
// Conter the buttons
                        for(id = 0; id < 2; id++)
                                WinSetWindowPos(hwndButton[id], NULLHANDLE, (cxClient >> 1) + ButtonWidth * (id - 1), (cyClient - ButtonHeight) >> 1, 0, 0, SWP_MOVE);
// make the status bar span the width of the window
                        WinSetWindowPos(hwndButton[2], NULLHANDLE, 0, 0, cxClient, cyChar * 5 / 4, SWP_SIZE);
                        return 0;
                case WM_COMMAND:
                        WinQueryWindowRect(hwnd, &rcl);
                        WinMapWindowPoints(hwnd, HWND_DESKTOP, (PPOINTL) &rcl, 2);

                        switch(COMMANDMSG(&msg)->cmd) {
                                case 0: // "Smaller"
                                        rcl.xLeft               += cxClient / 20;
                                        rcl.xRight      -= cxClient / 20;
                                        rcl.yBottom += cyClient / 20;
                                        rcl.yTop                -= cyClient / 20;
// Disable "Smaller" button if window is too small for the buttons
                                        if (((359 * cxClient / 400) < (2 * ButtonWidth)) || ((359  * cyClient / 400) < (ButtonHeight + 5 / 2 * cyChar)))
                                                WinEnableWindow(hwndButton[0], FALSE);
                                        break;
                                case 1: // "Larger"
                                        rcl.xLeft               -= cxClient / 20;
                                        rcl.xRight      += cxClient / 20;
                                        rcl.yBottom -= cyClient / 20;
                                        rcl.yTop                += cyClient / 20;
// Enable "Smaller" button if it was disabled
                                        if (!WinIsWindowEnabled(hwndButton[0]))
                                                WinEnableWindow(hwndButton[0], TRUE);
                                        break;
                        }
                        WinCalcFrameRect(hwndFrame, &rcl, FALSE);
                        WinSetWindowPos(hwndFrame, NULLHANDLE, rcl.xLeft, rcl.yBottom, rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom, SWP_MOVE | SWP_SIZE);
                        return 0;
                case WM_ERASEBACKGROUND:
                        hps = WinGetPS(hwnd);
                        WinQueryWindowRect(hwnd, &rcl);
                        WinFillRect(hps, &rcl, CLR_PALEGRAY);
                        WinReleasePS(hps);
                        return 0;
        }
        return WinDefWindowProc(hwnd, msg, mp1, mp2);
}
