/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Detective;
import game.Fugitive;
import game.Link;
import game.Move;
import game.Node;
import game.Transport;
import i18n.I18n;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;

public class TestBoard
implements Transport,
Comparator<Object>,
Comparable<Object> {
    private static final int NO_OF_MOVES = 23;
    private static final int NO_OF_DETECTIVES = 5;
    private static final int CHECK_POINTS = 5;
    private static final int INF = 100;
    private static final int WIN = 200;
    private static final int LOSE = -200;
    private static final int NBEST = 1000000000;
    private static final int BLACK_TICKETS = 5;
    private static int DEPTH = 2;
    private static int[][] shortestDistance;
    private static Node[] nodes;
    private static Point[] nodePositions;
    private static int[] checkPoints;
    private static int noOfNodes;
    private int currentMoves;
    private Detective[] detectives;
    private Fugitive MrX;

    TestBoard() {
        int i;
        this.currentMoves = 0;
        checkPoints = new int[5];
        int i2 = 0;
        while (i2 < 5) {
            TestBoard.checkPoints[i2] = 3 + 5 * i2;
            ++i2;
        }
        this.readFile();
        this.readPosFile();
        this.detectives = new Detective[5];
        int partition = nodes.length / 5 - 1;
        int part = 1;
        int i3 = 0;
        while (i3 < 5) {
            int rnd = (int)((double)partition * Math.random());
            int pos = rnd + part;
            this.detectives[i3] = new Detective(nodes[pos]);
            part += partition;
            ++i3;
        }
        int xPos = 0;
        boolean done = true;
        do {
            xPos = 1 + (int)((double)noOfNodes * Math.random());
            i = 0;
            while (i < 5) {
                if (xPos == this.detectives[i].getPosition().getPosition()) {
                    done = false;
                }
                ++i;
            }
        } while (!done);
        this.MrX = new Fugitive(nodes[xPos]);
        this.MrX.setBlackTickets(5);
        shortestDistance = new int[nodes.length][nodes.length];
        i = 0;
        while (i < nodes.length) {
            int j = 0;
            while (j < nodes.length) {
                TestBoard.shortestDistance[i][j] = this.weight(nodes[i], nodes[j]);
                ++j;
            }
            ++i;
        }
        shortestDistance = this.getShortestDistanceMatrix(shortestDistance, 1);
    }

    private TestBoard(TestBoard board) {
        this.currentMoves = board.currentMoves;
        this.detectives = new Detective[board.detectives.length];
        int i = 0;
        while (i < this.detectives.length) {
            this.detectives[i] = new Detective(board.detectives[i]);
            ++i;
        }
        Node n = board.MrX.getPosition();
        this.MrX = new Fugitive(n);
    }

    public void setDepth(int d) {
        DEPTH = d;
    }

    private void readFile() {
        String fileName = "./SCOTMAP.TXT";
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                throw new IOException();
            }
            RandomAccessFile map = new RandomAccessFile(f, "r");
            String buffer = map.readLine();
            StringTokenizer token = new StringTokenizer(buffer);
            noOfNodes = Integer.parseInt(token.nextToken());
            nodes = new Node[noOfNodes];
            int i = 0;
            while (i < nodes.length) {
                TestBoard.nodes[i] = new Node(i);
                ++i;
            }
            int lks = Integer.parseInt(token.nextToken());
            int i2 = 0;
            while (i2 < lks) {
                buffer = map.readLine();
                token = new StringTokenizer(buffer);
                int node1 = Integer.parseInt(token.nextToken());
                int node2 = Integer.parseInt(token.nextToken());
                String strType = token.nextToken();
                int type = 100;
                if (strType.equals("T")) {
                    type = 1;
                }
                if (strType.equals("B")) {
                    type = 2;
                }
                if (strType.equals("U")) {
                    type = 3;
                }
                if (strType.equals("F")) {
                    type = 50;
                }
                nodes[node1].addLink(nodes[node2], type);
                nodes[node2].addLink(nodes[node1], type);
                ++i2;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, I18n.tr("ErrorFileNotFound", fileName), I18n.tr("ErrorTitle"), 0);
            System.exit(1);
        }
    }

    private void readPosFile() {
        String fileName = "./SCOTPOS.TXT";
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                throw new IOException();
            }
            RandomAccessFile map = new RandomAccessFile(f, "r");
            String buffer = map.readLine();
            StringTokenizer token = new StringTokenizer(buffer);
            noOfNodes = Integer.parseInt(token.nextToken());
            nodePositions = new Point[noOfNodes];
            int i = 0;
            while (i < noOfNodes) {
                buffer = map.readLine();
                token = new StringTokenizer(buffer);
                int node = Integer.parseInt(token.nextToken());
                int x = Integer.parseInt(token.nextToken());
                int y = Integer.parseInt(token.nextToken());
                TestBoard.nodePositions[node] = new Point(x, y);
                ++i;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, I18n.tr("ErrorFileNotFound", fileName), I18n.tr("ErrorTitle"), 0);
            System.exit(1);
        }
    }

    public void printBoard() {
        int i = 0;
        while (i < nodes.length) {
            System.out.print("\nNode:" + nodes[i].getPosition() + "\t");
            Link[] links = nodes[i].getLinks();
            int j = 0;
            while (j < links.length) {
                Node to = links[j].getToNode();
                System.out.print("\t" + to.getPosition());
                System.out.println("\t" + links[j].getType());
                ++j;
            }
            ++i;
        }
    }

    private int weight(Node x, Node y) {
        if (x.equals(y)) {
            return 0;
        }
        int weight = 100;
        Link[] lk = x.getLinks();
        int i = 0;
        while (i < lk.length) {
            Node n = lk[i].getToNode();
            if (n.equals(y)) {
                weight = lk[i].getType();
            }
            ++i;
        }
        if (weight != 100 && weight != 50) {
            weight = 1;
        }
        return weight;
    }

    private int[][] getShortestDistanceMatrix(int[][] mat, int k) {
        if (k == nodes.length - 1) {
            return mat;
        }
        int[][] newMat = new int[nodes.length][nodes.length];
        int i = 0;
        while (i < nodes.length) {
            int j = 0;
            while (j < nodes.length) {
                newMat[i][j] = Math.min(mat[i][j], mat[i][k] + mat[k][j]);
                ++j;
            }
            ++i;
        }
        return this.getShortestDistanceMatrix(newMat, ++k);
    }

    public void test() {
        int i = 0;
        while (i < nodes.length) {
            int j = 0;
            while (j < nodes.length) {
                System.out.println("Weight function for " + i + " " + j + " = " + shortestDistance[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public static int getNumberOfDetectives() {
        return 5;
    }

    private boolean isLegalMove(Link l) {
        if (l.getType() == 50 && this.MrX.getBlackTickets() <= 0) {
            return false;
        }
        boolean canMove = true;
        int i = 0;
        while (i < this.detectives.length) {
            Node n = this.detectives[i].getPosition();
            if (n.getPosition() == l.getToNode().getPosition()) {
                canMove = false;
            }
            ++i;
        }
        return canMove;
    }

    public TreeSet<Move> getDetectivePossibleMoves(int i) {
        return this.detectives[i].getPossibleMoves(this);
    }

    public void changeDetectivePosition(int i, Move move) {
        this.detectives[i].changePosition(nodes[move.getNode()], move.getType());
    }

    public boolean isMachineWin() {
        boolean noneCanMove = true;
        int i = 0;
        while (i < 5) {
            if (this.detectives[i].canMove(this)) {
                noneCanMove = false;
            }
            ++i;
        }
        return this.currentMoves == 23 || noneCanMove;
    }

    public boolean isUserWin() {
        Link[] xLinks = this.MrX.getPosition().getLinks();
        boolean isBlocked = true;
        int i = 0;
        while (i < xLinks.length) {
            Node xNode = xLinks[i].getToNode();
            boolean thisIsOccupied = false;
            int j = 0;
            while (j < 5) {
                Node dNode = this.detectives[j].getPosition();
                if (dNode.equals(xNode)) {
                    thisIsOccupied = true;
                }
                ++j;
            }
            if (!thisIsOccupied) {
                isBlocked = false;
            }
            ++i;
        }
        boolean isCaptured = false;
        int i2 = 0;
        while (i2 < 5) {
            Node detNode = this.detectives[i2].getPosition();
            if (detNode.equals(this.MrX.getPosition())) {
                isCaptured = true;
            }
            ++i2;
        }
        return isBlocked || isCaptured;
    }

    private Node randomMove() {
        Node n;
        Node toNode = n = this.MrX.getPosition();
        Link[] lk = n.getLinks();
        boolean done = false;
        while (!done) {
            int rnd = (int)((double)lk.length * Math.random());
            if (!this.isLegalMove(lk[rnd])) continue;
            done = true;
        }
        return toNode;
    }

    private Node bestMove(AtomicBoolean useBlackTicket) {
        Node n = this.MrX.getPosition();
        Link[] lk = n.getLinks();
        int[] score = new int[lk.length];
        Node[] possibleNodes = new Node[lk.length];
        int legalMoves = 0;
        int beta = -200;
        int i = 0;
        while (i < lk.length) {
            if (this.isLegalMove(lk[i])) {
                if (legalMoves > 0 && beta < score[legalMoves - 1]) {
                    beta = score[legalMoves - 1];
                }
                TestBoard board = new TestBoard(this);
                board.MrX.change(lk[i].getToNode());
                possibleNodes[legalMoves] = lk[i].getToNode();
                score[legalMoves] = this.evaluateMove(board, false, 0, beta);
                ++legalMoves;
            }
            ++i;
        }
        Node toNode = possibleNodes[0];
        int max = score[0];
        int i2 = 0;
        while (i2 < legalMoves) {
            if (max < score[i2]) {
                toNode = possibleNodes[i2];
                max = score[i2];
            }
            ++i2;
        }
        useBlackTicket.set(this.isBlackTicketUsable(n, possibleNodes, legalMoves, score));
        return toNode;
    }

    public void printPossibleDetectiveMoves() {
        System.out.println("Generating detective moves:");
        LinkedList<TestBoard> possibleMoves = new LinkedList<TestBoard>();
        this.generateDetectiveMoves(this, possibleMoves, 0);
        Object[] moves = possibleMoves.toArray();
        Arrays.sort(moves);
        int size = moves.length;
        int count = 0;
        while (count < size && count <= 1000000000) {
            TestBoard b = (TestBoard)moves[count];
            int i = 0;
            while (i < 5) {
                System.out.print(String.valueOf(b.detectives[i].getPosition().getPosition()) + " ");
                ++i;
            }
            System.out.println("Score " + TestBoard.scoreBoard(b));
            ++count;
        }
        possibleMoves = null;
        moves = null;
        System.gc();
    }

    private int evaluateMove(TestBoard b, boolean isMachineMove, int depth, int alphabeta) {
        if (depth == DEPTH) {
            return TestBoard.scoreBoard(b);
        }
        if (isMachineMove) {
            Node dPos = b.MrX.getPosition();
            Link[] lk = dPos.getLinks();
            int[] score = new int[lk.length];
            int legalMoves = 0;
            int beta = -200;
            int i = 0;
            while (i < lk.length) {
                Node newPos = lk[i].getToNode();
                if (b.isLegalMove(lk[i])) {
                    if (legalMoves > 0 && beta < score[legalMoves - 1]) {
                        beta = score[legalMoves - 1];
                    }
                    TestBoard board = new TestBoard(b);
                    board.MrX.change(newPos);
                    score[legalMoves] = board.isUserWin() ? -200 : (board.isMachineWin() ? 200 : this.evaluateMove(board, false, depth + 1, beta));
                    if (score[legalMoves] > alphabeta) {
                        return score[legalMoves];
                    }
                    ++legalMoves;
                }
                ++i;
            }
            int max = score[0];
            int i2 = 0;
            while (i2 < legalMoves) {
                if (score[i2] > max) {
                    max = score[i2];
                }
                ++i2;
            }
            return max;
        }
        LinkedList<TestBoard> possibleMoves = new LinkedList<TestBoard>();
        this.generateDetectiveMoves(b, possibleMoves, 0);
        Object[] possibleMovesArray = possibleMoves.toArray();
        int[] score = new int[possibleMovesArray.length];
        int alpha = 200;
        int i = 0;
        while (i < score.length && i < 1000000000) {
            TestBoard board;
            if (i > 0 && alpha > score[i - 1]) {
                alpha = score[i - 1];
            }
            score[i] = (board = (TestBoard)possibleMovesArray[i]).isUserWin() ? -200 : (board.isMachineWin() ? 200 : this.evaluateMove(board, true, depth + 1, alpha));
            if (score[i] < alphabeta) {
                return score[i];
            }
            ++i;
        }
        possibleMoves = null;
        possibleMovesArray = null;
        System.gc();
        int min = score[0];
        int i3 = 0;
        while (i3 < score.length && i3 < 1000000000) {
            if (score[i3] < min) {
                min = score[i3];
            }
            ++i3;
        }
        return min;
    }

    private void generateDetectiveMoves(TestBoard board, LinkedList<TestBoard> possibleMoves, int detIndex) {
        if (!board.detectives[detIndex].canMove(board)) {
            if (detIndex == 4) {
                possibleMoves.add(board);
            } else {
                this.generateDetectiveMoves(board, possibleMoves, detIndex + 1);
            }
        } else {
            TreeSet<Move> m = board.detectives[detIndex].getPossibleMoves(board);
            int size = m.size();
            int i = 0;
            while (i < size) {
                Move l = m.pollFirst();
                TestBoard temp = new TestBoard(board);
                temp.detectives[detIndex].change(nodes[l.getNode()], l.getType());
                if (detIndex == 4) {
                    possibleMoves.add(temp);
                } else {
                    this.generateDetectiveMoves(temp, possibleMoves, detIndex + 1);
                }
                ++i;
            }
            m = null;
        }
    }

    private void generatePrunedDetectiveMoves(TestBoard board, LinkedList<TestBoard> possibleMoves, int detIndex) {
        if (!board.detectives[detIndex].canMove(board)) {
            if (detIndex == 4) {
                possibleMoves.add(board);
            } else {
                this.generateDetectiveMoves(board, possibleMoves, detIndex + 1);
            }
        } else {
            TreeSet<Move> m = board.detectives[detIndex].getPossibleMoves(board);
            int size = m.size();
            int i = 0;
            while (i < size) {
                Move l = m.pollFirst();
                TestBoard temp = new TestBoard(board);
                temp.detectives[detIndex].change(nodes[l.getNode()], l.getType());
                if (detIndex == 4) {
                    possibleMoves.add(temp);
                } else {
                    this.generatePrunedDetectiveMoves(temp, possibleMoves, detIndex + 1);
                }
                ++i;
            }
            m = null;
        }
    }

    public boolean isCheckPoint() {
        boolean isCheckPoint = false;
        int i = 0;
        while (i < checkPoints.length) {
            if (this.currentMoves == checkPoints[i]) {
                isCheckPoint = true;
            }
            ++i;
        }
        return isCheckPoint;
    }

    public boolean isCheckPoint(int move) {
        boolean isCheckPoint = false;
        int i = 0;
        while (i < checkPoints.length) {
            if (move == checkPoints[i]) {
                isCheckPoint = true;
            }
            ++i;
        }
        return isCheckPoint;
    }

    private boolean isBlackTicketUsable(Node from, Node[] possibleNodes, int legalMoves, int[] score) {
        Link[] links = from.getLinks();
        if (legalMoves == 1) {
            return false;
        }
        if (this.MrX.getBlackTickets() <= 0) {
            return false;
        }
        if (this.isCheckPoint(this.currentMoves + 1) || this.isCheckPoint(this.currentMoves + 2)) {
            return false;
        }
        int pos1 = possibleNodes[0].getPosition();
        boolean multi = false;
        int i = 1;
        while (i < legalMoves) {
            if (possibleNodes[i].getPosition() != pos1) {
                multi = true;
            }
            ++i;
        }
        if (!multi) {
            return false;
        }
        int taxiLink = 0;
        int busLink = 0;
        int ugLink = 0;
        int ferryLink = 0;
        int i2 = 0;
        while (i2 < links.length) {
            boolean canVisit = false;
            int j = 0;
            while (j < legalMoves) {
                if (possibleNodes[j] == links[i2].getToNode() && score[j] > 0) {
                    canVisit = true;
                }
                ++j;
            }
            if (canVisit && links[i2].getType() == 1) {
                taxiLink = 1;
            }
            if (canVisit && links[i2].getType() == 2) {
                busLink = 1;
            }
            if (canVisit && links[i2].getType() == 3) {
                ugLink = 1;
            }
            if (canVisit && links[i2].getType() == 50) {
                ferryLink = 1;
            }
            ++i2;
        }
        if (taxiLink + busLink + ugLink + ferryLink <= 1) {
            return false;
        }
        if (((Move)this.MrX.prevPositions.getLast()).getType() == 60) {
            return false;
        }
        return this.isCheckPoint() || this.isCheckPoint(this.currentMoves - 1);
    }

    private static int scoreBoard(TestBoard board) {
        Detective[] det = board.detectives;
        Fugitive mrx = board.MrX;
        int minDistance = 100;
        int totalMobility = 0;
        int count = 0;
        while (count < 5) {
            int distance = shortestDistance[det[count].getPosition().getPosition()][mrx.getPosition().getPosition()];
            if (distance < minDistance) {
                minDistance = distance;
            }
            ++count;
        }
        Node n = board.MrX.getPosition();
        Link[] lk = n.getLinks();
        int i = 0;
        while (i < lk.length) {
            if (board.isLegalMove(lk[i])) {
                ++totalMobility;
            }
            ++i;
        }
        int score = 20 * minDistance + totalMobility;
        return score;
    }

    @Override
    public int compare(Object b1, Object b2) {
        TestBoard board1 = (TestBoard)b1;
        TestBoard board2 = (TestBoard)b2;
        Detective[] det1 = board1.detectives;
        Detective[] det2 = board2.detectives;
        int[] d1 = new int[5];
        int[] d2 = new int[5];
        int i = 0;
        while (i < 5) {
            d1[i] = shortestDistance[det1[i].getPosition().getPosition()][board1.MrX.getPosition().getPosition()];
            d2[i] = shortestDistance[det2[i].getPosition().getPosition()][board2.MrX.getPosition().getPosition()];
            ++i;
        }
        Arrays.sort(d1);
        Arrays.sort(d2);
        int count = 0;
        while (count < 5 && d1[count] == d2[count]) {
            ++count;
        }
        if (count >= 5) {
            return 0;
        }
        return d1[count] - d2[count];
    }

    public boolean equal(TestBoard b1, TestBoard b2) {
        return this.compare(b1, b2) == 0;
    }

    @Override
    public int compareTo(Object o) {
        TestBoard b = (TestBoard)o;
        return this.compare(this, b);
    }

    public Move moveMrX() {
        AtomicBoolean useBlackTicket = new AtomicBoolean();
        Node bestNode = this.bestMove(useBlackTicket);
        int type = this.MrX.changePosition(bestNode);
        int pos = this.MrX.getPosition().getPosition();
        if (useBlackTicket.get()) {
            this.MrX.useBlackTicket();
            type = 60;
        }
        ++this.currentMoves;
        return new Move(pos, type);
    }

    public Detective[] getDetectives() {
        return this.detectives;
    }

    public Fugitive getMrX() {
        return this.MrX;
    }

    public int getCurrentMoves() {
        return this.currentMoves;
    }

    public String toString() {
        return "" + TestBoard.scoreBoard(this);
    }

    public Point getPoint(int nodeIndex) {
        return nodePositions[nodeIndex];
    }
}

