/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Detective;
import game.MapLabel;
import game.Move;
import game.TableDialog;
import game.TestBoard;
import game.Transport;
import i18n.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PlayGame
extends JApplet
implements ActionListener,
Transport,
ItemListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final int NO_OF_DETECTIVES = 5;
    public static Font font = new Font("SansSerif", 0, 15);
    TestBoard board;
    JFrame parentFrame;
    Container container;
    MapLabel the_map;
    String mrX = "Mr. X";
    JButton start;
    JButton det;
    JButton mx;
    JTextField msg;
    int currentDetectiveIndex = 0;
    Move recentMove;
    boolean gameStarted = false;
    boolean canMove = true;
    JTextField detectiveStatus;
    JButton done;
    JComboBox getMove;
    JMenuItem newGame;
    JMenuItem exitGame;
    JMenuItem about;
    JMenuItem help;
    JMenuItem ackn;
    GridBagConstraints mapC;
    GridBagConstraints detC;
    GridBagConstraints mxC;
    GridBagConstraints startC;
    GridBagConstraints doneC;
    GridBagConstraints getMoveC;
    GridBagConstraints msgC;
    GridBagConstraints detectiveStatusC;

    void buildUI(JFrame f) {
        this.parentFrame = f;
        this.container = this.parentFrame.getContentPane();
        this.container.setLayout(new GridBagLayout());
        this.mapC = new GridBagConstraints();
        this.mapC.fill = 1;
        int v = 20;
        int h = 30;
        this.the_map = new MapLabel(new ImageIcon("./map.jpg"), TestBoard.getNumberOfDetectives());
        JScrollPane map = new JScrollPane(this.the_map, v, h);
        this.mapC.gridx = 0;
        this.mapC.gridy = 0;
        this.mapC.gridwidth = 7;
        this.mapC.ipady = 1000;
        this.mapC.ipady = 600;
        this.mapC.weightx = 1.0;
        this.mapC.weighty = 1.0;
        this.mapC.insets = new Insets(10, 10, 10, 10);
        this.container.add((Component)map, this.mapC);
        this.det = new JButton(I18n.tr("DetectivesButton"));
        this.det.addActionListener(this);
        this.det.setActionCommand("detectives");
        this.det.setVisible(true);
        if (!this.gameStarted) {
            this.det.setEnabled(false);
        }
        this.detC = new GridBagConstraints();
        this.detC.gridx = 0;
        this.detC.gridy = 1;
        this.detC.insets = new Insets(0, 10, 5, 5);
        this.container.add((Component)this.det, this.detC);
        this.mx = new JButton(I18n.tr("MovesButton"));
        this.mx.addActionListener(this);
        this.mx.setActionCommand(this.mrX);
        this.mx.setVisible(true);
        if (!this.gameStarted) {
            this.mx.setEnabled(false);
        }
        this.mxC = new GridBagConstraints();
        this.mxC.gridx = 1;
        this.mxC.gridy = 1;
        this.mxC.insets = new Insets(0, 5, 5, 5);
        this.container.add((Component)this.mx, this.mxC);
        this.start = new JButton(I18n.tr("StartGameButton"));
        this.start.addActionListener(this);
        this.start.setActionCommand("start");
        if (this.gameStarted) {
            this.start.setEnabled(false);
        }
        this.startC = new GridBagConstraints();
        this.startC.gridx = 2;
        this.startC.gridy = 1;
        this.startC.insets = new Insets(0, 5, 5, 5);
        this.container.add((Component)this.start, this.startC);
        this.done = new JButton(I18n.tr("DoneButton"));
        this.done.addActionListener(this);
        this.done.setActionCommand("done");
        if (!this.gameStarted) {
            this.done.setEnabled(false);
        }
        this.doneC = new GridBagConstraints();
        this.doneC.gridx = 6;
        this.doneC.gridy = 1;
        this.doneC.insets = new Insets(0, 5, 5, 5);
        this.doneC.fill = 2;
        this.doneC.anchor = 13;
        this.container.add((Component)this.done, this.doneC);
        this.msg = new JTextField(50);
        this.msgC = new GridBagConstraints();
        this.msgC.gridx = 3;
        this.msgC.gridy = 1;
        this.msgC.ipadx = 150;
        this.msgC.insets = new Insets(0, 5, 5, 5);
        this.container.add((Component)this.msg, this.msgC);
        this.msg.setEditable(false);
        this.msg.setText(I18n.tr("MsgClickStartGame"));
        this.detectiveStatus = new JTextField(120);
        this.detectiveStatus.setEditable(false);
        this.detectiveStatusC = new GridBagConstraints();
        this.detectiveStatusC.gridx = 4;
        this.detectiveStatusC.gridy = 1;
        this.detectiveStatusC.ipadx = 320;
        this.detectiveStatusC.insets = new Insets(0, 5, 5, 5);
        this.getMoveC = new GridBagConstraints();
        this.getMoveC.gridx = 5;
        this.getMoveC.gridy = 1;
        this.getMoveC.insets = new Insets(0, 5, 5, 5);
        this.parentFrame.setVisible(true);
        this.addMenu();
    }

    private void addMenu() {
        JMenuBar mbar = new JMenuBar();
        this.parentFrame.setJMenuBar(mbar);
        JMenu fileMenu = new JMenu(I18n.tr("FileMenu"));
        mbar.add(fileMenu);
        this.newGame = new JMenuItem(I18n.tr("File_NewMenuItem"));
        fileMenu.add(this.newGame);
        this.newGame.addActionListener(this);
        this.exitGame = new JMenuItem(I18n.tr("File_ExitMenuItem"));
        fileMenu.add(this.exitGame);
        this.exitGame.addActionListener(this);
        JMenu helpMenu = new JMenu(I18n.tr("HelpMenu"));
        mbar.add(helpMenu);
        this.about = new JMenuItem(I18n.tr("Help_AboutMenuItem"));
        helpMenu.add(this.about);
        this.about.addActionListener(this);
        this.help = new JMenuItem(I18n.tr("Help_HelpMenuItem"));
        helpMenu.add(this.help);
        this.help.addActionListener(this);
    }

    private void handleMenuEvent(Object source) {
        if (source == this.newGame) {
            this.reset();
        } else if (source == this.exitGame) {
            System.exit(0);
        } else if (source == this.about) {
            this.aboutThisGame();
        } else if (source == this.help) {
            this.help();
        }
    }

    private void aboutThisGame() {
        JOptionPane.showMessageDialog(this.parentFrame, I18n.tr("AboutText"), I18n.tr("AboutTitle"), 1);
    }

    private void help() {
        JOptionPane.showMessageDialog(this.parentFrame, I18n.tr("HelpText"), I18n.tr("HelpTitle"), 1);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String order = ae.getActionCommand();
        Object source = ae.getSource();
        this.handleMenuEvent(source);
        if (order.equals("start")) {
            this.gameStarted = true;
            this.det.setEnabled(true);
            this.mx.setEnabled(true);
            this.start.setEnabled(false);
            this.parentFrame.setVisible(true);
            this.msg.setText(I18n.tr("MsgLoading"));
            this.board = new TestBoard();
            int i = 1;
            while (i <= TestBoard.getNumberOfDetectives()) {
                this.the_map.setPlayerPos(i, this.board.getPoint(this.board.getDetectives()[i - 1].position.getPosition()));
                ++i;
            }
            this.the_map.setCurrentPlayer(1);
            this.parentFrame.setVisible(true);
            this.msg.setText(I18n.tr("MsgLoadingDone"));
            this.container.add((Component)this.detectiveStatus, this.detectiveStatusC);
            this.moveMrX();
            this.done.setVisible(true);
            this.detectiveStatus.setVisible(true);
        } else if (order.equals("detectives")) {
            String dets = "";
            int i = 0;
            while (i < 5) {
                dets = String.valueOf(dets) + I18n.tr("DetectiveInfoText", i + 1, this.board.getDetectives()[i].toString()) + "\n";
                ++i;
            }
            JOptionPane.showMessageDialog(this.parentFrame, dets, I18n.tr("DetectiveInfoTitle"), 1);
        } else if (order.equals(this.mrX)) {
            TableDialog tb = new TableDialog(this.parentFrame, I18n.tr("PreviousMovesTitle"), this.board, this, false);
            tb.setVisible(true);
        } else if (order.equals("done")) {
            if (this.canMove) {
                this.board.changeDetectivePosition(this.currentDetectiveIndex, this.recentMove);
                this.container.remove(this.getMove);
            }
            int nodePos = this.board.getDetectives()[this.currentDetectiveIndex].position.getPosition();
            Point currentDetectivePos = this.board.getPoint(nodePos);
            this.the_map.setPlayerPos(this.currentDetectiveIndex + 1, currentDetectivePos.x, currentDetectivePos.y);
            this.parentFrame.setVisible(true);
            this.currentDetectiveIndex = (this.currentDetectiveIndex + 1) % 5;
            this.the_map.setCurrentPlayer(this.currentDetectiveIndex + 1);
            if (this.board.isUserWin()) {
                this.humanWin();
            } else if (this.currentDetectiveIndex == 0 && !this.board.isUserWin()) {
                this.moveMrX();
            } else {
                this.getDetectiveMove();
            }
        }
    }

    private void moveMrX() {
        if (this.board.isUserWin()) {
            this.humanWin();
        }
        Move move = this.board.moveMrX();
        String str = "Mr. X moved by ";
        switch (move.getType()) {
            case 1: {
                str = String.valueOf(str) + "Taxi";
                break;
            }
            case 2: {
                str = String.valueOf(str) + "Bus";
                break;
            }
            case 3: {
                str = String.valueOf(str) + "Underground";
                break;
            }
            case 50: {
                str = String.valueOf(str) + "unknown transport (Black Ticket)";
                break;
            }
            case 60: {
                str = String.valueOf(str) + "unknown transport (Black Ticket)";
            }
        }
        if (this.board.isCheckPoint()) {
            str = String.valueOf(str) + " and is at the position " + move.getNode();
            this.the_map.mrXVisible = true;
        } else {
            this.the_map.mrXVisible = false;
        }
        this.the_map.setPlayerPos(0, this.board.getPoint(move.getNode()).getLocation());
        JOptionPane.showMessageDialog(this.parentFrame, str, "Mr. X move", 1);
        if (this.board.isMachineWin()) {
            this.machineWin();
        } else {
            this.getDetectiveMove();
        }
    }

    private void humanWin() {
        this.the_map.mrXVisible = true;
        this.reset();
        this.msg.setText(I18n.tr("MsgHumanWin"));
        JOptionPane.showMessageDialog(this.parentFrame, I18n.tr("HumanWinText"), I18n.tr("HumanWinTitle"), 1);
        this.repaint();
        this.displayPrevPos();
    }

    private void machineWin() {
        this.reset();
        this.msg.setText(I18n.tr("MsgMachineWin"));
        JOptionPane.showMessageDialog(this.parentFrame, I18n.tr("MachineWinText"), I18n.tr("MachineWinTitle"), 1);
        this.detectiveStatus.setText("");
        this.repaint();
        this.displayPrevPos();
    }

    private void displayPrevPos() {
        TableDialog td = new TableDialog(this.parentFrame, I18n.tr("PreviousMovesTitle"), this.board, this, true);
        td.setVisible(true);
    }

    private void reset() {
        try {
            this.det.setEnabled(false);
            this.mx.setEnabled(false);
            this.start.setEnabled(true);
            this.container.remove(this.getMove);
            this.done.setEnabled(false);
            this.done.setVisible(false);
            this.detectiveStatus.setVisible(false);
            this.the_map.setCurrentPlayer(-1);
            this.getMove.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.currentDetectiveIndex = 0;
        this.parentFrame.setVisible(true);
        this.done.repaint();
        this.msg.setText(I18n.tr("MsgClickStartGame"));
        this.repaint();
        this.gameStarted = false;
    }

    private void getDetectiveMove() {
        this.getMove = new JComboBox();
        this.getMove.setSize(new Dimension(120, 30));
        this.done.setEnabled(true);
        this.parentFrame.setVisible(true);
        Detective[] detectives = this.board.getDetectives();
        this.msg.setText(I18n.tr("MsgMoveDetective", this.currentDetectiveIndex + 1));
        this.detectiveStatus.setText(I18n.tr("DetectiveStatusText", this.currentDetectiveIndex + 1, detectives[this.currentDetectiveIndex].toString()));
        if (detectives[this.currentDetectiveIndex].canMove(this.board)) {
            TreeSet<Move> moves = this.board.getDetectivePossibleMoves(this.currentDetectiveIndex);
            int i = 0;
            while (!moves.isEmpty()) {
                Move m = moves.first();
                this.getMove.addItem(m.toDisplayString());
                if (i == 0) {
                    this.recentMove = m;
                }
                moves.remove(m);
                ++i;
            }
            this.getMove.setSelectedItem(this.recentMove.toString());
            this.getMove.addItemListener(this);
            this.getMove.setVisible(true);
            this.container.add((Component)this.getMove, this.getMoveC);
            this.getMove.setEnabled(true);
            this.canMove = true;
        } else {
            detectives[this.currentDetectiveIndex].setStaticState();
            this.msg.setText(I18n.tr("MsgDetectiveStranded", this.currentDetectiveIndex + 1));
            this.getMove.setVisible(false);
            this.canMove = false;
        }
        this.getMove.repaint();
        this.repaint();
        this.parentFrame.setVisible(true);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        String move = (String)ie.getItem();
        this.recentMove = new Move(move);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame(I18n.tr("WindowTitle"));
        PlayGame game = new PlayGame();
        game.buildUI(f);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        f.setSize(new Dimension(1024, 700));
        f.setVisible(true);
        f.setResizable(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (!this.gameStarted) {
            DefaultListSelectionModel table = (DefaultListSelectionModel)evt.getSource();
            int index = table.getMaxSelectionIndex();
            int i = 0;
            while (i <= 5) {
                LinkedList<Move> prevPos = i == 0 ? this.board.getMrX().getPrevPos() : this.board.getDetectives()[i - 1].getPrevPos();
                int pos = prevPos.size() <= index + 1 ? prevPos.getLast().getNode() : prevPos.get(index + 1).getNode();
                this.the_map.setPlayerPos(i, this.board.getPoint(pos));
                this.the_map.setCurrentPlayer(-1);
                ++i;
            }
        }
    }
}

