/*
** Module   :ENTRIES.H
** Abstract :Describes DLL entry points
**
** Copyright (C) Link Guard Solutions
** For conditions of distribution and use, see license in license.txt
**
** Log: Fri  28/12/2003 Created
**
*/

#ifndef __ENTRIES_H
#define __ENTRIES_H

#ifndef APIENTRY
#define APIENTRY    _System
#endif

#ifndef LOG_EMERG
#define	LOG_EMERG	0			/* system is unusable */
#define	LOG_ALERT	1			/* action must be taken immediately */
#define	LOG_CRIT	2			/* critical conditions */
#define LOG_ERR		3			/* error conditions */
#define	LOG_WARNING	4			/* warning conditions */
#define	LOG_NOTICE	5			/* normal but significant condition */
#define	LOG_INFO	6			/* informational */
#define	LOG_DEBUG	7			/* debug-level messages */
#endif

#ifndef PLUGIN_ACTION_ALLOW
#define PLUGIN_ACTION_ALLOW 0
#define PLUGIN_ACTION_CONT  1
#define PLUGIN_ACTION_DROP  2
#endif

typedef void APIENTRY DLLlog(unsigned long pnum, unsigned long pri, char * message);
typedef DLLlog *pDLLlog;

typedef void APIENTRY DLLinit(unsigned long pnum, unsigned long *plidx, pDLLlog logfunc);
typedef DLLinit *pDLLinit;
#define nDLLinit    200 //DLLinit ordinal

typedef unsigned long APIENTRY DLLinitcomplete(unsigned long plidx);
typedef DLLinitcomplete *pDLLinitcomplete;
#define nDLLinitcomplete  201 //DLLinit ordinal

typedef void APIENTRY DLLsconfig(unsigned long plidx, char *var, char *val);
typedef DLLsconfig *pDLLsconfig;
#define nDLLsconfig 202 //DLLsconfig ordinal

typedef unsigned long APIENTRY DLLwrite(unsigned long plidx, unsigned long source, char *packet, unsigned long psize);
typedef DLLwrite *pDLLwrite;
#define nDLLwrite   203 //DLLwrite ordinal

typedef void APIENTRY DLLdone(unsigned long plidx);
typedef DLLdone *pDLLdone;
#define nDLLdone   204 //DLLdone ordinal

#endif  /*__ENTRIES_H*/

