/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.hoverhelp;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class HoverHelp {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_hoverhelp");
    static final int hhiInformation = 0;
    static final int hhiWarning = 1;
    static final String[] imageLocations = new String[]{"information.gif", "warning.gif"};
    Image[] images;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new HoverHelp().open(display);
        while (shell != null && !shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public Shell open(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.hoverhelp.HoverHelp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        try {
            if (this.images == null) {
                this.images = new Image[imageLocations.length];
                int i = 0;
                while (i < imageLocations.length) {
                    InputStream stream = clazz2.getResourceAsStream(imageLocations[i]);
                    ImageData source = new ImageData(stream);
                    ImageData mask = source.getTransparencyMask();
                    this.images[i] = new Image((Device)display, source, mask);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            System.err.println(this.getResourceString("error.CouldNotLoadResources", new Object[]{ex.getMessage()}));
            return null;
        }
        Shell shell = new Shell();
        this.createPartControl((Composite)shell);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HoverHelp.this.images != null) {
                    int i = 0;
                    while (i < HoverHelp.this.images.length) {
                        Image image = HoverHelp.this.images[i];
                        if (image != null) {
                            image.dispose();
                        }
                        ++i;
                    }
                    HoverHelp.this.images = null;
                }
            }
        });
        shell.pack();
        shell.open();
        return shell;
    }

    public String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(this.getResourceString(key), args);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    public void createPartControl(Composite frame) {
        ToolTipHandler tooltip = new ToolTipHandler(frame.getShell());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        frame.setLayout((Layout)layout);
        ToolBar bar = new ToolBar(frame, 2048);
        int i = 0;
        while (i < 5) {
            ToolItem item = new ToolItem(bar, 8);
            item.setText(this.getResourceString("ToolItem.text", new Object[]{new Integer(i)}));
            item.setData("TIP_TEXT", (Object)this.getResourceString("ToolItem.tooltip", new Object[]{item.getText()}));
            item.setData("TIP_HELPTEXTHANDLER", (Object)new ToolTipHelpTextHandler(){

                public String getHelpText(Widget widget) {
                    Item item = (Item)widget;
                    return HoverHelp.this.getResourceString("ToolItem.help", new Object[]{item.getText()});
                }
            });
            ++i;
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        bar.setLayoutData((Object)gridData);
        tooltip.activateHoverHelp((Control)bar);
        Table table = new Table(frame, 2048);
        int i2 = 0;
        while (i2 < 4) {
            TableItem item = new TableItem(table, 8);
            item.setText(this.getResourceString("Item", new Object[]{new Integer(i2)}));
            item.setData("TIP_IMAGE", (Object)this.images[0]);
            item.setText(this.getResourceString("TableItem.text", new Object[]{new Integer(i2)}));
            item.setData("TIP_TEXT", (Object)this.getResourceString("TableItem.tooltip", new Object[]{item.getText()}));
            item.setData("TIP_HELPTEXTHANDLER", (Object)new ToolTipHelpTextHandler(){

                public String getHelpText(Widget widget) {
                    Item item = (Item)widget;
                    return HoverHelp.this.getResourceString("TableItem.help", new Object[]{item.getText()});
                }
            });
            ++i2;
        }
        table.setLayoutData((Object)new GridData(16));
        tooltip.activateHoverHelp((Control)table);
        Tree tree = new Tree(frame, 2048);
        int i3 = 0;
        while (i3 < 4) {
            TreeItem item = new TreeItem(tree, 8);
            item.setText(this.getResourceString("Item", new Object[]{new Integer(i3)}));
            item.setData("TIP_IMAGE", (Object)this.images[1]);
            item.setText(this.getResourceString("TreeItem.text", new Object[]{new Integer(i3)}));
            item.setData("TIP_TEXT", (Object)this.getResourceString("TreeItem.tooltip", new Object[]{item.getText()}));
            item.setData("TIP_HELPTEXTHANDLER", (Object)new ToolTipHelpTextHandler(){

                public String getHelpText(Widget widget) {
                    Item item = (Item)widget;
                    return HoverHelp.this.getResourceString("TreeItem.help", new Object[]{item.getText()});
                }
            });
            ++i3;
        }
        tree.setLayoutData((Object)new GridData(16));
        tooltip.activateHoverHelp((Control)tree);
        Button button = new Button(frame, 8);
        button.setText(this.getResourceString("Hello.text"));
        button.setData("TIP_TEXT", (Object)this.getResourceString("Hello.tooltip"));
        tooltip.activateHoverHelp((Control)button);
    }

    protected static class ToolTipHandler {
        private Shell parentShell;
        private Shell tipShell;
        private Label tipLabelImage;
        private Label tipLabelText;
        private Widget tipWidget;
        private Point tipPosition;

        public ToolTipHandler(Shell parent) {
            Display display = parent.getDisplay();
            this.parentShell = parent;
            this.tipShell = new Shell(parent, 16384);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 2;
            this.tipShell.setLayout((Layout)gridLayout);
            this.tipShell.setBackground(display.getSystemColor(29));
            this.tipLabelImage = new Label((Composite)this.tipShell, 0);
            this.tipLabelImage.setForeground(display.getSystemColor(28));
            this.tipLabelImage.setBackground(display.getSystemColor(29));
            this.tipLabelImage.setLayoutData((Object)new GridData(772));
            this.tipLabelText = new Label((Composite)this.tipShell, 0);
            this.tipLabelText.setForeground(display.getSystemColor(28));
            this.tipLabelText.setBackground(display.getSystemColor(29));
            this.tipLabelText.setLayoutData((Object)new GridData(772));
        }

        public void activateHoverHelp(Control control) {
            control.addMouseListener((MouseListener)new MouseAdapter(this){
                private final /* synthetic */ ToolTipHandler this$1;
                {
                    this.this$1 = toolTipHandler;
                }

                public void mouseDown(MouseEvent e) {
                    if (ToolTipHandler.access$0(this.this$1).isVisible()) {
                        ToolTipHandler.access$0(this.this$1).setVisible(false);
                    }
                }
            });
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(this, control){
                private final /* synthetic */ ToolTipHandler this$1;
                private final /* synthetic */ Control val$control;
                {
                    this.this$1 = toolTipHandler;
                    this.val$control = control;
                }

                public void mouseExit(MouseEvent e) {
                    if (ToolTipHandler.access$0(this.this$1).isVisible()) {
                        ToolTipHandler.access$0(this.this$1).setVisible(false);
                    }
                    ToolTipHandler.access$1(this.this$1, null);
                }

                public void mouseHover(MouseEvent event) {
                    ToolBar w;
                    Point pt = new Point(event.x, event.y);
                    Widget widget = event.widget;
                    if (widget instanceof ToolBar) {
                        w = (ToolBar)widget;
                        widget = w.getItem(pt);
                    }
                    if (widget instanceof Table) {
                        w = (Table)widget;
                        widget = w.getItem(pt);
                    }
                    if (widget instanceof Tree) {
                        w = (Tree)widget;
                        widget = w.getItem(pt);
                    }
                    if (widget == null) {
                        ToolTipHandler.access$0(this.this$1).setVisible(false);
                        ToolTipHandler.access$1(this.this$1, null);
                        return;
                    }
                    if (widget == ToolTipHandler.access$2(this.this$1)) {
                        return;
                    }
                    ToolTipHandler.access$1(this.this$1, widget);
                    ToolTipHandler.access$3(this.this$1, this.val$control.toDisplay(pt));
                    String text = (String)widget.getData("TIP_TEXT");
                    Image image = (Image)widget.getData("TIP_IMAGE");
                    ToolTipHandler.access$4(this.this$1).setText(text != null ? text : "");
                    ToolTipHandler.access$5(this.this$1).setImage(image);
                    ToolTipHandler.access$0(this.this$1).pack();
                    ToolTipHandler.access$7(this.this$1, ToolTipHandler.access$0(this.this$1), ToolTipHandler.access$6(this.this$1));
                    ToolTipHandler.access$0(this.this$1).setVisible(true);
                }
            });
            control.addHelpListener(new HelpListener(this){
                private final /* synthetic */ ToolTipHandler this$1;
                {
                    this.this$1 = toolTipHandler;
                }

                public void helpRequested(HelpEvent event) {
                    if (ToolTipHandler.access$2(this.this$1) == null) {
                        return;
                    }
                    ToolTipHelpTextHandler handler = (ToolTipHelpTextHandler)ToolTipHandler.access$2(this.this$1).getData("TIP_HELPTEXTHANDLER");
                    if (handler == null) {
                        return;
                    }
                    String text = handler.getHelpText(ToolTipHandler.access$2(this.this$1));
                    if (text == null) {
                        return;
                    }
                    if (ToolTipHandler.access$0(this.this$1).isVisible()) {
                        ToolTipHandler.access$0(this.this$1).setVisible(false);
                        Shell helpShell = new Shell(ToolTipHandler.access$8(this.this$1), 1264);
                        helpShell.setLayout((Layout)new FillLayout());
                        Label label = new Label((Composite)helpShell, 0);
                        label.setText(text);
                        helpShell.pack();
                        ToolTipHandler.access$7(this.this$1, helpShell, ToolTipHandler.access$6(this.this$1));
                        helpShell.open();
                    }
                }
            });
        }

        private void setHoverLocation(Shell shell, Point position) {
            Rectangle displayBounds = shell.getDisplay().getBounds();
            Rectangle shellBounds = shell.getBounds();
            shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
            shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
            shell.setBounds(shellBounds);
        }

        static /* synthetic */ Shell access$0(ToolTipHandler toolTipHandler) {
            return toolTipHandler.tipShell;
        }

        static /* synthetic */ void access$1(ToolTipHandler toolTipHandler, Widget widget) {
            toolTipHandler.tipWidget = widget;
        }

        static /* synthetic */ Widget access$2(ToolTipHandler toolTipHandler) {
            return toolTipHandler.tipWidget;
        }

        static /* synthetic */ void access$3(ToolTipHandler toolTipHandler, Point point) {
            toolTipHandler.tipPosition = point;
        }

        static /* synthetic */ Label access$4(ToolTipHandler toolTipHandler) {
            return toolTipHandler.tipLabelText;
        }

        static /* synthetic */ Label access$5(ToolTipHandler toolTipHandler) {
            return toolTipHandler.tipLabelImage;
        }

        static /* synthetic */ Point access$6(ToolTipHandler toolTipHandler) {
            return toolTipHandler.tipPosition;
        }

        static /* synthetic */ void access$7(ToolTipHandler toolTipHandler, Shell shell, Point point) {
            toolTipHandler.setHoverLocation(shell, point);
        }

        static /* synthetic */ Shell access$8(ToolTipHandler toolTipHandler) {
            return toolTipHandler.parentShell;
        }
    }

    protected interface ToolTipHelpTextHandler {
        public String getHelpText(Widget var1);
    }
}

