/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.AlignableTab;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

class ButtonTab
extends AlignableTab {
    Button button1;
    Button button2;
    Button button3;
    Button button4;
    Button button5;
    Button button6;
    Group textButtonGroup;
    Group imageButtonGroup;
    Button upButton;
    Button downButton;
    Button pushButton;
    Button checkButton;
    Button radioButton;
    Button toggleButton;
    Button arrowButton;
    Button flatButton;

    ButtonTab(ControlExample instance) {
        super(instance);
    }

    void createControlGroup() {
        super.createControlGroup();
        this.upButton = new Button((Composite)this.allignmentGroup, 16);
        this.upButton.setText(ControlExample.getResourceString("Up"));
        this.downButton = new Button((Composite)this.allignmentGroup, 16);
        this.downButton.setText(ControlExample.getResourceString("Down"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                ButtonTab.this.setExampleWidgetAlignment();
            }
        };
        this.upButton.addSelectionListener((SelectionListener)selectionListener);
        this.downButton.addSelectionListener((SelectionListener)selectionListener);
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.textButtonGroup = new Group((Composite)this.exampleGroup, 0);
        GridLayout gridLayout = new GridLayout();
        this.textButtonGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.textButtonGroup.setLayoutData((Object)new GridData(784));
        this.textButtonGroup.setText(ControlExample.getResourceString("Text_Buttons"));
        this.imageButtonGroup = new Group((Composite)this.exampleGroup, 0);
        gridLayout = new GridLayout();
        this.imageButtonGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        this.imageButtonGroup.setLayoutData((Object)new GridData(784));
        this.imageButtonGroup.setText(ControlExample.getResourceString("Image_Buttons"));
    }

    void createExampleWidgets() {
        int style = 0;
        if (this.pushButton.getSelection()) {
            style |= 8;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.radioButton.getSelection()) {
            style |= 0x10;
        }
        if (this.toggleButton.getSelection()) {
            style |= 2;
        }
        if (this.arrowButton.getSelection()) {
            style |= 4;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.button1 = new Button((Composite)this.textButtonGroup, style);
        this.button1.setText(ControlExample.getResourceString("One"));
        this.button2 = new Button((Composite)this.textButtonGroup, style);
        this.button2.setText(ControlExample.getResourceString("Two"));
        this.button3 = new Button((Composite)this.textButtonGroup, style);
        this.button3.setText(ControlExample.getResourceString("Three"));
        this.button4 = new Button((Composite)this.imageButtonGroup, style);
        this.button4.setImage(this.instance.images[0]);
        this.button5 = new Button((Composite)this.imageButtonGroup, style);
        this.button5.setImage(this.instance.images[1]);
        this.button6 = new Button((Composite)this.imageButtonGroup, style);
        this.button6.setImage(this.instance.images[2]);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.pushButton = new Button((Composite)this.styleGroup, 16);
        this.pushButton.setText("SWT.PUSH");
        this.checkButton = new Button((Composite)this.styleGroup, 16);
        this.checkButton.setText("SWT.CHECK");
        this.radioButton = new Button((Composite)this.styleGroup, 16);
        this.radioButton.setText("SWT.RADIO");
        this.toggleButton = new Button((Composite)this.styleGroup, 16);
        this.toggleButton.setText("SWT.TOGGLE");
        this.arrowButton = new Button((Composite)this.styleGroup, 16);
        this.arrowButton.setText("SWT.ARROW");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.button1, this.button2, this.button3, this.button4, this.button5, this.button6};
    }

    String getTabText() {
        return "Button";
    }

    void setExampleWidgetAlignment() {
        int allignment = 0;
        if (this.leftButton.getSelection()) {
            allignment = 16384;
        }
        if (this.centerButton.getSelection()) {
            allignment = 0x1000000;
        }
        if (this.rightButton.getSelection()) {
            allignment = 131072;
        }
        if (this.upButton.getSelection()) {
            allignment = 128;
        }
        if (this.downButton.getSelection()) {
            allignment = 1024;
        }
        this.button1.setAlignment(allignment);
        this.button2.setAlignment(allignment);
        this.button3.setAlignment(allignment);
        this.button4.setAlignment(allignment);
        this.button5.setAlignment(allignment);
        this.button6.setAlignment(allignment);
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        if (this.arrowButton.getSelection()) {
            this.upButton.setEnabled(true);
            this.centerButton.setEnabled(false);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.centerButton.setEnabled(true);
            this.downButton.setEnabled(false);
        }
        this.upButton.setSelection((this.button1.getStyle() & 0x80) != 0);
        this.downButton.setSelection((this.button1.getStyle() & 0x400) != 0);
        this.pushButton.setSelection((this.button1.getStyle() & 8) != 0);
        this.checkButton.setSelection((this.button1.getStyle() & 0x20) != 0);
        this.radioButton.setSelection((this.button1.getStyle() & 0x10) != 0);
        this.toggleButton.setSelection((this.button1.getStyle() & 2) != 0);
        this.arrowButton.setSelection((this.button1.getStyle() & 4) != 0);
        this.flatButton.setSelection((this.button1.getStyle() & 0x800000) != 0);
        this.borderButton.setSelection((this.button1.getStyle() & 0x800) != 0);
    }
}

