/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int increment;
    int pageIncrement;

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void createWidget() {
        this.increment = 1;
        this.pageIncrement = 10;
    }

    public Display getDisplay() {
        Scrollable parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        int handle = this.hwndScrollBar();
        int mr = OS.WinSendMsg(handle, 419, 0, 0);
        return OS.SHORT2FROMMP(mr);
    }

    public int getMinimum() {
        this.checkWidget();
        int handle = this.hwndScrollBar();
        int mr = OS.WinSendMsg(handle, 419, 0, 0);
        return OS.SHORT1FROMMP(mr);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        int handle = this.hwndScrollBar();
        int usSliderPos = OS.WinSendMsg(handle, 418, 0, 0);
        return usSliderPos;
    }

    public Point getSize() {
        int height;
        int width;
        this.checkWidget();
        RECTL rect = new RECTL();
        OS.WinQueryWindowRect(this.parent.handle, rect);
        if ((this.style & 0x100) != 0) {
            width = rect.xRight - rect.xLeft;
            height = OS.WinQuerySysValue(1, 23);
        } else {
            width = OS.WinQuerySysValue(1, 22);
            height = rect.yBottom - rect.yTop;
        }
        return new Point(width, height);
    }

    public int getThumb() {
        this.checkWidget();
        Point size = this.getSize();
        int prop = 0;
        int hwnd = this.hwndScrollBar();
        int mr = OS.WinSendMsg(hwnd, 419, 0, 0);
        short min = OS.SHORT1FROMMP(mr);
        short max = OS.SHORT2FROMMP(mr);
        prop = (this.style & 0x100) != 0 ? (max - min) / size.x : (max - min) / size.y;
        return prop;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x80) == 0;
    }

    int hwndScrollBar() {
        return this.parent.handle;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int scrollBarType() {
        if ((this.style & 0x200) != 0) {
            return 1;
        }
        return 0;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int hwnd = this.hwndScrollBar();
        OS.WinEnableWindow(hwnd, enabled);
        this.state &= 0xFFFFFFBF;
        if (!enabled) {
            this.state |= 0x40;
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        int usMinimum = 0;
        int hwnd = 0;
        int usSliderPos = 0;
        this.checkWidget();
        if (value < 0) {
            return;
        }
        hwnd = this.hwndScrollBar();
        usMinimum = this.getMinimum();
        if (value - usMinimum < 1) {
            return;
        }
        usSliderPos = this.getSelection();
        OS.WinSendMsg(hwnd, 416, usSliderPos, OS.MPFROM2SHORT((short)usMinimum, (short)(value + 1)));
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int max = this.getMaximum();
        int pos = this.getSelection();
        int handle = this.hwndScrollBar();
        OS.WinSendMsg(handle, 416, pos, OS.MPFROM2SHORT((short)value, (short)(max + 1)));
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection < 0) {
            return;
        }
        int handle = this.hwndScrollBar();
        OS.WinSendMsg(handle, 417, selection, 0);
    }

    public void setThumb(int value) {
        short min;
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int hwnd = this.hwndScrollBar();
        int type = this.scrollBarType();
        int mr = OS.WinSendMsg(hwnd, 419, 0, 0);
        short max = OS.SHORT2FROMMP(mr);
        if (max - (min = OS.SHORT2FROMMP(mr)) - value < 0) {
            return;
        }
        OS.WinSendMsg(hwnd, 422, OS.MPFROM2SHORT((short)value, (short)(max + 1)), 0);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (selection < 0) {
            return;
        }
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (maximum - minimum - thumb < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        int hwnd = this.hwndScrollBar();
        OS.WinSendMsg(hwnd, 416, selection, OS.MPFROM2SHORT((short)minimum, (short)maximum));
        this.setThumb(thumb);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
    }

    MRESULT wmScrollChild(int mp1, int mp2) {
        short pos = OS.SHORT1FROMMP(mp2);
        short code = OS.SHORT2FROMMP(mp2);
        int min = this.getMinimum();
        int max = this.getMaximum();
        if (code == 7) {
            return null;
        }
        Event event = new Event();
        switch (code) {
            case 5: {
                if (pos == max) {
                    event.detail = 0x1000008;
                    break;
                }
                if (pos == min) {
                    event.detail = 0x1000007;
                    break;
                }
                event.detail = 1;
                break;
            }
            case 2: {
                event.detail = 0x1000002;
                break;
            }
            case 1: {
                event.detail = 0x1000001;
                break;
            }
            case 4: {
                event.detail = 0x1000006;
                break;
            }
            case 3: {
                event.detail = 0x1000005;
            }
        }
        this.sendEvent(13, event);
        return null;
    }
}

