/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(style));
        this.checkSubclass();
    }

    static int checkStyle(int style) {
        int mask;
        int bits;
        if ((style & 0x38000) == 0) {
            style |= 0x10000;
        }
        if ((bits = style & (mask = 4064)) == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        PSZ buffer2;
        PSZ buffer1;
        int code;
        int buttonBits = 0;
        if ((this.style & 0x20) == 32) {
            buttonBits = 0;
        }
        if ((this.style & 0x120) == 288) {
            buttonBits = 1;
        }
        if ((this.style & 0xC0) == 192) {
            buttonBits = 4;
        }
        if ((this.style & 0x1C0) == 448) {
            buttonBits = 5;
        }
        if ((this.style & 0x500) == 1280) {
            buttonBits = 2;
        }
        if ((this.style & 0xE00) == 3584) {
            buttonBits = 3;
        }
        if (buttonBits == 0) {
            buttonBits = 0;
        }
        int iconBits = 0;
        if ((this.style & 1) != 0) {
            iconBits = 64;
        }
        if ((this.style & 2) != 0) {
            iconBits = 48;
        }
        if ((this.style & 4) != 0) {
            iconBits = 16;
        }
        if ((this.style & 8) != 0) {
            iconBits = 32;
        }
        if ((this.style & 0x10) != 0) {
            iconBits = 48;
        }
        int modalBits = 0;
        if ((this.style & 0x8000) != 0) {
            modalBits = 0;
        }
        if ((this.style & 0x10000) != 0) {
            modalBits = 0;
        }
        if ((this.style & 0x20000) != 0) {
            modalBits = 4096;
        }
        int bits = buttonBits | iconBits | modalBits | 0x4000;
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        if ((code = OS.WinMessageBox(1, hwndOwner, buffer1 = new PSZ(this.message), buffer2 = new PSZ(this.title), 0, bits)) != 0) {
            int type = bits & 0xF;
            if (type == 0) {
                return 32;
            }
            if (type == 1) {
                return code == 1 ? 32 : 256;
            }
            if (type == 4) {
                return code == 6 ? 64 : 128;
            }
            if (type == 5) {
                if (code == 6) {
                    return 64;
                }
                if (code == 7) {
                    return 128;
                }
                return 256;
            }
            if (type == 2) {
                return code == 4 ? 1024 : 256;
            }
            if (type == 3) {
                if (code == 4) {
                    return 1024;
                }
                if (code == 3) {
                    return 512;
                }
                return 2048;
            }
        }
        return 256;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

