/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.pm.ACCEL;
import org.eclipse.swt.internal.pm.MENUITEM;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.OWNERITEM;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int id;
    int accelerator;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    void fillAccel(ACCEL accel) {
        accel.fs = 0;
        accel.key = 0;
        accel.cmd = 0;
        if (this.accelerator == 0) {
            return;
        }
        int fs = 2;
        int key = this.accelerator & 0xFFF8FFFF;
        int vKey = Display.untranslateKey(key);
        if (vKey != 0) {
            key = vKey;
        }
        accel.key = (short)key;
        accel.cmd = (short)this.id;
        accel.fs = (byte)fs;
        if ((this.accelerator & 0x10000) != 0) {
            accel.fs = (short)(accel.fs | 0x20);
        }
        if ((this.accelerator & 0x40000) != 0) {
            accel.fs = (short)(accel.fs | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            accel.fs = (short)(accel.fs | 8);
        }
        System.out.println("MenuItem.fillAccel - KEY = " + accel.key);
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public Display getDisplay() {
        Menu parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        int hMenu = this.parent.handle;
        short sState = (short)OS.WinSendMsg(hMenu, 401, OS.MPFROM2SHORT((short)this.id, (short)0), 16384);
        return (sState & 0x4000) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        int hMenu = this.parent.handle;
        short sState = (short)OS.WinSendMsg(hMenu, 401, OS.MPFROM2SHORT((short)this.id, (short)0), 8192);
        return (sState & 0x2000) != 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    /*
     * Unable to fully structure code
     */
    String patchMnemonics(String string) {
        buf = new StringBuffer(string);
        mnemonicIdx = string.lastIndexOf(38);
        lastIsMnemonic = false;
        i = 0;
        while (i < buf.length()) {
            v0 = isMnemonic = buf.charAt(i) == '&';
            if (!lastIsMnemonic) ** GOTO lbl24
            if (isMnemonic) {
                buf.deleteCharAt(i--);
                if (mnemonicIdx >= 0) {
                    --mnemonicIdx;
                }
                lastIsMnemonic = false;
            } else {
                if (i - 1 == mnemonicIdx) {
                    buf.replace(i - 1, i, "~");
                    mnemonicIdx = -1;
                } else {
                    buf.deleteCharAt(i-- - 1);
                    if (mnemonicIdx >= 0) {
                        --mnemonicIdx;
                    }
                }
lbl24:
                // 5 sources

                if (!isMnemonic && buf.charAt(i) == '~') {
                    buf.insert(i++, '~');
                    if (mnemonicIdx >= 0) {
                        ++mnemonicIdx;
                    }
                }
                lastIsMnemonic = isMnemonic;
            }
            ++i;
        }
        if (lastIsMnemonic) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    void releaseChild() {
        super.releaseChild();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        if (this.menu != null) {
            this.menu.releaseWidget();
            this.menu.releaseHandle();
        }
        this.menu = null;
        super.releaseWidget();
        if (this.accelerator != 0) {
            this.parent.destroyAcceleratorTable();
        }
        this.accelerator = 0;
        Decorations shell = this.parent.parent;
        shell.remove(this);
        this.parent = null;
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        this.accelerator = accelerator;
        this.parent.destroyAcceleratorTable();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int hMenu = this.parent.handle;
        short sState = (short)OS.WinSendMsg(hMenu, 401, OS.MPFROM2SHORT((short)this.id, (short)0), 16384);
        sState = (short)(sState & 0xFFFFBFFF);
        if (!enabled) {
            sState = (short)(sState | 0x4000);
        }
        int success = OS.WinSendMsg(hMenu, 402, OS.MPFROM2SHORT((short)this.id, (short)0), OS.MPFROM2SHORT((short)16384, sState));
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu;
        int hMenu = this.parent.handle;
        MENUITEM info = new MENUITEM();
        int index = 0;
        while (index < this.parent.getItemCount()) {
            if (OS.WinSendMsg(hMenu, 400, (int)((short)index), 0) == this.id) break;
            ++index;
        }
        int idItem = OS.WinSendMsg(hMenu, 400, (int)((short)index), 0);
        OS.WinSendMsg(hMenu, 386, OS.MPFROM2SHORT((short)idItem, (short)1), info);
        int length = 128;
        PSZ buffer = new PSZ(length);
        if (menu != null) {
            menu.cascade = this;
            info.afStyle = (short)(info.afStyle | 0x10);
            info.hwndSubMenu = menu.handle;
        }
        OS.WinSendMsg(hMenu, 395, OS.MPFROM2SHORT((short)idItem, (short)length), buffer);
        OS.WinSendMsg(hMenu, 385, OS.MPFROM2SHORT((short)idItem, (short)0), 0);
        int rc = OS.WinSendMsg(hMenu, 384, info, buffer);
        if (rc == -1 || rc == -1) {
            this.error(29);
        }
        this.parent.destroyAcceleratorTable();
    }

    public void setSelection(boolean selected) {
        int success;
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        int hMenu = this.parent.handle;
        int sState = OS.WinSendMsg(hMenu, 401, OS.MPFROM2SHORT((short)this.id, (short)1), 8192);
        sState &= 0xFFFFDFFF;
        if (selected) {
            sState |= 0x2000;
        }
        if ((success = OS.WinSendMsg(hMenu, 402, OS.MPFROM2SHORT((short)this.id, (short)1), OS.MPFROM2SHORT((short)8192, (short)sState))) == 0) {
            this.error(28);
        }
        this.parent.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        int hMenu = this.parent.handle;
        string = this.patchMnemonics(string);
        PSZ buffer = new PSZ(string);
        int rc = OS.WinSendMsg(hMenu, 398, (int)((short)this.id), buffer);
        if (rc != 1) {
            this.error(13);
        }
        this.parent.redraw();
    }

    int widgetStyle() {
        if ((this.style & 2) != 0) {
            return 4;
        }
        if ((this.style & 0x40) != 0) {
            return 16;
        }
        return 1;
    }

    MRESULT wmCommandChild(int mp1, int mp2) {
        if ((this.style & 0x30) != 0) {
            this.setSelection(!this.getSelection());
        }
        Event event = new Event();
        if ((OS.WinGetKeyState(1, 41) & 0x8000) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((OS.WinGetKeyState(1, 9) & 0x8000) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((OS.WinGetKeyState(1, 10) & 0x8000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((OS.WinGetKeyState(1, 1) & 0x8000) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((OS.WinGetKeyState(1, 2) & 0x8000) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((OS.WinGetKeyState(1, 3) & 0x8000) != 0) {
            event.stateMask |= 0x200000;
        }
        this.postEvent(13, event);
        return null;
    }

    MRESULT wmDrawChild(int mp1, int mp2) {
        System.out.println("MenuItem:wmDrawChild");
        OWNERITEM struct = new OWNERITEM();
        OS.objcpy(struct, mp2);
        return null;
    }

    MRESULT wmMeasureChild(int mp1, int mp2) {
        System.out.println("MenuItem:wmMeasureChild");
        return null;
    }
}

