/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.BITMAPINFOHEADER2;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.internal.pm.SWP;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Button
extends Control {
    String text = "";
    Image image;
    static final int ButtonProc;
    static final PSZ ButtonClass;
    static final int CheckWidth;
    static final int CheckHeight;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
        if ((style & 0x800000) != 0 && (style & 0xA) != 0) {
            int[] value = new int[]{-39};
            int index = value[0] < 0 || this.getDisplay().hPalette != 0 ? 4 : 3;
            OS.WinSetPresParam(this.handle, index, 4, value);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        if (msg == 15 && (this.style & 2) != 0 && this.image == null) {
            return 0;
        }
        return OS.WinCallWindowProc(ButtonProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 8, 4, 32, 16, 2, 0)) & 8) != 0) {
            return Widget.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x32) != 0) {
            return Widget.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Widget.checkBits(style, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        OS.WinSendMsg(this.handle, 288, 0, 0);
    }

    byte[] computeWindowTextSize(int hps, FONTMETRICS fm, Point size) {
        size.x = 0;
        size.y = fm.lMaxBaselineExt;
        int length = OS.WinQueryWindowTextLength(this.handle);
        byte[] text = null;
        if (length != 0) {
            PSZ buffer = new PSZ(length);
            OS.WinQueryWindowText(this.handle, length + 1, buffer);
            RECTL rect = new RECTL();
            text = buffer.getBytes();
            int[] pnts = new int[10];
            int extX = 0;
            int dx = 0;
            int is = 0;
            while (is < length) {
                int ie = is + 512;
                if (ie > length) {
                    ie = length;
                }
                if (is != 0) {
                    System.arraycopy(text, is, text, 0, ie - is);
                }
                OS.GpiQueryTextBox(hps, ie - is, text, 5, pnts);
                extX += pnts[8];
                dx = pnts[4];
                if (dx < pnts[8]) {
                    dx = pnts[8];
                }
                dx -= pnts[8];
                is = ie;
            }
            size.x = extX + dx;
        }
        text = this.patchMnemonics(this.text).getBytes();
        return text;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                width += OS.WinQuerySysValue(1, 22);
                height += OS.WinQuerySysValue(1, 24) + 4;
            } else {
                width += OS.WinQuerySysValue(1, 25) + 4;
                height += OS.WinQuerySysValue(1, 23);
            }
            if (wHint != -1) {
                width = wHint + border * 2;
            }
            if (hHint != -1) {
                height = hHint + border * 2;
            }
            return new Point(width, height);
        }
        int extra = 0;
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        if (this.image == null) {
            Point size = new Point(0, 0);
            int hps = this.hps;
            if (hps == 0) {
                hps = OS.WinGetPS(this.handle);
            }
            FONTMETRICS fm = new FONTMETRICS();
            OS.GpiQueryFontMetrics(hps, 228, fm);
            if (this.computeWindowTextSize(hps, fm, size) != null) {
                extra = Math.max(8, fm.lAveCharWidth);
                width += size.x;
            }
            height += size.y;
            if (this.hps == 0) {
                OS.WinReleasePS(hps);
            }
        } else {
            Rectangle rect = this.image.getBounds();
            width = rect.width;
            height = rect.height;
            extra = 4;
        }
        if ((this.style & 0x30) != 0) {
            width += CheckWidth + extra;
            height = Math.max(height + 2, CheckHeight + 2);
        }
        if ((this.style & 0xA) != 0) {
            width += 10;
            height += 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return -40;
        }
        return super.defaultBackground();
    }

    int defaultForeground() {
        return -18;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.style & 0xA) != 0) {
            return OS.WinQuerySysValue(1, 26);
        }
        return 0;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        return (bits & 0x400) != 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int state = OS.WinSendMsg(this.handle, 292, 0, 0);
        return (state & 0xFFFF) != 0;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean isTabItem() {
        return super.isTabItem();
    }

    boolean mnemonicHit(char ch) {
        if (!this.setFocus()) {
            return false;
        }
        this.click();
        return true;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child && child instanceof Button) {
                Button button = (Button)child;
                if ((button.style & 0x10) != 0 && button.getSelection()) {
                    OS.WinPostMsg(button.handle, 293, 0, button.handle);
                }
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            OS.WinInvalidateRect(this.handle, null, false);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getDefault() == value) {
            return;
        }
        if (value) {
            OS.WinSendMsg(this.handle, 294, 1, 0);
        } else {
            OS.WinSendMsg(this.handle, 294, 0, 0);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return false;
        }
        return super.setFocus();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 0x38) != 0 && (image != null && this.image == null || image == null && this.image != null)) {
            int bits = OS.WinQueryWindowULong(this.handle, -2);
            bits &= 0xFFFFFFF0;
            if (image != null) {
                bits |= 7;
            } else if ((this.style & 8) != 0) {
                bits |= 0;
            } else if ((this.style & 0x20) != 0) {
                bits |= 1;
            } else if ((this.style & 0x10) != 0) {
                bits |= 3;
            }
            OS.WinSetWindowULong(this.handle, -2, bits);
        }
        this.image = image;
        OS.WinInvalidateRect(this.handle, null, false);
    }

    void setPresBackground() {
        if ((this.style & 0xA) != 0) {
            return;
        }
        super.setPresBackground();
    }

    void setPresForeground() {
        if ((this.style & 0xA) != 0) {
            return;
        }
        super.setPresForeground();
    }

    boolean setRadioFocus() {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return this.setFocus();
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        OS.WinSendMsg(this.handle, 293, selected ? 1 : 0, 0);
        OS.WinSetWindowULong(this.handle, -2, bits);
        if (!selected) {
            return;
        }
        if ((this.style & 0x10) == 0) {
            return;
        }
        this.menuShell().setSavedFocus(this);
    }

    boolean setTabItemFocus() {
        boolean result = super.setTabItemFocus();
        if ((this.style & 0x10) != 0 && result) {
            this.click();
        }
        return result;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.image != null && (this.style & 0x38) != 0) {
            int bits = OS.WinQueryWindowULong(this.handle, -2);
            bits &= 0xFFFFFFF0;
            if ((this.style & 8) != 0) {
                bits |= 0;
            } else if ((this.style & 0x20) != 0) {
                bits |= 1;
            } else if ((this.style & 0x10) != 0) {
                bits |= 3;
            }
            OS.WinSetWindowULong(this.handle, -2, bits);
        }
        this.image = null;
        this.text = string;
        string = this.patchMnemonics(string);
        PSZ title = new PSZ(string);
        OS.WinSetWindowText(this.handle, title);
    }

    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            bits |= 0x1000;
        }
        if ((this.style & 4) != 0) {
            return bits | 0 | 7 | 0x2000 | 0x800;
        }
        if ((this.style & 8) != 0) {
            return bits | 0 | 0x20000;
        }
        if ((this.style & 0x20) != 0) {
            return bits | 1;
        }
        if ((this.style & 0x10) != 0) {
            return bits | 3;
        }
        if ((this.style & 2) != 0) {
            return bits | 0 | 7;
        }
        return bits | 0 | 0x20000;
    }

    PSZ windowClass() {
        return ButtonClass;
    }

    int windowProc() {
        return ButtonProc;
    }

    int windowProc(int msg, int mp1, int mp2) {
        int result = super.windowProc(msg, mp1, mp2);
        if (msg == 293 && mp2 == this.handle) {
            this.postEvent(13);
        }
        return result;
    }

    void drawFocusRect() {
        int hps = OS.WinGetPS(this.handle);
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.handle, rcl);
        boolean doit = false;
        if (this.image == null) {
            FONTMETRICS fm = new FONTMETRICS();
            Point size = new Point(0, 0);
            OS.GpiQueryFontMetrics(hps, 228, fm);
            if (this.computeWindowTextSize(hps, fm, size) != null) {
                rcl.xLeft = (rcl.xRight - size.x) / 2 - 1;
                rcl.yBottom = (rcl.yTop - size.y) / 2 - 1;
                rcl.xRight = rcl.xLeft + size.x + 2;
                rcl.yTop = rcl.yBottom + size.y + 2;
                doit = true;
            }
        } else if (rcl.xRight > rcl.xLeft && rcl.yTop > rcl.yBottom) {
            doit = true;
        }
        if (doit) {
            int[] lineBundle = new int[]{0, -2, 262149, 0, 0, 9, 0};
            OS.GpiSetAttrs(hps, 1, 78, 0, lineBundle);
            int[] pnt = new int[]{rcl.xLeft, rcl.yBottom};
            OS.GpiMove(hps, pnt);
            pnt[0] = rcl.xRight - 1;
            pnt[1] = rcl.yTop - 1;
            OS.GpiBox(hps, 2, pnt, 0, 0);
        }
        OS.WinReleasePS(hps);
    }

    MRESULT WM_QUERYDLGCODE(int mp1, int mp2) {
        MRESULT result = super.WM_QUERYDLGCODE(mp1, mp2);
        if (result != null) {
            return result;
        }
        if ((this.style & 4) != 0) {
            return new MRESULT(8);
        }
        if ((this.style & 0x10) != 0) {
            return new MRESULT(6);
        }
        if ((this.style & 0x22) != 0) {
            return new MRESULT(66);
        }
        return result;
    }

    MRESULT WM_SETFOCUS(int mp1, int mp2) {
        boolean gotFocus = OS.SHORT1FROMMP(mp2) > 0;
        MRESULT result = null;
        if (gotFocus) {
            int bits = 0;
            if ((this.style & 0x10) != 0) {
                bits = OS.WinQueryWindowULong(this.handle, -2);
            }
            result = super.WM_SETFOCUS(mp1, mp2);
            if ((this.style & 0x10) != 0) {
                OS.WinSetWindowULong(this.handle, -2, bits);
            }
            if ((this.style & 8) != 0) {
                this.menuShell().setDefaultButton(this, false);
            }
        } else {
            result = super.WM_SETFOCUS(mp1, mp2);
            if ((this.style & 8) != 0 && this.getDefault()) {
                this.menuShell().setDefaultButton(null, false);
            }
        }
        if (gotFocus) {
            if ((this.style & 2) != 0 && this.image == null) {
                OS.WinInvalidateRect(this.handle, null, false);
            } else {
                Control oldFocus = WidgetTable.get(mp1);
                if (oldFocus != null && oldFocus instanceof Button) {
                    Button b = (Button)oldFocus;
                    if ((b.style & 2) != 0 && b.image == null) {
                        OS.WinInvalidateRect(b.handle, null, false);
                    }
                }
            }
        } else if ((this.style & 2) != 0 && this.image == null && WidgetTable.get(mp1) == null) {
            this.drawFocusRect();
        }
        return result;
    }

    MRESULT wmCommandChild(int mp1, int mp2) {
        if ((this.style & 0x32) == 0) {
            this.postEvent(13);
        }
        return super.wmCommandChild(mp1, mp2);
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        int code = mp1 >> 16;
        switch (code) {
            case 1: 
            case 2: {
                if ((this.style & 0xC) != 0) break;
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) == 0) {
                        this.selectRadio();
                    } else {
                        this.setSelection(!this.getSelection());
                    }
                }
                this.postEvent(13);
                break;
            }
            case 3: {
                return this.wmDrawChild(mp1, mp2);
            }
        }
        return super.wmControlChild(mp1, mp2);
    }

    MRESULT wmDrawChild(int mp1, int mp2) {
        int hbmMem;
        int hdcMem;
        int hpsMem;
        int hpsButton;
        SWP swp;
        block55: {
            int dy;
            int[] hrgnOld;
            int hrgn;
            int bw;
            int parentBackground;
            int hPalette;
            int hps;
            int focusH;
            int focusW;
            int focusY;
            int focusX;
            int[] pnt;
            boolean checkOrRadio;
            boolean flat;
            boolean enabled;
            boolean def;
            boolean hilited;
            boolean checked;
            block54: {
                int clr2;
                int clr1;
                block53: {
                    swp = new SWP();
                    this.getBounds(swp);
                    if (swp.cx == 0 || swp.cy == 0) {
                        return MRESULT.ZERO;
                    }
                    int[] userbutton = new int[16];
                    OS.objcpy(userbutton, mp2);
                    hpsButton = userbutton[1];
                    int state = userbutton[2];
                    int oldState = userbutton[3];
                    checked = OS.WinSendMsg(this.handle, 292, 0, 0) != 0;
                    hilited = (state & 0x100) != 0;
                    def = (state & 0x400) != 0;
                    enabled = (state & 0x200) == 0;
                    flat = (this.style & 0x800000) != 0;
                    checkOrRadio = (this.style & 0x30) != 0;
                    Display display = this.getDisplay();
                    pnt = new int[]{0, 0};
                    focusX = 0;
                    focusY = 0;
                    focusW = 0;
                    focusH = 0;
                    if ((this.style & 2) != 0 && !hilited && (oldState & 0x100) != 0) {
                        OS.WinQueryMsgPos(0, pnt);
                        OS.WinMapWindowPoints(1, this.handle, pnt, 1);
                        if (pnt[0] > 0 && pnt[1] > 0 && pnt[0] < swp.cx && pnt[1] < swp.cy) {
                            return MRESULT.ZERO;
                        }
                    }
                    hps = hpsButton;
                    hpsMem = 0;
                    hdcMem = 0;
                    hbmMem = 0;
                    if (this.image != null || (this.style & 4) != 0 && swp.cx > 22 && swp.cy > 22 || (this.style & 2) != 0) {
                        hdcMem = OS.DevOpenDC(0, 8, new PSZ("*"), 4, new PSZ[]{new PSZ("Display"), null, null, null}, 0);
                        hpsMem = OS.GpiCreatePS(0, hdcMem, new int[]{swp.cx, swp.cy}, 20488);
                        BITMAPINFOHEADER2 hdr = new BITMAPINFOHEADER2();
                        hdr.cx = swp.cx;
                        hdr.cy = swp.cy;
                        hdr.cPlanes = 1;
                        hdr.cBitCount = (short)this.getDisplay().getDepth();
                        hdr.ulCompression = 0;
                        hdr.cbImage = 0;
                        hdr.cxResolution = 0;
                        hdr.cyResolution = 0;
                        hdr.cclrUsed = 0;
                        hdr.cclrImportant = 0;
                        hdr.usUnits = 0;
                        hdr.usReserved = 0;
                        hdr.usRecording = 0;
                        hdr.usRendering = 0;
                        hdr.cSize1 = 0;
                        hdr.cSize2 = 0;
                        hdr.ulColorEncoding = 0;
                        hdr.ulIdentifier = 0;
                        hbmMem = OS.GpiCreateBitmap(hpsMem, hdr, 0, null, null);
                        OS.GpiSetBitmap(hpsMem, hbmMem);
                        if (this.image == null) {
                            GC.internal_set_font(hpsMem, hdcMem, display, this.getFont().internal_get_handle());
                        }
                        hps = hpsMem;
                    }
                    OS.GpiSetMix(hps, 2);
                    OS.GpiSetBackMix(hps, 2);
                    OS.GpiSetPattern(hps, 64);
                    hPalette = this.getDisplay().hPalette;
                    if (hPalette == 0) {
                        OS.GpiCreateLogColorTable(hps, 0, 3, 0, 0, null);
                    } else {
                        OS.GpiSelectPalette(hps, hPalette);
                    }
                    parentBackground = this.parent.getBackgroundPixel();
                    bw = (this.style & 0xA) != 0 ? 1 : 0;
                    hrgn = 0;
                    hrgnOld = new int[1];
                    OS.GpiSetColor(hps, parentBackground);
                    if (bw > 0) {
                        pnt[0] = 0;
                        pnt[1] = 0;
                        OS.GpiMove(hps, pnt);
                        pnt[0] = swp.cx - 1;
                        pnt[1] = swp.cy - 1;
                        OS.GpiBox(hps, 2, pnt, 0, 0);
                    }
                    if (!flat && !checkOrRadio) break block53;
                    pnt[0] = bw;
                    pnt[1] = bw;
                    OS.GpiMove(hps, pnt);
                    pnt[0] = swp.cx - bw - 1;
                    pnt[1] = swp.cy - bw - 1;
                    if ((this.style & 2) != 0 && checked) {
                        OS.GpiSetColor(hps, parentBackground);
                        OS.GpiSetBackColor(hps, -41);
                        OS.GpiSetPattern(hps, 17);
                    } else if (checkOrRadio) {
                        OS.GpiSetBackColor(hps, this.getBackgroundPixel());
                    } else {
                        OS.GpiSetBackColor(hps, parentBackground);
                    }
                    OS.GpiBox(hps, 1, pnt, 0, 0);
                    break block54;
                }
                pnt[0] = bw;
                pnt[1] = bw;
                OS.GpiSetPel(hps, pnt);
                pnt[0] = swp.cx - bw - 1;
                pnt[1] = swp.cy - bw - 1;
                OS.GpiSetPel(hps, pnt);
                OS.GpiSetColor(hps, -39);
                pnt[0] = bw;
                pnt[1] = bw + 1;
                OS.GpiMove(hps, pnt);
                pnt[1] = swp.cy - bw - 1;
                OS.GpiLine(hps, pnt);
                pnt[0] = swp.cx - bw - 2;
                OS.GpiLine(hps, pnt);
                OS.GpiSetColor(hps, -41);
                pnt[0] = pnt[0] + 1;
                pnt[1] = pnt[1] - 1;
                OS.GpiMove(hps, pnt);
                pnt[1] = bw;
                OS.GpiLine(hps, pnt);
                pnt[0] = bw + 1;
                OS.GpiLine(hps, pnt);
                if (hilited || checked) {
                    clr1 = -39;
                    clr2 = -41;
                } else {
                    clr1 = -41;
                    clr2 = -39;
                }
                OS.GpiSetColor(hps, clr1);
                pnt[1] = swp.cy - bw - 2;
                OS.GpiLine(hps, pnt);
                pnt[0] = swp.cx - bw - 3;
                OS.GpiLine(hps, pnt);
                pnt[0] = pnt[0] - 1;
                pnt[1] = pnt[1] - 1;
                OS.GpiMove(hps, pnt);
                pnt[0] = bw + 2;
                OS.GpiLine(hps, pnt);
                pnt[1] = bw + 2;
                OS.GpiLine(hps, pnt);
                OS.GpiSetColor(hps, clr2);
                pnt[1] = pnt[1] - 1;
                OS.GpiMove(hps, pnt);
                pnt[0] = swp.cx - bw - 2;
                OS.GpiLine(hps, pnt);
                pnt[1] = swp.cy - bw - 2;
                OS.GpiLine(hps, pnt);
                pnt[0] = pnt[0] - 1;
                pnt[1] = pnt[1] - 1;
                OS.GpiMove(hps, pnt);
                pnt[1] = bw + 2;
                OS.GpiLine(hps, pnt);
                pnt[0] = bw + 3;
                OS.GpiLine(hps, pnt);
                int lim = 6 + (bw << 1);
                if (swp.cx <= lim || swp.cy <= lim) break block55;
                pnt[1] = pnt[1] + 1;
                OS.GpiMove(hps, pnt);
                pnt[0] = swp.cx - bw - 4;
                pnt[1] = swp.cy - bw - 4;
                if ((this.style & 2) != 0 && checked && enabled) {
                    OS.GpiSetColor(hps, -40);
                    OS.GpiSetBackColor(hps, -41);
                    OS.GpiSetPattern(hps, 17);
                } else {
                    OS.GpiSetBackColor(hps, -40);
                }
                OS.GpiBox(hps, 1, pnt, 0, 0);
                hrgn = OS.GpiCreateRegion(hps, 1, new int[]{bw + 3, bw + 3, pnt[0] + 1, pnt[1] + 1});
                OS.GpiSetClipRegion(hps, hrgn, hrgnOld);
            }
            if ((this.style & 4) != 0) {
                pnt[0] = swp.cx / 2;
                pnt[1] = swp.cy / 2;
                if (hilited && !flat) {
                    pnt[0] = pnt[0] + 1;
                    pnt[1] = pnt[1] - 1;
                }
                int half = swp.cx < swp.cy ? swp.cx : swp.cy;
                half -= bw * 2 + 8;
                half /= 2;
                if (--half < 0) {
                    half = 0;
                }
                int dx = 0;
                dy = 0;
                if ((this.style & 0x480) != 0) {
                    pnt[1] = (this.style & 0x80) != 0 ? pnt[1] + half / 2 : pnt[1] - (half / 2 + 1);
                    dx = swp.cx % 2 == 0 ? 1 : 0;
                } else {
                    pnt[0] = (this.style & 0x4000) != 0 ? pnt[0] + half / 2 : pnt[0] - (half / 2 + 1);
                    dy = swp.cy % 2 == 0 ? 1 : 0;
                }
                int[] pnts = new int[6];
                if (enabled) {
                    OS.GpiSetBackColor(hps, hilited && flat ? -39 : -18);
                } else {
                    OS.GpiSetColor(hps, -18);
                    OS.GpiSetBackColor(hps, -40);
                    OS.GpiSetPattern(hps, 17);
                }
                OS.GpiBeginArea(hps, 0);
                OS.GpiMove(hps, pnt);
                if ((this.style & 0x20400) != 0) {
                    pnts[0] = pnt[0];
                    pnts[1] = pnt[1];
                    pnts[2] = pnt[0];
                    pnts[3] = pnt[1] + half;
                    pnts[4] = pnt[0] + half;
                    pnts[5] = pnt[1];
                    OS.GpiPolyLine(hps, pnts.length / 2, pnts);
                }
                if ((this.style & 0x4400) != 0) {
                    pnts[0] = pnt[0] - dx;
                    pnts[1] = pnt[1];
                    pnts[2] = pnt[0] - dx;
                    pnts[3] = pnt[1] + half;
                    pnts[4] = pnt[0] - dx - half;
                    pnts[5] = pnt[1];
                    OS.GpiPolyLine(hps, pnts.length / 2, pnts);
                }
                if ((this.style & 0x4080) != 0) {
                    pnts[0] = pnt[0] - dx;
                    pnts[1] = pnt[1] - dy;
                    pnts[2] = pnt[0] - dx;
                    pnts[3] = pnt[1] - dy - half;
                    pnts[4] = pnt[0] - dx - half;
                    pnts[5] = pnt[1] - dy;
                    OS.GpiPolyLine(hps, pnts.length / 2, pnts);
                }
                if ((this.style & 0x20080) != 0) {
                    pnts[0] = pnt[0];
                    pnts[1] = pnt[1] - dy;
                    pnts[2] = pnt[0];
                    pnts[3] = pnt[1] - dy - half;
                    pnts[4] = pnt[0] + half;
                    pnts[5] = pnt[1] - dy;
                    OS.GpiPolyLine(hps, pnts.length / 2, pnts);
                }
                OS.GpiEndArea(hps);
            } else if ((this.style & 2) != 0 && this.image == null) {
                FONTMETRICS fm = new FONTMETRICS();
                OS.GpiQueryFontMetrics(hps, 228, fm);
                Point size = new Point(0, 0);
                byte[] text = this.computeWindowTextSize(hpsButton, fm, size);
                if (text != null) {
                    RECTL rcl = new RECTL();
                    int cx = swp.cx;
                    if (!flat) {
                        --cx;
                    }
                    rcl.xLeft = (cx - size.x) / 2;
                    rcl.yBottom = (swp.cy - size.y) / 2;
                    if (hilited && !flat) {
                        ++rcl.xLeft;
                        --rcl.yBottom;
                    }
                    rcl.xRight = rcl.xLeft + size.x;
                    rcl.yTop = rcl.yBottom + size.y;
                    OS.GpiSetBackMix(hps, 5);
                    OS.GpiSetPattern(hps, 16);
                    OS.WinDrawText(hps, -1, text, rcl, hilited && flat ? -39 : -18, 0, 8192);
                    if (OS.WinQueryFocus(1) == this.handle && !hilited) {
                        focusX = (swp.cx - size.x) / 2 - 1;
                        focusY = (swp.cy - size.y) / 2 - 1;
                        focusW = size.x + 2;
                        focusH = size.y + 2;
                    }
                }
            } else if (checkOrRadio) {
                int dx;
                int hBitmap = OS.WinGetSysBitmap(1, 48);
                int y = (swp.cy - CheckHeight) / 2;
                dy = (this.style & 0x10) != 0 ? 1 : 2;
                dy *= CheckHeight;
                int n = dx = hilited ? 2 : 0;
                if (checked) {
                    ++dx;
                }
                OS.GpiWCBitBlt(hps, hBitmap, 4, new int[]{0, y, CheckWidth - 1, y + CheckHeight - 1, dx *= CheckWidth, dy, dx + CheckWidth, dy + CheckHeight}, 204, 2);
                OS.GpiDeleteBitmap(hBitmap);
            }
            if (this.image != null && (this.style & 4) == 0) {
                Rectangle bounds = this.image.getBounds();
                int x = 0;
                int y = (swp.cy - bounds.height) / 2;
                if (checkOrRadio) {
                    x = CheckWidth + 4;
                } else {
                    x = (swp.cx - bounds.width) / 2;
                    if (hilited) {
                        ++x;
                        --y;
                    }
                }
                if (this.image.type == 0) {
                    OS.GpiWCBitBlt(hps, this.image.handle, 4, new int[]{x, y, x + bounds.width - 1, y + bounds.height - 1, 0, 0, bounds.width, bounds.height}, 204, 2);
                } else if (this.image.type == 1) {
                    int hbmColor = this.image.handle;
                    int hbmPointer = this.image.maskHandle;
                    if (hbmPointer == 0) {
                        OS.WinDrawPointer(hps, x, y, hbmColor, 0);
                    } else {
                        OS.GpiSetColor(hps, hPalette != 0 ? 15 : 0xFFFFFF);
                        OS.GpiSetBackColor(hps, 0);
                        OS.GpiWCBitBlt(hps, hbmPointer, 4, new int[]{x, y, x + bounds.width - 1, y + bounds.height - 1, 0, bounds.height, bounds.width, bounds.height << 1}, 136, 2);
                        OS.GpiWCBitBlt(hps, hbmColor, 4, new int[]{x, y, x + bounds.width - 1, y + bounds.height - 1, 0, 0, bounds.width, bounds.height}, 102, 2);
                        OS.GpiWCBitBlt(hps, hbmPointer, 4, new int[]{x, y, x + bounds.width - 1, y + bounds.height - 1, 0, 0, bounds.width, bounds.height}, 102, 2);
                    }
                }
            }
            if (hrgn != 0) {
                OS.GpiSetClipRegion(hps, hrgnOld[0], hrgnOld);
                OS.GpiDestroyRegion(hps, hrgn);
            }
            if (focusW > 0 && focusH > 0) {
                int[] lineBundle = new int[]{0, -2, 262149, 0, 0, 9, 0};
                OS.GpiSetAttrs(hps, 1, 78, 0, lineBundle);
                pnt[0] = focusX;
                pnt[1] = focusY;
                OS.GpiMove(hps, pnt);
                pnt[0] = focusX + focusW - 1;
                pnt[1] = focusY + focusH - 1;
                OS.GpiBox(hps, 2, pnt, 0, 0);
            }
            if (!flat && def && (this.style & 8) != 0) {
                OS.GpiSetColor(hps, -38);
                pnt[0] = 0;
                pnt[1] = 0;
                OS.GpiMove(hps, pnt);
                pnt[0] = swp.cx - 1;
                pnt[1] = swp.cy - 1;
                OS.GpiBox(hps, 2, pnt, 0, 0);
                pnt[0] = 1;
                pnt[1] = 1;
                OS.GpiMove(hps, pnt);
                pnt[0] = swp.cx - 2;
                pnt[1] = swp.cy - 2;
                OS.GpiBox(hps, 2, pnt, 0, 0);
            }
            if (!enabled && ((this.style & 0xA) != 0 || checkOrRadio)) {
                OS.GpiSetColor(hps, checkOrRadio ? parentBackground : -40);
                OS.GpiSetBackMix(hps, 5);
                OS.GpiSetPattern(hps, 17);
                pnt[0] = 0;
                pnt[1] = 0;
                OS.GpiMove(hps, pnt);
                pnt[0] = swp.cx - 1;
                pnt[1] = swp.cy - 1;
                OS.GpiBox(hps, 1, pnt, 0, 0);
            }
        }
        if (hpsMem != 0) {
            OS.GpiBitBlt(hpsButton, hpsMem, 4, new int[]{0, 0, swp.cx, swp.cy, 0, 0, swp.cx, swp.cy}, 204, 2);
            OS.GpiDestroyPS(hpsMem);
            OS.DevCloseDC(hdcMem);
            OS.GpiDeleteBitmap(hbmMem);
        }
        return MRESULT.ZERO;
    }

    static {
        ButtonClass = PSZ.getAtom(-65533);
        int hBitmap = OS.WinGetSysBitmap(1, 48);
        if (hBitmap == 0) {
            CheckWidth = OS.WinQuerySysValue(1, 22);
            CheckHeight = OS.WinQuerySysValue(1, 23);
        } else {
            BITMAPINFOHEADER2 bmpData = new BITMAPINFOHEADER2();
            OS.GpiQueryBitmapInfoHeader(hBitmap, bmpData);
            OS.GpiDeleteBitmap(hBitmap);
            CheckWidth = bmpData.cx / 4;
            CheckHeight = bmpData.cy / 3;
        }
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, ButtonClass, pclsiClassInfo);
        ButtonProc = pclsiClassInfo.pfnWindowProc;
    }
}

