/*============================================================================*/
/* SVCRun.CMD                                                                 */
/*                                                                            */
/* Run SETI@Home using work units from a set of cache directories.            */
/*                                                                            */
/*============================================================================*/
/* Part of SETIView/2 Cache                                                   */
/*                                                                            */
/* Copyright David Forrester 1999-2001                                        */
/* Created:   Sometime in 1999                                                */
/*                                                                            */
/*============================================================================*/
/* Modification History:                                                      */
/* 0.1.1 - Wasn't checking hostname correctly.  Meant that two machines       */
/*         could attempt to process same work unit.                           */
/*       - Reformatted If statements.                                         */
/*                                                                            */
/* 0.1.2 - Change to using Directory function instead of CD.                  */
/*       - Slight changes to details displayed on the screen.                 */
/*                                                                            */
/* 0.1.3 - New: Adding parameters for SETILog2.CMD so that SAH files aren't   */
/*         backed up or can turn off logging.                                 */
/*                                                                            */
/* 0.1.3 - New: Adding parameters for SETILog2.CMD so that SAH files aren't   */
/*         backed up or can turn off logging.                                 */
/*                                                                            */
/* 0.1.4 - New: Making changes so that it can be run under Regina in Win2000. */
/*                                                                            */
/*============================================================================*/
Trace "Off"
Parse Arg remove_host_name .

/* Customise here */
seti_program_OS2 = "..\setiathome.exe"
seti_program_Win = "..\setiathome-3.03.i386-winnt-cmdline.exe"
seti_parameters  = ""
seti_proxy       = ""
seti_Log_Dir     = ''
setiLog2_params  = "/NOBACKUP"
/* End of Customisation section */

Parse Source opSys callType programName tail

If opSys = 'WIN32' Then seti_program = seti_program_Win
Else seti_program = seti_program_OS2

remove_host_name = Translate(Strip(remove_host_name)) = 'REMOVEHOSTNAME'

seti_parameters = "-stop_after_process" seti_parameters

'mode 80,100'

/* Some general stuff. */
call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs
TRUE  = 1
FALSE = 0

seti_ext             = 'sah'
seti_work_unit_name  = 'work_unit'
seti_result_name     = 'result'
seti_state_name      = 'state'
seti_work_unit_file  = seti_work_unit_name  || '.' || seti_ext
seti_state_file      = seti_state_name      || '.' || seti_ext
seti_result_file     = seti_result_name     || '.' || seti_ext

seti_ok_file_name   = 'SVCache.OK'
seti_stop_file_name = 'SVCache.STOP'
setihost_file       = 'SVCache.HOST'
done_progress       = 0.999
max_date_const      = '9999-99-99 99:99:99'

hostname = Strip(Value('HOSTNAME', , 'OS2ENVIRONMENT'))
If hostname = '' then hostname = 'UNKNOWN'

seti_command    = seti_program seti_parameters seti_proxy

dir_found = TRUE
start_dir = Directory()

Do While dir_found

  /* Set the variables for finding appropriate directories. */
  dir_found          = FALSE
  use_dir            = FALSE
  seti_host_found    = FALSE
  max_progress       = 0
  max_dir            = 0
  min_date_dir       = 0
  work_file_date     = max_date_const
  min_work_file_date = max_date_const
  setihost_operating_system = ''
  Call Directory start_dir

  /* Firstly, search the directories for one that this machine is processing.     */
  /* Or is available.                                                             */
  Call SysFileTree '*', 'cacheDirs', 'DO'
  Do i = 1 To cacheDirs.0 While \dir_found
    opSys_ok     = TRUE
    possible_dir = TRUE
    setihost_operating_system = ''
    Call Directory cacheDirs.i
    Say 'Checking dir' cacheDirs.i
    If Stream(seti_ok_file_name, 'C', 'QUERY EXISTS') <> '' | Stream(seti_stop_file_name, 'C', 'QUERY EXISTS') <> '' Then Do
      progress = GetState()
      Say '  progress= ' progress

      If progress > done_progress Then Do
         possible_dir = FALSE
         Say '  Progress='progress '  Deleting SETIHOST'
         Call SysFileDelete(setihost_file)
      End /* If .. Then Do */
      Else Do
         If Stream(setihost_file, 'C', 'QUERY EXISTS') <> '' Then Do
            Say '  'setihost_file' exists'
            setihost_hostName = GetProcessorName()
            setihost_operating_system = Strip(operating_system)
            If Translate(hostname) = Translate(setihost_hostName) Then Do
               Say '    host name matches!'
               seti_host_found = TRUE
               If opSys = operating_system Then Do
                  possible_dir = TRUE
                  seti_host_found = TRUE
                  Say '    operating system matches!'
                  Say '    Progress='progress '  Deleting SETIHOST'
                  Call SysFileDelete(setihost_file)
                  dir_found = TRUE
                  use_dir   = cacheDirs.i
                  Say '    hostname='hostname '  dir_found='dir_found '  use_dir='use_dir '  possible_dir='possible_dir
                  Say '    setihost_hostName='setihost_hostName
               End /* If .. Then Do */
               Else Do
                  seti_host_found = FALSE
                  possible_dir    = FALSE
                  Say "    operating system doesn't match!"
                  Say '    hostname='hostname '  dir_found='dir_found '  use_dir='use_dir  'operating system='operating_system '  possible_dir='possible_dir
               End /* Else Do */
            End /* If .. Then Do */
            Else If setihost_hostName = '' Then Do
                seti_host_found = FALSE
                opSys_ok        = (setihost_operating_system = '' | setihost_operating_system = opSys)
                possible_dir    = opSys_ok
                Say "    "setihost_file" host name empty"
                Say '    hostname='hostname '  setihost_operating_system='setihost_operating_system '  possible_dir='possible_dir
            End /* Else Do */
            Else Do
                possible_dir = FALSE
            End /* Else Do */
         End /* If .. Then Do */

         If \dir_found & possible_dir Then Do
            Say '  Setting max and mins'
            max_progress = Max(progress, max_progress)
            If max_progress = progress Then max_dir = cacheDirs.i
            Say '    max_progress='max_progress '  progress='progress '  max_dir='max_dir
            Say '    min_work_file_date='min_work_file_date '  work_file_date='work_file_date
            Say '    min_date_dir='min_date_dir '  min_work_file_date='min_work_file_date
            Say '    setihost_operating_system='setihost_operating_system  'opSys='opSys '  possible_dir='possible_dir
            If min_work_file_date > work_file_date Then
            Do
               min_date_dir = cacheDirs.i
               min_work_file_date = work_file_date
            End /* If .. Then Do */

         End /* If .. Then Do */
      End /* Else Do */
    End /* If .. Then Do */
  End

  /* If only deleting the host file, then leave the loop. */
  If remove_host_name Then Do
     /* Want to write a host file that indicates the operating system used. */
     If dir_found & seti_host_found Then
     Do
        Say 'Removing host name from Host file then exiting...'
        Call Directory use_dir
        Call WriteProcessorFile
     End /* If .. Then Do */
     Leave
  End /* If .. Then Do */

  /* Didn't find a directory for this machine.  Use the one that's */
  /* furthest along.                                               */
  If \dir_found Then Do
    If (max_progress < done_progress) & (max_progress > 0) Then Do
      dir_found = 1
      use_dir   = max_dir
    End /* If .. Then Do */
    Else If (min_date_dir > 0) & (max_progress = 0) Then Do
      dir_found = 1
      use_dir   = min_date_dir
    End /* Else If .. Then Do */
  End /* If .. Then Do */

  /* Now lets run it. */
  If dir_found Then Do
     Call Directory use_dir
     Call WriteProcessorFile hostname
     Say 'Processing in directory' use_dir
     seti_command
     Say 'Finished with rc=' || rc
     Call '..\SetiLog2.CMD' seti_Log_Dir setilog2_params
     Call SysFileDelete(setihost_file)
     Call WriteProcessorFile
     dir_found = 1
  End
  Else dir_found = 0
  Say "Restarting in 30 seconds.  Press Ctrl-C to stop."
  Call SysSleep 30

End /* Do While .. */

Exit

GetState:
/* Return the percent complete of the work unit. */
progress = 0
found    = 0
If Stream(seti_result_file, 'C', 'QUERY EXISTS') <> '' Then progress = 1.00
Else Do
  call stream seti_state_file , 'C', 'OPEN READ'
  if lines(seti_state_file) = 0 then do
     If Stream(seti_result_file, 'C', 'QUERY EXISTS') <> '' Then progress = 1.00
     Else progress = 0
  End /* If .. Then Do */
  Else Do
    do while \found & lines(seti_state_file) > 0
       theline = linein(seti_state_file)
       if abbrev(theline, 'prog=') then do
          found = 1
          parse var theline . '=' progress
       End /* If .. Then Do */
    end /* Do While .. */
  End /* Else Do */
  Call stream seti_state_file, 'C', 'CLOSE'
End /* Else Do */

work_file_date = max_date_const
If progress < done_progress Then Do
   work_file_date = SysGetFileDateTime(seti_work_unit_file)
   If work_file_date = -1 Then Do
      work_file_date = max_date_const
   End /* If .. Then Do */
End /* If .. Then Do */

Return progress /* GetState */


GetProcessorName:
/* Read the host file to determine the processor name. */

found = 0
call stream setihost_file , 'C', 'OPEN READ'
if lines(setihost_file) = 0 then do
   processorname    = ''
   operating_system = ''
end
else do
   do while \found & lines(setihost_file) > 0
      theline = linein(setihost_file)
      if abbrev(theline, 'host=') Then Do
         Parse Var theline . '=' processorname
      end
      Else If abbrev(theline, 'opera') Then Do
         Parse Var theline . '=' operating_system
      end
   end
end
call stream setihost_file, 'C', 'CLOSE'

Return Strip(processorname) /* GetProcessorName */


WriteProcessorFile:
/* Write the host file to store details of who is processing this. */
Parse Arg processing_hostname

Call Stream  setihost_file , 'C', 'OPEN WRITE'
/* Call Stream  setihost_file , 'C', 'SEEK 0' */

Call Lineout setihost_file, "host=" processing_hostname, 1
Call Lineout setihost_file, "max_progress=" max_progress
Call Lineout setihost_file, "use_dir=" use_dir
Call Lineout setihost_file, "max_dir=" max_dir
Call Lineout setihost_file, "min_date_dir=" min_date_dir
Call Lineout setihost_file, "min_work_file_date=" min_work_file_date
Call Lineout setihost_file, "operating_system=" opSys
Call Stream  setihost_file, 'C', 'CLOSE'

Return processorname /* WriteProcessorFile */


