/*============================================================================*/
/* SVCBuf.CMD                                                                 */
/*                                                                            */
/* Go through the SETI@Home buffer directories and send/get work units.       */
/* - Checks all subdirectories                                                */
/* - Decides based on files whether to return a work unit, get another or     */
/*   ignore the directory.                                                    */
/*                                                                            */
/*============================================================================*/
/* Part of SETIView/2 Cache                                                   */
/*                                                                            */
/* Copyright David Forrester 1999-2001                                        */
/* Created:   Sometime in 1999                                                */
/*                                                                            */
/*============================================================================*/
/* Modification History:                                                      */
/* 0.1.1 - Bug: Didn't rename SVCACHE.START to SVCACHE.OK after getting a new */
/*         work unit.  Also, now deleting STOP_AFTER_SEND.TXT file after work */
/*         unit has been returned and a SVCACHE.STOP file is found.           */
/*                                                                            */
/* 0.1.2 - New: Adding parameters for SETILog2.CMD so that SAH files aren't   */
/*         backed up or can turn off logging.                                 */
/*                                                                            */
/* 0.1.3 - New: Making changes so that it can be run under Regina in Win2000. */
/*                                                                            */
/*============================================================================*/
Trace "Off"

/* Customise here */
start_delay     = 0          /* This is a delay before starting to process the cache. */
seti_dir        = ""
seti_program_OS2 = "..\setiathome.exe"
seti_program_Win = "..\setiathome-3.03.i386-winnt-cmdline.exe"
seti_parameters_OS2 = "-sleep 100"
seti_parameters_Win = ""
seti_proxy          = ""
seti_Log_Dir        = ""
setiLog2_params     = "/NOBACKUP"
/* End of Customisation section */

Parse Source opSys callType programName tail

If opSys = 'WIN32' Then Do
   seti_program    = seti_program_Win
   seti_parameters = seti_parameters_Win
End /* If .. Then Do */
Else Do
   seti_program    = seti_program_OS2
   seti_parameters = seti_parameters_OS2
End /* Else Do */

seti_parameters = "-stop_after_xfer" seti_parameters
seti_command    = seti_program seti_parameters seti_proxy

Call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
Call SysLoadFuncs

'mode 80,100'

false       = 0
true        = 1

/* These are the marker files for various actions. */
seti_ok_file_name        = 'SVCache.OK'
seti_stop_file_name      = 'SVCache.STOP'
seti_no_file_name        = 'SVCache.NO'
seti_start_file_name     = 'SVCache.START'
seti_send_stop_file_name = 'stop_after_send.txt'
seti_result_file_name    = 'result.sah'
seti_header_file_name    = 'result_header.sah'
setihost_file            = 'SVCache.HOST'

seti_ok    = false
seti_stop  = false
seti_start = false
seti_xfer  = false

Say
Say 'Starting SetiBuf!!!!!!!!!!!!!'
'echo Starting SetiBuf!!!!!!!!!!!!!' date() time() '>> SVCbuf.log'
Say

If start_delay > 0 Then Do
   Say '    Waiting' start_delay 'seconds before starting processing...'
   Call SysSleep(start_delay)
end /* If .. Then Do */

start_dir = Directory()
seti_dir  = Directory(seti_dir)

Call SysFileTree '*', 'cacheDirs', 'DO'
Do i = 1 To cacheDirs.0
   Say
   Call Directory cacheDirs.i
   current_dir = seti_dir || '\' || cacheDirs.i || '\'
   Say 'Processing directory =' cacheDirs.i '...'

   seti_xfer   = false
   seti_ok     = Stream(seti_ok_file_name,      'C', 'QUERY EXISTS') <> ''
   seti_start  = Stream(seti_start_file_name,   'C', 'QUERY EXISTS') <> ''
   seti_stop   = Stream(seti_stop_file_name,    'C', 'QUERY EXISTS') <> ''
   seti_result = Stream(seti_result_file_name,  'C', 'QUERY EXISTS') <> ''
   seti_header = Stream(seti_header_file_name,  'C', 'QUERY EXISTS') <> ''

   If \(seti_ok | seti_start | seti_stop) Then
      Do
         Say '  Directory not to be process!'
      End /* If .. Then Do */

   If (seti_ok | seti_start) & (Stream(seti_send_stop_file_name,  'C', 'QUERY EXISTS') <> '') Then
      Do
         Say '  SETI@Home stop file found in directory' cacheDirs.i '!'
         '@DEL' seti_send_stop_file_name
         Say '    Attempting to delete' seti_send_stop_file_name 'file rc=' result
         seti_xfer = true
      End /* If .. Then Do */

   If seti_ok | seti_stop Then
      Do
         result = 0
         If seti_result Then
            Do
               Say '  result file found in directory' cacheDirs.i '!'
               Call '..\SetiLog2.CMD' seti_Log_Dir setilog2_params
               seti_xfer = (result = 0)
            End /* If .. Then Do */
      End /* If .. Then Do */

   If seti_stop Then
      Do
         Say '  Stopping processing in directory' cacheDirs.i '!'
         If seti_result Then
            Do
               '@COPY' seti_stop_file_name seti_send_stop_file_name '>nul'
               Say '    creating file:' seti_send_stop_file_name 'rc=' result
               '@COPY' seti_stop_file_name seti_no_file_name '>nul'
               Say '    creating file:' seti_send_stop_file_name 'rc=' result
               '@DEL' seti_stop_file_name '>nul'
               Say '    deleting file:' seti_stop_file_name 'rc=' result
            End /* If .. Then Do */
         Else Do
            Say '    no result file, so delaying stop.'
         End /* Else Do */
      End /* If .. Then Do */

   If seti_start Then
      Do
         Say '  Starting processing in directory' cacheDirs.i '!'
         seti_xfer = true
      End /* If .. Then Do */

   if \(seti_result | seti_header) & (seti_ok | seti_start | seti_stop) Then
      do
         say '  No header and no result in but supposed to be processing' cacheDirs.i '!'
         say '    Will do a transfer.'
         seti_xfer = true
      end /* if .. then do */

   If seti_xfer Then
      Do
         Say '  Transfering results/getting work unit...'
         seti_command
         Say '    result of seti@home xfer =' rc

         /* Delete the host file. */
         Call SysFileDelete(setihost_file)
      End /* If .. Then Do */

   If seti_stop Then Do
      '@DEL' seti_send_stop_file_name '>nul'
   End /* If .. Then Do */

   If seti_start & Stream(seti_header_file_name,  'C', 'QUERY EXISTS') <> '' Then Do
      '@COPY' seti_start_file_name seti_ok_file_name '>nul'
      Say '    creating file:' seti_ok_file_name 'rc=' result
      '@DEL' seti_start_file_name '>nul'
      Say '    deleting file:' seti_start_file_name 'rc=' result
   End /* If .. Then Do */

   Call Directory start_dir
End


