/*
//  (C) COPYRIGHT International Business Machines Corp. 1996
//  All Rights Reserved
//  Licensed Materials - Property of IBM
//  US Government Users Restricted Rights - Use, duplication or
//  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//
//
//  DISCLAIMER OF WARRANTIES.
//  The following [enclosed] code is sample code created by IBM
//  Corporation. This sample code is not part of any standard or IBM
//  product and is provided to you solely for the purpose of assisting
//  you in the development of your applications.  The code is provided
//  "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
//  NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//  FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
//  THIS CODE.  THIS CODE MAY CONTAIN ERRORS.  IBM shall not be liable
//  for any damages arising out of your use of the sample code, even
//  if it has been advised of the possibility of such damages.
//
//  DISTRIBUTION.
//  This sample code can be freely distributed, copied, altered, and
//  incorporated into other software, provided that it bears the above
//  Copyright notice and DISCLAIMER intact.
*/

#define SOM_Module_checkers_Source

#include "Checkers.ih"

static int redRegistered = FALSE;
static int blackRegistered = FALSE;

SOM_Scope void  SOMLINK COM_ibm_samples_CheckersregisterPlayer(
                                        COM_ibm_samples_Checkers *somSelf, 
                                        Environment *ev, 
                                        COM_ibm_samples_Checkers_Square player)
{
    int x, y;
    COM_ibm_samples_CheckersData *somThis = COM_ibm_samples_CheckersGetData(somSelf);
    COM_ibm_samples_CheckersMethodDebug("COM_ibm_samples_Checkers", "COM_ibm_samples_CheckersregisterPlayer");
  if (player == COM_ibm_samples_Checkers_Red)
    if (!redRegistered)
      redRegistered = TRUE;
    else
      ;
  else if (player == COM_ibm_samples_Checkers_Black)
    if (!blackRegistered)
      blackRegistered = TRUE;
    else
      ;

  if (redRegistered != blackRegistered)
  {
   
    for (x = 0; x < 8; ++x)
      for (y = 0; y < 8; ++y)
        if ((y + x) % 2 == 0)
          somThis->board[x][y] = COM_ibm_samples_Checkers_NoPlay;
        else if (y <= 2)
          somThis->board[x][y] = COM_ibm_samples_Checkers_Black;
        else if (y >= 5)
          somThis->board[x][y] = COM_ibm_samples_Checkers_Red;
        else
          somThis->board[x][y] = COM_ibm_samples_Checkers_Open;
    somThis->gameStatus = COM_ibm_samples_Checkers_RedTurn;
  }

}


SOM_Scope void  SOMLINK COM_ibm_samples_Checkersmove(
                                  COM_ibm_samples_Checkers *somSelf, 
                                  Environment *ev, 
                                  COM_ibm_samples_Checkers_Square player, 
                                  short fromX, 
                                  short fromY, 
                                  short toX, 
                                  short toY)
{
    short x, y;
    COM_ibm_samples_Checkers_Square currentPlayer;
    COM_ibm_samples_Checkers_Square opponent;
    COM_ibm_samples_Checkers_Square opponentKing;
    COM_ibm_samples_Checkers_InvalidMove *exBadMove;

    COM_ibm_samples_CheckersData *somThis = COM_ibm_samples_CheckersGetData(somSelf);
    COM_ibm_samples_CheckersMethodDebug("COM_ibm_samples_Checkers", "COM_ibm_samples_Checkersmove");

    /* allocate memory for the InvalidMove exception (in case we need to throw one) */
    exBadMove = (COM_ibm_samples_Checkers_InvalidMove *) SOMMalloc (sizeof(ex_COM_ibm_samples_Checkers_InvalidMove));

    /* Make sure:
        - from and to Squares are on the board
        - from Square contains a piece of the current player
        - to Square is Open
        - the mover is the current player
    */
    if (!redRegistered && !blackRegistered)
      ; 

    currentPlayer = somThis->gameStatus == COM_ibm_samples_Checkers_RedTurn ?
                                                COM_ibm_samples_Checkers_Red : 
                                                COM_ibm_samples_Checkers_Black;
    if (fromX < 0 || fromX >= 8 || fromY < 0 || fromY >= 8 ||
        toX < 0 || toX >= 8 || toY < 0 || toY >= 8)
    {
      /* allocate memory for the details string of the exception */
      exBadMove->details = (string) SOMMalloc (strlen("Not on the board")+1);

      /* copy the bad news to the exception string */
      strcpy (exBadMove->details, "Not on the board");

      /* set the exception in the environment structure */
      somSetException (ev, USER_EXCEPTION,
                       ex_COM_ibm_samples_Checkers_InvalidMove,
                       (void *)exBadMove);
      return;
    }
    else if ((somThis->board[fromX][fromY] != currentPlayer &&
        somThis->board[fromX][fromY] != currentPlayer + 2) || player != currentPlayer)
    {
      /* allocate memory for the details string of the exception */
      exBadMove->details = (string) SOMMalloc (strlen("It's not your turn to move")+1);

      /* copy the bad news to the exception string */
      strcpy (exBadMove->details, "It's not your turn to move");

      /* set the exception in the environment structure */
      somSetException (ev, USER_EXCEPTION,
                       ex_COM_ibm_samples_Checkers_InvalidMove,
                       (void *)exBadMove);
      return;
    }
    else if (somThis->board[toX][toY] != COM_ibm_samples_Checkers_Open)
    {
      /* allocate memory for the details string of the exception */
      exBadMove->details = (string) SOMMalloc (strlen("That square is not open")+1);

      /* copy the bad news to the exception string */
      strcpy (exBadMove->details, "That square is not open");

      /* set the exception in the environment structure */
      somSetException (ev, USER_EXCEPTION,
                       ex_COM_ibm_samples_Checkers_InvalidMove,
                       (void *)exBadMove);
      return;
    }

    /* Make sure that if the move is backward, that the piece is a king. */
    if (player == COM_ibm_samples_Checkers_Black && toY < fromY && 
        somThis->board[fromX][fromY] != COM_ibm_samples_Checkers_BlackKing)
    {
      /* allocate memory for the details string of the exception */
      exBadMove->details = (string) SOMMalloc (strlen("That piece cannot move backward")+1);

      /* copy the bad news to the exception string */
      strcpy (exBadMove->details,"That piece cannot move backward" );

      /* set the exception in the environment structure */
      somSetException (ev, USER_EXCEPTION,
                       ex_COM_ibm_samples_Checkers_InvalidMove,
                       (void *)exBadMove);
      return;
    }
    if (player == COM_ibm_samples_Checkers_Red && toY > fromY &&
           somThis->board[fromX][fromY] != COM_ibm_samples_Checkers_RedKing)
    {
      /* allocate memory for the details string of the exception */
      exBadMove->details = (string) SOMMalloc (strlen("That piece cannot move backward")+1);

      /* copy the bad news to the exception string */
      strcpy (exBadMove->details,"That piece cannot move backward" );

      /* set the exception in the environment structure */
      somSetException (ev, USER_EXCEPTION,
                       ex_COM_ibm_samples_Checkers_InvalidMove,
                       (void *)exBadMove);
      return;
    }
    opponent = player == COM_ibm_samples_Checkers_Red ? 
        			 COM_ibm_samples_Checkers_Black :
				 COM_ibm_samples_Checkers_Red;
    opponentKing = opponent + 2;

    
    if (abs (toY - fromY) == 1 && abs (toX - fromX) == 1)
    {
      
      somThis->board[toX][toY] = somThis->board[fromX][fromY];
      somThis->board[fromX][fromY] = COM_ibm_samples_Checkers_Open;
      somThis->gameStatus = somThis->gameStatus == COM_ibm_samples_Checkers_RedTurn ?
        						COM_ibm_samples_Checkers_BlackTurn :
							COM_ibm_samples_Checkers_RedTurn;
    }
    
    else if (abs (toY - fromY) == 2 && abs (toX - fromX) == 2 &&
             (somThis->board[(toX + fromX) / 2][(toY + fromY) / 2] == opponent ||
              somThis->board[(toX + fromX) / 2][(toY + fromY) / 2] == opponentKing))
    {
      
      somThis->board[toX][toY] = somThis->board[fromX][fromY];
      somThis->board[fromX][fromY] = COM_ibm_samples_Checkers_Open;
      somThis->board[(toX + fromX) / 2][(toY + fromY) / 2] = COM_ibm_samples_Checkers_Open;

      
      if ((toX < 6 && toY < 6 && 
			   (somThis->board[toX + 1][toY + 1] == opponent ||
			    somThis->board[toX + 1][toY + 1] == opponentKing
            ) &&
			    somThis->board[toX + 2][toY + 2] == COM_ibm_samples_Checkers_Open &&
			    somThis->board[toX][toY] != COM_ibm_samples_Checkers_Red
			 ) ||
          (toX < 6 && toY > 1 &&
			   (somThis->board[toX + 1][toY - 1] == opponent ||
				 somThis->board[toX + 1][toY - 1] == opponentKing
				) && 
           somThis->board[toX + 2][toY - 2] == COM_ibm_samples_Checkers_Open &&
			  somThis->board[toX][toY] != COM_ibm_samples_Checkers_Black
			 ) ||
          (toX > 1 && toY < 6 &&
				(somThis->board[toX - 1][toY + 1] == opponent ||
				 somThis->board[toX - 1][toY + 1] == opponentKing
			   ) &&
				somThis->board[toX - 2][toY + 2] == COM_ibm_samples_Checkers_Open &&
				somThis->board[toX][toY] != COM_ibm_samples_Checkers_Red
			 ) ||
          (toX > 1 && toY > 1 &&
				(somThis->board[toX - 1][toY - 1] == opponent ||
				 somThis->board[toX - 1][toY - 1] == opponentKing
		      ) &&
			  somThis->board[toX - 2][toY - 2] == COM_ibm_samples_Checkers_Open &&
			  somThis->board[toX][toY] != COM_ibm_samples_Checkers_Black
			 )
			)
        ;
      else
      {
        COM_ibm_samples_Checkers_Square playerKing = player + 2;
        short count = 0;
        for ( x = 0; x < 8; ++x)
          for ( y = 0; y < 8; ++y)
            if (somThis->board[x][y] == opponent ||
					 somThis->board[x][y] == opponentKing)
              ++count;
        if (count == 0)
          somThis->gameStatus = somThis->gameStatus == COM_ibm_samples_Checkers_RedTurn ?
                        				  COM_ibm_samples_Checkers_RedWon :
                        				  COM_ibm_samples_Checkers_BlackWon;
        else
          somThis->gameStatus = somThis->gameStatus == COM_ibm_samples_Checkers_RedTurn ?
							  COM_ibm_samples_Checkers_BlackTurn :
							  COM_ibm_samples_Checkers_RedTurn;
      }
    }
    else
    {
      /* Tried moving somewhere else on the board */
      /* allocate memory for the details string of the exception */
      exBadMove->details = (string) SOMMalloc (strlen("That is an invalid square")+1);

      /* copy the bad news to the exception string */
      strcpy (exBadMove->details, "That is an invalid square");

      /* set the exception in the environment structure */
      somSetException (ev, USER_EXCEPTION,
                       ex_COM_ibm_samples_Checkers_InvalidMove,
                       (void *)exBadMove);
      return;
    }
    if (currentPlayer == COM_ibm_samples_Checkers_Red && 
		  toY == 0)
      somThis->board[toX][toY] = COM_ibm_samples_Checkers_RedKing;
    else if (currentPlayer == COM_ibm_samples_Checkers_Black &&
	     toY == 7)
      somThis->board[toX][toY] = COM_ibm_samples_Checkers_BlackKing;


    /* If the exception was never thrown, free the memory allocated for it.
       Note that if the exception *was* thrown, SOM takes care of freeing this
       memory instead.  */
    SOMFree(exBadMove);

}


SOM_Scope void  SOMLINK COM_ibm_samples_Checkersreset(COM_ibm_samples_Checkers *somSelf, 
                                                       Environment *ev)
{
   int x, y;
    COM_ibm_samples_CheckersData *somThis = COM_ibm_samples_CheckersGetData(somSelf);
    COM_ibm_samples_CheckersMethodDebug("COM_ibm_samples_Checkers", "COM_ibm_samples_Checkersreset");

    for ( x = 0; x < 8; ++x)
      for ( y = 0; y < 8; ++y)
        if ((y + x) % 2 == 0)
          somThis->board[x][y] = COM_ibm_samples_Checkers_NoPlay;
        else if (y <= 2)
          somThis->board[x][y] = COM_ibm_samples_Checkers_Black;
        else if (y >= 5)
          somThis->board[x][y] = COM_ibm_samples_Checkers_Red;
        else
          somThis->board[x][y] = COM_ibm_samples_Checkers_Open;
    somThis->gameStatus = COM_ibm_samples_Checkers_RedTurn;

}


SOM_Scope void  SOMLINK COM_ibm_samples_Checkersclose(COM_ibm_samples_Checkers *somSelf, 
                                                       Environment *ev)
{
    COM_ibm_samples_CheckersData *somThis = COM_ibm_samples_CheckersGetData(somSelf);
    COM_ibm_samples_CheckersMethodDebug("COM_ibm_samples_Checkers", "COM_ibm_samples_Checkersclose");

    if (somThis->gameStatus == COM_ibm_samples_Checkers_Closed)
      ;
    else
      somThis->gameStatus = COM_ibm_samples_Checkers_Closed;

    redRegistered = blackRegistered = FALSE;

}


SOM_Scope void SOMLINK COM_ibm_samples_CheckerssomDefaultInit(COM_ibm_samples_Checkers *somSelf, 
                                   som3InitCtrl* ctrl)
{
    int x, y;
    COM_ibm_samples_CheckersData *somThis; /* set in BeginInitializer */
    som3InitCtrl globalCtrl;
    somBooleanVector myMask;
    COM_ibm_samples_CheckersMethodDebug("COM_ibm_samples_Checkers", "somDefaultInit");
    COM_ibm_samples_Checkers_BeginInitializer_somDefaultInit;

    COM_ibm_samples_Checkers_Init_SOMObject_somDefaultInit(somSelf, ctrl);

    /* 
     * local Checkers initialization code added by programmer 
     */
    for ( x = 0; x < 8; ++x)
      for ( y = 0; y < 8; ++y)
        if ((y + x) % 2 == 0)
          somThis->board[x][y] = COM_ibm_samples_Checkers_NoPlay;
        else if (y <= 2)
          somThis->board[x][y] = COM_ibm_samples_Checkers_Black;
        else if (y >= 5)
          somThis->board[x][y] = COM_ibm_samples_Checkers_Red;
        else
          somThis->board[x][y] = COM_ibm_samples_Checkers_Open;
    somThis->gameStatus = COM_ibm_samples_Checkers_RedTurn;
}

