:userdoc.
:title.REXXUTIL Addendum
.*********************************************************
:h1 res=100.Added REXXUTIL Functions
:i1.Introducing the added functions
:i1 id=rxutladd.RexxUtil - added functions
:p.Fixpack 12 and above for OS/2 Warp 4 introduced new functions 
for the REXX library REXXUTIL.
:p.This chapter describes the following REXX functions:
:table cols='21 39' rules=none frame=none.
:row.
:c.:hp2.REXX Function:ehp2.
:c.:hp2.Purpose:ehp2.
:row.
:c.:link reftype=hd res=200.SysQueryExtLIBPATH:elink.
:c.Return the current path to be searched before or after the system LIBPATH.
:row.
:c.:link reftype=hd res=220.SysSetExtLIBPATH:elink.
:c.Define the current path to be searched before or after the system LIBPATH.
:row.
:c.:link reftype=hd res=210.SysQuerySwitchList:elink.
:c.Obtain information about the entries in the window list.
:row.
:c.:link reftype=hd res=230.SysSwitchSession:elink.
:c.Activating a specific program.
:row.
:c.:link reftype=hd res=235.SysDumpVariables:elink.
:c.Dump all variables in the current scope either to the specified file (new data is appended) or to STDOUT.
:row.
:c.:link reftype=hd res=240.SysSetFileDateTime:elink.
:c.Modify the "Last Modified" date of the specified file.
:row.
:c.:link reftype=hd res=250.SysGetFileDateTime:elink.
:c.Return the selected file date time attribute of the specified file.
:row.
:c.:link reftype=hd res=260.SysStemCopy:elink.
:c.Copy elements from the source stem to the target stem.
:row.
:c.:link reftype=hd res=270.SysStemDelete:elink.
:c.Deletes items from a stem.
:row.
:c.:link reftype=hd res=280.SysStemInsert:elink.
:c.Insert a new item at the specified position in the stem.
:row.
:c.:link reftype=hd res=290.SysStemSort:elink.
:c.Sort all or the specified items in the stem.
:row.
:c.:link reftype=hd res=300.SysVersion:elink.
:c.Return a string to identify the operating system and its version.
:row.
:c.:link reftype=hd res=310.SysUtilVersion:elink.
:c.Return a version number that identifies the current level of the REXX utilities package.
:etable.
.*********************************************************
:h2 res=200.SysQueryExtLIBPATH
:i2 refid=rxutladd.SysQueryExtLIBPATH
:cgraphic.
Ŀ
                                                                        
 >>SysQueryExtLIBPATH(flag)>< 
                                                                        

:ecgraphic.
:p.This function returns the current path to be searched before or after the 
system LIBPATH when locating DLLs.
:p.:hp2.Parameters:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.flag:ehp1.
:pd.The flag controlling which extended LIBPATH should be returned:
:parml compact break=none tsize=6.
:pt.:hp2.'B':ehp2.
:pd.Return the BEGINLIBPATH setting.
:pt.:hp2.'E':ehp2.
:pd.Return the ENDLIBPATH setting.
:eparml.
:eparml.
:lm margin=1.
:p.:hp2.Example&colon.:ehp2.
:xmp.
/* Show the current setting of the extended LIBPATH */
say "BEGINLIBPATH is:" SysQueryExtLIBPATH("B")
say "ENDLIBPATH is:  " SysQueryExtLIBPATH("E")
:exmp.
.*********************************************************
:h2 res=220.SysSetExtLIBPATH
:i2 refid=rxutladd.SysSetExtLIBPATH
:cgraphic.
Ŀ
                                                                        
 >>SysSetExtLIBPATH(,flag)>< 
                       path                                         
                                                                        

:ecgraphic.
:p.This function defines the current path to be searched before or after the 
system LIBPATH when locating DLLs. The OS/2 error code will be returned (0 if successful).
:p.:hp2.Parameters:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.path:ehp1.
:pd.The extended LIBPATH string. The string can be up to 1024 characters 
long. The extended LIBPATH may contain the 
strings &cdq.&percent.BEGINLIBPATH&percent.&cdq. or 
&cdq.&percent.ENDLIBPATH&percent.&cdq. in which case the current values 
will be inserted in the resulting extended LIBPATH. However, if the 
resulting extended LIBPATH is longer than 1024 characters, the function 
will return an error.
.br
To remove the current extended LIBPATH you can specify an empty 
string or omit this parameter.
:pt.:hp1.flag:ehp1.
:pd.The flag controlling which extended LIBPATH should be set:
:parml compact break=none tsize=6.
:pt.:hp2.'B':ehp2.
:pd.Set the BEGINLIBPATH.
:pt.:hp2.'E':ehp2.
:pd.Set the ENDLIBPATH.
:eparml.
:eparml.
:lm margin=1.
:p.:hp2.Example&colon.:ehp2.
:xmp.
/* Add D&colon.&bsl.TEST to BEGINLIBPATH and delete ENDLIBPATH */
Call SysSetExtLIBPATH &cdq.D&colon.&bsl.TEST&semi.&percent.BEGINLIBPATH&percent.&cdq., &cdq.B&cdq.
Call SysSetExtLIBPATH , &cdq.E&cdq.
:exmp.
.*********************************************************
:h2 res=210.SysQuerySwitchList
:i2 refid=rxutladd.SysQuerySwitchList
:cgraphic.
Ŀ
                                                                        
 >>SysQuerySwitchList(stem)>< 
                              ,flags                                
                                                                        

:ecgraphic.
:p.This function obtains information about the entries in the Window List. 
By default only visible and jumpable entries will be returned.
:p.:hp2.Parameters:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.stem:ehp1.
:pd.The name of a REXX stem variable. SysQuerySwitchList sets REXX 
variable stem.0 to the number of Window List entries and stores the 
individual entries in stem.1 to stem.n.
:pt.:hp1.flags:ehp1.
:pd.Any combination of the following:
:parml compact break=none tsize=6.
:pt.:hp2.'I':ehp2.
:pd.Include invisible entries in the list.
:pt.:hp2.'G':ehp2.
:pd.Include grayed entries in the list.
:pt.:hp2.'N':ehp2.
:pd.Include entries in the list that are not jumpable.
:pt.:hp2.'D':ehp2.
:pd.Return the list in the detailed form:
.br
:xmp.PID SID Visibility Jumpable ProgType Name:exmp.
:eparml.
:eparml.
:lm margin=1.
:p.:hp2.Example&colon.:ehp2.
:xmp.
/* Type the Window List */
call SysQuerySwitchList "list."
do i = 1 to list.0
   say 'Entry' i 'is' list.i
end
:exmp.
.*********************************************************
:h2 res=230.SysSwitchSession
:i2 refid=rxutladd.SysSwitchSession
:cgraphic.
Ŀ
                                                                        
 >>SysSwitchSession(name)>< 
                                                                        

:ecgraphic.
:p.This function makes a specific program the active program. The function 
returns the error code from WinSwitchToProgram (0 if successful).
:p.:hp2.Parameters:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.name:ehp1.
:pd.The name of the session to switch to. The name must match the 
appropriate program name as used in the Window List 
(see function :link reftype=hd res=210.SysQuerySwitchList:elink.).
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=235.SysDumpVariables
:i2 refid=rxutladd.SysDumpVariables
:cgraphic.
Ŀ
                                                                        
 >>SysDumpVariables([filename])>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysDumpVariables([filename]):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.filename:ehp1.
:pd.Name of the file where variables are appended to (dump is 
written to STDOUT if omitted).
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.This function dumps all variables in the current scope either 
to the specified file (new data will be appended) or to STDOUT 
if the filename parameter is omitted. The format of the data 
is (one variable per line)&colon.
:xmp.Name=MYVAR, Value="This is the content of MYVAR":exmp.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Call SysDumpVariables "MyVars.Lst" /* append vars to file */
Call SysDumpVariables              /* list vars on STDOUT */
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.0:ehp2.
:pd.dump completed OK
:pt.:hp2.-1:ehp2.
:pd.failure during dump
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=240.SysSetFileDateTime
:i2 refid=rxutladd.SysSetFileDateTime
:cgraphic.
Ŀ
                                                                        
 >>SysSetFileDateTime(filename [,newdate] [,newtime])>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysSetFileDateTime(filename [,newdate] [,newtime]):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.filename:ehp1.
:pd.Name of the file to update.
:pt.:hp1.newdate:ehp1.
:pd.New date to set in format YYYY-MM-DD.
:parml compact tsize=8 break=none.
:pt.OS&slr.2&colon.
:pd.(YYYY &gt. 1980)
:pt.Win&colon.
:pd.(YYYY &gt. 1800)
:pt.AIX&slr.Linux&colon.
:pd.(YYYY &gt. 1900)
:eparml.
:pt.:hp1.newtime:ehp1.
:pd.New time to set in format HH&colon.MM&colon.SS (24 hr format)
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.This function can be used to modify the &cdq.Last Modified&cdq. Date 
of the specified file. If no new date or new time is specified then 
the file date and time will be set to the current time 
(:link refid=touch reftype=fn.TOUCH:elink.). If only 
one of date or time is omitted then this parameter will be left unchanged.
:p.For OS&slr.2 and Windows NT the filename may also specify a directory 
name. This does not work with Windows 95&slr.98 or AIX&slr.Linux however.
:p.The file you want to change must not be opened by another process 
or at least it must allow shared writes in order to update the 
timestamp.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Call SysSetFileDateTime "MyFile.Log"  /* touch file */
Call SysSetFileDateTime "MyFile.Log", "1998-12-17"
Call SysSetFileDateTime "MyFile.Log",, "16&colon.37&colon.21"
Call SysSetFileDateTime "MyFile.Log", "1998-12-17", "16&colon.37&colon.21"

Call SysSetFileDateTime "C&colon.\MyDir"    /* touch dir on OS/2, NT */
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.0:ehp2.
:pd.file date/time was updated correctly
:pt.:hp2.-1:ehp2.
:pd.failure attribute update
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=250.SysGetFileDateTime
:i2 refid=rxutladd.SysGetFileDateTime
:cgraphic.
Ŀ
                                                                        
 >>SysGetFileDateTime(filename [,timesel])>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysGetFileDateTime(filename [,timesel]):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.filename:ehp1.
:pd.Name of the file to query.
:pt.:hp1.timesel:ehp1.
:pd.What filetime to query: CREATE &splitvbar. ACCESS &splitvbar. WRITE.
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.The function call returns the selected file date time attribute 
of the specified file if this is supported by the operating 
and file system (e.g. FAT does not provide Create&slr.Access). The 
selector for the time to be returned can be abbreviated with 
its first character.
:p.For OS&slr.2 and Windows NT the filename may also specify a directory 
name. This does not work with Windows 95&slr.98 or AIX&slr.Linux however.
:p.The file you want to query must not be opened by another process 
or at least it must allow shared reads in order to query the 
timestamp.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Say "File creation time&colon."      SysGetFileDateTime("MyFile.Log", "C")
Say "File last access time&colon."   SysGetFileDateTime("MyFile.Log", "A")
Say "File last update time&colon."   SysGetFileDateTime("MyFile.Log", "W")

Say "Directory creation time&colon." SysGetFileDateTime("C&colon.\MyDir", "C")
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=8 break=none.
:pt.:hp2.-1:ehp2.
:pd.file date/time query failed
:pt.:hp2.other:ehp2.
:pd.date and time as YYYY-MM-DD HH&colon.MM&colon.SS
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=260.SysStemCopy
:i2 refid=rxutladd.SysStemCopy
:cgraphic.
Ŀ
                                                                        
 >>SysStemCopy(fromstem, tostem, [from], [to], [count] [,insert])>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysStemCopy(fromstem, tostem, [from], [to], [count] [,insert]):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.fromstem:ehp1.
:pd.Name of source stem
:pt.:hp1.tostem:ehp1.
:pd.Name of target stem
:pt.:hp1.from:ehp1.
:pd.First index in source stem to copy
:pt.:hp1.to:ehp1.
:pd.Position where items are copied&slr.inserted in target stem
:pt.:hp1.count:ehp1.
:pd.Number of items to copy&slr.insert
:pt.:hp1.insert:ehp1.
:pd.'I' to indicate insert instead of 'O' overwrite
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.Copy elements from the source stem to the target stem. Elements 
in the source stem are copied starting at the :hp1.from:ehp1. index 
(default 1) into the target stem beginning at the :hp1.to:ehp1. index 
(default 1). The number of items to copy to the target stem can 
be specified with :hp1.count:ehp1. (default is to copy all items in the 
source stem). You can optionally specify that the items should 
be inserted into the target stem at the position :hp1.to:ehp1. and the 
existing items will be shifted to the back accordingly.
:p.This function operates only on stem arrays that specify the 
number of elements in stem.0 and all elements must be numbered 
from 1 to n with no omitted index.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Source.0 = 3
Source.1 = "Hello"
Source.2 = "from"
Source.3 = "REXX"
Call SysStemCopy "Source.", "Target."

Call SysStemCopy "Source.", "Target.", 1, 5, 2, "I"
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.0:ehp2.
:pd.stem copy was successful
:pt.:hp2.-1:ehp2.
:pd.stem copy failed
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=270.SysStemDelete
:i2 refid=rxutladd.SysStemDelete
:cgraphic.
Ŀ
                                                                        
 >>SysStemDelete(stem, startitem [,itemcount])>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysStemDelete(stem, startitem [,itemcount]):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.stem:ehp1.
:pd.Name of stem where item will be deleted
:pt.:hp1.startitem:ehp1.
:pd.Index of item to delete
:pt.:hp1.itemcount:ehp1.
:pd.Number of items to delete if more than 1
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.Deletes the specified item at index :hp1.startitem:ehp1. 
in the :hp1.stem:ehp1.. 
If more than one item is to be deleted then the :hp1.count of 
items:ehp1. can be specified as the third parameter. After deleting 
the requested items the stem will be compacted, that means 
items following the deleted items will be shifted up into the 
vacant positions.
:p.This function operates only on stem arrays that specify the number 
of elements in stem.0 and all elements must be numbered from 1 to 
n with no omitted index.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Call SysStemDelete "MyStem.", 5

Call SysStemDelete "MyStem.", 5, 4
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.0:ehp2.
:pd.delete was successful
:pt.:hp2.-1:ehp2.
:pd.delete failed
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=280.SysStemInsert
:i2 refid=rxutladd.SysStemInsert
:cgraphic.
Ŀ
                                                                        
 >>SysStemInsert(stem, position, value)>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysStemInsert(stem, position, value):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.stem:ehp1.
:pd.Name of stem where item will be inserted
:pt.:hp1.position:ehp1.
:pd.Index where new item will be inserted
:pt.:hp1.value:ehp1.
:pd.New item value
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.A new item will be inserted at the specified :hp1.position:ehp1. in 
the :hp1.stem:ehp1.. All existing items in the stem from the specified 
position will be shifted up by one to make room for the new 
item.
:p.This function operates only on stem arrays that specify the 
number of elements in stem.0 and all elements must be numbered 
from 1 to n with no omitted index.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Call SysStemInsert "MyStem.", 5, "New value for item 5"
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.0:ehp2.
:pd.insert was successful
:pt.:hp2.-1:ehp2.
:pd.insert failed
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=290.SysStemSort
:i2 refid=rxutladd.SysStemSort
:cgraphic.
Ŀ
                                                                        
 >>SysStemSort(stem, order, type, start, end, firstcol, lastcol)>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysStemSort(stem, order, type, start, end, firstcol, lastcol):exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.:hp1.stem:ehp1.
:pd.Name of stem to sort
:pt.:hp1.order:ehp1.
:pd.'A' or 'D' for sort order (default: ascending)
:pt.:hp1.type:ehp1.
:pd.'C', 'I'  for comparision type (case &slr. ignore, default: case)
:pt.:hp1.start:ehp1.
:pd.First index to sort (default: 1)
:pt.:hp1.end:ehp1.
:pd.Last index to sort (default: last item)
:pt.:hp1.firstcol:ehp1.
:pd.First column to use as sort key (default: 1)
:pt.:hp1.lastcol:ehp1.
:pd.Last column to use as sort key (default: last column)
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.This call sorts all or the specified items in the :hp1.stem:ehp1.. 
Sort :hp1.order:ehp1. can be specified as ascending or descending, 
comparison :hp1.type:ehp1. can respect or ignore the case of the strings 
being compared. The sorting can further be narrowed by specifying 
the :hp1.first:ehp1. and :hp1.last:ehp1. item to be sorted or by 
specifying the columns used as the sorting key. The sort uses a 
quicksort algorithm, so the order of equal elements according to 
the sort key is undetermined.
:p.This function operates only on stem arrays that specify the 
number of elements in stem.0 and all elements must be numbered 
from 1 to n with no omitted index.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
/* sort all elements descending, use cols 5 to 10 as key */
Call SysStemSort "MyStem.", "D",,,,5, 10

/* sort all elements ascending, ignore the case */
Call SysStemSort "MyStem.", "A", "I"

/* sort elements 10 to 20 ascending, use cols 1 to 10 as key */
Call SysStemSort "MyStem.",,,10, 20, 1, 10:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.0:ehp2.
:pd.sort was successful
:pt.:hp2.-1:ehp2.
:pd.sort failed
:eparml.
:lm margin=1.
.*********************************************************
:h2 res=300.SysVersion
:i2 refid=rxutladd.SysVersion
:cgraphic.
Ŀ
                                                                        
 >>SysVersion()>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysVersion():exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.
:pd.None
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.This function returns a string to identify the operating system 
and its version. The returned string contains an identifier for 
the operating system as the first word and then the version in 
the second word.
:p.:hp2.Examples&colon.:ehp2.
:xmp.
Say SysVersion()       /* show OS and version */
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.:hp2.Operating system and version:ehp2.
:pd.Possible output for operating systems supported by REXX:
:eparml.
:xmp.
Say SysVersion()   ->  "WindowsNT 4.00"
Say SysVersion()   ->  "OS&slr.2 2.40"
Say SysVersion()   ->  "AIX 4.2"
Say SysVersion()   ->  "Linux 2.0.34"
:exmp.
:lm margin=1.
:note.This function can be used to replace the operating system specific 
functions SysOS2Ver(), SysWinVer(), and SysLinVer().
.*********************************************************
:h2 res=310.SysUtilVersion
:i2 refid=rxutladd.SysUtilVersion
:cgraphic.
Ŀ
                                                                        
 >>SysUtilVersion()>< 
                                                                        

:ecgraphic.
:p.:hp2.Syntax&colon.:ehp2.
:lm margin=3.:xmp.result = SysUtilVersion():exmp.:lm margin=1.
:p.:hp2.Parameters&colon.:ehp2.
:lm margin=3.
:parml.
:pt.
:pd.None
:eparml.
:lm margin=1.
:p.:hp2.Function&colon.:ehp2.
:p.This function returns a version number that identifies the current 
level of the REXX Utilities package. This can be used to verify 
that certain functions are available.
:p.:hp2.Examples&colon.:ehp2.
:p.Since this function was not part of the original packaging a 
sample logic to check for a certain level of REXXUTIL could look 
like this:
:xmp.
If RxFuncQuery("SysUtilVersion") = 1 &splitvbar. SysUtilVersion() < "2.00" Then
  Say "Your REXXUTIL.DLL is not at the current level"
:exmp.
:p.If a specific function should be used that was added at a later 
REXXUTIL level a similar check can be performed by querying that 
function:
:xmp.
If RxFuncQuery("SysSetFileDateTime") = 1 Then
  Say "Your REXXUTIL.DLL is not at the current level"
:exmp.
:p.:hp2.Return&colon.:ehp2.
:lm margin=3.
:parml compact tsize=6 break=none.
:pt.
:pd.REXXUTIL version number in the format (n.mm)
:eparml.
:lm margin=1.
.*********************************************
:fn id=touch.
:p.:hp1.touch:ehp1. is a standard Unix program used to change a 
file's access and modification timestamps.
:efn.
.*********************************************
:euserdoc.






