/* RxStocks v1.8 by Dimitris 'sehh' Michelinakis <sehh@altered.com> */
/* based on libstocks by Eric Laeuffer <laeuffer@cybercable.fr> */

#define RETURN_INVALID 40
#define RETURN_OK       0
#define INCL_REXXSAA
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include "../lib/stocks.h"

libstocks_return_code DefProxy(char *proxy) {
 libstocks_return_code error;
 error = set_proxy(proxy);
 if (error) { return(error); }
 return 0;
}

libstocks_return_code GetHistorical(char *symbol, char *date1, char *date2, char *rc) {
 char tmp[2048];
 stock *stocks_quotes=NULL;
 stock *stocks_tmp;
 libstocks_return_code error;
 error = get_stock_history(symbol, date1, date2, &stocks_quotes);
 if (error) { return error; }
 stocks_tmp = stocks_quotes;
 while(stocks_tmp!=0) {
  //strcat(rc," "); if (stocks_tmp->Time) { strcat(rc,stocks_tmp->Time); }
  strcat(rc," "); if (stocks_tmp->Date) { strcat(rc,stocks_tmp->Date); }
  //strcat(rc," "); if (stocks_tmp->Symbol) { strcat(rc,stocks_tmp->Symbol); }
  //strcat(rc," "); if (stocks_tmp->Name) { strcat(rc,stocks_tmp->Name); }
  //sprintf(tmp, " %-7.2f", stocks_tmp->CurrentPrice);
  //strcat(rc,tmp);
  sprintf(tmp, " %-8.3f", stocks_tmp->LastPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-8.3f", stocks_tmp->OpenPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-8.3f", stocks_tmp->MinPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-8.3f", stocks_tmp->MaxPrice);
  strcat(rc,tmp);
  //sprintf(tmp, " %-6.2f", stocks_tmp->Variation);
  //strcat(rc,tmp);
  //sprintf(tmp, " %5.2f", stocks_tmp->Pourcentage);
  //strcat(rc,tmp);
  sprintf(tmp, " %d", stocks_tmp->Volume);
  strcat(rc,tmp);
  stocks_tmp = next_stock(stocks_tmp);
 }
 free_stocks(stocks_quotes);
 return 0;
}

libstocks_return_code GetStocks(char *stock_liste, char *rc) {
 char tmp[2048];
 stock *stocks_quotes=NULL;
 stock *stocks_tmp;
 libstocks_return_code error;
 error = get_stocks(stock_liste, &stocks_quotes);
 if (error) { return error; }
 stocks_tmp = stocks_quotes;
 while(stocks_tmp!=0) {
  strcat(rc," "); if (stocks_tmp->Time) { strcat(rc,stocks_tmp->Time); }
  strcat(rc," "); if (stocks_tmp->Date) { strcat(rc,stocks_tmp->Date); }
  strcat(rc," "); if (stocks_tmp->Symbol) { strcat(rc,stocks_tmp->Symbol); }
  strcat(rc," "); if (stocks_tmp->Name) { strcat(rc,stocks_tmp->Name); }
  sprintf(tmp, " %-7.2f", stocks_tmp->CurrentPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-7.2f", stocks_tmp->LastPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-7.2f", stocks_tmp->OpenPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-7.2f", stocks_tmp->MinPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-7.2f", stocks_tmp->MaxPrice);
  strcat(rc,tmp);
  sprintf(tmp, " %-6.2f", stocks_tmp->Variation);
  strcat(rc,tmp);
  sprintf(tmp, " %5.2f", stocks_tmp->Pourcentage);
  strcat(rc,tmp);
  sprintf(tmp, " %-9d", stocks_tmp->Volume);
  strcat(rc,tmp);
  stocks_tmp = next_stock(stocks_tmp);
 }
 free_stocks(stocks_quotes);
 return 0;
}

ULONG RxGetStocks(CHAR *name,
               ULONG numargs,
               RXSTRING args[],
               CHAR *queuename,
               RXSTRING *retstr)
{
 char rc[2048]="";
 libstocks_return_code error;
 if (numargs==1) {
  error = GetStocks(args[0].strptr, rc); }
 else if (numargs==2) {
  error = DefProxy(args[1].strptr);
  if (error) {
   sprintf(rc, "%d", error);
   strcpy(retstr->strptr, rc);
   retstr->strlength=strlen(rc);
   return RETURN_OK;
  }
  error = GetStocks(args[0].strptr, rc); }
 else if (numargs==3) {
  error = GetHistorical(args[0].strptr, args[1].strptr, args[2].strptr, rc); }
 else if (numargs==4) {
  error = DefProxy(args[1].strptr);
  if (error) {
   sprintf(rc, "%d", error);
   strcpy(retstr->strptr, rc);
   retstr->strlength=strlen(rc);
   return RETURN_OK;
  }
  error = GetHistorical(args[0].strptr, args[1].strptr, args[2].strptr, rc); }
 else { return RETURN_INVALID; }
 if (error) {
  sprintf(rc, "%d", error); }
 strcpy(retstr->strptr, rc);
 retstr->strlength=strlen(rc);
 return RETURN_OK;
}

ULONG RxStocksDropFuncs(CHAR *name,
                        ULONG numargs,
                        RXSTRING args[],
                        CHAR *queuename,
                        RXSTRING *retstr)
{
 RexxDeregisterFunction( "RxGetStocks" );
 RexxDeregisterFunction( "RxStocksDropFuncs" );
 RexxDeregisterFunction( "RxStocksLoadFuncs" );
 return RETURN_OK;
}

ULONG RxStocksLoadFuncs(CHAR *name,
                        ULONG numargs,
                        RXSTRING args[],
                        CHAR *queuename,
                        RXSTRING *retstr)
{
 RexxRegisterFunctionDll( "RxGetStocks", "RxStocks", "RxGetStocks" );
 RexxRegisterFunctionDll( "RxStocksDropFuncs", "RxStocks", "RxStocksDropFuncs" );
 return RETURN_OK;
}
