/**
 * REXX Communication Control Function Library  Ver.1.1
 *                  copyright 1998, Naga(Kazuo Adachi)
 *                          mailto:nagaw@ibm.net
 *                          mailto:GDB00421@nifty.ne.jp
 *
 * $Id$
 *
 * $Log$
 */

ARG dialCmd, dialNum

CALL RxFuncAdd 'RxCommLoadFuncs','RxComm','RxCommLoadFuncs'
CALL RxCommLoadFuncs

/*--------------------------------------------------------*/
/**
 * Dial-up to BBS(Server)
 */
chkDCD = 1
IF POS( 'DCD', RxCommSignal() ) > 0 THEN chkDCD = 0
rc = RxCommWrite( dialCmd || dialNum || '0D'x )
DO FOREVER
    rc = RxCommRead()
    CALL CHAROUT , rc
    IF POS( 'CONNECT'   , rc ) = 1 THEN RETURN 0
    IF POS( 'BUSY'      , rc ) = 1 |,
       POS( 'NO CARRIER', rc ) = 1 |,
       POS( 'NO DIAL'   , rc ) = 1 |,
       POS( 'NO ANSWER' , rc ) = 1 |,
       POS( 'ERROR'     , rc ) = 1 THEN RETURN 1

    IF chkDCD & POS( 'DCD', RxCommSignal() ) > 0 THEN RETURN 0
END

RETURN -1
