/* Install of RoboticsMessenger/2 */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

CALL SysCls

say 'Rexx Installer for RoboticsMessenger/2'
say '--------------------------------------------'
say
say '   Installation...'
say
say '   copies files to destination directory'
say '   creates folder and objects on desktop'
say '   makes the settings for correct operation'
say
say '   Please read the supplied information'
say '   file for correct operation'
say

/* Ask Directory */

say 'Enter target directory (e.g.: C:\ROMES):'
say '(<return> = current directory, object creation only, no copy operation)'
PARSE PULL InstDir
InstDir = STRIP(InstDir, 'T', '\')

IF InstDir="" THEN
 DO
   InstDir=directory()
   SIGNAL MakeIcons
 END

/* Create Directory */
say
say '--------------------------------------------'
say 'creating directories'
say '--------------------------------------------'

if InstDir <> "." then
   DO
     call SysFileTree InstDir, "SearchDir", "D"
     if SearchDir.0 = 0 then do
         rc = SysMkDir(InstDir)
            if rc <> 0 then do
                 say "Error: Cannot create directory!" InstDir
                 exit
            end
     end
end

/* Copy files */
say
say '--------------------------------------------'
say 'copying files'
say '--------------------------------------------'

'@Copy ROMES.exe 'InstDir'\ROMES.exe'
'@Copy Splitdump.exe 'InstDir'\splitdump.exe'
'@Copy ROMES.INF 'InstDir'\ROMES.INF'
'@Copy convert.cmd 'InstDir'\convert.cmd'
'@Copy faxview.cmd 'InstDir'\faxview.cmd'
'@Copy faximg.dll 'InstDir'\faximg.dll'
'@Copy faxjpeg.dll 'InstDir'\faxjpeg.dll'
'@Copy faxlog.dll 'InstDir'\faxlog.dll'
'@Copy faxpm.dll 'InstDir'\faxpm.dll'
'@Copy faxrtl.dll 'InstDir'\faxrtl.dll'
'@Copy faxproc.dll 'InstDir'\faxproc.dll'
'@Copy faxview.dll 'InstDir'\faxview.dll'
'@Copy faxview.exe 'InstDir'\faxview.exe'
'@Copy frec.cfg 'InstDir'\frec.cfg'
'@Copy frec.dll 'InstDir'\frec.dll'
'@Copy frec.exe 'InstDir'\frec.exe'
'@Copy fontedit.exe 'InstDir'\fontedit.exe'
'@Copy gsm.dll 'InstDir'\gsm.dll'
'@Copy pcm2wav.dll 'InstDir'\pcm2wav.dll'
'@Copy pcm2wav.exe 'InstDir'\pcm2wav.exe'
'@Copy pcm2wav.ico 'InstDir'\pcm2wav.ico'
'@Copy ROMESFOLD1.ICO 'InstDir'\ROMESFOLD1.ICO'
'@Copy ROMESFOLD2.ICO 'InstDir'\ROMESFOLD2.ICO'
'@mkdir 'InstDir'\FAX'
'@mkdir 'InstDir'\VOICE'

MakeIcons:
/* Make icons */
say
say '--------------------------------------------'
say 'creating icons'
say '--------------------------------------------'


classname = 'WPFolder'
title     = 'Robotics^Messenger/2'
location  = '<WP_DESKTOP>'
icon1     = InstDir||'\ROMESFOLD1.ICO'
icon2     = InstDir||'\ROMESFOLD2.ICO'
icon      = 'ICONFILE='icon1||';ICONNFILE=1,'||icon2
folderid  = '<ROMES2_FOLDER>'
setup     = 'OBJECTID='||folderid||';'||icon
rc        = SysCreateObject(classname, title, location ,setup,'U')

classname = 'WPProgram'
title     = 'Romes Information'
location  = '<ROMES2_FOLDER>'
infname   = InstDir||'\ROMES.INF' 
WorkDir   = InstDir
setup     = 'OBJECTID=<ROMES_INF>;EXENAME=VIEW.EXE;PARAMETERS='||infname||';STARTUPDIR='WorkDir
rc        = SysCreateObject(classname, title, folderid, setup,'U')

classname = 'WPProgram'
location  = '<ROMES2_FOLDER>'
title     = 'Robotics^Messenger/2'
exename   = 'EXENAME='||InstDir||'\ROMES.EXE'
WorkDir   = InstDir
setup     = 'OBJECTID=<ROMES2_PROGRAM>;STARTUPDIR='||InstDir||';STARTUPDIR='||Workdir||';'||exename
rc        = SysCreateObject(classname, title, folderid, setup, 'U')          

classname = 'WPProgram'
location  = '<ROMES2_FOLDER>'
title     = 'Faxview'
exename   = 'EXENAME='||InstDir||'\Faxview.EXE'
WorkDir   = InstDir
setup     = 'OBJECTID=<FaxView_PROGRAM>;STARTUPDIR='||InstDir||';STARTUPDIR='||Workdir||';'||exename
rc        = SysCreateObject(classname, title, folderid, setup, 'U')          

if stream( InstDir||'\convert.cmd', "c", "QUERY EXIST" ) <> "" then
 do
   do i = 1 until lines(InstDir||'\convert.cmd') = 0
       file_old.i=linein(InstDir||'\convert.cmd')
   end
   call stream InstDir||'\convert.cmd', "c", "CLOSE"
   file_old.0=i

   call SysFileSearch 'D:\ROMES', InstDir||'\convert.cmd', 'file_new.', 'N'
   do i=1 to file_new.0
     position=lastpos('D:\ROMES', file_new.i)
     file_new.i=delstr(file_new.i,position,8)
     file_new.i=insert(InstDir,file_new.i,position-1)
     PARSE VALUE file_new.i WITH line " " file_new.i
     file_new.i=STRIP(file_new.i)
     file_old.line=file_new.i
   end

   call SysFileDelete(InstDir||'\convert.cmd')
   do i=1 to file_old.0
     call lineout InstDir||'\convert.cmd', file_old.i
   end
 end

if stream( InstDir||'\frec.cfg', "c", "QUERY EXIST" ) <> "" then
 do
   do i = 1 until lines(InstDir||'\frec.cfg') = 0
       file_old.i=linein(InstDir||'\frec.cfg')
   end
   call stream InstDir||'\frec.cfg', "c", "CLOSE"
   file_old.0=i

   call SysFileSearch 'D:\ROMES', InstDir||'\frec.cfg', 'file_new.', 'N'
   do i=1 to file_new.0
     position=lastpos('D:\ROMES', file_new.i)
     file_new.i=delstr(file_new.i,position,8)
     file_new.i=insert(InstDir,file_new.i,position-1)
     PARSE VALUE file_new.i WITH line " " file_new.i
     file_new.i=STRIP(file_new.i)
     file_old.line=file_new.i
   end

   call SysFileDelete(InstDir||'\frec.cfg')
   do i=1 to file_old.0
     call lineout InstDir||'\frec.cfg', file_old.i
   end
 end
