/*
 * This file is (C) Chris Wohlgemuth 2001
 *
 * It's part of the RexxMail class for even better WPS
 * integration of RexxMail (http://www.degeus.com).
 *
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef _MAILFILE_HH
#define _MAILFILE_HH

#define INCL_DOS
#define INCL_WIN
#include <os2.h>

#include "mailfile.h"

#define FIELDOFFSETUL(type, field)    ((ULONG)&(((type *)0)->field))

#define NUM_MAIL_FIELDS 7

/* Set some default titles */
PSZ pszMailColTitles[NUM_MAIL_FIELDS]= {"Subject", "From", "To", "CC", "BCC", "Date", "Attach"};

static char chrSubject[SIZE_TITLE];
static char chrFrom[SIZE_TITLE];
static char chrTo[SIZE_TITLE];
static char chrCC[SIZE_TITLE];
static char chrBCC[SIZE_TITLE];
static char chrDate[SIZE_TITLE];
static char chrAttach[SIZE_TITLE];

static char chrAttachYes[SIZE_ATTACHMENT]="Yes";
static char chrAttachNo[SIZE_ATTACHMENT]="No";;

typedef struct _MAILDETAILS
{
  PSZ pszSubject;
  PSZ pszFrom;
  PSZ pszTo;
  PSZ pszCC;
  PSZ pszBCC;
  PSZ pszDate;
  PSZ pszAttachment;
}MAILDETAILS;

typedef MAILDETAILS *PMAILDETAILS;

#pragma SOMAsDefault(on)

#include <wpdataf.hh>
#include <wpfolder.hh>

CLASSFIELDINFO cfiFieldInfo[NUM_MAIL_FIELDS];

class M_CWMailFile:public M_WPDataFile
{
#pragma SOMClassName(*,"M_CWMailFile")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
public:
  virtual PSZ  wpclsQueryTitle();
  virtual ULONG wpclsQueryDetailsInfo(PCLASSFIELDINFO *pClassFieldInfo, PULONG pSize);
  virtual void wpclsInitData();
  virtual BOOL wpclsCreateDefaultTemplates(WPObject* Folder);
#pragma SOMReleaseOrder()
#pragma SOMIDLPass(M_CWMailFile, "Implementation-End","dllname=rxmail;")
};

class CWMailFile:public WPDataFile
{
#pragma SOMClassName(*,"CWMailFile")
#pragma SOMMetaClass(*,"M_CWMailFile")
#pragma SOMClassVersion(*,1,2)
#pragma SOMCallstyle(oidl)
private:
  char chrSubject[SIZE_SUBJECT];       /* REXXMAILSUBJECT    */
  char chrFrom[SIZE_FROM];             /* REXXMAILFROM       */
  char chrTo[SIZE_TO];                 /* REXXMAILTO         */
  char chrCC[SIZE_CC];                 /* REXXMAILCC         */
  char chrBCC[SIZE_BCC];               /* REXXMAILBCC        */
  char chrDate[SIZE_DATE];             /* REXXMAILDATE       */
  char chrAttachment[SIZE_ATTACHMENT]; /* REXXMAILATTACHMENT */
public:
  virtual BOOL wpSetup(PSZ pSetupString);
  virtual BOOL wpSetupOnce(PSZ pSetupString);
  virtual BOOL wpQueryDetailsData(PVOID *ppDetailsData, PULONG pcp);
  virtual BOOL wpSaveState();
  virtual BOOL wpRestoreState(ULONG ulReserved);
#pragma SOMReleaseOrder()

#pragma SOMIDLPass(CWMailFile, "Implementation-End","dllname=rxmail;")
};
#pragma SOMAsDefault(pop)
#endif




