/* rexx */
parse arg argument

signal on error
signal on syntax  name syntax
signal on halt    name halt
signal on failure name failure
'@echo off'
'cls'
say
say 'TestMulT --- Testing REXXGDB2.DLL In A Multi-threaded environment'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., Jul 1996 - Aug 1997'
say

/*
RXU Courtesy Dave Boll of Ford Credit (e-mail: usfmcfkf@ibmmail.com)

RXU is a freeware DLL with lots of quality and useful REXX functions for
OS/2 which can be found on OS/2 BBSes near you or on the Internet under
the name of RXUnn.ZIP.

This program was tested with functions found in RXU19.ZIP.
*/
if rxfuncquery('RxCreateRexxThread') then
   call rxfuncadd 'RxCreateRexxThread', 'RXU',      'RxCreateRexxThread'

/*
Load all OS/2 PL/2 REXX Utilities in REXXUTIL
*/
if rxfuncquery('sysloadfuncs') then do
   call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
   call sysloadfuncs
   end

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

call time 'R'
say 'Connecting to SAMPLE database...'
call g2connectreset
call g2connectshare 'SAMPLE'
say 'Execution time    ' time('E') / 1
say
say copies('~', 78)
say center('*** TESTMULT TESTS STARTED ***', 78)
say
say copies('~', 78)
do forever
   do ix = 1 to argument
      say 'Launch Thread'ix'...'
      call rxcreaterexxthread 'Thread'ix
      end
   call syssleep 5  /* Take a break for 5 seconds        */
                    /* TestMult in another session can   */
                    /* gain some CPU cycles this way...  */
   end
return 0



error:
say 'Error detected on line' SIGL
return 10

syntax:
say 'Syntax error detected on line' SIGL
return 20

halt:
say 'Halt error detected on line' SIGL
return 30

failure:
say 'Failure error detected on line' SIGL
return 40
return
