/* REXX2VIO: bind resource to REXX_VIO.EXE */

Parse Arg FileName ExeName

if FileName = '' then
  do
    Say 'Usage: REXX2VIO <sourcefile> [<exefile>]'
    Return 1
  end

if Stream(FileName, 'C', 'Query Exist') == '' then
  do
    Say 'File "'FileName'" does not exist!'
    Return 1
  end

if ExeName = '' then
  do
    Parse Value FileSpec('name', FileName) With Fname '.' Fext
    ExeName = FileSpec('drive', FileName)||FileSpec('path', FileName)||Fname||'.exe'
  end

Parse Source operatingSystem commandType sourceFileName
REXX_VIO = FileSpec('drive', sourceFileName) || FileSpec('path', sourceFileName) || 'REXX_VIO.EXE'
if Stream(REXX_VIO, 'C', 'Query Exist') == '' then
  do
    Say 'File "'REXX_VIO'" is required, but does not exist!'
    Return 1
  end


'@copy' REXX_VIO ExeName
'@echo RESOURCE 17746 1' FileName ' > %tmp%\rexx2vio.rc'
'@rc.exe -n -x2 %tmp%\rexx2vio.rc' ExeName
'@del %tmp%\rexx2vio.rc %tmp%\rexx2vio.res'
Return 0
