/*
 * This program displays the contents of a Rexx program and executes it with output
 * displayed in an application window.
 */
options INTERNAL_QUEUES
numeric digits 12
Trace o

Parse Arg fn

!det.!filetext. = ''
!det.!numbertext. = ''
!det.!filetext.0 = 0
!det.!numbertext.0 = 0
!det.!dir = ''
!det.!mle_pos = -1

Call RxFuncAdd 'DW_LoadFuncs','rexxdw','DW_LoadFuncs'
If DW_LoadFuncs() \= 0 Then Exit 1

Call dw_init !REXXDW.!DW_NEW_THREAD
/*
 * Calculate various default fixed heights
 */
!det.!screenheight = dw_screen_height()
!det.!baseheight = (!det.!screenheight * 3 ) % 4
!det.!toolbarheight = 32
!det.!labelheight = 20
!det.!scrollbarheight = 14
!det.!statuslineheight = 20
!det.!pixmapheight = !det.!baseheight - !det.!toolbarheight - !det.!labelheight - !det.!scrollbarheight - !det.!statuslineheight
!det.!total_cols = 80
!det.!total_lines = 20
!det.!current_row = 0
!det.!current_col = 0
!det.!havefile = 0
/*
 * Calculate various default fixed widths
 */
!det.!screenwidth = dw_screen_width()
!det.!basewidth = (!det.!screenwidth * 3 ) % 4
!det.!filepadding = 5
!det.!scrollbarwidth = 14

Parse Source os . prog
Select
   When os = 'WIN32' Then
      Do

         !det.!fixedfont = '12.Courier'
         !det.!italicfont = '12.Courier Italic'
         !det.!boldfont = '12.Courier Bold'
         !det.!bolditalicfont = '12.Courier Bold Italic'

/*
         !det.!fixedfont = '10.Terminal'
         !det.!italicfont = '10.Terminal Italic'
         !det.!boldfont = '10.Terminal Bold'
         !det.!bolditalicfont = '10.Terminal Bold Italic'
*/
         imagedir = 'win'
         !det.!ossep = '\'
         highlight_datadir = '-D c:\bin'
         !det.!wc_command = 'qwc.exe'
      End
   When os = 'OS2' | os = 'OS/2' Then
      Do
         !det.!fixedfont = "5.System VIO"
         imagedir = 'os2'
         !det.!ossep = '\'
         !det.!wc_command = 'wc.exe'
      End
   When !REXXDW.!GTK_MAJOR_VERSION > 1 Then
      Do
         !det.!fixedfont = 'monospace 8'
         !det.!italicfont = 'monospace italic 8'
         !det.!boldfont = 'monospace bold italic 8'
         !det.!bolditalicfont = 'monospace italic 8'
         imagedir = 'gtk'
         !det.!ossep = '/'
         highlight_datadir = ''
         !det.!wc_command = 'wc'
      End
   Otherwise
      Do
         !det.!fixedfont      = '-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1'
         !det.!italicfont     = '-adobe-courier-medium-o-normal-*-*-120-*-*-m-*-iso8859-1'
         !det.!boldfont       = '-adobe-courier-bold-r-normal-*-*-120-*-*-m-*-iso8859-1'
         !det.!bolditalicfont = '-adobe-courier-bold-o-normal-*-*-120-*-*-m-*-iso8859-1'
         imagedir = 'images/gtk'
         !det.!ossep = '/'
         highlight_datadir = ''
         !det.!wc_command = 'wc'
      End
End
!det.!styles.0 = 0
!det.!style_idx = 0

!det.!style = 'the'

pos = Lastpos( !det.!ossep, prog )
base = Substr( prog, 1, pos-1 )
len = Length( base )
If Right( base, 3 ) = 'bin' Then !det.!icondir = Substr( base, 1, len-3 ) || 'share' || !det.!ossep || 'qocca' || !det.!ossep || imagedir || !det.!ossep
Else !det.!icondir = base || !det.!ossep || imagedir || !det.!ossep

Call CreateTopWindow

?icon = dw_icon_load_from_file( !det.!icondir'showdifferences' )
Call dw_window_set_icon !det.!topwin, ?icon

/*
 * Set our default window to the toplevel window so our keypress events occur
 * there - this is a guess!! Nope - doesn't work under windows
 */

Drop !det.!fn.1. !det.!fn.2.
/*
 * The following is the main event loop for this program. We check the
 * variable !REXXDW.!HAVE_REXXCALLBACK to determine which mechanism
 * can be used for callbacks. It is far better to use the mechanism
 * offered by an interpreter that offers RexxCallBack() in its API.
 */
If !REXXDW.!HAVE_REXXCALLBACK Then
   Do
      Call dw_main
   End
Else
   Do Forever
      cmd = dw_main_iteration()
      If cmd \= '' Then Interpret 'Call' cmd
   End

Return

CreateTopWindow: Procedure Expose !REXXDW. !det.
!det.!windowstyle = dw_or( !REXXDW.!DW_FCF_SYSMENU, !REXXDW.!DW_FCF_TITLEBAR, !REXXDW.!DW_FCF_SHELLPOSITION, !REXXDW.!DW_FCF_TASKLIST, !REXXDW.!DW_FCF_DLGBORDER, !REXXDW.!DW_FCF_SIZEBORDER, !REXXDW.!DW_FCF_MINMAX )
!det.!topwin = dw_window_new( !REXXDW.!DW_DESKTOP, 'Regina Program Runner', !det.!windowstyle )

topbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start !det.!topwin, topbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_signal_connect !det.!topwin, !REXXDW.!DW_DELETE_EVENT, 'CloseCallback'
/*
 * Create the toolbar box and render box container
 */
tb_box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start topbox, tb_box, 0, 40, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
Call CreateButtonBar tb_box

/* create the window for program parameters */
box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start topbox, box, 0, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

tmp = dw_text_new( 'Regina switches:', 0 )
Call dw_box_pack_start box, tmp, 100, 20, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_style tmp, dw_or( !REXXDW.!DW_DT_LEFT, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_LEFT, !REXXDW.!DW_DT_VCENTER )
!det.!switches = dw_entryfield_new( '', 0 )
Call dw_box_pack_start box, !det.!switches, 100, 20, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

Call dw_box_pack_start box, , 0, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

tmp = dw_text_new( 'REGINA_LANG env variable:', 0 )
Call dw_box_pack_start box, tmp, 150, 20, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_style tmp, dw_or( !REXXDW.!DW_DT_LEFT, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_LEFT, !REXXDW.!DW_DT_VCENTER )
!det.!env = dw_entryfield_new( '', 0 )
Call dw_box_pack_start box, !det.!env, 200, 20, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start topbox, box, 0, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

tmp = dw_text_new( 'Program Arguments:', 0 )
Call dw_box_pack_start box, tmp, 100, 20, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_style tmp, dw_or( !REXXDW.!DW_DT_LEFT, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_LEFT, !REXXDW.!DW_DT_VCENTER )
!det.!entry = dw_entryfield_new( '', 0 )
Call dw_box_pack_start box, !det.!entry, 0, 20, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
/*
 * Create the box for the file details
 */
!det.!detail_box = dw_box_new( !REXXDW.!DW_HORZ )
/*Call dw_box_pack_start topbox, !det.!detail_box, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2*/

Call CreateFileWindow
Call CreatePixmaps

!det.!output_box = dw_box_new( !REXXDW.!DW_HORZ )
/*Call dw_box_pack_start topbox, !det.!output_box, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2*/

vsplitbar = dw_splitbar_new( !REXXDW.!DW_VERT, !det.!detail_box, !det.!output_box, 0 )
Call dw_box_pack_start topbox, vsplitbar, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_splitbar_set vsplitbar, 50.0

!det.!mle = dw_mle_new( 0 )
Call dw_box_pack_start !det.!output_box, !det.!mle, 0, 200, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 2
Call dw_window_set_font !det.!mle, !det.!fixedfont

Call dw_mle_set_editable !det.!mle, !REXXDW.!DW_EDITABLE

/*
 * Create the box for the status details
 */
status_box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start topbox, status_box, 0, !det.!statuslineheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 2
/* add status lines */
!det.!statustext = dw_status_text_new( '', 0 )
Call dw_box_pack_start status_box, !det.!statustext, 0, !det.!statuslineheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!det.!statusdiffs = dw_status_text_new( '', 0 )
Call dw_box_pack_start status_box, !det.!statusdiffs, 100, !det.!statuslineheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_style !det.!statusdiffs, dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER) , dw_or( !REXXDW.!DW_DT_CENTER, !REXXDW.!DW_DT_VCENTER )
/*
 * Display the window
 */
Call dw_window_set_pos_size !det.!topwin, (!det.!screenwidth % 2) - (!det.!basewidth % 2), (!det.!screenheight % 2) - (!det.!baseheight % 2), !det.!basewidth, !det.!baseheight
Call dw_window_show !det.!topwin

Return

CreateFileWindow: Procedure Expose !REXXDW. !det.
title = 'Rexx Program:'
title = ''

/* create box for filecontents and line numbers and scrollbars*/
!det.!groupbox = dw_groupbox_new( !REXXDW.!DW_VERT, ' 'title' ' )
Call dw_box_pack_start !det.!detail_box, !det.!groupbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 5

Return

CreatePixmaps: Procedure Expose !REXXDW. !det.
depth = dw_color_depth_get()
horzbox = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start !det.!groupbox, horzbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

numberbox = dw_box_new( !REXXDW.!DW_VERT )
/* create render box for filenumbers pixmap */
!det.!numberbox = dw_render_new( 0 )
Call dw_window_set_font !det.!numberbox, !det.!fixedfont
Parse Value dw_font_text_extents_get( !det.!numberbox, , "y_g([" ) With !det.!font_width !det.!font_height
!det.!font_width = !det.!font_width % 5

!det.!numberpixmap_cols = 3
!det.!numberpixmap_width = !det.!font_width * !det.!numberpixmap_cols
!det.!pixmap_rows = !det.!pixmapheight % !det.!font_height
/* we now know how wide the renderbox will be */
!det.!filepixmap_width = !det.!total_cols * !det.!font_width
!det.!filepixmap_viewport_width = (!det.!basewidth % 2 ) - !det.!numberpixmap_width - !det.!filepadding - !det.!scrollbarwidth
!det.!filepixmap_viewport_cols = !det.!filepixmap_viewport_width % !det.!font_width
Call dw_box_pack_start horzbox, numberbox, !det.!numberpixmap_width, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_box_pack_start numberbox, !det.!numberbox, !det.!numberpixmap_width, !det.!font_height, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
/* pack a small empty space above the number total */
Call dw_box_pack_start numberbox, 0, 0, 3, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
/* Pack an area of number render box for the total number of lines */
!det.!total_label = dw_text_new( '', 0 )
Call dw_box_pack_start numberbox, !det.!total_label, !det.!numberpixmap_width, !det.!scrollbarheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_window_set_style !det.!total_label, !REXXDW.!DW_DT_RIGHT, !REXXDW.!DW_DT_RIGHT
Call dw_window_set_font !det.!total_label, !det.!fixedfont

/* Pack an area of empty space between number and file boxes */
Call dw_box_pack_start horzbox, 0, !det.!filepadding, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0

/* box for filecontents */
vertbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start horzbox, vertbox, 0, 0, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_color vertbox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE

/* create render box for filedetails pixmap */
!det.!filebox = dw_render_new( 0 )
Call dw_box_pack_start vertbox, !det.!filebox, !det.!font_width, !det.!font_height, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
Call dw_window_set_font !det.!filebox, !det.!fixedfont
Call dw_window_set_color !det.!filebox, !REXXDW.!DW_CLR_BLACK, !REXXDW.!DW_CLR_WHITE

/* pack a small empty space above the horizontal scrollbar */
Call dw_box_pack_start vertbox, 0, 0, 3, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* create horizonal scrollbar */
!det.!hscrollbar = dw_scrollbar_new( !REXXDW.!DW_HORZ, 0 )
Call dw_box_pack_start vertbox, !det.!hscrollbar, 0, !det.!scrollbarheight, !REXXDW.!DW_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

vscrollbox = dw_box_new( !REXXDW.!DW_VERT )
Call dw_box_pack_start horzbox, vscrollbox, !det.!scrollbarwidth, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
!det.!vscrollbar = dw_scrollbar_new( !REXXDW.!DW_VERT, 0 )
Call dw_box_pack_start vscrollbox, !det.!vscrollbar, !det.!scrollbarwidth, 0, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_EXPAND_VERT, 0
/* Pack an area of empty space 14x14 pixels */
Call dw_box_pack_start vscrollbox, 0, !det.!scrollbarwidth, !det.!scrollbarheight, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

/* create arbitrary sized pixmaps */
If trace() = 'F' Then say '----' !det.!pixmapheight
Call dw_color_foreground_set !REXXDW.!DW_CLR_WHITE
!det.!numberpixmap = dw_pixmap_new( !det.!numberbox, !det.!font_width, !det.!font_height, depth )
!det.!filepixmap =   dw_pixmap_new( !det.!filebox, !det.!font_width, !det.!font_height, depth )

Call dw_signal_connect !det.!numberbox, !REXXDW.!DW_EXPOSE_EVENT, 'ExposeCallback'
Call dw_signal_connect !det.!filebox, !REXXDW.!DW_EXPOSE_EVENT, 'ExposeCallback'
Call dw_signal_connect !det.!numberbox, !REXXDW.!DW_CONFIGURE_EVENT, 'ConfigureCallback'
Call dw_signal_connect !det.!filebox, !REXXDW.!DW_CONFIGURE_EVENT, 'ConfigureCallback'
Call dw_signal_connect !det.!hscrollbar, !REXXDW.!DW_VALUE_CHANGED_EVENT, 'ValueChangedCallback'
Call dw_signal_connect !det.!vscrollbar, !REXXDW.!DW_VALUE_CHANGED_EVENT, 'ValueChangedCallback'

Return

/*
 * Generic callback for each of the render boxes.
 * The width and height
 */
ExposeCallback: Procedure Expose !REXXDW. !det.
Parse Arg win
If win = !det.!filebox Then
   Do
      pixmap = !det.!filepixmap
      x = !det.!current_col*!det.!font_width
   End
Else
   Do
      pixmap = !det.!numberpixmap
      x = 0
   End

Parse Value dw_window_get_pos_size( win ) With . . width height

If trace() = 'F' Then say 'got expose for' num 'width' width 'height' height 'win' win 'filebox' !det.!filebox 'numberbox' !det.!numberbox
Call dw_pixmap_bitblt win, , 0, 0, width, height, , pixmap, x, 0
Call dw_flush
return 1

ConfigureCallback: Procedure Expose !REXXDW. !det.
Parse Arg win, width, height
depth = dw_color_depth_get()

If win = !det.!filebox Then pixmap = !det.!filepixmap
Else pixmap = !det.!numberpixmap

!det.!pixmap_rows = height % !det.!font_height
!det.!pixmapheight = height

If trace() = 'F' Then say 'pixmap height' !det.!pixmapheight !det.!baseheight
/* Destroy the old pixmap */
Call dw_pixmap_destroy pixmap
!det.!filepixmap_viewport_height = height

Select
   When win = !det.!filebox Then
      Do
         !det.!filepixmap_viewport_cols = width % !det.!font_width
         !det.!filepixmap_viewport_width = width
         /* Create new pixmap with the current sizes */
         If !det.!havefile = 0 Then !det.!filepixmap_width = width
         !det.!filepixmap = dw_pixmap_new( !det.!filebox, !det.!filepixmap_width, !det.!pixmapheight, depth )
         pixmap = !det.!filepixmap
      End
   When win = !det.!numberbox Then
      Do
         /* Create new pixmap with the current sizes */
         !det.!numberpixmap = dw_pixmap_new( !det.!numberbox, !det.!numberpixmap_width, !det.!pixmapheight, depth )
         pixmap = !det.!numberpixmap
      End
   Otherwise Nop
End
If trace() = 'F' Then say 'new pixmap is' pixmap 'widths' dw_pixmap_width( !det.!numberpixmap ) dw_pixmap_width( !det.!filepixmap )
/* Update scrollbar ranges with new values for the current file */
Call dw_scrollbar_set_range !det.!hscrollbar, !det.!total_cols, !det.!filepixmap_viewport_cols
Call dw_scrollbar_set_range !det.!vscrollbar, !det.!total_lines, !det.!pixmap_rows

/* Redraw the window */
Call DisplayFile
Return 1

ValueChangedCallback: Procedure Expose !REXXDW. !det.
Parse Arg win, value
If trace() = 'F' Then say 'got valuechanged for' num
If win = !det.!vscrollbar Then
   Do
      !det.!current_row = value
      Call dw_scrollbar_set_pos !det.!vscrollbar, value
   End
Else
   Do
      !det.!current_col = value
      Call dw_scrollbar_set_pos !det.!hscrollbar, value
   End
Call DisplayFile
Return 1

OpenProgramCallback: Procedure Expose !REXXDW. !det.
/*
 * dw_file_browse() at least under Windows changes directory!
 */
here = Directory()
!det.!file = Strip( dw_file_browse( 'Select Rexx Program', !det.!dir, 'rexx', !REXXDW.!DW_FILE_OPEN ) )
If !det.!file \= '' Then
   Do
      rpos = Lastpos( !det.!ossep, !det.!file )
      !det.!dir = Substr( !det.!file, 1, rpos-1 )
      !det.!filetext. = ''
      !det.!numbertext. = ''
      max_width = 0
      Call Stream !det.!file, 'C', 'OPEN READ'
      Do i = 1 While Lines( !det.!file ) > 0
         !det.!filetext.i = Linein( !det.!file )
         !det.!numbertext.i = Right( i, 3 )
         this_width = Length( !det.!filetext.i )
         If this_width > max_width Then max_width = this_width
      End
      Call Stream !det.!file, 'C', 'CLOSE'
      !det.!total_cols = max_width
      !det.!filetext.0 = i - 1
      !det.!numbertext.0 = i - 1
      !det.!total_lines = !det.!filetext.0

      Call ConfigureCallback !det.!filebox, !det.!filepixmap_viewport_width, !det.!filepixmap_viewport_height
      Call DisplayFile
      Call ClearSettings
   End
Call Directory here
!det.!havefile = 1
Return 0

ClearSettings: Procedure Expose !REXXDW. !det.
Call dw_window_enable !det.!mle
Call dw_mle_set_cursor !det.!mle, 0
Call dw_mle_delete !det.!mle
!det.!mle_pos = -1
Call dw_window_set_text !det.!entry, ''
Call dw_window_set_text !det.!switches, ''
Call dw_window_set_text !det.!env, ''
Call dw_window_set_text !det.!groupbox, !det.!file
Return 0

ExecuteProgramCallback: Procedure Expose !REXXDW. !det.
env = dw_window_get_text( !det.!env )
Call Value 'REGINA_LANG', env, 'ENVIRONMENT'
args = dw_window_get_text( !det.!entry )
switches = dw_window_get_text( !det.!switches )
Address System 'regina' switches quote( !det.!file ) args With Output FIFO '' Error FIFO ''
crlf = d2c(13)||d2c(10)
Do i = 1 To Queued()
   Parse Pull line
   !det.!mle_pos = dw_mle_import( !det.!mle, line||crlf, !det.!mle_pos )
End
Parse Value dw_window_get_pos_size( !det.!mle ) With x y width height
Parse Value dw_font_text_extents_get( !det.!mle, , "g(" ) With font_width font_height
num = width % ( font_width / 2 )
!det.!mle_pos = dw_mle_import( !det.!mle, Copies( '=', num-3 )||crlf, !det.!mle_pos )
Parse Value dw_mle_get_size( !det.!mle ) With bytes lines
Call dw_mle_set_visible !det.!mle, lines
Return 0

/*
 * Prepare the file details for displaying
 */
DisplayFile: Procedure Expose !REXXDW. !det.
If trace() = 'F' Then say 'got displayfile for' idx
Call dw_color_foreground_set !REXXDW.!DW_CLR_WHITE
Call dw_draw_rect 0, !det.!numberpixmap, !REXXDW.!DW_FILL, 0, 0, !det.!numberpixmap_width, !det.!pixmapheight
If !det._syntax = '!DET._SYNTAX' | !det._have_highlight = 0 Then back = !REXXDW.!DW_CLR_WHITE
Else back = !det.!default_back
Call dw_color_foreground_set back
Call dw_draw_rect 0, !det.!filepixmap, !REXXDW.!DW_FILL, 0, 0, !det.!filepixmap_width, !det.!pixmapheight
Call dw_color_background_set back

Do i = 1 To !det.!pixmap_rows+1 While(i+!det.!current_row) < !det.!numbertext.0 + 1
   y = (i-1)*!det.!font_height
   fileline = i + !det.!current_row
   Call Addrow back, !det.!filepixmap_width, idx, y, !det.!numbertext.fileline, !det.!filetext.fileline, !det.!filetag.fileline
   y = y + !det.!font_height
End
Call ExposeCallback !det.!numberbox, 0, 0, 0, 0
Call ExposeCallback !det.!filebox, 0, 0, 0, 0
Return

AddRow: Procedure Expose !REXXDW. !det.
Parse Arg back, pixmap_width, idx, y, number, fileline, tag
If number \= '' Then
   Do
      Call dw_color_foreground_set !REXXDW.!DW_CLR_BLACK
      Call dw_color_background_set !REXXDW.!DW_CLR_WHITE
      Call dw_draw_text 0, !det.!numberpixmap, 0, y, Right( number, !det.!numberpixmap_cols )
   End
Call WriteTextLine back, pixmap_width, idx, y, fileline, tag
Return

WriteTextLine: Procedure Expose !REXXDW. !det.
Parse Arg back, pixmap_width, idx, y, fileline, tag
Call dw_color_background_set back
/*
 * If we aren't using highlighting, then just display the text as is
 */
Call dw_color_foreground_set !REXXDW.!DW_CLR_BLACK
If !REXXDW.!GTK_MAJOR_VERSION < 2 Then Call dw_window_set_font !det.!filebox, !det.!fixedfont

If !det._syntax = '!DET._SYNTAX' | !det._have_highlight = 0 Then
   Do
      Call dw_draw_text 0, !det.!filepixmap, 0, y, fileline
   End
Else
   Do
      /*
       * Now split the line up at each <span>
       */
      x = 0
      Do Forever
         If Left( fileline, 13 ) = '<span class="' Then
            Do
               Parse Var fileline '<span class="' class '">' fragment '</span>' fileline
               Call dw_color_foreground_set !det.!color.class
               If !REXXDW.!GTK_MAJOR_VERSION < 2 Then Call dw_window_set_font !det.!filebox, !det.!font.class
            End
         Else
            Do
               Parse Var fileline fragment '<span class="' fileline
               If Strip( fileline ) \= '' Then fileline = '<span class="'fileline
               Call dw_color_foreground_set !det.!default_fore
               If !REXXDW.!GTK_MAJOR_VERSION < 2 Then Call dw_window_set_font !det.!filebox, !det.!fixedfont
            End
         fragment = ConvertHTMLMnemonics( fragment )
         Call dw_draw_text 0, !det.!filepixmap, x, y, fragment
         x = x + !det.!font_width * Length( fragment )
         If fileline = '' Then Leave
      End
   End
Return

ConvertHTMLMnemonics: Procedure
Parse Arg fragment
fragment = Changestr( '&lt;', fragment, '<' )
fragment = Changestr( '&gt;', fragment, '>' )
fragment = Changestr( '&amp;', fragment, '&' )
fragment = Changestr( '&quot;', fragment, '"' )
Return fragment

CloseCallback: Procedure Expose !REXXDW. !det.
Call dw_window_destroy( !det.!topwin )
Call dw_exit( 0 )
Exit 0
Return

/*
 * Contains bitmap buttons for opening and executing program
 */
CreateButtonBar: Procedure Expose !REXXDW. !det.
Parse Arg tb_box
/*
 * Create a box for the bitmap buttons
 */
button_box_width = (2*32) + 20
button_box = dw_box_new( !REXXDW.!DW_HORZ )
Call dw_box_pack_start tb_box, button_box, button_box_width, 40, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0

!det.!bbopen = dw_bitmapbutton_new_from_file( 'Open Program', 0, !det.!icondir||'open' )
Call dw_box_pack_start button_box, !det.!bbopen, 36, 36, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_signal_connect !det.!bbopen, !REXXDW.!DW_CLICKED_EVENT, 'OpenProgramCallback'
/* pack a bit of blank space after the button */
Call dw_box_pack_start button_box, 0, 5, 36, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
!det.!bbexecute = dw_bitmapbutton_new_from_file( 'Execute Program', 0, !det.!icondir||'execute' )
Call dw_box_pack_start button_box, !det.!bbexecute, 36, 36, !REXXDW.!DW_DONT_EXPAND_HORZ, !REXXDW.!DW_DONT_EXPAND_VERT, 0
Call dw_signal_connect !det.!bbexecute,  !REXXDW.!DW_CLICKED_EVENT, 'ExecuteProgramCallback'

Return

GetColor:
Parse Arg cnum
newcolor = TkChooseColor( '-initialcolor', !det.!color.cnum )
If newcolor \= '' Then
   Do
      !det.!color.cnum = newcolor
      Call TkConfig colorbutton.cnum, '-background', newcolor
      Do gc_idx = 1 To 2
         Call SetTextColors gc_idx
      End
      Call DrawChangeBars
      Call WriteUserConfigFile
   End
Return

GetStyles: Procedure Expose !REXXDW. !det.
Parse Arg switches
Address System 'highlight -w' switches With Output Stem !styles. Error Stem junk.
If rc \= 0 Then Return 0
idx = 0
Do i = 1 To !styles.0
   If Words( !styles.i ) = 1 Then
      Do
         idx = idx + 1
         !det.!styles.idx = Strip( !styles.i )
      End
End
!det.!styles.0 = idx
Return 1

GetStyleColors: Procedure Expose !REXXDW. !det.
Parse Arg switches, syntax, style
If syntax \= '' Then syntax = '-S' syntax
If style \= '' Then style = '-s' style
tmpfile = SysTempFileName( 'rxdiff???' )
Call Stream tmpfile, 'C', 'OPEN WRITE REPLACE'
Call Lineout tmpfile, ''
Call Stream tmpfile, 'C', 'CLOSE'
If trace() = 'F' Then say 'getting colors' switches syntax style '-i'
Address System 'highlight' switches syntax style '-i' tmpfile With Output Stem high. Error Stem junk.
Call SysFileDelete tmpfile
!det.!classes = ''
Do i = 1 To high.0
   If Strip( high.i ) \= '' Then /* ignore blank lines */
      Do
         If Left( high.i, 5 ) = '<pre>' Then Leave
         Else
            Do
               Select
                  When Word( high.i, 1 ) = 'pre' Then
                     Do
                        Parse Var high.i . 'color:#' default_fore ';' . '-color:#' default_back ';' .
                     End
                  When Left( Word( high.i, 1 ), 1 ) = '.' Then
                     Do
                        Parse Var high.i '.' !class '{' . 'color:#' class_color ';' fontstuff '}' .
                        !class = Strip( Strip( !class ), 'B', '	' )
                        !det.!classes = !det.!classes !class
                        If class_color = '' Then class_color = default_fore
                        redx = Substr( class_color, 1, 2 )
                        greenx = Substr( class_color, 3, 2 )
                        bluex = Substr( class_color, 5, 2 )
                        !det.!color.!class = dw_rgb( x2d( redx), x2d( greenx ), x2d( bluex ) )
                        Select
                           When Countstr( 'bold', fontstuff ) \= 0 & Countstr( 'italic', fontstuff ) \= 0 Then !det.!font.!class = !det.!bolditalicfont
                           When Countstr( 'bold', fontstuff ) \= 0 Then !det.!font.!class = !det.!boldfont
                           When Countstr( 'italic', fontstuff ) \= 0 Then !det.!font.!class = !det.!italicfont
                           Otherwise !det.!font.!class = !det.!fixedfont
                        End
If trace() = 'F' Then                         say x2d(redx) x2d(greenx) x2d(bluex) !det.!color.!class
                     End
                  Otherwise Nop
               End
            End
      End
End
Do i = 1 To Words( !det.!classes )
   class = Word( !det.!classes, i )
If trace() = 'F' Then    Say 'color for' class 'is' !det.!color.class
If trace() = 'F' Then    Say 'font for' class 'is' !det.!font.class
End
/*
 * Calculate the default foreground color...
 */
redx = Substr( default_fore, 1, 2 )
greenx = Substr( default_fore, 3, 2 )
bluex = Substr( default_fore, 5, 2 )
!det.!default_fore = dw_rgb( x2d( redx), x2d( greenx ), x2d( bluex ) )
/*
 * Calculate the default background color...
 */
redx = Substr( default_back, 1, 2 )
greenx = Substr( default_back, 3, 2 )
bluex = Substr( default_back, 5, 2 )
!det.!default_back = dw_rgb( x2d( redx), x2d( greenx ), x2d( bluex ) )
If trace() = 'F' Then say 'default' !det.!default_fore !det.!default_back
Return

GetHighlightedLines: Procedure Expose !REXXDW. !det.
Parse Arg fn, idx, switches, syntax, style
If syntax \= '' Then syntax = '-S' syntax
If style \= '' Then style = '-s' style
Address System 'highlight' switches syntax style '-i' quote( fn ) With Output Stem high. Error Stem junk.
If trace() = 'F' Then say 'highlight' switches syntax style '-i' fn
If trace() = 'F' Then say 'got' high.0 'lines from highlight' 'with' junk.0 'errors'
/*
 * Clean up the formatting, so that each line starts with <span><span class="line">
 * and each line ends with </span>
 */
state = 'head'
Do i = 1 To high.0
   Select
      When Strip( high.i ) = '' Then Nop /* ignore blank lines */
      When state = 'file' Then
         Do
            If Left( high.i, 6 ) = '</pre>' Then Leave
            If Right( high.i, 7 ) \= '</span>' Then
               Do
                  next = i + 1
                  If Left( high.next, 7 ) = '</span>' Then
                     Do
                        high.i = high.i'</span>'
                        high.next = Substr( high.next, 8 )
                     End
               End
            /*
             * Parse Line number out of line
             */
            Parse Var high.i . 'class="line">' lno '</span>' line
            lno = Strip( lno )
            /*
             * Remove any spaning code that doesn't change any characters
             */
            Do j = 1 To Words( !det.!classes )
               class = Word( !det.!classes, j )
               line = Changestr( '<span class="'class'"></span>', line, '' )
            End
            !det.!fn.idx.lno = line
            !det.!fn.idx.0 = lno
         End
      When state = 'head' Then
         Do
            If Left( high.i, 5 ) = '<pre>' Then state = 'file'
         End
      Otherwise Nop
   End
End
Return

Quote: Procedure
Parse Arg str
If Countstr( '"', str ) = 0 Then Return '"'str'"'
Else Return "'"str"'"
