/**
 * $Id: TimeFormat.java,v 1.1.1.1 2001/07/22 02:44:50 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import java.util.Calendar;
import java.text.NumberFormat;
import java.text.DateFormat;

/**
 * Rudimentary time formatting tools.
 */
public class TimeFormat {
	
    /**
     * Formats a long representing a number of seconds into
     * human-readable time (e.g. "hh:mm", "mm:ss", "2 days, hh:mm".
     * @return formatted text
     */
    public static String format(long sec) {
	NumberFormat nf = NumberFormat.getInstance();
	nf.setMinimumIntegerDigits(2);
	String s = "";
	long days, hours, minutes, seconds, rest;
	days = sec / (60 * 60 * 24);
	rest = sec % (60 * 60 * 24);
	hours = rest / (60 * 60);
	rest = rest % (60 * 60);
	minutes = rest / 60;
	rest = rest % 60;
	seconds = rest;
	if(days > 0) 
	    s += days + (days > 1 ? " days" :
			 " day") + ", ";
	if(hours > 0) 
	    s += nf.format(hours) + ":";

	s += nf.format(minutes);

	if(hours < 1) 
	    s += ":" + nf.format(seconds);

	return s;
    }

    public static String formatCurrentDateTime(int df, int tf) {
        
        return DateFormat.getDateInstance(df).format(Calendar.getInstance().getTime()) + " " + DateFormat.getTimeInstance(tf).format(Calendar.getInstance().getTime());

    }

}


