/**
 * $Id: SystemEventHandler.java,v 1.1.1.1 2001/07/22 02:44:50 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import java.io.File;

/**
 * Implement SystemEventHandler to react to
 * operating system events.
 */
public interface SystemEventHandler {
    /**
     * This method is called when the application is requested
     * to quit.
     */
    public void handleQuit();
    /**
     * This method is called when the application is requested
     * to open a document.
     * @param f the file to open.
     */
    public void handleOpenDocument(File f);
    /**
     * This method is called when the application is requested
     * to print a document.
     * @param f the file to print.
     */
    public void handlePrintDocument(File f);
    /**
     * This method is called when the application is requested
     * to show an about box.
     */
    public void handleAbout();
}
