/**
 * $Id: InterruptableInputStream.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import java.io.InputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class InterruptableInputStream extends InputStream {

    private boolean interrupted = false;
    private InputStream input;

    public InterruptableInputStream(InputStream i) {

        input = i;

    }

    public int read(byte b[], int off, int len) throws IOException {

        while(!interrupted) {

            try {

                return input.read(b, off, len);

            } catch(InterruptedIOException e) {

                if(interrupted)
                    throw new IOException("interrupted");

            }

        }

        throw new IOException("interrupted");

    }

    public int read() throws IOException {

        while(!interrupted) {

            try {
                
                return input.read();
                
            } catch(InterruptedIOException e) {

                if(interrupted)
                    throw new IOException("interrupted");

            }

        }

        throw new IOException("interrupted");

    }

    public void close() throws IOException {

        try {

            super.close();
            input.close();

        } finally {

            DebuggerOutput.debug("InterruptableInputStream.close: interrupted = true");
            interrupted = true;

        }

    }

}
