/**
 * $Id: Agreement.java,v 1.1.1.1 2001/07/22 02:44:49 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

package redlight.server;

import java.io.File;
import java.io.LineNumberReader;
import java.io.InputStreamReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import redlight.hotline.HLServer;
import redlight.hotline.HLServerAgreement;

/**
 * Reads the agreement from disk.
 */
public class Agreement extends HLServerAgreement {

    File agreementFile;
    long lastModified;

    /**
     * Creates flat news with the given file for persistent storage.
     * @param file the file.
     */
    public Agreement(HLServer h, File file) {

        super(h);
        agreementFile = file;

    }

    /**
     * Load the component from disk if it has changed.
     */
    public void checkModified() {

        if(agreementFile.lastModified() != lastModified) {

            Main.logLine("Agreement file " + agreementFile.toString() + " changed, reloading.");
            load();

        }

    }

    /**
     * Loads flat news from persistent storage.
     */
    public void load() {

        if(agreementFile.exists()) {

            load(agreementFile);
            lastModified = agreementFile.lastModified();
            
        } else {

            agreement = null;

        }

    }

    /**
     * Loads flat news from the given InputStream.
     * @param in the InputStream.
     */
    public void load(InputStream in) {

        LineNumberReader lr = null;
        String n = null;

        try {

            lr = new LineNumberReader(new InputStreamReader(in));
            
            for(String line = lr.readLine(); line != null; line = lr.readLine())
                if(line != null)
                    n = (n == null ? line + "\r" : n + line + "\r");

        } catch(Exception e) {

            n = null;

            String error = "Error reading agreement file " + agreementFile.toString();

            if(lr != null)
                error += " at line " + lr.getLineNumber();
            
            error += " (" + e.toString() + ").";

            Main.logLine(error);

        }

        agreement = n;

    }

}

