/**
 * $Id: Fork.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;

import redlight.utils.DebuggerOutput;

/**
 * A Fork describes a single fork in a file.
 * Macintosh files have two forks; a data fork and a
 * resource fork.
 */
public abstract class Fork {
    MacFile parent;
    boolean isClosed = false;

    public Fork(MacFile f) {

	parent = f;

    }

    public abstract DataOutput getDataOutput() throws IOException;

    public abstract DataInput getDataInput() throws IOException;

    public abstract long seek(long s) throws IOException;

    public abstract void close() throws IOException;

    public abstract long size(); 

    public abstract boolean exists();

    public boolean delete() {

        return true;

    }

    public boolean renameTo(File f) {

        return true;

    }

}








