package redlight.hotline.iconlib;

import java.util.Vector;
/*
                Read the license.txt file for license information!
                If you don't have it, get it at www.MarkusStengel.de.
*/

/**
 *          this class stored an entire block index table, such as GIFf, ICON, ...
 *          @author     Markus Stengel
 *          @see          <a href="http://www.MarkusStengel.de">developer site</a>
 */
public class HLTable {
     String      blockName;                                                       // name of the block
     int          dataSizeUVT;                                                  // size of the UVT
     int          dataOffsetUVT;                                                  // offset of the UVT
     int          rowCountLVT;                                                  // number of rows (16 byte blocks) in the LVT
     int          dataOffsetLVT;                                                  // offset of the LVT
     Vector     data;                                                                 // here are the data objects stored
     Vector     identities;                                                       // basically unnecessary, used for fast access though

     /**
      *          initializes the class variables and allocates memory
      */
     public HLTable() {
          data                     = new Vector();
          identities          = new Vector();
          dataSizeUVT          = 0;
          dataOffsetUVT     = 0;
          rowCountLVT          = 0;
          dataOffsetLVT     = 0;
          blockName          = null;
     }

     /**
      *          adds a new HLData object (identity, offset and size of e.g. an ICON) to the data table,
      *          furthermore it extracts the identity and stores it in a seperate table for quicker
      *          access
      *          @param          hldata     entry in the form of a HLData object
      */
     public void add(HLData hldata) {
          data.add (hldata);
          identities.add(new Integer(hldata.identity));
     }

     /**
      *          retrieve an HLData object at a given index in the data table
      *          @param          index          index of the object, if the index is greater or equal to the
      *                                             size of the table, <b>null</b> is returned
      *          @return                         the desired HLData object if it existed, otherwise it returns <b>null</b>
      */
     public HLData get(int index) {
          if (index >= size()) return null;
          return (HLData) data.get(index);
     }

     /**
      *          replace an HLData object at a given index in the data table
      *          @param          index          index of the object, if the index is greater or equal to the
      *                                             size of the table, <b>null</b> is returned and nothing else happens
      *          @return                         the HLData object that was previously stored at that index - if it existed -  otherwise it returns <b>null</b>
      */
     public HLData set(int index, HLData dat) {
          if (index >= size()) return null;
          return (HLData) data.set(index, dat);
     }

     /**
      *          find the corresponding index to a HLData object in the data table with the matching identity
      *          @param          identity     identity to be searched
      *          @return                         index of the desired HLData object if it exists, <b>-1</b> otherwise
      */
     public int find(int identity) {
          return identities.indexOf(new Integer(identity));
     }

     /**
      *          report the number of elements in the data table
      *          @return                         number of elements in the data table
      */
     public int size () {
          return data.size();
     }
}
